/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swingservice;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.DeviceIdInfoBo;
import com.huawei.netcareinsidesdk.bo.InternationalizeBo;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.bo.VerifyCodeRecordBo;
import com.huawei.netcareinsidesdk.constants.DatacomNetworkTiedPolicyEnum;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.constants.FileTypeEnum;
import com.huawei.netcareinsidesdk.constants.InitManageControlPolicyEnum;
import com.huawei.netcareinsidesdk.constants.InsidePolicyEnum;
import com.huawei.netcareinsidesdk.constants.InterceptPolicyEnum;
import com.huawei.netcareinsidesdk.constants.RiskLevelEnum;
import com.huawei.netcareinsidesdk.constants.TaskStatusNameEnum;
import com.huawei.netcareinsidesdk.constants.TaskTypeEnum;
import com.huawei.netcareinsidesdk.dao.ControlPolicyConfigDao;
import com.huawei.netcareinsidesdk.dao.DeviceInfoDao;
import com.huawei.netcareinsidesdk.dao.EngineeringCommissioningNesMapper;
import com.huawei.netcareinsidesdk.dao.StmInfoDao;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.dao.VerifyCodeRecordDao;
import com.huawei.netcareinsidesdk.exception.NetCareInsideSdkException;
import com.huawei.netcareinsidesdk.utils.CmsSignUtils;
import com.huawei.netcareinsidesdk.utils.CommonDataDeal;
import com.huawei.netcareinsidesdk.utils.DataInternationalizationUtil;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.FileDealUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.JsonParseUtils;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.QRCodeUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.RsaUtil;
import com.huawei.netcareinsidesdk.utils.TelnetUtil;
import com.huawei.netcareinsidesdk.utils.VerifyCodeUtil;
import com.huawei.netcareinsidesdk.utils.ZipUtils;
import com.huawei.netcareinsidesdk.vo.InitQrInfoVo;
import com.huawei.netcareinsidesdk.vo.TaskControlPolicyQueryVo;
import com.huawei.netcareinsidesdk.vo.UserAuthenticateInfoVo;
import com.huawei.netcareinsidesdk.vo.UserInfoResultVo;
import com.huawei.us.common.file.UsFileSafeUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class InitSwingService {
    private static final Logger RUN_LOGGER = LoggerFactory.getLogger(InitSwingService.class);
    private static final String ZERO = "0";
    private static final String ONE = "1";
    private static String site;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private ControlPolicyConfigDao controlPolicyConfigDao;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private DeviceInfoDao deviceInfoDao;
    @Autowired
    private CommonDataDeal commonDataDeal;
    @Autowired
    private TelnetUtil telnetUtil;
    @Autowired
    private DataInternationalizationUtil dataInternationalizationUtil;
    @Autowired
    private EngineeringCommissioningNesMapper nesMapper;
    @Autowired
    private VerifyCodeRecordDao verifyCodeRecordDao;
    @Autowired
    private VerifyCodeUtil verifyCodeUtil;
    @Autowired
    private StmInfoDao stmInfoDao;
    private static final String INIT_DATA_FILE = "initAuth.json";
    private static final String INIT_DATA_SIGN_FILE = "initAuth.json.sign";
    private static final String TEMP_PATH;

    public BufferedImage getInitAuthQRCode() {
        RUN_LOGGER.info("Start getInitAuthQRCode.");
        String url = PropertyUtil.getScanQrUrl("toolInitializationUrl", "China");
        String windowsAccount = this.getWindowsAccount();
        DeviceIdInfoBo deviceIdInfoBo = this.deviceInfoDao.queryDeviceInfo(windowsAccount);
        if (deviceIdInfoBo == null) {
            RUN_LOGGER.error("Query device info failed.");
            return null;
        }
        String encryptStr = null;
        try {
            String codeAndAccount = "site=@deviceId=" + deviceIdInfoBo.getDeviceId();
            encryptStr = URLEncoder.encode(RsaUtil.encrypt(codeAndAccount, PropertyUtil.getString("pubkeyByEncrypt")), "UTF-8");
        }
        catch (UnsupportedEncodingException | GeneralSecurityException ex) {
            RUN_LOGGER.error("getInitAuthQRCode encrypt error {}", (Object)ex.getMessage());
            return null;
        }
        String content = url + "?esn=" + deviceIdInfoBo.getEsn() + "&encryptInfo=" + encryptStr;
        RUN_LOGGER.info("End getInitAuthQRCode.");
        return QRCodeUtil.createImage(content + "&lang=" + LanguageManager.getInstance().getCurLanguage() + "&timeZone=" + DateUtil.getTimeZoneId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result importInitAuthInfo(MultipartFile file) {
        RUN_LOGGER.info("Start importInitAuthInfo");
        if (!FileDealUtil.isSecureFile(file)) {
            RUN_LOGGER.error("US-Check,Check zip file failed.");
            return Result.fail(ErrorCodeEnum.COMPRESS_PACKAGE_VERIFY_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.COMPRESS_PACKAGE_VERIFY_FAILED.getErrorCode()));
        }
        String fileName = file.getOriginalFilename();
        Result checkFileType = this.checkFileType(file, fileName);
        if (checkFileType != null) {
            return checkFileType;
        }
        String path = TEMP_PATH + File.separator + fileName;
        String safeFilePath = UsFileSafeUtils.getSafeFilePath((String)path);
        File dest = new File(safeFilePath);
        Result unZipFiles = this.unZipFiles(file, dest);
        if (unZipFiles != null) {
            return unZipFiles;
        }
        String filepath = TEMP_PATH + File.separator + INIT_DATA_FILE;
        Result signResult = this.getSignResult(filepath, dest);
        if (signResult != null) {
            return signResult;
        }
        try {
            JSONObject jsonObject = JsonParseUtils.parseJson(filepath);
            if (this.importUserInfo(jsonObject)) {
                RUN_LOGGER.error("AuthInfo is null.");
                Result result = Result.fail(ErrorCodeEnum.INIT_INFO_NOT_EMPTY.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.INIT_INFO_NOT_EMPTY.getErrorCode()));
                return result;
            }
        }
        catch (IOException exception) {
            RUN_LOGGER.error("Import authInfo failed.");
            Result result = Result.fail(ErrorCodeEnum.INIT_INFO_IMPORT_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.INIT_INFO_IMPORT_FAILED.getErrorCode()));
            return result;
        }
        catch (JSONException exception) {
            RUN_LOGGER.error("The format of the imported information is incorrect.");
            Result result = Result.fail(ErrorCodeEnum.DATA_PARSE_EXCEPTION.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.DATA_PARSE_EXCEPTION.getErrorCode()));
            return result;
        }
        finally {
            FileDealUtil.clearTempFiles(new File(dest.getParent()));
        }
        this.commonDataDeal.updateTaskInfoPolicy();
        RUN_LOGGER.info("End importInitAuthInfo");
        return Result.success("import successed!");
    }

    public Result queryUserInfo() {
        RUN_LOGGER.info("Start queryUserInfo");
        UserAuthenticateInfoBo authenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (ObjectUtils.isEmpty((Object)authenticateInfoBo)) {
            RUN_LOGGER.error("UserAuthenticateInfoBo info is empty.");
            return Result.fail(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode()));
        }
        UserAuthenticateInfoVo infoVo = new UserAuthenticateInfoVo();
        BeanUtils.copyProperties((Object)authenticateInfoBo, (Object)infoVo);
        ArrayList<UserAuthenticateInfoVo> infoVos = new ArrayList<UserAuthenticateInfoVo>();
        infoVos.add(infoVo);
        ArrayList<InternationalizeBo> internationalizeBos = this.dataInternationalizationUtil.getRegOfficeProductInternationalizeBos();
        internationalizeBos.add(this.dataInternationalizationUtil.getDictCodeInternationalizeBo("isPublicOmTerminal", "isPublicOmTerminalName", "isPublicOmTerminal"));
        this.dataInternationalizationUtil.setInternationalizeData(LanguageManager.getInstance().getCurLanguage().toLanguageTag(), infoVos, (List<InternationalizeBo>)internationalizeBos);
        RUN_LOGGER.info("End queryUserInfo");
        return Result.success(infoVos.get(0));
    }

    public Result queryControlPolicy() {
        RUN_LOGGER.info("Start queryControlPolicy");
        UserAuthenticateInfoBo queryActiveStatusUserInfo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (ObjectUtils.isEmpty((Object)queryActiveStatusUserInfo)) {
            RUN_LOGGER.error("The UserAuthenticateInfoBo info is empty.");
            return Result.fail(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode()));
        }
        TaskControlPolicyQueryVo taskControlPolicyQueryVo = new TaskControlPolicyQueryVo();
        BeanUtils.copyProperties((Object)queryActiveStatusUserInfo, (Object)taskControlPolicyQueryVo);
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), queryActiveStatusUserInfo.getLoginAccount());
        if (ObjectUtils.isNotEmpty((Object)taskInfoBo)) {
            if (TaskTypeEnum.QUERY.getTaskTypeEn().equals(taskInfoBo.getTaskType()) && !StringUtils.equals((CharSequence)"027425", (CharSequence)queryActiveStatusUserInfo.getRegionCode()) && !taskInfoBo.getTaskId().startsWith("NonChange")) {
                taskControlPolicyQueryVo.setInterceptPolicy(taskInfoBo.getInterceptPolicy());
            }
            if (TaskTypeEnum.MICRO_NETWORK_CHANGE.getTaskTypeEn().equals(taskInfoBo.getTaskType())) {
                String policyCode = InsidePolicyEnum.getPolicyCode(InterceptPolicyEnum.getPolicyEnumByValue(taskInfoBo.getInterceptPolicy()), RiskLevelEnum.getRiskEnumByCode(taskInfoBo.getRiskLevel()));
                taskControlPolicyQueryVo.setRoInsidePolicy(policyCode);
            }
        }
        List<InternationalizeBo> internationalizeBos = this.getInternationalizeBos();
        ArrayList<TaskControlPolicyQueryVo> controlPolicyQueryVos = new ArrayList<TaskControlPolicyQueryVo>();
        controlPolicyQueryVos.add(taskControlPolicyQueryVo);
        this.dataInternationalizationUtil.setInternationalizeData(LanguageManager.getInstance().getCurLanguage().toLanguageTag(), controlPolicyQueryVos, internationalizeBos);
        TaskControlPolicyQueryVo taskControlPolicy = (TaskControlPolicyQueryVo)controlPolicyQueryVos.get(0);
        if (StringUtils.isEmpty((CharSequence)taskControlPolicy.getNotStructuralComponentPolicy())) {
            RUN_LOGGER.info("End queryControlPolicy");
            return Result.success(null);
        }
        RUN_LOGGER.info("End queryControlPolicy");
        return Result.success(taskControlPolicy);
    }

    private List<InternationalizeBo> getInternationalizeBos() {
        ArrayList<InternationalizeBo> internationalizeBos = new ArrayList<InternationalizeBo>();
        internationalizeBos.add(this.dataInternationalizationUtil.getDictCodeInternationalizeBo("roInsidePolicy", "roInsidePolicyName", "insidePolicy"));
        internationalizeBos.add(this.dataInternationalizationUtil.getDictCodeInternationalizeBo("operationPreparationInsidePolicy", "operationPreparationInsidePolicyName", "insidePolicy"));
        internationalizeBos.add(this.dataInternationalizationUtil.getDictCodeInternationalizeBo("interceptPolicy", "interceptPolicyName", "interceptPolicy"));
        internationalizeBos.add(this.dataInternationalizationUtil.getDictCodeInternationalizeBo("notStructuralComponentPolicy", "notStructuralComponentPolicyName", "interceptPolicy"));
        internationalizeBos.add(this.dataInternationalizationUtil.getDictCodeInternationalizeBo("structuralComponentPolicy", "structuralComponentPolicyName", "interceptPolicy"));
        internationalizeBos.add(this.dataInternationalizationUtil.getDictCodeInternationalizeBo("datacomNetworkTiedPolicy", "datacomNetworkTiedPolicyName", "datacomNetworkTiedPolicy"));
        return internationalizeBos;
    }

    public Result updateUserInfo(UserAuthenticateInfoBo authenticateInfoBo) {
        RUN_LOGGER.info("Start updateUserInfo");
        UserAuthenticateInfoBo infoBo = new UserAuthenticateInfoBo();
        infoBo.setId(authenticateInfoBo.getId());
        if (ObjectUtils.isEmpty((Object)this.userAuthenticateInfoDao.queryUserInfo(infoBo))) {
            RUN_LOGGER.error("The subscriber data does not exist.");
            return Result.fail(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode()));
        }
        this.userAuthenticateInfoDao.updateUserAuthenticateInfo(authenticateInfoBo);
        RUN_LOGGER.info("End updateUserInfo");
        return Result.success("updateUserInfo success!");
    }

    public int isConnectedClient() {
        RUN_LOGGER.info("Start isConnectedClient");
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        if (hasConnectedClient.get("isConnected").booleanValue() || hasConnectedClient.get("isTelnet").booleanValue()) {
            String windowsAccount = this.getWindowsAccount();
            DeviceIdInfoBo deviceIdInfoBo = this.deviceInfoDao.queryDeviceInfo(windowsAccount);
            if (Objects.nonNull(deviceIdInfoBo) && StringUtils.isNotBlank((CharSequence)deviceIdInfoBo.getDeviceId()) && StringUtils.containsWhitespace((CharSequence)deviceIdInfoBo.getDeviceId())) {
                deviceIdInfoBo.setDeviceId(deviceIdInfoBo.getDeviceId().replaceAll(" ", "%20"));
            }
            Map<String, String> controlPolicyMap = this.commonDataDeal.queryControlPolicyForClient(deviceIdInfoBo);
            return this.commonDataDeal.getAuthInfoFromClient(deviceIdInfoBo, controlPolicyMap);
        }
        RUN_LOGGER.error("NetCareClient disconnected!");
        return 1;
    }

    private boolean importUserInfo(JSONObject jsonObject) {
        RUN_LOGGER.info("importUserInfo start.");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.commonDataDeal.insertInitAuthInfo(jsonObject, ONE, null);
        if (Objects.isNull(userAuthenticateInfoBo)) {
            RUN_LOGGER.error("AuthInfo is null.");
            return true;
        }
        if (ObjectUtils.isNotEmpty((Object)jsonObject.getJSONObject("defaultTaskInfo"))) {
            this.insertTaskInfo(jsonObject, userAuthenticateInfoBo);
        }
        RUN_LOGGER.info("importUserInfo end.");
        return false;
    }

    private Result getSignResult(String filepath, File dest) {
        String signFilePath = TEMP_PATH + File.separator + INIT_DATA_SIGN_FILE;
        String publicKey = PropertyUtil.getString("publicKeyToSign");
        String content = null;
        byte[] signByte = null;
        try {
            content = FileUtils.readFileToString((File)new File(filepath), (Charset)StandardCharsets.UTF_8);
            signByte = FileUtils.readFileToByteArray((File)new File(signFilePath));
        }
        catch (IOException e) {
            FileDealUtil.clearTempFiles(new File(dest.getParent()));
            RUN_LOGGER.error("Sign file failed, because read file failed.");
            return Result.fail(ErrorCodeEnum.VERIFY_SIGN_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.VERIFY_SIGN_FAILED.getErrorCode()));
        }
        boolean sigeResult = false;
        try {
            sigeResult = CmsSignUtils.verifySignature(RsaUtil.getPublicKey(publicKey), content, signByte);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            RUN_LOGGER.error("Sign file failed, because sign file exception.");
            return Result.fail(ErrorCodeEnum.VERIFY_SIGN_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.VERIFY_SIGN_FAILED.getErrorCode()));
        }
        if (!sigeResult) {
            RUN_LOGGER.error("Sign file failed, because sign file failed.");
            return Result.fail(ErrorCodeEnum.VERIFY_SIGN_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.VERIFY_SIGN_FAILED.getErrorCode()));
        }
        RUN_LOGGER.info("Sign the file succeed.");
        return null;
    }

    private Result unZipFiles(MultipartFile file, File dest) {
        boolean mkdirs;
        if (!dest.getParentFile().exists() && !(mkdirs = dest.getParentFile().mkdirs())) {
            RUN_LOGGER.error("Unzip,mkdir temp failed.");
            return Result.fail(ErrorCodeEnum.CREATE_TEMP_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.CREATE_TEMP_FAILED.getErrorCode()));
        }
        try (InputStream fileStream = file.getInputStream();){
            FileUtils.copyInputStreamToFile((InputStream)fileStream, (File)dest);
        }
        catch (IOException e) {
            RUN_LOGGER.error("Unzip,Copy zip file to dest failed.");
            return Result.fail(ErrorCodeEnum.UNZIP_FILE_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.UNZIP_FILE_FAILED.getErrorCode()));
        }
        try {
            String zipFilesMsg = ZipUtils.unZipFiles(dest, dest.getParent());
            if (Objects.nonNull(zipFilesMsg)) {
                RUN_LOGGER.error(zipFilesMsg);
                return Result.fail(1, zipFilesMsg);
            }
        }
        catch (IOException e) {
            FileDealUtil.clearTempFiles(new File(dest.getParent()));
            RUN_LOGGER.error("Unzip the zip file failed.");
            return Result.fail(ErrorCodeEnum.UNZIP_FILE_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.UNZIP_FILE_FAILED.getErrorCode()));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Result checkFileType(MultipartFile file, String fileName) {
        try (InputStream inputStream = file.getInputStream();){
            boolean isOk = FileDealUtil.checkFileType(inputStream, FileTypeEnum.ZIP);
            if (isOk) {
                if (fileName.startsWith("initAuth")) return null;
            }
            RUN_LOGGER.error("initAuth zip file check failed.");
            Result result = Result.fail(ErrorCodeEnum.COMPRESS_FILE_FORMAT_VERIFY_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.COMPRESS_FILE_FORMAT_VERIFY_FAILED.getErrorCode()));
            return result;
        }
        catch (IOException exception) {
            RUN_LOGGER.error("initAuth zip file check except.");
            return Result.fail(ErrorCodeEnum.COMPRESS_FILE_FORMAT_VERIFY_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.COMPRESS_FILE_FORMAT_VERIFY_FAILED.getErrorCode()));
        }
    }

    private void insertTaskInfo(JSONObject jsonObject, UserAuthenticateInfoBo userAuthenticateInfoBo) {
        JSONObject defaultTaskInfo = jsonObject.getJSONObject("defaultTaskInfo");
        if (defaultTaskInfo.isEmpty()) {
            RUN_LOGGER.info("defaultTaskInfo is empty.");
            return;
        }
        TaskInfoBo taskInfoBo = new TaskInfoBo();
        taskInfoBo.setTaskId(defaultTaskInfo.getString("taskId"));
        taskInfoBo.setTaskName(defaultTaskInfo.getString("taskName"));
        taskInfoBo.setTaskType(defaultTaskInfo.getString("taskType"));
        taskInfoBo.setTaskExecutor(defaultTaskInfo.getString("executor"));
        taskInfoBo.setTaskExecutorName(userAuthenticateInfoBo.getLoginAccountName());
        taskInfoBo.setInterceptPolicy(defaultTaskInfo.getString("interceptionType"));
        taskInfoBo.setTaskStartTime(this.stringToDate(defaultTaskInfo.getString("startTime")));
        taskInfoBo.setTaskEndTime(this.stringToDate(defaultTaskInfo.getString("endTime")));
        taskInfoBo.setRegion(userAuthenticateInfoBo.getRegion());
        taskInfoBo.setRepOffice(userAuthenticateInfoBo.getRepOffice());
        taskInfoBo.setRegionEn(userAuthenticateInfoBo.getRegionEn());
        taskInfoBo.setRepOfficeEn(userAuthenticateInfoBo.getRepOfficeEn());
        taskInfoBo.setRegionCode(userAuthenticateInfoBo.getRegionCode());
        taskInfoBo.setRepOfficeCode(userAuthenticateInfoBo.getRepOfficeCode());
        taskInfoBo.setProductLine(userAuthenticateInfoBo.getProductLine());
        taskInfoBo.setProductLineEn(userAuthenticateInfoBo.getProductLineEn());
        taskInfoBo.setProductLineCode(userAuthenticateInfoBo.getProductLineCode());
        taskInfoBo.setUpdateTime(DateUtil.getUtcDate(new Date()));
        taskInfoBo.setOperator(userAuthenticateInfoBo.getLoginAccount());
        taskInfoBo.setIsCurTask(true);
        taskInfoBo.setTaskStatus(TaskStatusNameEnum.ONGOING.getCode());
        this.insertOrUpdateDefaultTaskInfo(taskInfoBo);
    }

    private void insertOrUpdateDefaultTaskInfo(TaskInfoBo taskInfoBo) {
        TaskInfoBo taskInfo = this.taskInfoDao.queryTaskInfoByTaskId(taskInfoBo.getTaskId());
        if (Objects.nonNull(taskInfo)) {
            this.taskInfoDao.updateDefaultTaskInfo(taskInfoBo);
            RUN_LOGGER.info("Update TaskInfo success.");
        } else {
            taskInfoBo.setCreateTime(DateUtil.getUtcDate(new Date()));
            this.taskInfoDao.insertTaskInfo(taskInfoBo);
            RUN_LOGGER.info("Insert TaskInfo success.");
        }
        this.taskInfoDao.setOtherTask(taskInfoBo.getTaskId(), null);
        RUN_LOGGER.info("End createDefaultTask");
    }

    private String getWindowsAccount() {
        Properties prop = System.getProperties();
        return prop.getProperty("user.name");
    }

    private Date stringToDate(String time) {
        if (StringUtils.isEmpty((CharSequence)time)) {
            return null;
        }
        Date date = null;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = format.parse(time);
        }
        catch (ParseException e) {
            RUN_LOGGER.error("DateUtil translationTime is exception");
        }
        return date;
    }

    public Result checkVerify(String verifyCode, String account) {
        RUN_LOGGER.info("InitServiceImpl checkVerify start.");
        TaskInfoBo taskInfoBo = new TaskInfoBo();
        taskInfoBo.setTaskExecutor(this.getWindowsAccount());
        List<VerifyCodeRecordBo> verifyCodeRecordBoList = this.verifyCodeRecordDao.queryLastApplyByAccount("\u521d\u59cb\u5316\u9a8c\u8bc1", null, taskInfoBo.getTaskExecutor(), 3);
        Map<String, String> checkResultMap = this.verifyCodeUtil.checkVerifyCode(taskInfoBo, verifyCode, "\u521d\u59cb\u5316\u9a8c\u8bc1", 3);
        String errorCode = checkResultMap.get("errorCode");
        String checkResult = checkResultMap.get("errorMsg");
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            RUN_LOGGER.error(checkResult);
            RUN_LOGGER.info("InitServiceImpl checkVerify failed end.");
            return Result.fail(errorCode, checkResult);
        }
        String verifyCodeType = null;
        for (VerifyCodeRecordBo verifyCodeRecordBo : verifyCodeRecordBoList) {
            if (!Objects.nonNull(verifyCodeRecordBo) || !StringUtils.equals((CharSequence)verifyCode, (CharSequence)verifyCodeRecordBo.getVerifyCode())) continue;
            verifyCodeType = verifyCodeRecordBo.getVerifyCodeType();
            break;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        this.processReturnVerifyCode(account, verifyCodeType, result);
        RUN_LOGGER.info("InitServiceImpl checkVerify success end.");
        return Result.success(result);
    }

    private void processReturnVerifyCode(String account, String verifyCodeType, Map<String, String> result) {
        if (StringUtils.isNotEmpty((CharSequence)verifyCodeType) && StringUtils.equals((CharSequence)verifyCodeType, (CharSequence)InitManageControlPolicyEnum.NOCONTROL_AND_NOSCAN.getDataCode())) {
            this.insertUser(verifyCodeType, account);
            this.insertDefaultTaskInfo(account);
            result.put("isImport", ONE);
        }
        if (StringUtils.isNotEmpty((CharSequence)verifyCodeType) && StringUtils.equals((CharSequence)verifyCodeType, (CharSequence)InitManageControlPolicyEnum.NOCONTROL_AND_STARTSCAN.getDataCode())) {
            this.insertUser(verifyCodeType, account);
            this.insertDefaultTaskInfo(account);
            result.put("isImport", ONE);
        }
        if (StringUtils.isNotEmpty((CharSequence)verifyCodeType) && StringUtils.equals((CharSequence)verifyCodeType, (CharSequence)InitManageControlPolicyEnum.CONTROL_SCAN.getDataCode())) {
            if (StringUtils.isNotBlank((CharSequence)account) && !StringUtils.equals((CharSequence)"newUser", (CharSequence)account)) {
                TaskInfoBo taskInfoBo = this.taskInfoDao.queryDefaultActiveTask(DateUtil.getUtcDate(new Date()), "defaultTask");
                if (Objects.nonNull(taskInfoBo)) {
                    this.taskInfoDao.deleteTaskInfoByTaskId(taskInfoBo);
                }
                UserAuthenticateInfoBo userAuthenticateInfoBo = new UserAuthenticateInfoBo();
                userAuthenticateInfoBo.setLoginAccount(account);
                UserAuthenticateInfoBo authenticateInfoBo = this.userAuthenticateInfoDao.queryUserInfo(userAuthenticateInfoBo);
                if (StringUtils.equalsAny((CharSequence)authenticateInfoBo.getInitManageControlPolicy(), (CharSequence[])new CharSequence[]{InitManageControlPolicyEnum.CONTROL_SCAN.getDataCode(), InitManageControlPolicyEnum.NOCONTROL_AND_STARTSCAN.getDataCode()})) {
                    userAuthenticateInfoBo.setInitManageControlPolicy(verifyCodeType);
                    userAuthenticateInfoBo.setCurStatus(0);
                    this.userAuthenticateInfoDao.updateUserControlPolicy(userAuthenticateInfoBo);
                    this.userAuthenticateInfoDao.updateOtherUserToNotCurrent(account);
                    result.put("isImport", ONE);
                }
            } else {
                result.put("isImport", ZERO);
            }
        }
    }

    private void insertDefaultTaskInfo(String account) {
        UserAuthenticateInfoBo authenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        TaskInfoBo defaultTask = InitSwingService.setDefaultTaskInfo(null);
        if (Objects.nonNull(authenticateInfoBo)) {
            defaultTask.setTaskExecutor(authenticateInfoBo.getLoginAccount());
            defaultTask.setTaskExecutorName(authenticateInfoBo.getLoginAccountName());
            if (Objects.isNull(authenticateInfoBo.getIsPublicOmTerminal()) || !authenticateInfoBo.getIsPublicOmTerminal().booleanValue()) {
                this.taskInfoDao.deleteTaskInfo(null);
            } else {
                TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), account);
                if (Objects.nonNull(taskInfoBo)) {
                    TaskInfoBo taskBo = new TaskInfoBo();
                    taskBo.setTaskId(taskInfoBo.getTaskId());
                    taskBo.setTaskStatus(TaskStatusNameEnum.TO_DO.getCode());
                    taskBo.setIsCurTask(false);
                    this.taskInfoDao.updateTask(taskBo);
                }
            }
        }
        this.insertOrUpdateDefaultTaskInfo(defaultTask);
    }

    private static TaskInfoBo setDefaultTaskInfo(UserAuthenticateInfoBo userAuthenticateInfoBo) {
        TaskInfoBo defaultTask = new TaskInfoBo();
        defaultTask.setTaskId("defaultTask");
        defaultTask.setTaskName("Default Task");
        defaultTask.setTaskType("query");
        defaultTask.setTaskExecutor("Default User");
        defaultTask.setTaskExecutorName("Default User");
        defaultTask.setInterceptPolicy(InterceptPolicyEnum.NO_INTERCEPT.getValue());
        defaultTask.setTaskStartTime(DateUtil.getUtcDate(new Date()));
        defaultTask.setTaskEndTime(DateUtil.addMonth(DateUtil.getUtcDate(new Date()), 360));
        defaultTask.setOperator("Default User");
        defaultTask.setIsCurTask(true);
        defaultTask.setTaskStatus(TaskStatusNameEnum.ONGOING.getCode());
        if (Objects.nonNull(userAuthenticateInfoBo)) {
            defaultTask.setTaskExecutor(userAuthenticateInfoBo.getLoginAccount());
            defaultTask.setTaskExecutorName(userAuthenticateInfoBo.getLoginAccountName());
            defaultTask.setOperator(userAuthenticateInfoBo.getLoginAccount());
        }
        return defaultTask;
    }

    private void insertUser(String verifyCodeType, String account) {
        UserAuthenticateInfoBo authenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(authenticateInfoBo)) {
            UserAuthenticateInfoBo userAuthenticateInfoBo = this.setUserParam(verifyCodeType);
            this.userAuthenticateInfoDao.insertUserAuthenticateInfo(userAuthenticateInfoBo);
        } else if (StringUtils.isEmpty((CharSequence)account) || StringUtils.equals((CharSequence)account, (CharSequence)"newUser")) {
            UserAuthenticateInfoBo authenticateInfo = new UserAuthenticateInfoBo();
            authenticateInfo.setLoginAccount("Default User");
            UserAuthenticateInfoBo infoBo = this.userAuthenticateInfoDao.queryUserInfo(authenticateInfo);
            if (Objects.nonNull(infoBo)) {
                UserAuthenticateInfoBo userAuthenticateInfoBo = new UserAuthenticateInfoBo();
                userAuthenticateInfoBo.setId(infoBo.getId());
                userAuthenticateInfoBo.setInitManageControlPolicy(verifyCodeType);
                userAuthenticateInfoBo.setCurStatus(0);
                userAuthenticateInfoBo.setUpdateTime(DateUtil.getUtcDate(new Date()));
                this.userAuthenticateInfoDao.updateOtherUserToNotCurrent("Default User");
                this.userAuthenticateInfoDao.updateUserAuthenticateInfo(userAuthenticateInfoBo);
            } else {
                UserAuthenticateInfoBo userAuthenticateInfoBo = this.setUserParam(verifyCodeType);
                this.userAuthenticateInfoDao.updateOtherUserToNotCurrent("Default User");
                this.userAuthenticateInfoDao.insertUserAuthenticateInfo(userAuthenticateInfoBo);
            }
        } else {
            UserAuthenticateInfoBo userAuthenticateInfoBo = new UserAuthenticateInfoBo();
            userAuthenticateInfoBo.setLoginAccount(account);
            userAuthenticateInfoBo.setInitManageControlPolicy(verifyCodeType);
            userAuthenticateInfoBo.setCurStatus(0);
            this.userAuthenticateInfoDao.updateOtherUserToNotCurrent(account);
            this.userAuthenticateInfoDao.updateUserControlPolicy(userAuthenticateInfoBo);
        }
    }

    private UserAuthenticateInfoBo setUserParam(String verifyCodeType) {
        DeviceIdInfoBo deviceIdInfoBo = this.deviceInfoDao.queryDeviceInfo(this.getWindowsAccount());
        UserAuthenticateInfoBo userAuthenticateInfoBo = new UserAuthenticateInfoBo();
        userAuthenticateInfoBo.setWindowsAccount(this.getWindowsAccount());
        userAuthenticateInfoBo.setLoginAccount("Default User");
        userAuthenticateInfoBo.setLoginAccountName("Default User");
        userAuthenticateInfoBo.setEsn(deviceIdInfoBo.getEsn());
        userAuthenticateInfoBo.setDeviceId(deviceIdInfoBo.getDeviceId());
        userAuthenticateInfoBo.setNotStructuralComponentPolicy(InterceptPolicyEnum.NO_INTERCEPT.getValue());
        userAuthenticateInfoBo.setStructuralComponentPolicy(InterceptPolicyEnum.NO_INTERCEPT.getValue());
        userAuthenticateInfoBo.setDatacomNetworkTiedPolicy(DatacomNetworkTiedPolicyEnum.NO_INTERCEPT.getValueEn());
        userAuthenticateInfoBo.setOperationPreparationInsidePolicy(InsidePolicyEnum.NO_INTERCEPT.getCode());
        userAuthenticateInfoBo.setCurStatus(0);
        userAuthenticateInfoBo.setAuthValidatePeriod("9999");
        userAuthenticateInfoBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        userAuthenticateInfoBo.setUpdateTime(DateUtil.getUtcDate(new Date()));
        userAuthenticateInfoBo.setOperator("Default User");
        userAuthenticateInfoBo.setSite(site);
        userAuthenticateInfoBo.setIsDefaultUser(ZERO);
        userAuthenticateInfoBo.setInitManageControlPolicy(verifyCodeType);
        return userAuthenticateInfoBo;
    }

    public BufferedImage getInitToolAuthQRCode(InitQrInfoVo initQrInfoVo) {
        RUN_LOGGER.info("Start getInitToolAuthQRCode.");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.nonNull(userAuthenticateInfoBo) && StringUtils.isNotEmpty((CharSequence)userAuthenticateInfoBo.getInitManageControlPolicy()) && InitManageControlPolicyEnum.NOCONTROL_AND_NOSCAN.getDataCode().equals(userAuthenticateInfoBo.getInitManageControlPolicy())) {
            RUN_LOGGER.info("The management and control policy is no control. Initialization is not performed.");
            return null;
        }
        String windowsAccount = this.getWindowsAccount();
        DeviceIdInfoBo deviceIdInfoBo = this.deviceInfoDao.queryDeviceInfo(windowsAccount);
        if (deviceIdInfoBo == null) {
            RUN_LOGGER.error("Query device info failed.");
            return null;
        }
        try {
            BufferedImage initQrCodeInfo = this.createInitQrCodeInfo(initQrInfoVo, deviceIdInfoBo, userAuthenticateInfoBo);
            RUN_LOGGER.info("End getInitToolAuthQRCode.");
            if (Objects.nonNull(userAuthenticateInfoBo)) {
                UserAuthenticateInfoBo authenticateInfoBo = new UserAuthenticateInfoBo();
                authenticateInfoBo.setId(userAuthenticateInfoBo.getId());
                String siteInfo = StringUtils.isEmpty((CharSequence)initQrInfoVo.getSite()) ? userAuthenticateInfoBo.getSite() : initQrInfoVo.getSite();
                authenticateInfoBo.setSite(siteInfo);
                this.userAuthenticateInfoDao.updateUserAuthenticateInfo(authenticateInfoBo);
            } else {
                site = initQrInfoVo.getSite();
            }
            return initQrCodeInfo;
        }
        catch (NetCareInsideSdkException | IOException e) {
            RUN_LOGGER.error("Create qrcode image failed.");
            return null;
        }
    }

    private BufferedImage createInitQrCodeInfo(InitQrInfoVo initQrInfoVo, DeviceIdInfoBo deviceIdInfoBo, UserAuthenticateInfoBo userAuthenticateInfoBo) throws IOException {
        String siteInfo = StringUtils.isNotBlank((CharSequence)initQrInfoVo.getSite()) ? initQrInfoVo.getSite() : site;
        String initAuthUrl = PropertyUtil.getScanQrUrl("toolInitializationUrl", siteInfo) + "?";
        String stmInfo = this.stmInfoDao.queryStmInfo();
        String accountAndVerifyCode = "";
        try {
            accountAndVerifyCode = this.getAccountAndVerifyCode(deviceIdInfoBo, stmInfo, initQrInfoVo, userAuthenticateInfoBo);
        }
        catch (UnsupportedEncodingException | GeneralSecurityException exception) {
            RUN_LOGGER.error("The verifyCode URLEncoder encode error.");
        }
        return QRCodeUtil.createImage(initAuthUrl + accountAndVerifyCode + "&lang=" + LanguageManager.getInstance().getCurLanguage());
    }

    private String getAccountAndVerifyCode(DeviceIdInfoBo deviceIdInfoBo, String stmInfo, InitQrInfoVo initQrInfoVo, UserAuthenticateInfoBo userAuthenticateInfoBo) throws UnsupportedEncodingException, GeneralSecurityException {
        String accountAndVerifyCode;
        StringBuilder verifyCode = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            String code = this.verifyCodeUtil.generalVerifyCode(6);
            this.insertVerifyCode(code, deviceIdInfoBo.getWindowsAccount(), i);
            verifyCode.append(code).append("#");
        }
        if (Objects.nonNull(userAuthenticateInfoBo)) {
            String isPublic;
            boolean isNewUser = StringUtils.isNotBlank((CharSequence)initQrInfoVo.getAccount()) && !StringUtils.equals((CharSequence)initQrInfoVo.getAccount(), (CharSequence)"newUser");
            String string = isPublic = Objects.nonNull(userAuthenticateInfoBo.getIsPublicOmTerminal()) ? String.valueOf(userAuthenticateInfoBo.getIsPublicOmTerminal()) : "";
            if (StringUtils.equals((CharSequence)"Default User", (CharSequence)userAuthenticateInfoBo.getLoginAccount())) {
                accountAndVerifyCode = this.addStmInfoParams(stmInfo) + "&deviceId=" + deviceIdInfoBo.getDeviceId() + "&esn=" + deviceIdInfoBo.getEsn() + "&isPublic=" + isPublic + "&verify=" + URLEncoder.encode(RsaUtil.encrypt(verifyCode.substring(0, verifyCode.length() - 1), PropertyUtil.getString("pubkeyByEncrypt")), "UTF-8");
            } else {
                String codeAndAccount = isNewUser ? verifyCode + "@" + initQrInfoVo.getAccount() : verifyCode.substring(0, verifyCode.length() - 1);
                accountAndVerifyCode = this.addStmInfoParams(stmInfo) + "deviceId=" + deviceIdInfoBo.getDeviceId() + "&esn=" + deviceIdInfoBo.getEsn() + "&isPublic=" + isPublic + "&verify=" + URLEncoder.encode(RsaUtil.encrypt(codeAndAccount, PropertyUtil.getString("pubkeyByEncrypt")), "UTF-8");
            }
        } else {
            String info = "deviceId=" + deviceIdInfoBo.getDeviceId() + "&esn=" + deviceIdInfoBo.getEsn() + "&isPublic=&" + this.addStmInfoParams(stmInfo);
            accountAndVerifyCode = info + "verify=" + URLEncoder.encode(RsaUtil.encrypt(verifyCode.substring(0, verifyCode.length() - 1), PropertyUtil.getString("pubkeyByEncrypt")), "UTF-8");
        }
        return accountAndVerifyCode;
    }

    private String addStmInfoParams(String stmInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)stmInfo)) {
            return "";
        }
        JSONObject jsonObject = JSONObject.parseObject((String)stmInfo);
        return stringBuilder.append("uid=").append(jsonObject.getString("uid")).append("&certDate=").append(jsonObject.getString("certDate")).append("&offeringId=").append(jsonObject.getString("offeringId")).append("&statusType=").append(jsonObject.getString("statusType")).append("&certType=").append(jsonObject.getString("certType")).append("&versionId=").append(jsonObject.getString("versionId")).append("&installTime=").append(jsonObject.getString("installTime")).append("&country=").append(jsonObject.getString("country")).append("&region=").append(jsonObject.getString("region")).append("&province=").append(jsonObject.getString("province")).append("&city=").append(jsonObject.getString("city")).append("&").toString();
    }

    private void insertVerifyCode(String verifyCode, String windowsAccount, int index) {
        VerifyCodeRecordBo codeRecordBo = new VerifyCodeRecordBo();
        codeRecordBo.setVerifyType("\u521d\u59cb\u5316\u9a8c\u8bc1");
        codeRecordBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        codeRecordBo.setVerifyCode(verifyCode);
        codeRecordBo.setAccount(windowsAccount);
        codeRecordBo.setVerifyStatus(2);
        codeRecordBo.setActivePeriod("30");
        codeRecordBo.setOperator(windowsAccount);
        codeRecordBo.setVerifyCodeType(String.valueOf(index));
        this.verifyCodeRecordDao.insertRecord(codeRecordBo);
    }

    public UserInfoResultVo queryUserList() {
        List<UserAuthenticateInfoBo> userAuthenticateInfoBos = this.userAuthenticateInfoDao.queryUserList();
        UserInfoResultVo userInfoResultVo = new UserInfoResultVo();
        if (CollectionUtils.isEmpty(userAuthenticateInfoBos)) {
            return userInfoResultVo;
        }
        if (userAuthenticateInfoBos.size() == 1) {
            userInfoResultVo.setIsPublicOmTerminal(userAuthenticateInfoBos.get(0).getIsPublicOmTerminal());
            userInfoResultVo.setCurrentUser(userAuthenticateInfoBos.get(0).getLoginAccount());
            UserInfoResultVo.UserInfoVo userInfoVo = new UserInfoResultVo.UserInfoVo();
            userInfoVo.setLoginAccount(userAuthenticateInfoBos.get(0).getLoginAccount());
            userInfoVo.setLoginAccountName(userAuthenticateInfoBos.get(0).getLoginAccountName());
            userInfoVo.setSite(userAuthenticateInfoBos.get(0).getSite());
            userInfoVo.setCurrentStatus(String.valueOf(userAuthenticateInfoBos.get(0).getCurStatus()));
            userInfoResultVo.setUserList(Collections.singletonList(userInfoVo));
            return userInfoResultVo;
        }
        ArrayList<UserInfoResultVo.UserInfoVo> userInfoVoList = new ArrayList<UserInfoResultVo.UserInfoVo>();
        for (UserAuthenticateInfoBo userAuthenticateInfoBo : userAuthenticateInfoBos) {
            UserInfoResultVo.UserInfoVo userVo = new UserInfoResultVo.UserInfoVo();
            userInfoResultVo.setIsPublicOmTerminal(userAuthenticateInfoBos.get(0).getIsPublicOmTerminal());
            if (0 == userAuthenticateInfoBo.getCurStatus()) {
                userInfoResultVo.setCurrentUser(userAuthenticateInfoBo.getLoginAccount());
            }
            userVo.setLoginAccount(userAuthenticateInfoBo.getLoginAccount());
            userVo.setLoginAccountName(userAuthenticateInfoBo.getLoginAccountName());
            userVo.setSite(userAuthenticateInfoBo.getSite());
            userVo.setCurrentStatus(String.valueOf(userAuthenticateInfoBo.getCurStatus()));
            userInfoVoList.add(userVo);
        }
        userInfoResultVo.setUserList(userInfoVoList);
        return userInfoResultVo;
    }

    static {
        TEMP_PATH = System.getProperties().getProperty("user.home") + File.separator + "insideTemp";
    }
}

