/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swingservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.DatacomNetworkTiedCommandBo;
import com.huawei.netcareinsidesdk.bo.DatacomNetworkTiedDataBo;
import com.huawei.netcareinsidesdk.bo.DatacomNetworkTiedInterceptRecordBo;
import com.huawei.netcareinsidesdk.bo.DeviceIdInfoBo;
import com.huawei.netcareinsidesdk.bo.EngineeringCommissioningNesBo;
import com.huawei.netcareinsidesdk.bo.ExcuteResultSwingBo;
import com.huawei.netcareinsidesdk.bo.RequestData;
import com.huawei.netcareinsidesdk.bo.ScheduleTaskBo;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.bo.VerifyCodeRecordBo;
import com.huawei.netcareinsidesdk.constants.DatacomNetworkTiedPolicyEnum;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.constants.HandlingMethodEnum;
import com.huawei.netcareinsidesdk.dao.DatacomNetworkTiedCommandDao;
import com.huawei.netcareinsidesdk.dao.DatacomNetworkTiedDataDao;
import com.huawei.netcareinsidesdk.dao.DatacomNetworkTiedInterceptRecordDao;
import com.huawei.netcareinsidesdk.dao.DeviceInfoDao;
import com.huawei.netcareinsidesdk.dao.EngineeringCommissioningNesMapper;
import com.huawei.netcareinsidesdk.dao.ScheduleTaskDao;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.dao.VerifyCodeRecordDao;
import com.huawei.netcareinsidesdk.dto.InterceptLogDto;
import com.huawei.netcareinsidesdk.dto.InterceptLogResponseDto;
import com.huawei.netcareinsidesdk.exception.NetCareInsideSdkException;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.HttpUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.PageBean;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.RsaUtil;
import com.huawei.netcareinsidesdk.utils.TelnetUtil;
import com.huawei.netcareinsidesdk.utils.VerifyCodeUtil;
import com.huawei.netcareinsidesdk.vo.BizNetChkCommandVo;
import com.huawei.netcareinsidesdk.vo.BizNetCommandInfoQueryVo;
import com.huawei.netcareinsidesdk.vo.DatacomNetworkTiedCommandVo;
import com.huawei.netcareinsidesdk.vo.DatacomNetworkTiedDataVo;
import com.huawei.netcareinsidesdk.vo.ExcuteResultVo;
import com.huawei.netcareinsidesdk.vo.VerifyCodeVo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NELoginSwingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NELoginSwingService.class);
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private VerifyCodeRecordDao verifyCodeRecordDao;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private DatacomNetworkTiedCommandDao commandDao;
    @Autowired
    private DatacomNetworkTiedInterceptRecordDao interceptRecordDao;
    @Autowired
    private EngineeringCommissioningNesMapper nesMapper;
    @Autowired
    private DatacomNetworkTiedDataDao tiedDataDao;
    @Autowired
    private VerifyCodeUtil verifyCodeUtil;
    @Autowired
    private ScheduleTaskDao scheduleTaskDao;
    @Autowired
    private DeviceInfoDao deviceInfoDao;
    @Autowired
    private TelnetUtil telnetUtil;

    public String getEncryptAccountAndCode(String verifyName, String urlKey) {
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userAuthenticateInfoBo)) {
            throw new NetCareInsideSdkException("This userAuthenticateInfo is abnormal. The userAuthenticateInfo is empty.");
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        if (Objects.isNull(taskInfoBo)) {
            throw new NetCareInsideSdkException("Current task executor is Empty!");
        }
        String verifyCode = this.verifyCodeUtil.generalVerifyCode(6);
        this.insertVerifyCode(taskInfoBo, verifyCode, verifyName);
        String siteInfo = StringUtils.isNotBlank((CharSequence)userAuthenticateInfoBo.getSite()) ? userAuthenticateInfoBo.getSite() : "China";
        return PropertyUtil.getScanQrUrl(urlKey, siteInfo) + "?accountAndVerifyCode=" + this.getEncryptStr(verifyCode, userAuthenticateInfoBo);
    }

    public Result checkAccountIdentity(VerifyCodeVo verifyCodeVo, String verifyType) {
        LOGGER.info("Start checkAccountIdentity.");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userAuthenticateInfoBo)) {
            return Result.fail(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode()));
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        if (Objects.isNull(taskInfoBo)) {
            LOGGER.error("This task is abnormal. The task is empty.");
            return Result.fail(ErrorCodeEnum.TICKET_INFO_IS_EMPTY.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.TICKET_INFO_IS_EMPTY.getErrorCode()));
        }
        Map<String, String> checkResultMap = this.verifyCodeUtil.checkVerifyCode(taskInfoBo, verifyCodeVo.getVerifyCode(), verifyType, 1);
        String errorCode = checkResultMap.get("errorCode");
        String checkResult = checkResultMap.get("errorMsg");
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            LOGGER.error(checkResult);
            return Result.fail(errorCode, checkResult);
        }
        return Result.success();
    }

    private String getEncryptStr(String verifyCode, UserAuthenticateInfoBo userAuthenticateInfoBo) {
        String pubKey = PropertyUtil.getString("pubkeyByEncrypt");
        try {
            String accountAndVerifyCodeEncrypt = null;
            accountAndVerifyCodeEncrypt = Objects.nonNull(userAuthenticateInfoBo.getIsPublicOmTerminal()) && userAuthenticateInfoBo.getIsPublicOmTerminal() != false ? URLEncoder.encode(RsaUtil.encrypt(verifyCode, pubKey), "UTF-8") : URLEncoder.encode(RsaUtil.encrypt(verifyCode + "@" + userAuthenticateInfoBo.getLoginAccount(), pubKey), "UTF-8");
            return accountAndVerifyCodeEncrypt;
        }
        catch (UnsupportedEncodingException | GeneralSecurityException except) {
            LOGGER.error("accountAndVerifyCodeEncrypt exception.");
            return null;
        }
    }

    private void insertVerifyCode(TaskInfoBo taskInfoBo, String verifyCode, String verifyName) {
        VerifyCodeRecordBo verifyCodeRecordBo = new VerifyCodeRecordBo();
        verifyCodeRecordBo.setVerifyType(verifyName);
        verifyCodeRecordBo.setTaskId(taskInfoBo.getTaskId());
        verifyCodeRecordBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        verifyCodeRecordBo.setAccount(taskInfoBo.getTaskExecutor());
        verifyCodeRecordBo.setVerifyCode(verifyCode);
        verifyCodeRecordBo.setVerifyStatus(2);
        verifyCodeRecordBo.setOperator(taskInfoBo.getTaskExecutor());
        verifyCodeRecordBo.setActivePeriod("30");
        this.verifyCodeRecordDao.insertRecord(verifyCodeRecordBo);
    }

    public BizNetCommandInfoQueryVo getBizNetChkCommand(BizNetChkCommandVo bizNetChkCommandVo) {
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        Integer pageNum = Integer.parseInt(bizNetChkCommandVo.getPageNum());
        Integer pageSize = Integer.parseInt(bizNetChkCommandVo.getPageSize());
        List<DatacomNetworkTiedCommandBo> datacomNetworkTiedCommandBos = this.commandDao.queryDatacomNetworkTiedCommand(userAuthenticateInfoBo.getLoginAccount());
        PageBean<DatacomNetworkTiedCommandBo> datacomNetworkTiedCommandBoPageBean = new PageBean<DatacomNetworkTiedCommandBo>(pageNum, pageSize, datacomNetworkTiedCommandBos);
        ArrayList<DatacomNetworkTiedCommandVo> networkTiedCommandVos = new ArrayList<DatacomNetworkTiedCommandVo>();
        for (DatacomNetworkTiedCommandBo commandBo : datacomNetworkTiedCommandBoPageBean.getList()) {
            DatacomNetworkTiedCommandVo commandVo = new DatacomNetworkTiedCommandVo();
            BeanUtils.copyProperties((Object)commandBo, (Object)commandVo);
            commandVo.setOperator(userAuthenticateInfoBo.getLoginAccountName());
            networkTiedCommandVos.add(commandVo);
        }
        BizNetCommandInfoQueryVo bizNetCommandInfoQueryVo = new BizNetCommandInfoQueryVo();
        bizNetCommandInfoQueryVo.setTotal(this.commandDao.queryDatacomNetworkTiedCommandCount(userAuthenticateInfoBo.getLoginAccount()));
        bizNetCommandInfoQueryVo.setNetworkTiedCommandVos(networkTiedCommandVos);
        LOGGER.info("End getBizNetChkCommand");
        return bizNetCommandInfoQueryVo;
    }

    public Result getCheckBizNetAccessResult(String guid) {
        LOGGER.info("Start getCheckBizNetAccessResult.");
        DatacomNetworkTiedInterceptRecordBo interceptRecordBo = this.interceptRecordDao.selectByGuid(guid);
        if (Objects.isNull(interceptRecordBo)) {
            LOGGER.error("The datacom network-tied interception record does not exist.");
            return Result.fail(ErrorCodeEnum.DATACOM_NETWORK_RECORD_NOT_EXIST.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.DATACOM_NETWORK_RECORD_NOT_EXIST.getErrorCode()));
        }
        DatacomNetworkTiedDataVo tiedDataVo = new DatacomNetworkTiedDataVo();
        tiedDataVo.setUpNum(this.internationalizeUtil.getMessage("10056", Collections.singletonList(interceptRecordBo.getSubReason())));
        if (StringUtils.isNotBlank((CharSequence)interceptRecordBo.getAnalysisResults()) && Integer.parseInt(interceptRecordBo.getAnalysisResults()) > 0) {
            tiedDataVo.setNesNum(this.internationalizeUtil.getMessage("10057", Arrays.asList(interceptRecordBo.getProductType(), interceptRecordBo.getAnalysisResults())));
        }
        DatacomNetworkTiedDataBo datacomNetworkTiedDataBo = this.tiedDataDao.queryDatacomNetworkTiedData();
        HashMap<String, List<String>> sourceData = new HashMap<String, List<String>>();
        this.checkedConversion(datacomNetworkTiedDataBo, sourceData);
        ArrayList excuteResultBos = new ArrayList();
        sourceData.entrySet().stream().forEach(stringListEntry -> {
            ExcuteResultSwingBo excuteResultBo = new ExcuteResultSwingBo();
            excuteResultBo.setExeCommand((String)stringListEntry.getKey());
            List entryList = (List)stringListEntry.getValue();
            ArrayList<ExcuteResultVo> excuteResultVos = new ArrayList<ExcuteResultVo>();
            entryList.stream().forEach(entry -> {
                ExcuteResultVo excuteResultVo = new ExcuteResultVo();
                excuteResultVo.setExeCommand(entry.trim());
                excuteResultVos.add(excuteResultVo);
            });
            excuteResultBo.setExeResult(excuteResultVos);
            excuteResultBos.add(excuteResultBo);
            tiedDataVo.setSourceData(excuteResultBos);
            LOGGER.info("The result of the grid-tied command is parsed successfully.");
        });
        LOGGER.info("End getCheckBizNetAccessResult.");
        return Result.success(tiedDataVo);
    }

    private void checkedConversion(DatacomNetworkTiedDataBo datacomNetworkTiedDataBo, Map<String, List<String>> sourceData) {
        LOGGER.info("Rectify the compilation alarm for checkedConversion.");
        if (Objects.nonNull(datacomNetworkTiedDataBo) && StringUtils.isNotEmpty((CharSequence)datacomNetworkTiedDataBo.getSourceData())) {
            Map sourceDataInfos = new HashMap();
            sourceDataInfos = (Map)JSONObject.parseObject((String)datacomNetworkTiedDataBo.getSourceData(), sourceDataInfos.getClass());
            sourceDataInfos.entrySet().stream().forEach(sourceDataInfo -> {
                if (sourceDataInfo.getKey() instanceof String && sourceDataInfo.getValue() instanceof List) {
                    List arrayList = new ArrayList();
                    arrayList = (List)JSONObject.parseObject((String)JSONObject.toJSONString(sourceDataInfo.getValue()), arrayList.getClass());
                    ArrayList list = new ArrayList();
                    arrayList.stream().forEach(array -> list.add((String)array));
                    sourceData.put((String)sourceDataInfo.getKey(), list);
                }
            });
        }
    }

    public Result updateBizNetInterceptRecord(DatacomNetworkTiedInterceptRecordBo interceptRecordBo) {
        DatacomNetworkTiedInterceptRecordBo tiedInterceptRecordBo = this.interceptRecordDao.selectByGuid(interceptRecordBo.getGuid());
        if (ObjectUtils.isEmpty((Object)tiedInterceptRecordBo)) {
            LOGGER.error("The datacom network-tied interception record does not exist.");
            return Result.fail(ErrorCodeEnum.DATACOM_NETWORK_RECORD_NOT_EXIST.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.DATACOM_NETWORK_RECORD_NOT_EXIST.getErrorCode()));
        }
        VerifyCodeVo verifyCodeVo = new VerifyCodeVo();
        verifyCodeVo.setVerifyCode(interceptRecordBo.getLockCode());
        Result checkAccountIdentity = this.checkAccountIdentity(verifyCodeVo, "\u6570\u901a\u5e76\u7f51\u64cd\u4f5c\u9a8c\u8bc1");
        if (!checkAccountIdentity.get("code").equals("0")) {
            return checkAccountIdentity;
        }
        interceptRecordBo.setUnLockTime(DateUtil.getUtcDate(new Date()));
        interceptRecordBo.setHandlingMethod(HandlingMethodEnum.CONTINUE_OPERATION.getValue());
        this.interceptRecordDao.updateByGuid(interceptRecordBo);
        List<Object> nesBos = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)tiedInterceptRecordBo.getAnalysisResults()) && Integer.parseInt(tiedInterceptRecordBo.getAnalysisResults()) > 0) {
            nesBos = this.nesMapper.queryEngineeringCommissioningNesByTaskId(tiedInterceptRecordBo.getTaskId());
        }
        if (ObjectUtils.isNotEmpty(nesBos) && nesBos.size() > 0) {
            EngineeringCommissioningNesBo nesBo = new EngineeringCommissioningNesBo();
            nesBo.setTaskId(tiedInterceptRecordBo.getTaskId());
            nesBo.setApprovalTag(Boolean.TRUE);
            LOGGER.info("Succeeded updateEngineeringCommissioningNes, the nes ip is {}.", (Object)nesBos.size());
            this.nesMapper.updateEngineeringCommissioningNes(nesBo);
        }
        tiedInterceptRecordBo.setUnLockTime(interceptRecordBo.getUnLockTime());
        tiedInterceptRecordBo.setHandlingMethod(interceptRecordBo.getHandlingMethod());
        tiedInterceptRecordBo.setLockCode(interceptRecordBo.getLockCode());
        this.reportLog(tiedInterceptRecordBo, HandlingMethodEnum.CONTINUE_OPERATION);
        return Result.success("updateBizNetInterceptRecord success.");
    }

    private void reportLog(DatacomNetworkTiedInterceptRecordBo tiedInterceptRecordBo, HandlingMethodEnum handlingMethodEnum) {
        InterceptLogDto interceptLogDto = this.buildInterceptLogDto(tiedInterceptRecordBo, handlingMethodEnum);
        ArrayList<ScheduleTaskBo> scheduleTaskBoList = new ArrayList<ScheduleTaskBo>();
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        if (hasConnectedClient.get("isConnected").booleanValue()) {
            this.reportLogToNetCare(Collections.singletonList(interceptLogDto), scheduleTaskBoList);
        }
        if (!CollectionUtils.isEmpty(scheduleTaskBoList)) {
            this.scheduleTaskDao.batchInsert(scheduleTaskBoList);
            LOGGER.info("batchInsert Scheduled Task success.");
        }
        LOGGER.info("Succeeded in updating the interception record.");
    }

    public String getBizNetQRCode(String guid) {
        LOGGER.info("Obtain the generated QR code data.");
        DatacomNetworkTiedInterceptRecordBo interceptRecordBo = this.interceptRecordDao.selectByGuid(guid);
        if (ObjectUtils.isEmpty((Object)interceptRecordBo)) {
            LOGGER.error("getBizNetQRCode interceptRecordBo is null.");
            throw new NetCareInsideSdkException("This interceptRecordBo is abnormal. The interceptRecordBo is empty.");
        }
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (ObjectUtils.isEmpty((Object)userAuthenticateInfoBo)) {
            LOGGER.error("getBizNetQRCode userAuthenticateInfoBo is null.");
            throw new NetCareInsideSdkException("This userAuthenticateInfoBo is abnormal. The userAuthenticateInfoBo is empty.");
        }
        String windowsAccount = this.getWindowsAccount();
        DeviceIdInfoBo deviceIdInfoBo = this.deviceInfoDao.queryDeviceInfo(windowsAccount);
        String deviceId = "";
        if (ObjectUtils.isNotEmpty((Object)deviceIdInfoBo)) {
            deviceId = deviceIdInfoBo.getDeviceId();
        }
        return String.join((CharSequence)"&", "taskNum=" + interceptRecordBo.getTaskId(), "ne=" + interceptRecordBo.getAnalysisResults(), "up=" + interceptRecordBo.getSubReason(), "ip=" + interceptRecordBo.getProductType(), "regionCode=" + userAuthenticateInfoBo.getRegionCode(), "repOfficeCode=" + userAuthenticateInfoBo.getRepOfficeCode(), "deviceId=" + deviceId);
    }

    public Result updateHandlingMethod(DatacomNetworkTiedInterceptRecordBo interceptRecordBo) {
        LOGGER.info("updateHandlingMethod start.");
        DatacomNetworkTiedInterceptRecordBo datacomNetworkTiedInterceptRecordBo = this.interceptRecordDao.selectByGuid(interceptRecordBo.getGuid());
        if (ObjectUtils.isEmpty((Object)datacomNetworkTiedInterceptRecordBo)) {
            LOGGER.info("The datacom network-tied interception record does not exist.");
            return Result.fail(ErrorCodeEnum.DATACOM_NETWORK_RECORD_NOT_EXIST.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.DATACOM_NETWORK_RECORD_NOT_EXIST.getErrorCode()));
        }
        this.interceptRecordDao.updateByGuid(interceptRecordBo);
        if (StringUtils.equals((CharSequence)interceptRecordBo.getHandlingMethod(), (CharSequence)HandlingMethodEnum.CONTINUE_OPERATION.getValue())) {
            List<Object> commissioningNesBos = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)datacomNetworkTiedInterceptRecordBo.getAnalysisResults()) && Integer.parseInt(datacomNetworkTiedInterceptRecordBo.getAnalysisResults()) > 0) {
                commissioningNesBos = this.nesMapper.queryEngineeringCommissioningNesByTaskId(datacomNetworkTiedInterceptRecordBo.getTaskId());
            }
            if (ObjectUtils.isNotEmpty(commissioningNesBos) && commissioningNesBos.size() > 0) {
                EngineeringCommissioningNesBo commissioningNesBo = new EngineeringCommissioningNesBo();
                commissioningNesBo.setTaskId(datacomNetworkTiedInterceptRecordBo.getTaskId());
                commissioningNesBo.setApprovalTag(Boolean.TRUE);
                LOGGER.info("Succeeded updateHandlingMethod, the nes ip is {}.", (Object)commissioningNesBos.size());
                this.nesMapper.updateEngineeringCommissioningNes(commissioningNesBo);
            }
        } else {
            this.reportLog(datacomNetworkTiedInterceptRecordBo, HandlingMethodEnum.CANCEL);
        }
        LOGGER.info("Update operation succeeded.");
        return Result.success("updateHandlingMethod success.");
    }

    private InterceptLogDto buildInterceptLogDto(DatacomNetworkTiedInterceptRecordBo tiedInterceptRecordBo, HandlingMethodEnum handlingMethodEnum) {
        InterceptLogDto interceptLogDto = new InterceptLogDto();
        interceptLogDto.setInfoId("1");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryTaskInfoByTaskId(tiedInterceptRecordBo.getTaskId());
        interceptLogDto.setAssociateTaskNum(tiedInterceptRecordBo.getTaskId());
        interceptLogDto.setRegionCode(taskInfoBo.getRegionCode());
        interceptLogDto.setOfficeCode(taskInfoBo.getRepOfficeCode());
        interceptLogDto.setProductLineCode(taskInfoBo.getProductLineCode());
        interceptLogDto.setAccount(userAuthenticateInfoBo.getLoginAccount());
        interceptLogDto.setUsername(userAuthenticateInfoBo.getLoginAccountName());
        String windowsAccount = this.getWindowsAccount();
        DeviceIdInfoBo deviceIdInfoBo = this.deviceInfoDao.queryDeviceInfo(windowsAccount);
        interceptLogDto.setTool(deviceIdInfoBo.getDeviceId());
        interceptLogDto.setInterceptType("4");
        interceptLogDto.setInterceptPolicy(StringUtils.equalsIgnoreCase((CharSequence)userAuthenticateInfoBo.getDatacomNetworkTiedPolicy(), (CharSequence)DatacomNetworkTiedPolicyEnum.INTERCEPTION_APPROVAL_BYPASS.getValueEn()) ? "3" : "2");
        StringBuilder command = new StringBuilder();
        command.append(this.internationalizeUtil.getMessage("10056", Collections.singletonList(tiedInterceptRecordBo.getSubReason())));
        if (StringUtils.isNotEmpty((CharSequence)tiedInterceptRecordBo.getAnalysisResults()) && Integer.parseInt(tiedInterceptRecordBo.getAnalysisResults()) > 0) {
            command.append(this.internationalizeUtil.getMessage("10057", Arrays.asList(tiedInterceptRecordBo.getProductType(), tiedInterceptRecordBo.getAnalysisResults())));
        }
        interceptLogDto.setEnterCommand(command.toString());
        interceptLogDto.setMatchCommand(tiedInterceptRecordBo.getCommand());
        interceptLogDto.setInterceptTime(DateUtil.formatDateToStr(tiedInterceptRecordBo.getInterceptTime(), "yyyy-MM-dd HH:mm:ss"));
        interceptLogDto.setProcessPolicy("0");
        if (handlingMethodEnum == HandlingMethodEnum.CONTINUE_OPERATION) {
            interceptLogDto.setProcessPolicy("1");
            interceptLogDto.setUnLockTime(DateUtil.formatDateToStr(tiedInterceptRecordBo.getUnLockTime(), "yyyy-MM-dd HH:mm:ss"));
            interceptLogDto.setUnLockCode(tiedInterceptRecordBo.getLockCode());
        }
        return interceptLogDto;
    }

    public List<String> reportLogToNetCare(List<InterceptLogDto> interceptLogDtos, List<ScheduleTaskBo> scheduleTaskBoList) {
        LOGGER.info("reportLogToNetCare start.");
        String uploadInterceptLogUrl = PropertyUtil.getString("uploadInterceptLogUrl");
        RequestData requestData = new RequestData();
        requestData.setType("POST");
        requestData.setUrl(uploadInterceptLogUrl);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", interceptLogDtos);
        requestData.setParam(jsonObject);
        JSONObject responseJsonResult = new JSONObject();
        try {
            responseJsonResult = HttpUtil.sendRest(requestData);
        }
        catch (Exception exception) {
            LOGGER.error("reportLogToNetCare sendRest error.");
        }
        LOGGER.info("responseJsonResult --> {}.", (Object)responseJsonResult);
        if (Objects.nonNull(responseJsonResult) && responseJsonResult.containsKey((Object)"status")) {
            String status = responseJsonResult.getString("status");
            if (StringUtils.equals((CharSequence)status, (CharSequence)"0") && StringUtils.equals((CharSequence)responseJsonResult.getString("returnValue"), (CharSequence)"10052")) {
                List<String> ids = this.parseObj(interceptLogDtos, responseJsonResult, scheduleTaskBoList);
                LOGGER.info("parseObj end.");
                return ids;
            }
            LOGGER.info("Report log failed, need add Scheduled Task");
            return this.dealAllFailedData(interceptLogDtos, scheduleTaskBoList);
        }
        LOGGER.info("NetCare Client return error.");
        return this.dealAllFailedData(interceptLogDtos, scheduleTaskBoList);
    }

    private List<String> dealAllFailedData(List<InterceptLogDto> interceptLogDtos, List<ScheduleTaskBo> scheduleTaskBoList) {
        ArrayList<String> reportFailInfoIds = new ArrayList<String>();
        interceptLogDtos.forEach(interceptLogDto -> {
            ScheduleTaskBo scheduleTaskBo = this.buildScheduleTaskBo((InterceptLogDto)interceptLogDto);
            reportFailInfoIds.add(interceptLogDto.getInfoId());
            scheduleTaskBoList.add(scheduleTaskBo);
        });
        return reportFailInfoIds;
    }

    public List<String> parseObj(List<InterceptLogDto> interceptLogDtos, JSONObject responseJsonResult, List<ScheduleTaskBo> scheduleTaskBoList) {
        LOGGER.info("parseObj start.");
        String returnObj = responseJsonResult.getString("obj");
        if (Objects.nonNull(returnObj)) {
            List responseDtos = JSONArray.parseArray((String)returnObj, InterceptLogResponseDto.class);
            List<String> reportFailInfoIds = responseDtos.stream().filter(interceptLogResponseDto -> !StringUtils.equals((CharSequence)interceptLogResponseDto.getStatus(), (CharSequence)"1")).map(InterceptLogResponseDto::getInfoId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(reportFailInfoIds)) {
                LOGGER.info("All log report success.");
                return null;
            }
            interceptLogDtos.forEach(interceptLogDto -> {
                if (reportFailInfoIds.contains(interceptLogDto.getInfoId())) {
                    ScheduleTaskBo scheduleTaskBo = this.buildScheduleTaskBo((InterceptLogDto)interceptLogDto);
                    scheduleTaskBoList.add(scheduleTaskBo);
                }
            });
            return reportFailInfoIds;
        }
        LOGGER.info("parseObj end.");
        return null;
    }

    private ScheduleTaskBo buildScheduleTaskBo(InterceptLogDto interceptLogDto) {
        ScheduleTaskBo scheduleTaskBo = new ScheduleTaskBo();
        scheduleTaskBo.setTaskNum(interceptLogDto.getAssociateTaskNum());
        scheduleTaskBo.setModuleName("interceptLog");
        scheduleTaskBo.setParam(JSONObject.toJSONString((Object)interceptLogDto));
        scheduleTaskBo.setUploadNum(0);
        scheduleTaskBo.setCreator(interceptLogDto.getAccount());
        scheduleTaskBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        return scheduleTaskBo;
    }

    private String getWindowsAccount() {
        Properties prop = System.getProperties();
        return prop.getProperty("user.name");
    }

    public void deleteBizNetCheckData() {
        this.tiedDataDao.deleteDatacomNetworkTiedData();
        LOGGER.info("delete biznet check data success.");
    }
}

