/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swingservice;

import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.RequestData;
import com.huawei.netcareinsidesdk.bo.TaskFinishPointBo;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.constants.TaskStatusNameEnum;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.utils.CommonDataDeal;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.HttpUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.vo.TaskFinishPointVo;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskCompleteSwingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskCompleteSwingService.class);
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private CommonDataDeal commonDataDeal;

    public Result reportFinishPoint(TaskFinishPointVo taskFinishPointVo) {
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userAuthenticateInfoBo)) {
            LOGGER.error("The current effective user does not exist!");
            return Result.fail(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode()));
        }
        TaskInfoBo curActiveTask = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        if (Objects.equals(curActiveTask.getTaskStatus(), TaskStatusNameEnum.COMPLETE.getCode())) {
            LOGGER.info("The current task has been completed and does not need to be reported.");
            return Result.success();
        }
        if (this.commonDataDeal.checkPositionAllowanceEmployee(curActiveTask.getTaskExecutorName()) && (StringUtils.isBlank((CharSequence)taskFinishPointVo.getAllowance()) || !taskFinishPointVo.getAllowance().matches("^[0-1]?$"))) {
            LOGGER.error("Param allowance is illegal!");
            return Result.fail(ErrorCodeEnum.INPUT_PARAM_INCORRECT.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.INPUT_PARAM_INCORRECT.getErrorCode(), Collections.singletonList("allowance")));
        }
        TaskFinishPointBo taskFinishPointBo = new TaskFinishPointBo();
        BeanUtils.copyProperties((Object)taskFinishPointVo, (Object)taskFinishPointBo);
        taskFinishPointBo.setTaskNum(curActiveTask.getTaskId());
        RequestData data = new RequestData();
        data.setUrl(PropertyUtil.getString("reportCompletePointUrl"));
        data.setType("POST");
        data.setParam((JSONObject)JSONObject.toJSON((Object)taskFinishPointBo));
        JSONObject returnResult = HttpUtil.sendRest(data);
        LOGGER.info("NetCare Client returnObj is {}", (Object)(Objects.nonNull(returnResult) ? returnResult.toJSONString() : null));
        if (Objects.nonNull(returnResult) && returnResult.containsKey((Object)"status")) {
            int returnStatus = returnResult.getIntValue("status");
            if (returnStatus != 0) {
                LOGGER.error("The NetCareClient fails to be reported at the completion point.");
                return Result.fail(ErrorCodeEnum.COMPLETE_POINT_REPORT_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.COMPLETE_POINT_REPORT_FAILED.getErrorCode()));
            }
        } else {
            LOGGER.error("NetCare Client return error.");
            return Result.fail(ErrorCodeEnum.NETCARECLIENT_ERROR.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.NETCARECLIENT_ERROR.getErrorCode()));
        }
        this.updateCompleteStatus(curActiveTask);
        return Result.success();
    }

    private void updateCompleteStatus(TaskInfoBo curActiveTask) {
        TaskInfoBo taskInfoBo = new TaskInfoBo();
        taskInfoBo.setTaskId(curActiveTask.getTaskId());
        taskInfoBo.setTaskStatus(TaskStatusNameEnum.COMPLETE.getCode());
        taskInfoBo.setIsCurTask(false);
        this.taskInfoDao.updateTask(taskInfoBo);
    }
}

