/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.BlockListMenuInfoBo;
import com.huawei.netcareinsidesdk.bo.ClientControlPolicyBo;
import com.huawei.netcareinsidesdk.bo.CommandVersionInfoBo;
import com.huawei.netcareinsidesdk.bo.ControlPolicyConfigBo;
import com.huawei.netcareinsidesdk.bo.CrtSchemeCommandInfoBo;
import com.huawei.netcareinsidesdk.bo.DatacomNetworkTiedCommandBo;
import com.huawei.netcareinsidesdk.bo.DeviceIdInfoBo;
import com.huawei.netcareinsidesdk.bo.HighRiskCommandInfoBo;
import com.huawei.netcareinsidesdk.bo.ProcessStagesBo;
import com.huawei.netcareinsidesdk.bo.RequestData;
import com.huawei.netcareinsidesdk.bo.TaskAccountBoundBo;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.TaskProcessStagesBo;
import com.huawei.netcareinsidesdk.bo.TaskSubtypeBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.bo.WhiteListCommandInfoBo;
import com.huawei.netcareinsidesdk.bo.WhiteListMenuInfoBo;
import com.huawei.netcareinsidesdk.constants.ControlPolicyEnum;
import com.huawei.netcareinsidesdk.constants.InitManageControlPolicyEnum;
import com.huawei.netcareinsidesdk.constants.InterceptPolicyEnum;
import com.huawei.netcareinsidesdk.constants.OperatePermissionEnum;
import com.huawei.netcareinsidesdk.constants.RiskLevelEnum;
import com.huawei.netcareinsidesdk.constants.TaskStatusNameEnum;
import com.huawei.netcareinsidesdk.constants.TaskSubtypeEnum;
import com.huawei.netcareinsidesdk.constants.TaskTypeEnum;
import com.huawei.netcareinsidesdk.dao.BlockListMenuInfoDao;
import com.huawei.netcareinsidesdk.dao.CommandVersionInfoDao;
import com.huawei.netcareinsidesdk.dao.ControlPolicyConfigDao;
import com.huawei.netcareinsidesdk.dao.CrtSchemeCommandInfoMapper;
import com.huawei.netcareinsidesdk.dao.DatacomNetworkTiedCommandDao;
import com.huawei.netcareinsidesdk.dao.EngineeringCommissioningNesMapper;
import com.huawei.netcareinsidesdk.dao.HighRiskCommandInfoDao;
import com.huawei.netcareinsidesdk.dao.TaskAccountBoundDao;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.TaskSubtypeDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.dao.WhiteListCommandInfoDao;
import com.huawei.netcareinsidesdk.dao.WhiteListMenuInfoDao;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.HttpUtil;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CommonDataDeal {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonDataDeal.class);
    private static final String BLOCKLIST_MENU = "blocklistMenu";
    private static final String WHITELIST_MENU = "whitelistMenu";
    private static final String HUA_WEI_ACCOUNT_REGEX = "^[a-z]00\\d{6}$";
    private static final String LEASED_REGEX = "^[A-Za-z]{1}84[0-9]{6,9}$";
    private static final String OD_REGEX = "^[A-Za-z]{1}300[0-9]{5,7}$";
    private static final String LEASED_OD_REGEX = "^[A-Za-z]{1}60[0-9]{6,8}$";
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private DatacomNetworkTiedCommandDao networkTiedCommandDao;
    @Autowired
    private TaskSubtypeDao taskSubtypeDao;
    @Autowired
    private TaskAccountBoundDao taskAccountBoundDao;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private HighRiskCommandInfoDao highRiskCommandInfoDao;
    @Autowired
    private WhiteListCommandInfoDao whiteListCommandInfoDao;
    @Autowired
    private CommandVersionInfoDao commandVersionInfoDao;
    @Autowired
    private CrtSchemeCommandInfoMapper crtSchemeCommandInfoMapper;
    @Autowired
    private BlockListMenuInfoDao blockListMenuInfoDao;
    @Autowired
    private WhiteListMenuInfoDao whiteListMenuInfoDao;
    @Autowired
    private ControlPolicyConfigDao controlPolicyConfigDao;
    @Autowired
    private EngineeringCommissioningNesMapper nesMapper;

    public void updateTaskInfoPolicy() {
        LOGGER.info("Update policies for valid tasks start.");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        List<TaskInfoBo> taskInfoBos = this.taskInfoDao.queryTasksByTaskStatus(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount(), TaskStatusNameEnum.TO_DO.getCode());
        List<TaskInfoBo> ongoingTaskInfoBos = this.taskInfoDao.queryTasksByTaskStatus(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount(), TaskStatusNameEnum.ONGOING.getCode());
        if (Objects.isNull(taskInfoBos) && Objects.isNull(ongoingTaskInfoBos)) {
            LOGGER.info("There is no valid task.");
            return;
        }
        taskInfoBos.addAll(ongoingTaskInfoBos);
        this.updateTaskInfo(userAuthenticateInfoBo, taskInfoBos);
        LOGGER.info("Update policies for valid tasks end.");
    }

    public boolean checkPositionAllowanceEmployee(String taskExecutorName) {
        LOGGER.info("Analyze whether the account meets the position allowance.");
        String account = "";
        try {
            String[] split;
            if (StringUtils.isNotBlank((CharSequence)taskExecutorName) && (split = taskExecutorName.split(" ")).length > 1) {
                String firstStr = String.valueOf(split[0].charAt(0));
                account = firstStr.toLowerCase(Locale.ENGLISH) + split[split.length - 1];
            }
        }
        catch (Exception exception) {
            LOGGER.error("the error info {}.", (Object)exception.getMessage());
            LOGGER.error("Failed to parse the position allowance account.");
            return false;
        }
        if (account.matches(HUA_WEI_ACCOUNT_REGEX)) {
            LOGGER.info("this is huawei account.");
            return Boolean.TRUE;
        }
        if (account.matches(OD_REGEX)) {
            LOGGER.info("this is 300 account.");
            return Boolean.TRUE;
        }
        if (account.matches(LEASED_REGEX)) {
            LOGGER.info("this is 84 account.");
            return Boolean.TRUE;
        }
        if (account.matches(LEASED_OD_REGEX)) {
            LOGGER.info("this is 60 account.");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void updateTaskInfo(UserAuthenticateInfoBo authenticateInfoBo, List<TaskInfoBo> taskInfoBos) {
        if (Objects.isNull(taskInfoBos) || taskInfoBos.size() == 0) {
            return;
        }
        taskInfoBos.stream().forEach(taskInfoBo -> {
            TaskInfoBo updateTaskInfo = new TaskInfoBo();
            updateTaskInfo.setTaskId(taskInfoBo.getTaskId());
            TaskSubtypeBo taskSubtypeBo = this.taskSubtypeDao.queryTaskSubtype(taskInfoBo.getTaskId());
            if (Objects.nonNull(taskSubtypeBo)) {
                updateTaskInfo.setInterceptPolicy(authenticateInfoBo.getStructuralComponentPolicy());
                this.taskInfoDao.updateTask(updateTaskInfo);
            }
        });
    }

    public void insertTaskAdditionalInfo(UserAuthenticateInfoBo authenticateInfo, JSONObject jsonObject, TaskInfoBo taskInfoBo) {
        this.insertCommandAndMenuInfo(new String[]{"defaultBlockListLib", "defaultTrustListLib"}, authenticateInfo, jsonObject);
        this.updateAuthInfo(jsonObject.getJSONObject("taskInfo"), taskInfoBo, authenticateInfo);
        this.parseAndInsertNeAccountInfo(jsonObject.getJSONArray("loginNeAccounts"), authenticateInfo, taskInfoBo.getTaskId());
    }

    public void insertCommandAndMenuInfo(String[] keys, UserAuthenticateInfoBo authenticateInfo, JSONObject jsonObject) {
        this.parseAndInsertBlockListInfo(jsonObject.getJSONObject(keys[0]), authenticateInfo);
        this.parseAndInsertTrustListInfo(jsonObject.getJSONObject(keys[1]), authenticateInfo);
        this.parseAndInsertBlockListMenuInfo(jsonObject.getJSONObject("blockListMenuLib"), authenticateInfo);
        this.parseAndInsertWhiteListMenuInfo(jsonObject.getJSONObject("trustListMenuLib"), authenticateInfo);
        this.parseAndInsertDatacomNetworkTiedCommand(jsonObject.getJSONArray("datacomNetworkTiedCommands"), authenticateInfo);
    }

    public void updateAuthInfo(JSONObject taskInfoJsonObj, TaskInfoBo taskInfoBo, UserAuthenticateInfoBo authenticateInfo) {
        LOGGER.info("Start updateAuthInfo.");
        authenticateInfo.setNotStructuralComponentPolicy(taskInfoJsonObj.getString(ControlPolicyEnum.NOT_STRUCTURAL_COMPONENT_POLICY.getPolicyType()));
        authenticateInfo.setStructuralComponentPolicy(taskInfoJsonObj.getString(ControlPolicyEnum.STRUCTURAL_COMPONENT_POLICY.getPolicyType()));
        authenticateInfo.setDatacomNetworkTiedPolicy(taskInfoJsonObj.getString(ControlPolicyEnum.DATACOM_NETWORK_TIED_POLICY.getPolicyType()));
        String policyCode = taskInfoJsonObj.getString(ControlPolicyEnum.OPERATION_PREPARATION_INSIDE_POLICY.getPolicyType());
        LOGGER.info("updateAuthInfo, task {} operationPreparationInsidePolicy is {}", (Object)taskInfoBo.getTaskId(), (Object)policyCode);
        authenticateInfo.setOperationPreparationInsidePolicy(policyCode);
        if (StringUtils.equalsIgnoreCase((CharSequence)taskInfoBo.getTaskType(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn())) {
            authenticateInfo.setUpdateTime(DateUtil.getUtcDate(new Date()));
        }
        if (taskInfoJsonObj.containsKey((Object)"commandVersion")) {
            authenticateInfo.setCommandVersion(taskInfoJsonObj.getString("commandVersion"));
        }
        this.userAuthenticateInfoDao.updateUserAuthenticateInfo(authenticateInfo);
        LOGGER.info("updateAuthInfo end");
    }

    public void parseAndInsertDatacomNetworkTiedCommand(JSONArray jsonArray, UserAuthenticateInfoBo authenticateInfo) {
        this.networkTiedCommandDao.deleteAllDatacomNetworkTiedCommand(null);
        if (ObjectUtils.isNotEmpty((Object)jsonArray)) {
            List datacomNetworkTiedCommandBos = JSONArray.parseArray((String)jsonArray.toJSONString(), DatacomNetworkTiedCommandBo.class);
            for (DatacomNetworkTiedCommandBo commandBo : datacomNetworkTiedCommandBos) {
                commandBo.setOperator(authenticateInfo.getLoginAccount());
                commandBo.setCreateTime(DateUtil.getUtcDate(new Date()));
            }
            this.networkTiedCommandDao.batchDatacomNetworkTiedCommand(datacomNetworkTiedCommandBos);
        }
    }

    public void parseAndInsertNeAccountInfo(JSONArray neAccountinfo, UserAuthenticateInfoBo userAuthenticateInfoBo, String taskId) {
        if (Objects.isNull(neAccountinfo) || neAccountinfo.isEmpty()) {
            return;
        }
        ArrayList<TaskAccountBoundBo> taskAccountBoundBoList = new ArrayList<TaskAccountBoundBo>();
        for (int i = 0; i < neAccountinfo.size(); ++i) {
            JSONObject jsonObject = neAccountinfo.getJSONObject(i);
            TaskAccountBoundBo boundBo = new TaskAccountBoundBo();
            boundBo.setTaskId(taskId);
            boundBo.setCreateTime(DateUtil.getUtcDate(new Date()));
            boundBo.setUpdateTime(DateUtil.getUtcDate(new Date()));
            boundBo.setTaskExecutor(userAuthenticateInfoBo.getLoginAccount());
            boundBo.setOperator(userAuthenticateInfoBo.getLoginAccount());
            boundBo.setAccountHolder(userAuthenticateInfoBo.getWindowsAccount());
            boundBo.setAccount(jsonObject.getString("accountName"));
            taskAccountBoundBoList.add(boundBo);
        }
        this.taskAccountBoundDao.batchInsertNeAccounts(taskAccountBoundBoList);
        LOGGER.info("Ne Account Info insert success.");
    }

    public void updateTaskSubtype(JSONObject jsonObject, TaskInfoBo taskInfoBo) {
        JSONObject object = JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"taskProcess")));
        if (Objects.isNull(object.getString("rfcStages"))) {
            return;
        }
        List taskProcessStagesBos = JSONArray.parseArray((String)object.getString("rfcStages"), TaskProcessStagesBo.class);
        this.addCrtSchemeCommandInfo(object, taskInfoBo);
        TaskSubtypeBo subtypeBo = new TaskSubtypeBo();
        subtypeBo.setOperator(taskInfoBo.getTaskExecutor());
        subtypeBo.setTaskId(taskInfoBo.getTaskId());
        subtypeBo.setTaskProcess(JSONObject.toJSONString((Object)jsonObject.get((Object)"taskProcess")));
        subtypeBo.setTaskProcessStages(JSONObject.toJSONString((Object)taskProcessStagesBos));
        subtypeBo.setDotInfo(JSONObject.toJSONString((Object)jsonObject.get((Object)"dotInfo")));
        subtypeBo.setNeInfoList(JSONObject.toJSONString((Object)jsonObject.get((Object)"neInfoList")));
        subtypeBo.setTaskSubtype(TaskSubtypeEnum.EASY_CRT_TYPE.getCode());
        subtypeBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        this.taskSubtypeDao.insertTaskSubtype(subtypeBo);
    }

    private void addCrtSchemeCommandInfo(JSONObject object, TaskInfoBo taskInfoBo) {
        List processStagesBoList = JSONArray.parseArray((String)object.getString("rfcStages"), ProcessStagesBo.class);
        HashSet crtSchemeCommandInfos = new HashSet();
        processStagesBoList.stream().forEach(processStagesBo -> {
            LOGGER.info("The method buildTaskSubtype Resolve the commands in the solution.");
            JSONObject processStagesBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)processStagesBo));
            JSONArray steps = processStagesBoJson.getJSONArray("steps");
            this.actionsInfo(crtSchemeCommandInfos, steps);
        });
        ArrayList<CrtSchemeCommandInfoBo> crtSchemeCommandInfoBos = new ArrayList<CrtSchemeCommandInfoBo>();
        for (String str : crtSchemeCommandInfos) {
            this.buildCrtSchemeCommandInfoBo(taskInfoBo, crtSchemeCommandInfoBos, str);
        }
        this.crtSchemeCommandInfoMapper.batchInsertCrtSchemeCommandInfo(crtSchemeCommandInfoBos);
    }

    private void buildCrtSchemeCommandInfoBo(TaskInfoBo taskInfoBo, List<CrtSchemeCommandInfoBo> crtSchemeCommandInfoBos, String str) {
        CrtSchemeCommandInfoBo crtSchemeCommandInfoBo = new CrtSchemeCommandInfoBo();
        crtSchemeCommandInfoBo.setIsRun(true);
        crtSchemeCommandInfoBo.setSchemeCommand(str);
        crtSchemeCommandInfoBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        crtSchemeCommandInfoBo.setTaskId(taskInfoBo.getTaskId());
        crtSchemeCommandInfoBos.add(crtSchemeCommandInfoBo);
    }

    private void actionsInfo(Set<String> crtSchemeCommandInfos, JSONArray actions) {
        LOGGER.info("The method actionsInfo Resolve the commands in the solution.");
        actions.stream().forEach(action -> {
            JSONObject actionJsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)action));
            JSONArray jsonArrayActions = actionJsonObject.getJSONArray("actions");
            jsonArrayActions.stream().forEach(json -> {
                JSONObject actionJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)json));
                JSONArray commandItemsJsonArray = actionJson.getJSONArray("commandItems");
                commandItemsJsonArray.stream().forEach(commandItem -> {
                    JSONObject commandItemJsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)commandItem));
                    crtSchemeCommandInfos.add(commandItemJsonObject.getString("command"));
                });
                JSONArray checkCommandsJsonArray = actionJson.getJSONArray("checkCommands");
                checkCommandsJsonArray.stream().forEach(checkCommands -> {
                    JSONObject checkCommandsJsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)checkCommands));
                    crtSchemeCommandInfos.add(checkCommandsJsonObject.getString("command"));
                });
            });
        });
    }

    public void parseAndInsertBlockListInfo(JSONObject highRiskinfo, UserAuthenticateInfoBo userAuthenticateInfoBo) {
        if (Objects.isNull(highRiskinfo) || highRiskinfo.isEmpty()) {
            LOGGER.info("defaultBlockListLib is null!");
            return;
        }
        ArrayList<HighRiskCommandInfoBo> highRiskCommandInfoBoList = new ArrayList<HighRiskCommandInfoBo>();
        if (highRiskinfo.containsKey((Object)"blockList")) {
            JSONArray highCommandJsonArray = highRiskinfo.getJSONArray("blockList");
            if (Objects.isNull(highCommandJsonArray) || highCommandJsonArray.isEmpty()) {
                LOGGER.info("blockList is null!");
                return;
            }
            for (int i = 0; i < highCommandJsonArray.size(); ++i) {
                JSONObject jsonObject = highCommandJsonArray.getJSONObject(i);
                HighRiskCommandInfoBo highRiskCommandInfoBo = new HighRiskCommandInfoBo();
                highRiskCommandInfoBo.setCreateTime(DateUtil.getUtcDate(new Date()));
                highRiskCommandInfoBo.setUpdateTime(DateUtil.getUtcDate(new Date()));
                highRiskCommandInfoBo.setRegionCode(jsonObject.getString("region"));
                highRiskCommandInfoBo.setRepOfficeCode(jsonObject.getString("repOffice"));
                highRiskCommandInfoBo.setProductLineCode(jsonObject.getString("productLine"));
                highRiskCommandInfoBo.setCommandRegex(jsonObject.getString("regCommand"));
                highRiskCommandInfoBo.setFullCommand(jsonObject.getString("fullCommand"));
                highRiskCommandInfoBo.setRiskLevel(RiskLevelEnum.getRiskCodeByEn(jsonObject.getString("riskLevel")));
                highRiskCommandInfoBo.setOperator(userAuthenticateInfoBo.getLoginAccount());
                highRiskCommandInfoBoList.add(highRiskCommandInfoBo);
            }
        }
        if (!highRiskCommandInfoBoList.isEmpty()) {
            this.highRiskCommandInfoDao.deleteAllHighRisks(null);
            this.highRiskCommandInfoDao.batchInsertHighRiskInfo(highRiskCommandInfoBoList);
            LOGGER.info("HighRisk info insert success, size is {}", (Object)highRiskCommandInfoBoList.size());
        }
        this.insertCommandVersionInfo(highRiskinfo.getJSONArray("newVersion"), userAuthenticateInfoBo, InterceptPolicyEnum.BLOCKLIST.getValue());
    }

    public void parseAndInsertTrustListInfo(JSONObject trustRiskinfo, UserAuthenticateInfoBo userAuthenticateInfoBo) {
        if (Objects.isNull(trustRiskinfo) || trustRiskinfo.isEmpty()) {
            LOGGER.info("defaultTrustListLib is null!");
            return;
        }
        ArrayList<WhiteListCommandInfoBo> trustRiskCommandInfoBoList = new ArrayList<WhiteListCommandInfoBo>();
        if (trustRiskinfo.containsKey((Object)"trustList")) {
            JSONArray trustCommandJsonArray = trustRiskinfo.getJSONArray("trustList");
            if (Objects.isNull(trustCommandJsonArray) || trustCommandJsonArray.isEmpty()) {
                LOGGER.info("trustList is null!");
                return;
            }
            for (int i = 0; i < trustCommandJsonArray.size(); ++i) {
                JSONObject jsonObject = trustCommandJsonArray.getJSONObject(i);
                WhiteListCommandInfoBo whiteListCommandInfoBo = new WhiteListCommandInfoBo();
                whiteListCommandInfoBo.setCreateTime(DateUtil.getUtcDate(new Date()));
                whiteListCommandInfoBo.setUpdateTime(DateUtil.getUtcDate(new Date()));
                whiteListCommandInfoBo.setRegionCode(jsonObject.getString("region"));
                whiteListCommandInfoBo.setRepOfficeCode(jsonObject.getString("repOffice"));
                whiteListCommandInfoBo.setProductLineCode(jsonObject.getString("productLine"));
                whiteListCommandInfoBo.setCommandRegex(jsonObject.getString("regCommand"));
                whiteListCommandInfoBo.setFullCommand(jsonObject.getString("fullCommand"));
                whiteListCommandInfoBo.setRiskLevel(RiskLevelEnum.getRiskCodeByEn(jsonObject.getString("riskLevel")));
                whiteListCommandInfoBo.setOperator(userAuthenticateInfoBo.getLoginAccount());
                trustRiskCommandInfoBoList.add(whiteListCommandInfoBo);
            }
        }
        if (!trustRiskCommandInfoBoList.isEmpty()) {
            this.whiteListCommandInfoDao.deleteAllWhiteList(null);
            this.whiteListCommandInfoDao.batchInsertWhiteListCommandInfo(trustRiskCommandInfoBoList);
            LOGGER.info("Trust list info insert success, size is {}", (Object)trustRiskCommandInfoBoList.size());
        }
        this.insertCommandVersionInfo(trustRiskinfo.getJSONArray("newVersion"), userAuthenticateInfoBo, InterceptPolicyEnum.WHITELIST.getValue());
    }

    private void insertCommandVersionInfo(JSONArray commandVersionList, UserAuthenticateInfoBo userAuthenticateInfoBo, String componentPolicy) {
        if (commandVersionList == null || commandVersionList.isEmpty()) {
            LOGGER.info("{} version info is empty.", (Object)componentPolicy);
            return;
        }
        ArrayList<CommandVersionInfoBo> versionList = new ArrayList<CommandVersionInfoBo>();
        for (int i = 0; i < commandVersionList.size(); ++i) {
            CommandVersionInfoBo commandVersionInfoBo = new CommandVersionInfoBo();
            JSONObject versionVo = commandVersionList.getJSONObject(i);
            commandVersionInfoBo.setComponentPolicy(componentPolicy);
            commandVersionInfoBo.setProductLineCode(versionVo.getString("productLine"));
            commandVersionInfoBo.setVersion(versionVo.getString("version"));
            commandVersionInfoBo.setUpdateTime(DateUtil.getUtcDate(new Date()));
            commandVersionInfoBo.setOperator(userAuthenticateInfoBo.getLoginAccount());
            versionList.add(commandVersionInfoBo);
        }
        if (ObjectUtils.isNotEmpty(versionList) && versionList.size() > 0) {
            this.commandVersionInfoDao.deleteCommandVersionList(componentPolicy, null);
            this.commandVersionInfoDao.batchInsertCommandVersionInfo(versionList);
            LOGGER.info("Insert CommandVersionInfo success.");
        }
    }

    public void parseAndInsertBlockListMenuInfo(JSONObject blockListMenuInfo, UserAuthenticateInfoBo userInfo) {
        LOGGER.info("parseAndInsertBlockListMenuInfo start.");
        if (Objects.isNull(blockListMenuInfo) || blockListMenuInfo.isEmpty()) {
            LOGGER.info("blockListMenuLib is null!");
            return;
        }
        ArrayList<BlockListMenuInfoBo> blockListMenuInfoBos = new ArrayList<BlockListMenuInfoBo>();
        if (blockListMenuInfo.containsKey((Object)"blockListMenu")) {
            JSONArray blockMenuListArray = blockListMenuInfo.getJSONArray("blockListMenu");
            if (Objects.isNull(blockMenuListArray) || blockMenuListArray.isEmpty()) {
                LOGGER.info("blockListMenu is null!");
                return;
            }
            for (int i = 0; i < blockMenuListArray.size(); ++i) {
                JSONObject jsonObject = blockMenuListArray.getJSONObject(i);
                BlockListMenuInfoBo blockListMenuInfoBo = new BlockListMenuInfoBo();
                blockListMenuInfoBo.setRegionCode(jsonObject.getString("region"));
                blockListMenuInfoBo.setRepOfficeCode(jsonObject.getString("repOffice"));
                blockListMenuInfoBo.setProductLineCode(jsonObject.getString("productLine"));
                blockListMenuInfoBo.setToolName(jsonObject.getString("toolName"));
                String toolVersion = jsonObject.getString("toolVersion");
                blockListMenuInfoBo.setToolVersion(StringUtils.isBlank((CharSequence)toolVersion) ? null : toolVersion);
                blockListMenuInfoBo.setMenuCn(jsonObject.getString("menuCn"));
                blockListMenuInfoBo.setMenuEn(jsonObject.getString("menuEn"));
                String menuCode = jsonObject.getString("menuCode");
                blockListMenuInfoBo.setMenuCode(StringUtils.isBlank((CharSequence)menuCode) ? null : menuCode);
                blockListMenuInfoBo.setRiskLevel(RiskLevelEnum.getRiskCodeByEn(jsonObject.getString("riskLevel")));
                blockListMenuInfoBo.setCreateTime(DateUtil.getUtcDate(new Date()));
                blockListMenuInfoBo.setOperator(userInfo.getLoginAccount());
                blockListMenuInfoBos.add(blockListMenuInfoBo);
            }
        }
        if (!blockListMenuInfoBos.isEmpty()) {
            this.blockListMenuInfoDao.deleteAllBlockListMenuInfo(null);
            this.blockListMenuInfoDao.batchInsertBlockListMenuInfo(blockListMenuInfoBos);
            LOGGER.info("blockListMenuInfo insert success, size is {}", (Object)blockListMenuInfoBos.size());
        }
        this.insertCommandVersionInfo(blockListMenuInfo.getJSONArray("newVersion"), userInfo, BLOCKLIST_MENU);
        LOGGER.info("parseAndInsertBlockListMenuInfo end.");
    }

    public void parseAndInsertWhiteListMenuInfo(JSONObject whiteListMenuInfo, UserAuthenticateInfoBo userInfo) {
        LOGGER.info("parseAndInsertWhiteListMenuInfo start.");
        if (Objects.isNull(whiteListMenuInfo) || whiteListMenuInfo.isEmpty()) {
            LOGGER.info("trustListMenuLib is null!");
            return;
        }
        ArrayList<WhiteListMenuInfoBo> whiteListMenuInfoBos = new ArrayList<WhiteListMenuInfoBo>();
        if (whiteListMenuInfo.containsKey((Object)"trustListMenu")) {
            JSONArray trustListMenuArray = whiteListMenuInfo.getJSONArray("trustListMenu");
            if (Objects.isNull(trustListMenuArray) || trustListMenuArray.isEmpty()) {
                LOGGER.info("trustListMenu is null!");
                return;
            }
            for (int i = 0; i < trustListMenuArray.size(); ++i) {
                JSONObject jsonObject = trustListMenuArray.getJSONObject(i);
                WhiteListMenuInfoBo whiteListMenuInfoBo = new WhiteListMenuInfoBo();
                whiteListMenuInfoBo.setRegionCode(jsonObject.getString("region"));
                whiteListMenuInfoBo.setRepOfficeCode(jsonObject.getString("repOffice"));
                whiteListMenuInfoBo.setProductLineCode(jsonObject.getString("productLine"));
                whiteListMenuInfoBo.setCreateTime(DateUtil.getUtcDate(new Date()));
                whiteListMenuInfoBo.setOperator(userInfo.getLoginAccount());
                whiteListMenuInfoBo.setToolName(jsonObject.getString("toolName"));
                String toolVersion = jsonObject.getString("toolVersion");
                whiteListMenuInfoBo.setToolVersion(StringUtils.isBlank((CharSequence)toolVersion) ? null : toolVersion);
                String menuCode = jsonObject.getString("menuCode");
                whiteListMenuInfoBo.setMenuCode(StringUtils.isBlank((CharSequence)menuCode) ? null : menuCode);
                whiteListMenuInfoBo.setMenuCn(jsonObject.getString("menuCn"));
                whiteListMenuInfoBo.setMenuEn(jsonObject.getString("menuEn"));
                whiteListMenuInfoBo.setRiskLevel(RiskLevelEnum.getRiskCodeByEn(jsonObject.getString("riskLevel")));
                whiteListMenuInfoBos.add(whiteListMenuInfoBo);
            }
        }
        if (!whiteListMenuInfoBos.isEmpty()) {
            this.whiteListMenuInfoDao.deleteAllWhiteListMenuInfo(null);
            this.whiteListMenuInfoDao.batchInsertWhiteListMenuInfo(whiteListMenuInfoBos);
            LOGGER.info("whiteListMenuInfo insert success, size is {}", (Object)whiteListMenuInfoBos.size());
        }
        this.insertCommandVersionInfo(whiteListMenuInfo.getJSONArray("newVersion"), userInfo, WHITELIST_MENU);
        LOGGER.info("parseAndInsertWhiteListMenuInfo end.");
    }

    public void deleteTaskSubtypeInfo() {
        List<TaskInfoBo> taskToDoInfoBos = this.taskInfoDao.queryTasksByTaskStatus(null, null, TaskStatusNameEnum.TO_DO.getCode());
        taskToDoInfoBos.forEach(taskToDoInfo -> this.taskSubtypeDao.deleteTaskSubtypeInfoByTaskId(taskToDoInfo.getTaskId()));
        List<TaskInfoBo> taskOngoingInfoBos = this.taskInfoDao.queryTasksByTaskStatus(null, null, TaskStatusNameEnum.ONGOING.getCode());
        taskOngoingInfoBos.forEach(taskOngoingInfo -> this.taskSubtypeDao.deleteTaskSubtypeInfoByTaskId(taskOngoingInfo.getTaskId()));
    }

    public Map<String, String> queryControlPolicyForClient(DeviceIdInfoBo deviceIdInfoBo) {
        JSONObject controlPolicyObj;
        RequestData requestData = new RequestData();
        String url = PropertyUtil.getString("getInitControlPolicyFromClientUrl") + "?deviceId=" + (Objects.isNull(deviceIdInfoBo.getDeviceId()) ? "" : deviceIdInfoBo.getDeviceId() + "&toolVersion=" + (Objects.isNull(deviceIdInfoBo.getToolVersion()) ? "" : deviceIdInfoBo.getToolVersion()));
        requestData.setUrl(url);
        requestData.setType("GET");
        JSONObject jsonObject = HttpUtil.sendRest(requestData);
        HashMap<String, String> controlPolicy = new HashMap<String, String>();
        LOGGER.info("queryControlPolicyForClient returnObj {}", (Object)jsonObject);
        if (Objects.nonNull(jsonObject) && jsonObject.getIntValue("status") == 0 && Objects.nonNull(controlPolicyObj = jsonObject.getJSONObject("obj")) && !controlPolicyObj.isEmpty()) {
            ClientControlPolicyBo controlPolicyBo = (ClientControlPolicyBo)JSON.toJavaObject((JSON)controlPolicyObj, ClientControlPolicyBo.class);
            controlPolicy.put("controlPolicy", controlPolicyBo.getInitManageControlPolicy());
            controlPolicy.put("loginAccount", controlPolicyBo.getLoginAccount());
            controlPolicy.put("operatePermission", OperatePermissionEnum.getOperatePermissionValueEnByCode(controlPolicyObj.getString("operatePermission")));
            controlPolicy.put("netCareRoleCode", controlPolicyBo.getNetCareRoleCode());
            return controlPolicy;
        }
        controlPolicy.put("operatePermission", "");
        controlPolicy.put("controlPolicy", InitManageControlPolicyEnum.CONTROL_SCAN.getDataCode());
        controlPolicy.put("netCareRoleCode", "");
        return controlPolicy;
    }

    public int getAuthInfoFromClient(DeviceIdInfoBo deviceIdInfoBo, Map<String, String> controlPolicyMap) {
        JSONObject initAuthJson;
        LOGGER.info("Start get auth info from client.");
        String url = PropertyUtil.getString("authInfoFromClientUrl");
        RequestData requestData = new RequestData();
        requestData.setUrl(url + "?deviceId=" + (Objects.isNull(deviceIdInfoBo.getDeviceId()) ? "" : deviceIdInfoBo.getDeviceId()) + "&esn=" + (Objects.isNull(deviceIdInfoBo.getEsn()) ? "" : deviceIdInfoBo.getEsn()));
        requestData.setType("GET");
        JSONObject jsonObject = HttpUtil.sendRest(requestData);
        if (Objects.nonNull(jsonObject) && jsonObject.getIntValue("status") == 0 && Objects.nonNull(initAuthJson = jsonObject.getJSONObject("obj")) && !initAuthJson.isEmpty()) {
            this.insertInitAuthInfo(initAuthJson, "0", controlPolicyMap);
            LOGGER.info("get auth info from client success.");
            return 0;
        }
        LOGGER.info("get auth info from client failed.");
        return 1;
    }

    public UserAuthenticateInfoBo insertInitAuthInfo(JSONObject initAuthInfo, String initSource, Map<String, String> controlPolicyMap) {
        JSONObject authInfoJsonObject = initAuthInfo.getJSONObject("authInfo");
        if (Objects.isNull(authInfoJsonObject)) {
            return null;
        }
        UserAuthenticateInfoBo newUser = this.buildNewUserBo(controlPolicyMap, authInfoJsonObject, initSource);
        UserAuthenticateInfoBo curUser = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        LOGGER.info("insertInitAuthInfo start, curUser {}, newUser {}", (Object)(Objects.nonNull(curUser) ? curUser.getLoginAccount() : null), (Object)newUser.getLoginAccount());
        this.handleUserInfoModification(newUser, curUser);
        if (Objects.nonNull(curUser)) {
            this.userAuthenticateInfoDao.deleteUserAuthenticateInfo(curUser.getLoginAccount());
        }
        this.userAuthenticateInfoDao.insertUserAuthenticateInfo(newUser);
        if (StringUtils.isBlank((CharSequence)newUser.getInitManageControlPolicy()) || StringUtils.equals((CharSequence)newUser.getInitManageControlPolicy(), (CharSequence)InitManageControlPolicyEnum.CONTROL_SCAN.getDataCode())) {
            TaskInfoBo taskInfoBo = new TaskInfoBo();
            taskInfoBo.setTaskId("defaultTask");
            this.taskInfoDao.deleteTaskInfoByTaskId(taskInfoBo);
        } else {
            this.createDefaultTask(newUser);
        }
        if (StringUtils.equals((CharSequence)newUser.getOperatePermission(), (CharSequence)OperatePermissionEnum.OPERATE.getValueEn()) && StringUtils.equals((CharSequence)newUser.getInitManageControlPolicy(), (CharSequence)InitManageControlPolicyEnum.NOCONTROL_AND_STARTSCAN.getDataCode())) {
            LOGGER.info("Operate&noControlAndStartScan, not insert command and other info.");
            return newUser;
        }
        this.insertCommandAndMenuInfo(new String[]{"blockListLib", "trustListLib"}, newUser, initAuthInfo);
        if (initAuthInfo.containsKey((Object)"regionControlSet") && Objects.nonNull(initAuthInfo.getJSONObject("regionControlSet"))) {
            this.insertAccountControlPolicyConfig(initAuthInfo, newUser);
        }
        this.updateTaskInfoPolicy();
        return newUser;
    }

    private void handleUserInfoModification(UserAuthenticateInfoBo synUser, UserAuthenticateInfoBo curUser) {
        if (!(!Objects.nonNull(curUser) || StringUtils.equals((CharSequence)synUser.getRegionCode(), (CharSequence)curUser.getRegionCode()) && StringUtils.equals((CharSequence)synUser.getRepOfficeCode(), (CharSequence)curUser.getRepOfficeCode()))) {
            LOGGER.error("Clear historical to-do tasks and ongoing tasks for different regions and rep offices.");
            this.deleteTaskSubtypeInfo();
            this.taskInfoDao.deleteTaskInfo(curUser.getLoginAccount());
            this.nesMapper.deleteEngineeringCommissioningNes();
        }
        if (Objects.nonNull(curUser) && !StringUtils.equals((CharSequence)synUser.getLoginAccount(), (CharSequence)curUser.getLoginAccount())) {
            LOGGER.error("Clear historical to-do tasks and ongoing tasks with different accounts.");
            this.deleteTaskSubtypeInfo();
            this.taskInfoDao.deleteTaskInfo(curUser.getLoginAccount());
            this.nesMapper.deleteEngineeringCommissioningNes();
        }
    }

    private void createDefaultTask(UserAuthenticateInfoBo userAuthenticateInfoBo) {
        TaskInfoBo taskInfo;
        LOGGER.info("Start createDefaultTask");
        TaskInfoBo taskInfoBo = new TaskInfoBo();
        taskInfoBo.setTaskId("defaultTask");
        taskInfoBo.setTaskName("Default Task");
        taskInfoBo.setTaskType("query");
        taskInfoBo.setTaskExecutor("Default User");
        taskInfoBo.setTaskExecutorName("Default User");
        taskInfoBo.setInterceptPolicy(InterceptPolicyEnum.NO_INTERCEPT.getValue());
        taskInfoBo.setTaskStartTime(DateUtil.getUtcDate(new Date()));
        taskInfoBo.setTaskEndTime(DateUtil.addMonth(DateUtil.getUtcDate(new Date()), 360));
        taskInfoBo.setOperator("Default User");
        taskInfoBo.setIsCurTask(true);
        taskInfoBo.setTaskStatus(TaskStatusNameEnum.ONGOING.getCode());
        if (Objects.nonNull(userAuthenticateInfoBo)) {
            taskInfoBo.setTaskExecutor(userAuthenticateInfoBo.getLoginAccount());
            taskInfoBo.setTaskExecutorName(userAuthenticateInfoBo.getLoginAccountName());
            taskInfoBo.setOperator(userAuthenticateInfoBo.getLoginAccount());
        }
        if (Objects.nonNull(taskInfo = this.taskInfoDao.queryTaskInfoByTaskId(taskInfoBo.getTaskId()))) {
            this.taskInfoDao.updateTask(taskInfoBo);
            LOGGER.info("Update TaskInfo success.");
        } else {
            this.taskInfoDao.deleteTaskInfo(null);
            LOGGER.info("delete no-default task success.");
            taskInfoBo.setCreateTime(DateUtil.getUtcDate(new Date()));
            this.taskInfoDao.insertTaskInfo(taskInfoBo);
            LOGGER.info("Insert TaskInfo success.");
        }
        this.taskInfoDao.setOtherTask(taskInfoBo.getTaskId(), null);
        LOGGER.info("End createDefaultTask");
    }

    private UserAuthenticateInfoBo buildNewUserBo(Map<String, String> controlPolicyMap, JSONObject authInfoJsonObject, String initSource) {
        UserAuthenticateInfoBo newUser = (UserAuthenticateInfoBo)JSON.toJavaObject((JSON)authInfoJsonObject, UserAuthenticateInfoBo.class);
        newUser.setCurStatus(0);
        newUser.setWindowsAccount(this.getWindowsAccount());
        newUser.setCreateTime(DateUtil.getUtcDate(new Date()));
        newUser.setUpdateTime(DateUtil.getUtcDate(new Date()));
        newUser.setOperator(newUser.getLoginAccount());
        if (StringUtils.contains((CharSequence)newUser.getDeviceId(), (CharSequence)"%20")) {
            newUser.setDeviceId(newUser.getDeviceId().replaceAll("%20", " "));
        }
        if (Objects.nonNull(controlPolicyMap)) {
            newUser.setOperatePermission(controlPolicyMap.get("operatePermission"));
            newUser.setInitManageControlPolicy(controlPolicyMap.get("controlPolicy"));
        }
        LOGGER.info("buildNewUserBo, newUser controlPolicy {}, operatePermission {}", (Object)newUser.getInitManageControlPolicy(), (Object)newUser.getOperatePermission());
        if (StringUtils.equals((CharSequence)newUser.getOperatePermission(), (CharSequence)OperatePermissionEnum.SELECT.getValueEn())) {
            newUser.setInitManageControlPolicy(InitManageControlPolicyEnum.NOCONTROL_AND_STARTSCAN.getDataCode());
        }
        return newUser;
    }

    private String getWindowsAccount() {
        Properties prop = System.getProperties();
        return prop.getProperty("user.name");
    }

    public void insertAccountControlPolicyConfig(JSONObject initAuthInfo, UserAuthenticateInfoBo newUser) {
        LOGGER.info("insertControlPolicyConfig start.");
        this.controlPolicyConfigDao.deleteControlPolicyConfig(newUser.getRegionCode(), newUser.getRepOfficeCode());
        ControlPolicyConfigBo controlPolicyConfigBo = new ControlPolicyConfigBo();
        controlPolicyConfigBo.setRegion(newUser.getRegion());
        controlPolicyConfigBo.setRepOffice(newUser.getRepOffice());
        controlPolicyConfigBo.setRegionEn(newUser.getRegionEn());
        controlPolicyConfigBo.setRepOfficeEn(newUser.getRepOfficeEn());
        controlPolicyConfigBo.setRegionCode(newUser.getRegionCode());
        controlPolicyConfigBo.setRepOfficeCode(newUser.getRepOfficeCode());
        controlPolicyConfigBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        controlPolicyConfigBo.setUpdateTime(DateUtil.getUtcDate(new Date()));
        controlPolicyConfigBo.setOperator(newUser.getLoginAccount());
        controlPolicyConfigBo.setAccountCheckType(initAuthInfo.getJSONObject("regionControlSet").getString("neAccountCheckType"));
        this.controlPolicyConfigDao.insertControlPolicyConfig(controlPolicyConfigBo);
        LOGGER.info("insertControlPolicyConfig success.");
    }

    public boolean isExpired(UserAuthenticateInfoBo userAuthenticateInfoBo) {
        Date currentTime = DateUtil.getUtcDate(new Date());
        BigDecimal bigDecimal = new BigDecimal(userAuthenticateInfoBo.getAuthValidatePeriod());
        BigDecimal authValidatePeriod = new BigDecimal(86400000);
        BigDecimal multiply = bigDecimal.multiply(authValidatePeriod);
        Date expireTime = new Date(userAuthenticateInfoBo.getUpdateTime().getTime() + multiply.longValue());
        LOGGER.info("End to expire time.");
        return expireTime.before(currentTime);
    }

    public void synTaskStatusFromClient(UserAuthenticateInfoBo userInfo) {
        if (Objects.isNull(userInfo)) {
            LOGGER.warn("synTaskStatusFromClient, user info is null.");
            return;
        }
        LOGGER.info("synTaskStatusFromClient start.");
        List<String> taskIds = this.getTaskIds(userInfo);
        if (CollectionUtils.isEmpty(taskIds)) {
            LOGGER.info("synTaskStatusFromClient, taskIds is empty, not need to query the status.");
            return;
        }
        String synTaskUrl = PropertyUtil.getString("getTaskStatusFromClientUrl");
        RequestData data = new RequestData();
        data.setUrl(synTaskUrl);
        data.setType("POST");
        JSONObject object = new JSONObject();
        LOGGER.info("synTaskStatusFromClient taskIds: {}", (Object)JSONObject.toJSONString(taskIds));
        object.put("taskNum", taskIds);
        data.setParam(object);
        JSONObject responseJson = HttpUtil.sendRest(data);
        if (Objects.isNull(responseJson)) {
            LOGGER.error("synTaskStatusFromClient, responseJson is null.");
            return;
        }
        if (responseJson.containsKey((Object)"status") && responseJson.getInteger("status") == 1) {
            LOGGER.error("synTaskStatusFromClient failed, The status is 1 in the returned result.");
            return;
        }
        if (responseJson.containsKey((Object)"obj")) {
            JSONObject jsonObject = responseJson.getJSONObject("obj");
            if (responseJson.getInteger("status") == 0 && Objects.nonNull(jsonObject) && Objects.nonNull(jsonObject.getJSONArray("data"))) {
                this.updateTaskStatus(jsonObject.getJSONArray("data"), userInfo);
            }
        } else {
            LOGGER.error("synTaskStatusFromClient failed, The obj is null in the returned result.");
        }
    }

    private void updateTaskStatus(JSONArray jsonArray, UserAuthenticateInfoBo userInfo) {
        if (Objects.isNull(jsonArray) || jsonArray.isEmpty()) {
            LOGGER.error("updateTaskStatus, return jsonArray is empty.");
            return;
        }
        LOGGER.info("updateTaskStatus, return jsonArray: {}", (Object)jsonArray.toJSONString());
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObj = jsonArray.getJSONObject(i);
            if (Objects.isNull(jsonObj)) {
                LOGGER.error("updateTaskStatus, return taskInfo is null.");
                continue;
            }
            String taskId = jsonObj.getString("taskId");
            TaskInfoBo taskInfoBo = new TaskInfoBo();
            taskInfoBo.setTaskId(taskId);
            if (jsonObj.getInteger("taskStatus") == 10060) {
                taskInfoBo.setTaskStatus(TaskStatusNameEnum.COMPLETE.getCode());
                taskInfoBo.setIsCurTask(false);
                this.taskInfoDao.updateTask(taskInfoBo);
                LOGGER.info("updateTaskStatus, Task {} completed", (Object)taskId);
                TaskInfoBo taskInfo = this.taskInfoDao.queryTaskInfoByTaskId(taskId);
                this.deleteEngineeringCommissioningNesByTaskId(taskInfo);
                continue;
            }
            TaskInfoBo curTask = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userInfo.getLoginAccount());
            if (Objects.isNull(curTask)) {
                LOGGER.info("updateTaskStatus, curTask is null.");
                continue;
            }
            if (!StringUtils.equals((CharSequence)taskId, (CharSequence)curTask.getTaskId()) || !jsonObj.containsKey((Object)"isCurrentTask") || jsonObj.getBooleanValue("isCurrentTask")) continue;
            taskInfoBo.setTaskStatus(TaskStatusNameEnum.TO_DO.getCode());
            taskInfoBo.setIsCurTask(false);
            this.taskInfoDao.updateTask(taskInfoBo);
            LOGGER.info("updateTaskStatus, task {} not ongoing in the Client, Set the status in the SDK from ongoing to to-do.", (Object)taskId);
        }
        LOGGER.info("updateTaskStatus end.");
    }

    private List<String> getTaskIds(UserAuthenticateInfoBo userInfo) {
        List<TaskInfoBo> taskInfoBoList = this.taskInfoDao.queryTasksInTimeRange(DateUtil.getUtcDate(new Date()), userInfo.getLoginAccount());
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userInfo.getLoginAccount());
        taskInfoBoList.add(taskInfoBo);
        ArrayList<String> taskIdList = new ArrayList<String>();
        for (TaskInfoBo taskInfo : taskInfoBoList) {
            boolean isValidTaskId = Objects.nonNull(taskInfo) && StringUtils.isNotEmpty((CharSequence)taskInfo.getTaskId());
            if (!isValidTaskId || StringUtils.equals((CharSequence)"\u672c\u5730\u81ea\u5efa", (CharSequence)taskInfo.getTaskObtainMode()) || StringUtils.equals((CharSequence)taskInfo.getTaskId(), (CharSequence)"defaultTask")) continue;
            taskIdList.add(taskInfo.getTaskId());
        }
        return taskIdList;
    }

    private void deleteEngineeringCommissioningNesByTaskId(TaskInfoBo curActiveTask) {
        if (StringUtils.equals((CharSequence)curActiveTask.getTaskType(), (CharSequence)TaskTypeEnum.PROJECT.getTaskTypeEn())) {
            this.nesMapper.deleteEngineeringCommissioningNesByTaskId(curActiveTask.getTaskId());
            LOGGER.info("The method deleteEngineeringCommissioningNesByTaskId success.");
        }
    }
}

