/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.huawei.netcareinsidesdk.exception.NetCareInsideSdkException;
import com.huawei.netcareinsidesdk.utils.ReflexesUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);

    public static Date dateAddFiveMin(Date authEndTime) {
        return new Date(authEndTime.getTime() + 300000L);
    }

    public static String formatDateToStr(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String formatDateToSpecific(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String formatDate = sdf.format(date);
        return formatDate.concat(":00");
    }

    public static Date formatToSpecificDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String format = sdf.format(date).concat(":00");
        return DateUtil.stringToDate(format, "yyyy-MM-dd HH:mm:ss");
    }

    public static String caculateTimeDiff(Date startTime, Date endTime) {
        long diff = endTime.getTime() - startTime.getTime();
        long diffHours = diff / 3600000L;
        long diffMinutes = diff / 60000L % 60L;
        StringBuffer sb = new StringBuffer();
        if (String.valueOf(diffHours).length() == 1) {
            sb.append("0" + diffHours).append(":");
        } else {
            sb.append(diffHours).append(":");
        }
        if (String.valueOf(diffMinutes).length() == 1) {
            sb.append("0" + diffMinutes);
        } else {
            sb.append(diffMinutes);
        }
        return sb.toString();
    }

    public static double getTimeDiff(Date startTime, Date endTime) {
        double hours = (double)(endTime.getTime() - startTime.getTime()) / 3600000.0;
        return BigDecimal.valueOf(hours).setScale(2, 4).doubleValue();
    }

    private static Double getRexStr(String minute) {
        String minuteStr = minute.replaceAll("^0+", "");
        if (StringUtils.isBlank((CharSequence)minuteStr)) {
            return 0.0;
        }
        return Double.parseDouble(minuteStr);
    }

    public static String converseDuration(String duration) {
        String[] durationArray = duration.split(":");
        double num = DateUtil.getRexStr(durationArray[1]) / 60.0 + DateUtil.getRexStr(durationArray[0]);
        DecimalFormat df = new DecimalFormat("#.00");
        return df.format(num);
    }

    public static boolean calculateTimeDiff(Date startDate, Date endDate, String duration) {
        String[] durationArray = duration.split(":");
        Date addHourDate = DateUtils.addHours((Date)startDate, (int)DateUtil.getIntDuration(durationArray[0]));
        Date caculatedDate = DateUtils.addMinutes((Date)addHourDate, (int)DateUtil.getIntDuration(durationArray[1]));
        return endDate.compareTo(caculatedDate) == 0;
    }

    private static int getIntDuration(String duration) {
        String durationStr = duration.replaceAll("^0+", "");
        if (StringUtils.isBlank((CharSequence)durationStr)) {
            return 0;
        }
        return Integer.parseInt(durationStr);
    }

    public static Date getUtcDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        return new Date(date.getTime() - (long)TimeZone.getDefault().getRawOffset());
    }

    public static Date getLocalDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        return new Date(date.getTime() + (long)TimeZone.getDefault().getRawOffset());
    }

    public static Date addMonth(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, amount);
        return cal.getTime();
    }

    public static Date stringToDate(String strTime, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = formatter.parse(strTime);
        }
        catch (ParseException parseException) {
            LOGGER.info("DateUtil stringToDate is exception");
        }
        return date;
    }

    public static String getTimeZoneId() {
        TimeZone timeZone = TimeZone.getDefault();
        if (Objects.isNull(timeZone) || StringUtils.isEmpty((CharSequence)timeZone.getID())) {
            return "Asia/Shanghai";
        }
        return timeZone.getID();
    }

    public static <T> T userTimeZoneTimeTranslationUtc(T obj, String ... timeNameList) {
        if (obj == null) {
            return obj;
        }
        Class<?> aClass = obj.getClass();
        DateUtil.setUserTimeUtc(obj, aClass, timeNameList);
        return obj;
    }

    public static <T> T userTimeTranslationUtc(T obj, String ... timeNameList) {
        if (obj == null) {
            return obj;
        }
        Class<?> aClass = obj.getClass();
        Arrays.stream(timeNameList).filter(StringUtils::isNotEmpty).forEach(item -> {
            try {
                Field currentDeclaredField = aClass.getDeclaredField((String)item);
                Date fieldValues = (Date)ReflexesUtils.getField(currentDeclaredField, obj, aClass);
                if (fieldValues == null) {
                    return;
                }
                if (currentDeclaredField.getType() == Date.class) {
                    TimeZone timeZone = TimeZone.getDefault();
                    long offset = timeZone.getRawOffset();
                    Date utcTime = new Date(DateUtil.getUtcDate(fieldValues).getTime() - offset);
                    ReflexesUtils.setField(currentDeclaredField, obj, aClass, utcTime);
                }
            }
            catch (NoSuchFieldException e) {
                LOGGER.error("DateUtil userTimeTranslationUtc error.");
            }
        });
        return obj;
    }

    public static <T> List<T> userTimeZoneTimeTranslationUtc(List<T> objList, String ... timeNameList) {
        if (objList == null || objList.size() == 0) {
            return objList;
        }
        for (T obj : objList) {
            if (obj == null) continue;
            Class<?> aClass = obj.getClass();
            DateUtil.setUserTimeUtc(obj, aClass, timeNameList);
        }
        return objList;
    }

    private static <T> void setUserTimeUtc(T obj, Class<?> aClass, String[] timeNameList) {
        Arrays.stream(timeNameList).filter(StringUtils::isNotEmpty).forEach(item -> {
            try {
                Field declaredField = aClass.getDeclaredField((String)item);
                Date fieldValues = (Date)ReflexesUtils.getField(declaredField, obj, aClass);
                if (fieldValues == null) {
                    return;
                }
                if (declaredField.getType() == Date.class) {
                    TimeZone timeZone = TimeZone.getDefault();
                    long offset = timeZone.getRawOffset();
                    Date utcTime = new Date(fieldValues.getTime() - offset);
                    ReflexesUtils.setField(declaredField, obj, aClass, utcTime);
                }
            }
            catch (NoSuchFieldException e) {
                LOGGER.error("DateUtil setUserTimeUtc error.");
            }
        });
    }

    public static <T> T dbTimeTranslationWebUtc(T obj, String ... timeNameList) {
        if (obj == null) {
            return null;
        }
        for (String timeName : timeNameList) {
            Object fieldValueObj;
            if (StringUtils.isEmpty((CharSequence)timeName) || (fieldValueObj = ReflexesUtils.getFieldValue(timeName, obj)) == null) continue;
            if (fieldValueObj instanceof Date) {
                Date fieldValues = (Date)fieldValueObj;
                TimeZone sysTimeZone = TimeZone.getDefault();
                long offset = sysTimeZone.getRawOffset();
                Date utcTime = new Date(fieldValues.getTime() + offset);
                ReflexesUtils.setFieldValue(timeName, obj, utcTime);
                continue;
            }
            throw new NetCareInsideSdkException("DateUtil dbTimeTranslationWebUtc error.");
        }
        return obj;
    }

    public static <T> List<T> dbTimeTranslationWebUtc(List<T> objList, String ... timeNameList) {
        if (objList == null) {
            return objList;
        }
        for (T obj : objList) {
            DateUtil.dbTimeTranslationWebUtc(obj, timeNameList);
        }
        return objList;
    }

    public static Date getCurrentDateOffsets(boolean pisPreDate) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, pisPreDate ? -1 : 1);
        return calendar.getTime();
    }
}

