/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.RequestData;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    private static final int TIME_OUT = 10;

    private HttpUtil() {
    }

    private static CloseableHttpClient initClient() {
        return HttpClientBuilder.create().build();
    }

    public static JSONObject sendRest(RequestData requestData) {
        JSONObject result = null;
        if (requestData == null) {
            logger.error("Request data is null.");
            return result;
        }
        logger.info("start sendRest");
        return StringUtils.equals((CharSequence)requestData.getType(), (CharSequence)"GET") ? HttpUtil.sendGetRest(requestData) : HttpUtil.sendPostRest(requestData);
    }

    private static void setRequest(HttpUriRequestBase httpUriRequestBase, RequestData requestData) {
        if (requestData.getParam() == null) {
            JSONObject object = new JSONObject();
            requestData.setParam(object);
        }
        httpUriRequestBase.setConfig(requestData.getRequestConfig());
        StringEntity se = new StringEntity(requestData.getParam().toJSONString(), ContentType.APPLICATION_JSON);
        httpUriRequestBase.setEntity((HttpEntity)se);
        JSONObject headers = requestData.getHeader();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry entry : headers.entrySet()) {
                httpUriRequestBase.addHeader((String)entry.getKey(), headers.get(entry.getKey()));
            }
        }
    }

    private static JSONObject sendPostRest(RequestData requestData) {
        HttpPost httpPost = new HttpPost(requestData.getUrl());
        RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(Timeout.ofSeconds((long)10L)).setConnectionRequestTimeout(Timeout.ofSeconds((long)10L)).build();
        requestData.setRequestConfig(requestConfig);
        HttpUtil.setRequest((HttpUriRequestBase)httpPost, requestData);
        try {
            CloseableHttpClient client = HttpUtil.initClient();
            return (JSONObject)client.execute((ClassicHttpRequest)httpPost, HttpUtil::handleResponse);
        }
        catch (IOException e) {
            logger.error("Failed to request the post interface of sendPostRest.");
            return null;
        }
    }

    private static JSONObject sendGetRest(RequestData requestData) {
        HttpGet httpGet = new HttpGet(requestData.getUrl());
        RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(Timeout.ofSeconds((long)10L)).setConnectionRequestTimeout(Timeout.ofSeconds((long)10L)).build();
        requestData.setRequestConfig(requestConfig);
        HttpUtil.setRequest((HttpUriRequestBase)httpGet, requestData);
        try {
            CloseableHttpClient client = HttpUtil.initClient();
            return (JSONObject)client.execute((ClassicHttpRequest)httpGet, HttpUtil::handleResponse);
        }
        catch (IOException e) {
            logger.error("Failed to request the get interface of sendGetRest.");
            return null;
        }
    }

    private static JSONObject handleResponse(ClassicHttpResponse response) {
        JSONObject result = new JSONObject();
        try {
            if (response != null) {
                logger.info("response resultCode:{}", (Object)response.getCode());
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    String results = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    logger.info("get results from entity size is {}", (Object)results.length());
                    result = JSONObject.parseObject((String)results);
                } else {
                    logger.error("Response entity is null.");
                }
            } else {
                logger.error("Response data is null.");
            }
        }
        catch (IOException | ParseException e) {
            logger.error("Failed to parse results.");
        }
        return result;
    }
}

