/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.ToolConfig;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.SpringContextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class JsonParseUtils {
    private static final Logger RUN_LOGGER = LoggerFactory.getLogger(JsonParseUtils.class);
    private static ToolConfig toolConfig = null;

    public static ToolConfig getToolConfig() {
        return toolConfig;
    }

    private static void initToolConfig() {
        String toolId = JsonParseUtils.getToolId();
        try (InputStream inputStream = PropertyUtil.class.getResourceAsStream("/toolConfig.json");
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
            List toolConfigs = JSON.parseArray((String)content.toString(), ToolConfig.class);
            for (ToolConfig tool : toolConfigs) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)toolId, (CharSequence)tool.getToolName())) continue;
                toolConfig = tool;
                break;
            }
            if (Objects.isNull(toolConfig)) {
                toolConfig = new ToolConfig();
                toolConfig.setToolName(toolId);
            }
        }
        catch (IOException ex) {
            RUN_LOGGER.error("initToolConfig error {}", (Object)ex.getMessage());
            toolConfig = new ToolConfig();
            toolConfig.setToolName(toolId);
        }
    }

    private static String getToolId() {
        Environment env = SpringContextUtils.getBean(Environment.class);
        String toolId = env.getProperty("netcareinside.tooId");
        RUN_LOGGER.info("application.yml netcareinside.tooId is {}", (Object)toolId);
        return toolId;
    }

    public static JSONObject parseJson(String fileName) throws IOException {
        StringBuffer sb = new StringBuffer();
        try (Reader reader = null;){
            File jsonFile = new File(fileName);
            reader = new InputStreamReader(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            int ch = 0;
            while ((ch = reader.read()) != -1) {
                sb.append((char)ch);
            }
        }
        RUN_LOGGER.info("Parse json file succeed.");
        return JSON.parseObject((String)sb.toString());
    }

    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (obj instanceof List) {
            for (Object ob : (List)obj) {
                result.add(clazz.cast(ob));
            }
            return result;
        }
        return null;
    }

    public static List<String> usingSubstringMethod(String text, int number) {
        ArrayList<String> results = new ArrayList<String>();
        int length = text.length();
        for (int i = 0; i < length; i += number) {
            results.add(text.substring(i, Math.min(length, i + number)));
        }
        return results;
    }

    static {
        JsonParseUtils.initToolConfig();
    }
}

