/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.huawei.netcareinsidesdk.bo.OfflineAuthCheckCache;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OfflineAuthUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfflineAuthUtil.class);
    private static final Integer VERIFY_ERROR_NUM = 5;
    private static final long ACCOUNT_LOCK_TIME = 300000L;
    private static final long OFFLINE_AUTH_CHECK_TIME = 60000L;
    private static List<OfflineAuthCheckCache> offlineBypassCheckCacheList = new ArrayList<OfflineAuthCheckCache>(5);
    private static Date firstAuthTime;
    @Autowired
    private InternationalizeUtil internationalizeUtil;

    private void clearAccountCache(String account) {
        offlineBypassCheckCacheList.removeIf(offlineAuthCheckCache -> StringUtils.equals((CharSequence)offlineAuthCheckCache.getAccount(), (CharSequence)account));
    }

    public Result getCheckTimesResult(Result checkResult, String account) {
        if (StringUtils.equals((CharSequence)String.valueOf(checkResult.get("code")), (CharSequence)"0")) {
            this.clearAccountCache(account);
        } else {
            HashMap<String, String> checkResultMap = new HashMap<String, String>();
            this.checkOfflineAuthFailedTimes(account, checkResultMap);
            if (!CollectionUtils.isEmpty(checkResultMap)) {
                LOGGER.error("importOfflineBypassFile check import failed times failed.");
                return Result.fail((String)checkResultMap.get("errorCode"), (String)checkResultMap.get("errorMsg"));
            }
        }
        return checkResult;
    }

    private void checkOfflineAuthFailedTimes(String account, Map<String, String> checkResultMap) {
        for (OfflineAuthCheckCache offlineAuthCheckCache : offlineBypassCheckCacheList) {
            if (!StringUtils.equals((CharSequence)offlineAuthCheckCache.getAccount(), (CharSequence)account)) continue;
            Date currentAuthTime = DateUtil.getUtcDate(new Date());
            Integer currentOfflineAuthNum = offlineAuthCheckCache.getOfflineAuthNum();
            offlineAuthCheckCache.setOfflineAuthNum(currentOfflineAuthNum + 1);
            if (offlineAuthCheckCache.getOfflineAuthNum() >= VERIFY_ERROR_NUM) {
                offlineAuthCheckCache.setLock(true);
                offlineAuthCheckCache.setLockTime(currentAuthTime);
                LOGGER.error("The number of offlineBypass times exceeds five,Your account has been locked,Please verify in 5 minutes!");
                checkResultMap.put("errorCode", ErrorCodeEnum.IMPORT_OFFLINE_BYPASS_FILE_TIMES_ERROR.getErrorCode());
                checkResultMap.put("errorMsg", this.internationalizeUtil.getMessage(ErrorCodeEnum.IMPORT_OFFLINE_BYPASS_FILE_TIMES_ERROR.getErrorCode()));
                return;
            }
            int remainNum = VERIFY_ERROR_NUM - offlineAuthCheckCache.getOfflineAuthNum();
            LOGGER.info("Check offlineBypass,{} more attempts are left. The account will be locked!", (Object)remainNum);
            return;
        }
        OfflineAuthCheckCache offlineAuthCheckCache = new OfflineAuthCheckCache();
        offlineAuthCheckCache.setAccount(account);
        offlineAuthCheckCache.setOfflineAuthNum(1);
        firstAuthTime = DateUtil.getUtcDate(new Date());
        offlineAuthCheckCache.setOfflineAuthTime(firstAuthTime);
        offlineBypassCheckCacheList.add(offlineAuthCheckCache);
        LOGGER.info("First check offlineBypass,4 more attempts are left. The account will be locked!");
    }

    public String verifyPreCheck(String account) {
        String errMsg = "";
        Iterator<OfflineAuthCheckCache> iterator = offlineBypassCheckCacheList.iterator();
        while (iterator.hasNext()) {
            OfflineAuthCheckCache offlineAuthCheckCache = iterator.next();
            if (!StringUtils.equals((CharSequence)offlineAuthCheckCache.getAccount(), (CharSequence)account) || !offlineAuthCheckCache.isLock()) continue;
            long unLockTime = offlineAuthCheckCache.getLockTime().getTime() + 300000L;
            Date currentTime = DateUtil.getUtcDate(new Date());
            if (currentTime.getTime() > unLockTime) {
                iterator.remove();
                return errMsg;
            }
            long milliSecondtime = unLockTime - currentTime.getTime();
            LOGGER.error("Your account has been locked,Please verify in {} seconds!", (Object)(milliSecondtime / 1000L));
            return this.internationalizeUtil.getMessage(ErrorCodeEnum.ACCOUNT_LOCKED_CHECK_OFFLINE_BYPASS.getErrorCode(), Collections.singletonList(String.valueOf(milliSecondtime / 1000L)));
        }
        return errMsg;
    }

    public Map<String, String> checkAccountValidity(String account) {
        HashMap<String, String> checkResultMap = new HashMap<String, String>();
        String errMsg = this.verifyPreCheck(account);
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            checkResultMap.put("errorCode", ErrorCodeEnum.ACCOUNT_LOCKED_VERIFY.getErrorCode());
            checkResultMap.put("errorMsg", errMsg);
            return checkResultMap;
        }
        return checkResultMap;
    }
}

