/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import java.util.List;

public class PageBean<T> {
    private int pageNum;
    private int pageSize;
    private int totalRecord;
    private int totalPage;
    private List<T> list;
    private int fromIndex;
    private int toIndex;

    public PageBean(int pageNum, int pageSize, List<T> list) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.totalRecord = list.size();
        this.fromIndex = (pageNum - 1) * pageSize;
        this.toIndex = pageNum * pageSize > this.totalRecord ? this.totalRecord : pageNum * pageSize;
        this.totalPage = this.totalRecord % pageSize == 0 ? this.totalRecord / pageSize : this.totalRecord / pageSize + 1;
        this.list = list.subList(this.fromIndex, this.toIndex);
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalRecord() {
        return this.totalRecord;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public List<T> getList() {
        return this.list;
    }

    public int getFromIndex() {
        return this.fromIndex;
    }

    public int getToIndex() {
        return this.toIndex;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalRecord(int totalRecord) {
        this.totalRecord = totalRecord;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public void setFromIndex(int fromIndex) {
        this.fromIndex = fromIndex;
    }

    public void setToIndex(int toIndex) {
        this.toIndex = toIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageBean)) {
            return false;
        }
        PageBean other = (PageBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotalRecord() != other.getTotalRecord()) {
            return false;
        }
        if (this.getTotalPage() != other.getTotalPage()) {
            return false;
        }
        if (this.getFromIndex() != other.getFromIndex()) {
            return false;
        }
        if (this.getToIndex() != other.getToIndex()) {
            return false;
        }
        List<T> this$list = this.getList();
        List<T> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNum();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getTotalRecord();
        result = result * 59 + this.getTotalPage();
        result = result * 59 + this.getFromIndex();
        result = result * 59 + this.getToIndex();
        List<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "PageBean(pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", totalRecord=" + this.getTotalRecord() + ", totalPage=" + this.getTotalPage() + ", list=" + this.getList() + ", fromIndex=" + this.getFromIndex() + ", toIndex=" + this.getToIndex() + ")";
    }
}

