/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.huawei.us.common.random.UsSecureRandom;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtil {
    private static final char[] LOWER_CASES = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] UPPER_CASES = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] NUMS_LIST = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] SYMBOLS_ARRAY = new char[]{'+', '-', '*', '/', '_', '!', '@', '#', '$', '%', '^', '&'};
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordUtil.class);

    private PasswordUtil() {
    }

    public static char[] genRandomPwd(int pwdLength) {
        if (pwdLength >= 8 && pwdLength <= 20) {
            SecureRandom random = null;
            try {
                random = UsSecureRandom.getInstance();
                if (Objects.isNull(random)) {
                    LOGGER.error("genRandomPwd is null");
                    return new char[0];
                }
                random.setSeed(random.generateSeed(64));
            }
            catch (NoSuchAlgorithmException var9) {
                LOGGER.error("genRandomPwd failed.");
                return new char[0];
            }
            int lower = random.nextInt(pwdLength + 1);
            lower = PasswordUtil.getValidLowerLength(pwdLength, lower);
            int upper = random.nextInt(pwdLength - lower + 1);
            upper = PasswordUtil.getValidUpperLength(pwdLength, lower, upper);
            int num = random.nextInt(pwdLength - lower - upper + 1);
            num = PasswordUtil.getValidNumLength(pwdLength, lower, upper, num);
            int symbol = pwdLength - lower - upper - num;
            char[] pwd = new char[pwdLength];
            int position = 0;
            return PasswordUtil.getChars(random, lower, upper, num, symbol, pwd, position);
        }
        return new char[0];
    }

    private static char[] getChars(SecureRandom random, int lower, int upper, int num, int symbol, char[] pwd, int position) {
        while (lower + upper + num + symbol > 0) {
            int type = random.nextInt(4);
            if (type == 0 && lower > 0) {
                pwd[position] = LOWER_CASES[random.nextInt(LOWER_CASES.length)];
                --lower;
                ++position;
                continue;
            }
            if (type == 1 && upper > 0) {
                pwd[position] = UPPER_CASES[random.nextInt(UPPER_CASES.length)];
                --upper;
                ++position;
                continue;
            }
            if (type == 2 && num > 0) {
                pwd[position] = NUMS_LIST[random.nextInt(NUMS_LIST.length)];
                --num;
                ++position;
                continue;
            }
            if (type == 3 && symbol > 0) {
                pwd[position] = SYMBOLS_ARRAY[random.nextInt(SYMBOLS_ARRAY.length)];
                --symbol;
                ++position;
                continue;
            }
            LOGGER.info("The branch will not be entered");
        }
        return pwd;
    }

    private static int getValidNumLength(int pwdLength, int lower, int upper, int num) {
        int tmpNum = num == 0 ? 1 : (num > pwdLength - lower - upper - 1 ? pwdLength - lower - upper - 1 : num);
        return tmpNum;
    }

    private static int getValidUpperLength(int pwdLength, int lower, int upper) {
        int tmpUpper = upper == 0 ? 1 : (upper > pwdLength - lower - 2 ? pwdLength - lower - 2 : upper);
        return tmpUpper;
    }

    private static int getValidLowerLength(int pwdLength, int lower) {
        int tmpLower = lower == 0 ? 1 : (lower > pwdLength - 3 ? pwdLength - 3 : lower);
        return tmpLower;
    }
}

