/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.huawei.us.common.file.UsFileUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyUtil.class);
    private static Map<String, String> configMap = new ConcurrentHashMap<String, String>();

    public static String getScanQrUrl(String urlKey, String env) {
        if (StringUtils.equals((CharSequence)env, (CharSequence)"Germany")) {
            return PropertyUtil.getString(urlKey + "_de");
        }
        return PropertyUtil.getString(urlKey);
    }

    public static Map<String, String> getPropertiesAsMap(String resourcePath) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)resourcePath)) {
            LOGGER.error("resourcePath is empty.");
            return map;
        }
        try (FileInputStream inStream = UsFileUtils.getFileInputStream((String)resourcePath);){
            Properties props = new Properties();
            props.load(inStream);
            PropertyUtil.loadToMap(props, map);
            props.clear();
        }
        catch (IOException exception) {
            LOGGER.error("getPropertiesAsMap IOException.");
        }
        return map;
    }

    public static String getString(String key) {
        String str = configMap.get(key);
        return StringUtils.isEmpty((CharSequence)str) ? "" : str.trim();
    }

    private static Map<String, String> getPropertiesAsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        PropertyUtil.readResources(map, "/netcareinsidedb.properties");
        PropertyUtil.readResources(map, "/netcareinside_sdk_env.properties");
        PropertyUtil.readResources(map, "/netcareinside_env.properties");
        PropertyUtil.readResources(map, "/pubkey.properties");
        return map;
    }

    private static void readResources(Map<String, String> map, String resourcePath) {
        try (InputStream inStream = PropertyUtil.class.getResourceAsStream(resourcePath);){
            if (inStream != null) {
                Properties props = new Properties();
                props.load(inStream);
                PropertyUtil.loadToMap(props, map);
                props.clear();
            }
        }
        catch (IOException e) {
            LOGGER.error("load file " + resourcePath + " occurred an error!", (Throwable)e);
        }
    }

    private static void loadToMap(Properties properties, Map<String, String> result) {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = String.valueOf(propertyNames.nextElement());
            String value = properties.getProperty(name);
            result.put(name, value);
        }
    }

    static {
        configMap.putAll(PropertyUtil.getPropertiesAsMap());
    }
}

