/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.huawei.us.common.resource.ResourceUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRCodeUtil {
    private static final Logger RUN_LOGGER = LoggerFactory.getLogger(QRCodeUtil.class);
    private static final String CHARSET = "utf-8";
    private static final int QRCODE_SIZE = 300;

    public static BufferedImage createImage(String content) {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = null;
        try {
            bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 300, 300, hints);
        }
        catch (WriterException e) {
            RUN_LOGGER.error("Create image failed!");
        }
        if (Objects.isNull(bitMatrix)) {
            throw new RuntimeException("createImage exception.");
        }
        int[] rec = bitMatrix.getEnclosingRectangle();
        int resWidth = rec[2] + 1;
        int resHeigth = rec[3] + 1;
        BitMatrix recBitMatrix = new BitMatrix(resWidth, resHeigth);
        recBitMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeigth; ++j) {
                if (!bitMatrix.get(i + rec[0], j + rec[1])) continue;
                recBitMatrix.set(i, j);
            }
        }
        int width = recBitMatrix.getWidth();
        int height = recBitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, recBitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        image = QRCodeUtil.generateQrcodeWithLogoImage(image);
        return image;
    }

    public static BufferedImage generateQrcodeWithLogoImage(BufferedImage qrcodeBuffImg) {
        Graphics2D graphics = qrcodeBuffImg.createGraphics();
        BufferedImage logo = null;
        try {
            logo = ImageIO.read(Objects.requireNonNull(ResourceUtil.class.getResourceAsStream("/swing_page_image/logo.png")));
        }
        catch (IOException e) {
            RUN_LOGGER.error("Read logo picture failed.");
            return null;
        }
        int logoWidth = logo.getWidth();
        int logoHeight = logo.getHeight();
        int width = (qrcodeBuffImg.getWidth() - logoWidth) / 2;
        int height = (qrcodeBuffImg.getHeight() - logoHeight) / 2;
        graphics.drawImage(logo, width, height, logoWidth, logoHeight, null);
        graphics.drawRoundRect(width, height, logoWidth, logoHeight, 15, 15);
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(Color.WHITE);
        graphics.drawRect(width, height, logoWidth, logoHeight);
        graphics.dispose();
        logo.flush();
        qrcodeBuffImg.flush();
        return qrcodeBuffImg;
    }
}

