/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflexesUtils {
    private static final Logger RUN_LOG = LoggerFactory.getLogger(ReflexesUtils.class);

    public static <T, R> void setField(Field field, T obj, Class<? extends T> objClass, R flag) {
        String filedName = ReflexesUtils.getFieldName(field);
        Class<?> type = field.getType();
        String methodName = "set" + filedName.substring(0, 1).toUpperCase(Locale.ROOT) + filedName.substring(1);
        try {
            Method method = objClass.getMethod(methodName, type);
            method.invoke(obj, flag);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            RUN_LOG.error("ReflexesUtils setField filedName = {}", (Object)e.getMessage());
        }
    }

    public static <T> Object getFieldValue(String filedName, T obj) {
        try {
            if (StringUtils.isBlank((CharSequence)filedName) || obj == null) {
                return null;
            }
            Class<?> objClass = obj.getClass();
            String methodName = "get" + filedName.substring(0, 1).toUpperCase(Locale.ROOT) + filedName.substring(1);
            String methodName2 = "is" + filedName.substring(0, 1).toUpperCase(Locale.ROOT) + filedName.substring(1);
            for (Method method : objClass.getMethods()) {
                if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) && !StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName2)) continue;
                return method.invoke(obj, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            RUN_LOG.error("ReflexesUtils getFieldValue fail filedName:{}", (Object)e.getMessage());
        }
        return null;
    }

    public static <T> Object getField(Field field, T obj, Class<? extends T> objClass) {
        String filedName = ReflexesUtils.getFieldName(field);
        String methodName = ReflexesUtils.getMethodName(filedName, "get");
        String methodName2 = ReflexesUtils.getMethodName(filedName, "is");
        try {
            for (Method method : objClass.getMethods()) {
                if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) && !StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName2)) continue;
                return method.invoke(obj, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            RUN_LOG.error("ReflexesUtils getField filedName = {}", (Object)e.getMessage());
        }
        return null;
    }

    public static <T, R> void setFieldValue(String filedName, T obj, R value) {
        try {
            if (StringUtils.isNotBlank((CharSequence)filedName) && obj != null) {
                Class<?> objClass = obj.getClass();
                Class<?> type = value == null ? ReflexesUtils.getFieldType(objClass, filedName) : value.getClass();
                String methodName = "set" + filedName.substring(0, 1).toUpperCase(Locale.ROOT) + filedName.substring(1);
                Method method = objClass.getMethod(methodName, type);
                method.invoke(obj, value);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            RUN_LOG.error("ReflexesUtils setFieldValue fail filedName:{}", (Object)e.getMessage());
        }
    }

    private static Class<?> getFieldType(Class<?> objClass, String filedName) throws NoSuchFieldException {
        try {
            return objClass.getDeclaredField(filedName).getType();
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = objClass.getSuperclass();
            if (superclass.equals(Object.class)) {
                throw e;
            }
            return ReflexesUtils.getFieldType(superclass, filedName);
        }
    }

    private static String getFieldName(Field field) {
        return field.getName();
    }

    private static String getMethodName(String filedName, String method) {
        return method + filedName.substring(0, 1).toUpperCase(Locale.ROOT) + filedName.substring(1);
    }
}

