/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.RequestData;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.utils.HttpUtil;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TelnetUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TelnetUtil.class);
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean telnetIp(String hostname, int port, int timeout) {
        Socket socket = new Socket();
        boolean isConnected = false;
        long start = System.currentTimeMillis();
        try {
            socket.connect(new InetSocketAddress(hostname, port), timeout);
            isConnected = socket.isConnected();
        }
        catch (IOException except) {
            long end = System.currentTimeMillis();
            LOGGER.error("telnet false, cost time -> {} ms", (Object)(end - start));
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                LOGGER.error("Socket close exception.");
            }
        }
        return isConnected;
    }

    public Map<String, Boolean> hasConnectedClient() {
        HashMap<String, Boolean> isClient = new HashMap<String, Boolean>();
        isClient.put("isConnected", false);
        isClient.put("isTelnet", false);
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.nonNull(userAuthenticateInfoBo) && Objects.nonNull(userAuthenticateInfoBo.getIsPublicOmTerminal()) && userAuthenticateInfoBo.getIsPublicOmTerminal().booleanValue()) {
            return isClient;
        }
        boolean isOk = this.telnetIp("localhost", 51943, 300);
        isClient.put("isTelnet", isOk);
        if (!isOk) {
            LOGGER.info("hasConnectedClient, telnetIp is false.");
            return isClient;
        }
        String queryConnectStatusUrl = PropertyUtil.getString("queryConnectStatusUrl");
        RequestData requestData = new RequestData();
        requestData.setUrl(queryConnectStatusUrl);
        requestData.setType("POST");
        JSONObject responseJson = HttpUtil.sendRest(requestData);
        if (Objects.isNull(responseJson)) {
            LOGGER.info("queryConnectStatusUrl responseJson is empty , isClient is {}.", (Object)JSONObject.toJSONString(isClient));
            return isClient;
        }
        LOGGER.info("queryConnectStatusUrl responseJson {}", (Object)responseJson.toJSONString());
        String returnValue = responseJson.getString("returnValue");
        JSONObject obj = responseJson.getJSONObject("obj");
        if (responseJson.containsKey((Object)"obj") && ObjectUtils.isNotEmpty((Object)responseJson.getJSONObject("obj"))) {
            String netStatus;
            LOGGER.info("queryConnectStatusUrl obj {}", (Object)obj.toJSONString());
            if (StringUtils.equals((CharSequence)returnValue, (CharSequence)"NetCare") && obj.containsKey((Object)"netStatus") && Objects.nonNull(netStatus = obj.getString("netStatus"))) {
                isClient.put("isConnected", StringUtils.equals((CharSequence)netStatus, (CharSequence)"true"));
                LOGGER.info("client online or offline response {}", (Object)JSONObject.toJSONString(isClient));
                return isClient;
            }
        }
        isClient.put("isConnected", StringUtils.equals((CharSequence)returnValue, (CharSequence)"NetCare"));
        if (Objects.isNull(obj)) {
            isClient.put("isTelnet", false);
        }
        LOGGER.info("is NetCare hasConnectedClient {}", (Object)JSONObject.toJSONString(isClient));
        return isClient;
    }
}

