/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.VerifyCodeCheckCache;
import com.huawei.netcareinsidesdk.bo.VerifyCodeRecordBo;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.dao.VerifyCodeRecordDao;
import com.huawei.netcareinsidesdk.exception.NetCareInsideSdkException;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VerifyCodeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifyCodeUtil.class);
    private static final Integer VERIFY_ERROR_NUM = 5;
    private static final long ACCOUNT_LOCK_TIME = 300000L;
    private static List<VerifyCodeCheckCache> verifyCodeCheckCacheList = new ArrayList<VerifyCodeCheckCache>(5);
    private static List<VerifyCodeRecordBo> verifyCodeCacheList = new ArrayList<VerifyCodeRecordBo>(7);
    @Autowired
    private VerifyCodeRecordDao verifyCodeRecordDao;
    @Autowired
    private InternationalizeUtil internationalizeUtil;

    public void clearCodeCache() {
        verifyCodeCacheList.clear();
    }

    public List<VerifyCodeRecordBo> getCodeCache() {
        return verifyCodeCacheList;
    }

    public void addCodeCache(List<VerifyCodeRecordBo> verifyCodeList) {
        this.clearCodeCache();
        verifyCodeCacheList.addAll(verifyCodeList);
    }

    public void clearAccountCache(String account) {
        verifyCodeCheckCacheList.removeIf(verifyCodeCheckCache -> StringUtils.equals((CharSequence)verifyCodeCheckCache.getAccount(), (CharSequence)account));
    }

    public void verifyFailNumCheck(String account, Map<String, String> checkResultMap) {
        for (VerifyCodeCheckCache verifyCodeCheckCache : verifyCodeCheckCacheList) {
            if (!StringUtils.equals((CharSequence)verifyCodeCheckCache.getAccount(), (CharSequence)account)) continue;
            Integer checkErrorNum = verifyCodeCheckCache.getCheckErrorNum();
            verifyCodeCheckCache.setCheckErrorNum(checkErrorNum + 1);
            if (verifyCodeCheckCache.getCheckErrorNum() >= VERIFY_ERROR_NUM) {
                verifyCodeCheckCache.setLock(true);
                verifyCodeCheckCache.setLockTime(DateUtil.getUtcDate(new Date()));
                LOGGER.error("The number of verification errors exceeds five,Your account has been locked,Please verify in 5 minutes!");
                checkResultMap.put("errorCode", ErrorCodeEnum.FIVE_MINUTE_TRY_AGAIN.getErrorCode());
                checkResultMap.put("errorMsg", this.internationalizeUtil.getMessage(ErrorCodeEnum.FIVE_MINUTE_TRY_AGAIN.getErrorCode()));
                return;
            }
            int remainNum = VERIFY_ERROR_NUM - verifyCodeCheckCache.getCheckErrorNum();
            LOGGER.error("The verification code you entered is incorrect,%s more attempts are left. The account will be locked!");
            checkResultMap.put("errorCode", ErrorCodeEnum.VERIFY_CODE_ERROR_AND_ACCOUNT_WILL_LOCKED.getErrorCode());
            checkResultMap.put("errorMsg", this.internationalizeUtil.getMessage(ErrorCodeEnum.VERIFY_CODE_ERROR_AND_ACCOUNT_WILL_LOCKED.getErrorCode(), Collections.singletonList(String.valueOf(remainNum))));
            return;
        }
        VerifyCodeCheckCache codeCheckCache = new VerifyCodeCheckCache();
        codeCheckCache.setAccount(account);
        codeCheckCache.setCheckErrorNum(1);
        verifyCodeCheckCacheList.add(codeCheckCache);
        LOGGER.error("The verification code you entered is incorrect,4 more attempts are left. The account will be locked!");
        checkResultMap.put("errorCode", ErrorCodeEnum.VERIFY_CODE_ERROR_AND_ACCOUNT_WILL_LOCKED.getErrorCode());
        checkResultMap.put("errorMsg", this.internationalizeUtil.getMessage(ErrorCodeEnum.VERIFY_CODE_ERROR_AND_ACCOUNT_WILL_LOCKED.getErrorCode(), Collections.singletonList("4")));
    }

    public String verifyPreCheck(String account) {
        String errMsg = "";
        Iterator<VerifyCodeCheckCache> iterator = verifyCodeCheckCacheList.iterator();
        while (iterator.hasNext()) {
            VerifyCodeCheckCache verifyCodeCheckCache = iterator.next();
            if (!StringUtils.equals((CharSequence)verifyCodeCheckCache.getAccount(), (CharSequence)account) || !verifyCodeCheckCache.isLock()) continue;
            Date lockTime = verifyCodeCheckCache.getLockTime();
            long unLockTime = lockTime.getTime() + 300000L;
            if (DateUtil.getUtcDate(new Date()).getTime() > unLockTime) {
                iterator.remove();
                return errMsg;
            }
            long milliSecondtime = unLockTime - DateUtil.getUtcDate(new Date()).getTime();
            LOGGER.error("Your account has been locked,Please verify in %s seconds!");
            return this.internationalizeUtil.getMessage(ErrorCodeEnum.ACCOUNT_LOCKED_VERIFY.getErrorCode(), Collections.singletonList(String.valueOf(milliSecondtime / 1000L)));
        }
        return errMsg;
    }

    public String generalVerifyCode(int len) {
        StringBuffer sb = new StringBuffer();
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstanceStrong();
            for (int i = 0; i < len; ++i) {
                int number = random.nextInt(10);
                sb.append(number);
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("generalVerifyCode failed, errMsg is {}", (Object)e.getMessage());
            throw new NetCareInsideSdkException("General SecureRandom error!");
        }
        return sb.toString();
    }

    public Map<String, String> checkVerifyCode(TaskInfoBo taskInfo, String inputVerifyCode, String verifyType, Integer codeNum) {
        HashMap<String, String> checkResultMap = new HashMap<String, String>();
        String errMsg = this.verifyPreCheck(taskInfo.getTaskExecutor());
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            checkResultMap.put("errorCode", ErrorCodeEnum.ACCOUNT_LOCKED_VERIFY.getErrorCode());
            checkResultMap.put("errorMsg", errMsg);
            return checkResultMap;
        }
        boolean isPass = false;
        List<VerifyCodeRecordBo> codeRecordBos = this.verifyCodeRecordDao.queryLastApplyByAccount(verifyType, taskInfo.getTaskId(), taskInfo.getTaskExecutor(), codeNum);
        for (VerifyCodeRecordBo verifyCodeRecord : codeRecordBos) {
            errMsg = this.checkActivePeriod(verifyCodeRecord);
            if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
                checkResultMap.put("errorCode", errMsg);
                checkResultMap.put("errorMsg", this.internationalizeUtil.getMessage(errMsg));
                return checkResultMap;
            }
            if (!StringUtils.equals((CharSequence)inputVerifyCode, (CharSequence)verifyCodeRecord.getVerifyCode())) continue;
            isPass = true;
            if (!Objects.nonNull(verifyCodeRecord.getVerifyCodeType())) break;
            checkResultMap.put("verifyCodeType", String.valueOf(verifyCodeRecord.getVerifyCodeType()));
            break;
        }
        if (isPass) {
            this.clearAccountCache(taskInfo.getTaskExecutor());
            this.updateVerifyCodeRecord(codeRecordBos);
        } else {
            this.verifyFailNumCheck(taskInfo.getTaskExecutor(), checkResultMap);
        }
        return checkResultMap;
    }

    private void updateVerifyCodeRecord(List<VerifyCodeRecordBo> codeRecordBos) {
        codeRecordBos.forEach(verifyCodeRecordBo -> {
            verifyCodeRecordBo.setVerifyStatus(0);
            verifyCodeRecordBo.setVerifyTime(DateUtil.getUtcDate(new Date()));
            this.verifyCodeRecordDao.updateRecord((VerifyCodeRecordBo)verifyCodeRecordBo);
        });
    }

    public String checkActivePeriod(VerifyCodeRecordBo verifyCodeRecord) {
        if (Objects.isNull(verifyCodeRecord) || StringUtils.isEmpty((CharSequence)verifyCodeRecord.getVerifyCode())) {
            LOGGER.error("No verification code is found,Apply for a verify code first!");
            return ErrorCodeEnum.VERIFY_CODE_NOT_FOUND.getErrorCode();
        }
        String period = StringUtils.isNotEmpty((CharSequence)verifyCodeRecord.getActivePeriod()) ? verifyCodeRecord.getActivePeriod() : "30";
        long activePeriod = Long.parseLong(period) * 60L * 1000L;
        long createTime = verifyCodeRecord.getCreateTime().getTime();
        if (DateUtil.getUtcDate(new Date()).getTime() > createTime + activePeriod) {
            LOGGER.error("The verification code has expired,Refresh the QR code and generate a new one!");
            return ErrorCodeEnum.VERIFY_CODE_EXPIRED.getErrorCode();
        }
        return "";
    }
}

