/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.StringUtils;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.LoggerFactory;

public final class Base64EncodeUtils {
    private Base64EncodeUtils() {
    }

    public static String encode(String pliant) {
        if (StringUtils.isNULLStr(pliant)) {
            return "";
        }
        return new String(Base64.encodeBase64((byte[])pliant.getBytes(Charset.defaultCharset())));
    }

    public static String encodeOfByteArray(byte[] pliant) {
        if (null == pliant || pliant.length == 0) {
            return "";
        }
        return new String(Base64.encodeBase64((byte[])pliant));
    }

    public static String decode(String code) {
        if (StringUtils.isNULLStr(code)) {
            return "";
        }
        byte[] ret = null;
        try {
            ret = Base64.decodeBase64((String)code);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Base64EncodeUtils.class).error("decode base64 error.", (Throwable)e);
            return "";
        }
        return new String(ret, Charset.defaultCharset());
    }

    public static byte[] decodeOfByteArray(String code) {
        if (StringUtils.isNULLStr(code)) {
            return new byte[0];
        }
        byte[] ret = null;
        try {
            ret = Base64.decodeBase64((String)code);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Base64EncodeUtils.class).error("decode base64 error.");
            return new byte[0];
        }
        return ret;
    }
}

