/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class CIUtils {
    public static void mangerJar(String boxDirectory, String toolDirectory, String toolPath, String iniLabel, String whitelistByAll, String whitelistByOne) {
        File[] boxJarList = new File(boxDirectory).listFiles();
        File[] toolJarList = new File(toolDirectory).listFiles();
        StringBuffer jarNamelist = new StringBuffer();
        if (null == boxJarList || boxJarList.length == 0 || null == toolJarList || toolJarList.length == 0) {
            return;
        }
        for (File boxJar : boxJarList) {
            for (File toolJar : toolJarList) {
                if (whitelistByAll == null || whitelistByAll.indexOf(toolJar.getName()) != -1 || whitelistByOne == null || whitelistByOne.indexOf(toolJar.getName()) != -1 || !boxJar.getName().equals(toolJar.getName())) continue;
                if (jarNamelist.length() > 0) {
                    jarNamelist.append(",");
                }
                jarNamelist.append(toolJar.getName());
                if (toolJar.delete()) continue;
                ToolLoggerFactory.getLogger(CIUtils.class).error("File delete error ,path is {}", (Object)toolJar);
            }
        }
        File ini = new File(toolPath + File.separator + "tool.ini");
        CIUtils.writToolini(ini, jarNamelist.toString(), iniLabel);
    }

    public static void mangerJarExpansion(String boxPath, String toolJarPath, String jarNameList, String toolIniPath, String iniLabel) {
        String[] jarList = jarNameList.split(",");
        ArrayList<String> exeistsJarList = new ArrayList<String>();
        for (String jarName : jarList) {
            File jar = new File(toolJarPath + File.separator + jarName);
            File targetFile = new File(boxPath + File.separator + jarName);
            if (!jar.exists()) continue;
            exeistsJarList.add(jarName);
            StreamUtils.copyFile(jar, targetFile);
            jar.delete();
        }
        if (exeistsJarList.isEmpty()) {
            return;
        }
        int handFlag = 0;
        StringBuffer newJarNameList = new StringBuffer();
        for (String jarName : exeistsJarList) {
            if (handFlag != 0) {
                newJarNameList.append(",");
            }
            ++handFlag;
            newJarNameList.append(jarName);
        }
        File ini = new File(toolIniPath);
        CIUtils.writToolini(ini, newJarNameList.toString(), iniLabel);
    }

    public static void mangerJarBySameName(String workPath, String toolPath, String folderName, String whitelistByAll, String whitelistByOne) {
        String boxDirectory = workPath + File.separator + folderName;
        String toolDirectory = toolPath + File.separator + folderName;
        CIUtils.mangerJar(boxDirectory, toolDirectory, toolPath, folderName, whitelistByAll, whitelistByOne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writToolini(File ini, String jarNamelist, String iniLabel) {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(ini, "rw");
            boolean exist = true;
            String head = "tool." + iniLabel + "=";
            String newStr = head + jarNamelist;
            String line = null;
            long lastPoint = 0L;
            while ((line = raf.readLine()) != null) {
                long ponit = raf.getFilePointer();
                if (line.contains(head)) {
                    exist = false;
                    String str = line.replace(line, newStr);
                    raf.seek(lastPoint);
                    raf.writeBytes(str);
                }
                lastPoint = ponit;
            }
            if (exist) {
                raf.seek(raf.length());
                raf.write(("\r\n" + newStr).getBytes());
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(CIUtils.class).error("writ tool.ini close failed", (Throwable)e);
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(CIUtils.class).error("raf close failed", (Throwable)e);
            }
        }
    }

    public static void mangerJar(String workPath, String toolPath, String folderName, String whitelistByAll) {
        CIUtils.mangerJarBySameName(workPath, toolPath, folderName, whitelistByAll, "");
    }

    public static void mangerJarByTools(String workPath, String tools, String toolNameList, String folderName, String whitelistByAll) {
        String[] toolNames;
        for (String toolname : toolNames = toolNameList.split(";")) {
            if (StringUtils.isNULLStr(toolname)) continue;
            String toolPath = tools + File.separator + toolname;
            CIUtils.mangerJar(workPath, toolPath, folderName, whitelistByAll);
        }
    }
}

