/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;

public class IniReader {
    private String iniOriginalInfo = "";
    private Map<String, String> iniCache = new HashMap<String, String>();

    public IniReader(File filePath) {
        this(StreamUtils.readStringFormFile(filePath));
    }

    public IniReader(File filePath, String charset) {
        this(StreamUtils.readStringFormFile(filePath, charset));
    }

    public IniReader(InputStream is) {
        this(StreamUtils.readStringFormInputStream(is));
    }

    public IniReader(String iniInfo) {
        this.iniOriginalInfo = iniInfo;
        this.analyzeInfo();
    }

    private void analyzeInfo() {
        String[] lines;
        for (String line : lines = this.iniOriginalInfo.split("\n")) {
            if (";".startsWith(line = line.trim()) || !(line = Normalizer.normalize(line, Normalizer.Form.NFKC)).contains("=")) continue;
            int idx = line.indexOf(61);
            this.iniCache.put(line.substring(0, idx).trim(), line.substring(idx + 1, line.length()).trim());
        }
    }

    public String getString(String key) {
        String val = this.iniCache.get(key);
        if (StringUtils.isNULLStr(val)) {
            return "";
        }
        return val;
    }

    public boolean getBoolean(String key) {
        String val = this.iniCache.get(key);
        return Boolean.valueOf(val);
    }

    public int getInt(String key) {
        String val = this.iniCache.get(key);
        return StringUtils.str2Int(val);
    }
}

