/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.context.IPropertiesManager;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.platform.util.PropertiesManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResourceUtil {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ResourceUtil.class);
    private static final String DEFAULT_RESOURCE_DIR = "config";
    private static final String DEFAULT_LANGUAGE_DIR = "languages";
    private static final String DEFAULT_IMAGE_DIR = "images";
    private static final String DEFAULT_PROPERTIES_NAME = "common";
    private static final String UNMATCHED_IMG = "config/base/images/none.png";
    private static final LanguageManager LANMAN = LanguageManager.getInstance();
    private static Map<String, IPropertiesManager> propMap = new HashMap<String, IPropertiesManager>();
    private static final String OEM_PROPERTIES_ZH = "logo/res/common_zh.properties";
    private static final String OEM_PROPERTIES_EN = "logo/res/common_en.properties";
    private static final String OEM_RES_KEYS = "logo/res/reslist.xml";
    private static final String OEM_PICPATH = "logo/img/";
    private static List<String> oemKeys = new ArrayList<String>();
    private static List<String> customizedSceneKeys = new ArrayList<String>();
    private static boolean oemSupported = false;
    private static Properties oemPropertiesZh = new Properties();
    private static Properties oemPropertiesEn = new Properties();
    private static boolean isCustomizedScene = false;
    private static Properties customizedPropertiesZh = new Properties();
    private static Properties customizedPropertiesEn = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadOemResKeys() {
        File sysResListFile = new File(ApplicationContext.getInstance().getConfigurationPath(), OEM_RES_KEYS);
        Document doc = null;
        FileInputStream filedInput = null;
        try {
            filedInput = new FileInputStream(sysResListFile);
            doc = XmlUtils.parseDocument(filedInput);
            Collection<Element> keys = XmlUtils.searchByExp2Ele(doc.getDocumentElement(), "/reslist/reskey");
            for (Element key : keys) {
                oemKeys.add(key.getTextContent());
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found:{}", (Object)sysResListFile.getName());
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("read reslist error.");
        }
        catch (Exception e1) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("read reslist error.");
        }
        finally {
            StreamUtils.closeStream(null, filedInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadOemProperties(String fileName) {
        File file = new File(ApplicationContext.getInstance().getConfigurationPath(), fileName);
        FileInputStream fileInputStream = null;
        Properties properties = new Properties();
        try {
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found:{}", (Object)file.getName());
        }
        catch (Exception ex) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("Can not find resource:" + file + ";" + ex);
        }
        finally {
            StreamUtils.closeStream(null, fileInputStream);
        }
        return properties;
    }

    public static String getString(String key) {
        return ResourceUtil.getString(key, LANMAN.getCurrentLanguage());
    }

    public static String getString(String key, Locale locale) {
        if (oemSupported && ResourceUtil.isOemKey(key)) {
            return ResourceUtil.getCustomedString(key, locale);
        }
        if (isCustomizedScene && customizedSceneKeys.contains(key)) {
            return ResourceUtil.getCustomedString(key, locale);
        }
        IPropertiesManager propManager = ResourceUtil.getPropertiesManager();
        return propManager.getString(locale, key);
    }

    public static boolean isOemKey(String key) {
        return oemKeys.contains(key);
    }

    private static String getCustomedString(String key, Locale locale) {
        Properties properties;
        if (ApplicationContext.getInstance().isJunit()) {
            return "Next";
        }
        if (oemSupported) {
            properties = "en".equalsIgnoreCase(locale.getLanguage()) ? oemPropertiesEn : oemPropertiesZh;
        } else {
            Properties properties2 = properties = "en".equalsIgnoreCase(locale.getLanguage()) ? customizedPropertiesEn : customizedPropertiesZh;
        }
        if (null == properties || properties.isEmpty()) {
            return "--";
        }
        String val = (String)properties.get(key);
        if (StringUtils.isNULLStr(val)) {
            return "--";
        }
        return val;
    }

    public static String getStringWithParams(String key, Object ... params) {
        return ResourceUtil.getStringWithParams(key, LANMAN.getCurrentLanguage(), params);
    }

    public static String getStringWithParams(String key, Locale locale, Object ... params) {
        if (isCustomizedScene && customizedSceneKeys.contains(key)) {
            String value = ResourceUtil.getCustomedString(key, locale);
            value = StringUtils.fillValues(value, params);
            return value;
        }
        IPropertiesManager propManager = ResourceUtil.getPropertiesManager();
        return propManager.getStringWithParams(locale, key, params);
    }

    public static String getString(ResourceBundle bundle, String key) {
        return bundle.getString(key);
    }

    public static URL getImageUrl(String key) {
        return ResourceUtil.getImageUrl(key, null);
    }

    public static URL getImageUrl(String key, Locale loc) {
        Class<ResourceUtil> invokerCls = ResourceUtil.class;
        String ctxPkg = ContextUtil.getContextPackageName(invokerCls);
        ClassLoader cl = ContextUtil.getContextClassLoader(invokerCls);
        if (null == cl) {
            return null;
        }
        URL imgURL = cl.getResource(ResourceUtil.getImageDir(ctxPkg, loc) + "/" + key);
        if (null == imgURL) {
            imgURL = cl.getResource(UNMATCHED_IMG);
        }
        return imgURL;
    }

    public static ImageIcon getImage(String key) {
        if (oemSupported && ResourceUtil.isOemKey(key)) {
            return ResourceUtil.getOemImageIcon(key);
        }
        return new ImageIcon(ResourceUtil.getImageUrl(key));
    }

    public static ImageIcon getOemImageIcon(String key) {
        if (ApplicationContext.getInstance().isJunit()) {
            return new ImageIcon(new byte[]{0, 1});
        }
        File sysFile = new File(ApplicationContext.getInstance().getConfigurationPath(), OEM_PICPATH);
        return new ImageIcon(sysFile.getPath() + File.separator + key);
    }

    public static ImageIcon getImage(String key, Locale locale) {
        URL url = ResourceUtil.getImageUrl(key, locale);
        if (null == url) {
            throw new NullPointerException();
        }
        return new ImageIcon(url);
    }

    public static String getImageDir(Locale loc) {
        Class<ResourceUtil> invokerCls = ResourceUtil.class;
        String ctxPkg = ContextUtil.getContextPackageName(invokerCls);
        return ResourceUtil.getImageDir(ctxPkg, loc);
    }

    public static URL getOEMImageUrl(String oemImgKey) {
        String vender = ApplicationContext.getInstance().getVender().toLowerCase(Locale.ENGLISH);
        return ResourceUtil.getImageUrl(vender + "/" + oemImgKey);
    }

    public static ImageIcon getOEMImage(String oemImgKey) {
        return new ImageIcon(ResourceUtil.getOEMImageUrl(oemImgKey));
    }

    public static String getOEMString(String oemStrKey) {
        String vender = ApplicationContext.getInstance().getVender().toLowerCase(Locale.ENGLISH);
        String key = oemStrKey + "." + vender;
        return ApplicationContext.getInstance().getAppConfig(key);
    }

    public static InputStream getStreamFromJar(String res) {
        ClassLoader cl = ContextUtil.getContextClassLoader(ResourceUtil.class);
        return null == cl ? null : cl.getResourceAsStream(res);
    }

    public static boolean containsString(Locale loc, String str) {
        IPropertiesManager propManager = ResourceUtil.getPropertiesManager();
        return propManager.containsString(loc, str);
    }

    public static Locale checkLocale(String key, String str) {
        IPropertiesManager propManager = ResourceUtil.getPropertiesManager();
        return propManager.checkLocale(key, str);
    }

    public static String getExceptionDesc(ToolException ex) {
        return ResourceUtil.getString(ex.getErrorId());
    }

    private static IPropertiesManager getPropertiesManager() {
        Class<ResourceUtil> invokerCls = ResourceUtil.class;
        String ctxPkg = ContextUtil.getContextPackageName(invokerCls);
        IPropertiesManager properties = propMap.get(ctxPkg);
        if (null == properties) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).info("Load properties for " + ctxPkg);
            ClassLoader cl = ContextUtil.getContextClassLoader(invokerCls);
            String propCfg = ResourceUtil.getPropertiesCfg(ctxPkg);
            Locale[] lans = ApplicationContext.getInstance().getSupportedLans();
            if (null == lans) {
                throw new NullPointerException();
            }
            properties = new PropertiesManager(propCfg, lans, cl);
            propMap.put(ctxPkg, properties);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPropOfFile(String fileName, String key) {
        File file = new File(fileName);
        FileInputStream in = null;
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        try {
            in = new FileInputStream(file);
            Properties prop = new Properties();
            prop.load(in);
            String string = prop.getProperty(key);
            return string;
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("read properties error ", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found:{}", (Object)file.getName());
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("read properties error ", (Throwable)e);
        }
        finally {
            StreamUtils.closeResource(null, in);
        }
        return null;
    }

    private static String getPropertiesCfg(String id) {
        return "config." + id + "." + DEFAULT_LANGUAGE_DIR + "." + DEFAULT_PROPERTIES_NAME;
    }

    public static String getImageDir(String id, Locale locale) {
        String dir = "config/" + id + "/" + DEFAULT_IMAGE_DIR;
        if (null != locale) {
            dir = dir + "-" + locale.toString();
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getValByProper(File properties, String key) {
        String string;
        block10: {
            Properties pro;
            FileInputStream in;
            block8: {
                String string2;
                block9: {
                    in = null;
                    pro = new Properties();
                    if (!StringUtils.isNULLStr(key)) break block8;
                    string2 = null;
                    if (in == null) break block9;
                    StreamUtils.closeStream(null, in);
                }
                return string2;
            }
            try {
                in = new FileInputStream(properties);
                pro.load(in);
                string = pro.getProperty(key);
                if (in == null) break block10;
            }
            catch (FileNotFoundException e) {
                String string3;
                block11: {
                    LOGGER.error("file not found:{}", (Object)properties.getName());
                    string3 = null;
                    if (in == null) break block11;
                    StreamUtils.closeStream(null, in);
                }
                return string3;
            }
            catch (Exception e2) {
                String string4;
                block12: {
                    ToolLoggerFactory.getLogger(ResourceUtil.class).error("", (Throwable)e2);
                    string4 = null;
                    if (in == null) break block12;
                    {
                        catch (Throwable throwable) {
                            if (in != null) {
                                StreamUtils.closeStream(null, in);
                            }
                            throw throwable;
                        }
                    }
                    StreamUtils.closeStream(null, in);
                }
                return string4;
            }
            StreamUtils.closeStream(null, in);
        }
        return string;
    }

    public static void initCustomizedResource(String keysPath, String propertiesZhPath, String propertiesEnPath) {
        isCustomizedScene = true;
        customizedPropertiesZh = ResourceUtil.loadProperties(propertiesZhPath);
        customizedPropertiesEn = ResourceUtil.loadProperties(propertiesEnPath);
        ResourceUtil.loadCustomizedKeys(customizedSceneKeys, keysPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadCustomizedKeys(List<String> customizedKeys, String keyPath) {
        File sysResListFile = new File(ApplicationContext.getInstance().getConfigurationPath(), keyPath);
        FileInputStream filedInput = null;
        try {
            filedInput = new FileInputStream(sysResListFile.getCanonicalFile());
            Document doc = XmlUtils.parseDocument(filedInput);
            Collection<Element> keys = XmlUtils.searchByExp2Ele(doc.getDocumentElement(), "/reslist/reskey");
            for (Element key : keys) {
                customizedKeys.add(key.getTextContent());
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found:{}", (Object)sysResListFile.getName());
            StreamUtils.closeStream(null, filedInput);
        }
        catch (IOException e1) {
            LOGGER.error("read reslist error.");
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, filedInput);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, filedInput);
        }
        StreamUtils.closeStream(null, filedInput);
    }

    private static Properties loadProperties(String fileName) {
        File file = new File(ApplicationContext.getInstance().getConfigurationPath(), fileName);
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(file.getCanonicalFile());){
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found:{}", (Object)file.getName());
        }
        catch (IOException ex) {
            LOGGER.error("Can not find resource:" + file);
        }
        return properties;
    }

    static {
        oemSupported = "true".equalsIgnoreCase(ApplicationContext.getInstance().getAppConfig("app.oem.mode.enabled"));
        ResourceUtil.loadOemResKeys();
        oemPropertiesZh = ResourceUtil.loadOemProperties(OEM_PROPERTIES_ZH);
        oemPropertiesEn = ResourceUtil.loadOemProperties(OEM_PROPERTIES_EN);
    }
}

