/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils.executor;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class CmdExecutor {
    private static final int WAIT_STREAM_TIMEOUT = 100;
    private static final int DEFAULT_CMD_TIMEOUT = 30;
    private static final int MAX_NUMBER = 50;

    public static void main(final String[] args) {
        Thread hook = new Thread(){

            @Override
            public void run() {
                CmdExecutor.executeCmd("CMD /C " + args[0].replaceAll(" ", "\" \""), 30);
            }
        };
        hook.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ToolLoggerFactory.getLogger(CmdExecutor.class).error("Uncaught sub thread error: " + e.getMessage(), e);
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String executeCmd(String cmd, int timeoutSecond) {
        String result;
        block17: {
            ExecutorService es;
            InputStream inputStream;
            block16: {
                inputStream = null;
                result = "";
                Process pro = null;
                es = null;
                pro = Runtime.getRuntime().exec(cmd);
                inputStream = pro.getInputStream();
                ProcessStreamClearCall streamClear = new ProcessStreamClearCall(inputStream);
                es = Executors.newFixedThreadPool(3);
                Future<String> future = es.submit(streamClear);
                result = future.get(timeoutSecond, TimeUnit.SECONDS);
                if (null == inputStream) break block16;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    ToolLoggerFactory.getLogger(CmdExecutor.class).error("error!", (Throwable)e);
                }
            }
            CmdExecutor.shutdownExecutorService(es);
            break block17;
            catch (RuntimeException e1) {
                ToolLoggerFactory.getLogger(CmdExecutor.class).error("error!", (Throwable)e1);
                break block17;
            }
            catch (Exception e12) {
                ToolLoggerFactory.getLogger(CmdExecutor.class).error("error!", (Throwable)e12);
                break block17;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        ToolLoggerFactory.getLogger(CmdExecutor.class).error("error!", (Throwable)e);
                    }
                }
                CmdExecutor.shutdownExecutorService(es);
            }
        }
        return result;
    }

    private static void shutdownExecutorService(ExecutorService es) {
        if (null != es) {
            try {
                es.shutdown();
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(CmdExecutor.class).error("ExecutorService shutdow failed.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String executeLineCmd(String lineCmd, String[] envs, int timeoutSecond) {
        InputStream inputStream = null;
        String result = "";
        ExecutorService es = null;
        Process pro = null;
        try {
            pro = Runtime.getRuntime().exec(CmdExecutor.quote(lineCmd), envs);
            inputStream = pro.getInputStream();
            ProcessStreamClearCall streamClear = new ProcessStreamClearCall(inputStream);
            es = Executors.newFixedThreadPool(3);
            Future<String> future = es.submit(streamClear);
            result = future.get(timeoutSecond, TimeUnit.SECONDS);
        }
        catch (RuntimeException e1) {
            ToolLoggerFactory.getLogger(CmdExecutor.class).error("error!", (Throwable)e1);
            StreamUtils.closeStream(null, inputStream);
            CmdExecutor.shutdownExecutorService(es);
        }
        catch (Exception e12) {
            ToolLoggerFactory.getLogger(CmdExecutor.class).error("error!", (Throwable)e12);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, inputStream);
                    CmdExecutor.shutdownExecutorService(es);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, inputStream);
            CmdExecutor.shutdownExecutorService(es);
        }
        StreamUtils.closeStream(null, inputStream);
        CmdExecutor.shutdownExecutorService(es);
        return result;
    }

    private static String quote(String str) {
        return "\"" + str + "\"";
    }

    private CmdExecutor() {
    }

    private static class ProcessStreamClearCall
    implements Callable<String> {
        InputStream ins;
        StringBuffer buff = new StringBuffer();

        public ProcessStreamClearCall(InputStream ins) {
            this.ins = ins;
        }

        @Override
        public String call() {
            try {
                int i = 0;
                boolean flag = false;
                while (true) {
                    Thread.sleep(100L);
                    int len = this.ins.available();
                    if (len <= 0) {
                        if (++i <= 50 || !flag) continue;
                        break;
                    }
                    i = 0;
                    flag = true;
                    byte[] bs = new byte[len];
                    int bSize = this.ins.read(bs);
                    this.buff.append(new String(bs, 0, bSize, Charset.defaultCharset()));
                }
            }
            catch (RuntimeException e) {
                ToolLoggerFactory.getLogger(CmdExecutor.class).error("error!", (Throwable)e);
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(CmdExecutor.class).error("error!", (Throwable)e);
            }
            return this.buff.toString();
        }
    }
}

