/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils.reflection;

import com.huawei.ism.tool.base.utils.StringUtils;

public interface PrimitiveParser {
    public Object parseValue(String var1);

    public static class DoubleParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String str) {
            return StringUtils.isNULLStr(str) ? 0.0 : Double.parseDouble(str);
        }
    }

    public static class FloatParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String str) {
            return Float.valueOf(StringUtils.isNULLStr(str) ? 0.0f : Float.parseFloat(str));
        }
    }

    public static class LongParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String str) {
            return StringUtils.isNULLStr(str) ? 0L : Long.parseLong(str);
        }
    }

    public static class IntegerParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String str) {
            return StringUtils.isNULLStr(str) ? 0 : Integer.parseInt(str);
        }
    }

    public static class ShortParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String str) {
            return StringUtils.isNULLStr(str) ? (short)0 : Short.parseShort(str);
        }
    }

    public static class CharParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String str) {
            return Character.valueOf(StringUtils.isNULLStr(str) ? (char)'\u0000' : str.charAt(0));
        }
    }

    public static class ByteParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String str) {
            return StringUtils.isNULLStr(str) ? (byte)0 : Byte.parseByte(str);
        }
    }

    public static class BooleanParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String str) {
            return StringUtils.isNULLStr(str) ? false : Boolean.parseBoolean(str);
        }
    }
}

