/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.register;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.common.data.DataType;
import com.huawei.ism.tool.framework.platform.common.tool.AbstractTool;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractFeature;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractFunction;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractSetting;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractToolBox;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.plugin.AbstractPlugin;
import com.huawei.ism.tool.framework.platform.pubservice.IServiceCenter;
import com.huawei.ism.tool.framework.platform.pubservice.ServiceCenterRegisterUtil;
import com.huawei.ism.tool.framework.platform.runtime.AbstractRuntime;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;

public final class RegisterUtil {
    private static final String DEFAULT_PLUGIN_CONFIG = "pluginsCfg.properties";
    private static final String PUBLIC_SERVICE_MNG_IMPL = "com.huawei.ism.tool.framework.pubservice.PublicServiceManage";
    private static final String PUBLIC_UI_MNG_IMPL = "com.huawei.ism.tool.framework.pubui.PublicUiManage";
    private static final String PUBLIC_SERVICE_PLUGINS = "public.service.plugins";
    private static final String PUBLIC_UI_PLUGINS = "public.ui.plugins";
    private static final String PUBLIC_UI_PLUGINS_BEFORE = "public.ui.plugins.before";
    private static final String PLUGINS = "plugins";
    private static final PlatformAppContext CONTEXT = PlatformAppContext.getInstance();
    private static final AbstractRuntime RUNTIME = CONTEXT.getRuntime();
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(RegisterUtil.class);

    public static void registerToolBox(AbstractToolBox toolBox) {
        String boxId = toolBox.getId();
        if (null != CONTEXT.getToolBox()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Register Toolbox[" + boxId + "] failed because already exists.");
            }
            return;
        }
        if (!toolBox.doInit(RUNTIME)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Failed to initialize toolbox[" + boxId + "].");
            }
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Toolbox[" + boxId + "] init success.");
        }
        CONTEXT.addToolBox(toolBox);
        for (AbstractFeature feature : CONTEXT.getFeatures()) {
            if (feature.hasParent()) continue;
            toolBox.addFeature(feature);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("Added Feature[" + feature.getId() + "] into toolbox[" + boxId + "]");
        }
        for (AbstractTool tool : CONTEXT.getTools()) {
            toolBox.addTool(tool);
            tool.afterAddIntoBox(toolBox);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("Added tool[" + tool.getId() + "] into toolbox[" + boxId + "]");
        }
        toolBox.registerSuccess(toolBox.getId());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished to register toolbox[" + boxId + "].");
        }
    }

    public static void addFeature(AbstractFeature feature) {
        String parentId;
        AbstractFeature parentfeature;
        String ftId = feature.getId();
        if (!feature.doInit(RUNTIME)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Failed to initialize feature[" + ftId + "].");
            }
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Feature[" + ftId + "] init success.");
        }
        CONTEXT.addFeature(feature);
        AbstractToolBox toolBox = CONTEXT.getToolBox();
        if (null != toolBox && !feature.hasParent()) {
            toolBox.addFeature(feature);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Feature[" + ftId + "] has been added into toolbox[" + toolBox.getName() + "]");
            }
        }
        if (feature.hasParent() && null != (parentfeature = CONTEXT.getFeature(parentId = feature.getParentId()))) {
            parentfeature.addSubFeature(feature);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Feature[" + ftId + "] has been added into parent feature[" + parentId + "]");
            }
        }
        for (AbstractFeature existsFeature : CONTEXT.getFeatures()) {
            if (!ftId.equals(existsFeature.getParentId())) continue;
            feature.addSubFeature(existsFeature);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("Feature[" + existsFeature.getId() + "] has been added into parent feature[" + ftId + "]");
        }
        for (AbstractFunction func : CONTEXT.getFunctions(ftId)) {
            feature.addFunction(func);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("Added function[" + func.getId() + "] into feature[" + ftId + "].");
        }
        feature.registerSuccess(feature.getId());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished to register feature[" + ftId + "].");
        }
    }

    public static void addTool(AbstractTool tool) {
        String toolId = tool.getId();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Register tool[" + toolId + "] ...");
        }
        if (CONTEXT.getTools().contains(tool)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("tttttttt:Register tool[" + toolId + "] aborted because already exists.");
            }
            return;
        }
        IServiceCenter serviceCenter = CONTEXT.getServiceCenter();
        IServiceCenter uiCenter = CONTEXT.getUiCenter();
        if (!RegisterUtil.checkDependences(serviceCenter, tool, tool.getDependingServices()) || !RegisterUtil.checkDependences(uiCenter, tool, tool.getDependingUIs())) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Register tool[" + toolId + "] aborted because lack of required service interfaces.");
            }
            return;
        }
        if (!tool.doInit(RUNTIME)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Failed to initialize tool[" + toolId + "].");
            }
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Tool[" + toolId + "] init success.");
        }
        CONTEXT.addTool(tool);
        AbstractToolBox toolBox = CONTEXT.getToolBox();
        if (null != toolBox) {
            toolBox.addTool(tool);
            tool.afterAddIntoBox(toolBox);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Tool[" + toolId + "] has been added into toolbox[" + toolBox.getName() + "]");
            }
        }
        tool.registerSuccess(toolId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished to register tool[" + toolId + "].");
        }
    }

    public static void addFunction(AbstractFunction function) {
        AbstractSetting setting;
        String funId = function.getId();
        String ftId = function.getFeatureId();
        if (CONTEXT.getFunctions(ftId).contains(function)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("ffffffff Register function[" + funId + "] aborted because already exists.");
            }
            return;
        }
        if (!function.doInit(RUNTIME)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Failed to initialize function[" + funId + "].");
            }
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Function[" + funId + "] init success.");
        }
        CONTEXT.addFunction(function);
        AbstractFeature feature = CONTEXT.getFeature(ftId);
        if (null != feature) {
            feature.addFunction(function);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Function[" + funId + "] has been added into feature[" + ftId + "]");
            }
        }
        if (null != (setting = CONTEXT.getSetting())) {
            setting.addFunction(function);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Function[" + funId + "] has been added into feature[" + ftId + "]");
            }
        }
        function.registerSuccess(funId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished to register function[" + funId + "].");
        }
    }

    public static void addSetting(AbstractSetting abstractSetting) {
        String funId = abstractSetting.getId();
        if (!abstractSetting.doInit(RUNTIME)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Failed to initialize function[" + funId + "].");
            }
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Function[" + funId + "] init success.");
        }
        CONTEXT.setSetting(abstractSetting);
        abstractSetting.registerSuccess(funId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished to register function[" + funId + "].");
        }
    }

    public static void removeTool(AbstractTool tool) {
        AbstractToolBox toolBox = CONTEXT.getToolBox();
        if (null != toolBox) {
            toolBox.removeTool(tool.getId());
        }
    }

    /*
     * Exception decompiling
     */
    public static void registerPluginsFromCfg() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static void registerUIFromCfg() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public static void registerServicesFromCfg() {
        block7: {
            Properties cfg = new Properties();
            FileInputStream in = null;
            try {
                String cfgPath = CONTEXT.getRuntime().getPath(DataType.applicationCfg) + DEFAULT_PLUGIN_CONFIG;
                in = new FileInputStream(cfgPath);
                cfg.load(in);
                RegisterUtil.registerServciesFromCfg(cfg);
                StreamUtils.closeStream(null, in);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Plugin config {} not found.", (Object)DEFAULT_PLUGIN_CONFIG);
            }
            catch (IOException e2) {
                LOGGER.error("Read plugin config errer.", (Throwable)e2);
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                StreamUtils.closeStream(null, in);
            }
        }
    }

    public static void registerUIFromCfg(Properties cfg) {
        if (null == cfg) {
            return;
        }
        IServiceCenter uiCenter = RegisterUtil.getServiceCenter(PUBLIC_UI_MNG_IMPL);
        if (null != uiCenter) {
            ServiceCenterRegisterUtil.registerUICenter(uiCenter);
            RegisterUtil.registerServicePlugins(cfg, uiCenter, PUBLIC_UI_PLUGINS_BEFORE);
        }
    }

    public static void registerPluginsFromCfg(Properties cfg) {
        if (null == cfg) {
            return;
        }
        IServiceCenter uiCenter = RegisterUtil.getServiceCenter(PUBLIC_UI_MNG_IMPL);
        if (null != uiCenter) {
            ServiceCenterRegisterUtil.registerUICenter(uiCenter);
            RegisterUtil.registerServicePlugins(cfg, uiCenter, PUBLIC_UI_PLUGINS);
        }
        for (AbstractPlugin plugin : RegisterUtil.getPlugins(cfg, PLUGINS)) {
            if (plugin instanceof AbstractTool) {
                RegisterUtil.addTool((AbstractTool)plugin);
                continue;
            }
            if (plugin instanceof AbstractToolBox) {
                RegisterUtil.registerToolBox((AbstractToolBox)plugin);
                continue;
            }
            if (plugin instanceof AbstractFeature) {
                RegisterUtil.addFeature((AbstractFeature)plugin);
                continue;
            }
            if (plugin instanceof AbstractFunction) {
                RegisterUtil.addFunction((AbstractFunction)plugin);
                continue;
            }
            if (!(plugin instanceof AbstractSetting)) continue;
            RegisterUtil.addSetting((AbstractSetting)plugin);
        }
    }

    public static void registerServciesFromCfg(Properties cfg) {
        if (null == cfg) {
            return;
        }
        IServiceCenter svcCenter = RegisterUtil.getServiceCenter(PUBLIC_SERVICE_MNG_IMPL);
        if (null != svcCenter) {
            ServiceCenterRegisterUtil.registerServiceCenter(svcCenter);
            RegisterUtil.registerServicePlugins(cfg, svcCenter, PUBLIC_SERVICE_PLUGINS);
        }
    }

    private static IServiceCenter getServiceCenter(String clsName) {
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkAccess(Thread.currentThread());
            }
            Class<?> clazz = Class.forName(clsName);
            Class<IServiceCenter> svcCenterClazz = clazz.asSubclass(IServiceCenter.class);
            Method methodGetInst = svcCenterClazz.getDeclaredMethod("getInstance", new Class[0]);
            return (IServiceCenter)methodGetInst.invoke(clazz, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("ClassNotFoundException:" + clsName, (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Initialize ServiceCenter Exception: getInstance() in " + clsName, (Throwable)e);
        }
        return null;
    }

    private static void registerServicePlugins(Properties cfg, IServiceCenter svcCenter, String pluginsKey) {
        for (AbstractPlugin plugin : RegisterUtil.getPlugins(cfg, pluginsKey)) {
            svcCenter.registerServicePlugin(plugin);
        }
    }

    private static List<AbstractPlugin> getPlugins(Properties cfg, String key) {
        ArrayList<AbstractPlugin> plugins = new ArrayList<AbstractPlugin>();
        String pluginsStr = cfg.getProperty(key);
        if (null != pluginsStr && !pluginsStr.isEmpty()) {
            String[] pluginsArr;
            for (String pluginClassName : pluginsArr = pluginsStr.split(",")) {
                AbstractPlugin plugin = RegisterUtil.getPlugin(pluginClassName);
                if (null == plugin) continue;
                plugins.add(plugin);
            }
        }
        return plugins;
    }

    private static AbstractPlugin getPlugin(String className) {
        try {
            Class<?> clazz = Class.forName(className.trim());
            Class<AbstractPlugin> pluginClazz = clazz.asSubclass(AbstractPlugin.class);
            return pluginClazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("ClassNotFoundException:" + StringUtils.getCleanMessage(className), (Throwable)e);
        }
        catch (InstantiationException e) {
            LOGGER.error("InstantiationException:" + StringUtils.getCleanMessage(className), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("IllegalAccessException:" + StringUtils.getCleanMessage(className), (Throwable)e);
        }
        return null;
    }

    private static boolean checkDependences(IServiceCenter cheker, AbstractTool tool, Collection<Class<?>> svcs) {
        if (null != svcs && !svcs.isEmpty()) {
            if (null == cheker) {
                return false;
            }
            Collection<Class<?>> unsup = cheker.trackServices(tool, svcs);
            if (!unsup.isEmpty()) {
                tool.fireServiceUnavailable(unsup);
                return false;
            }
        }
        return true;
    }
}

