/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.entity;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.ComputeStorageDevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DevNodeCommon;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.MultiRouteNode;
import com.huawei.ism.tool.framework.pubservice.entity.PriKeyInfo;
import com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy;
import com.huawei.ism.tool.framework.pubservice.entity.User;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class DevNode
extends DevNodeCommon {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DevNode.class);
    private User fusionCubeLoginUser = null;
    private User a3000LoginUser = null;
    private User clientUser;
    private List<String> selectedNodeIps = new ArrayList<String>();
    private User rootUser = null;
    private ComputeStorageDevNode computeStorageDevNode = null;
    private List<String> ipList = new ArrayList<String>();
    private Socks5Proxy socks5Proxy;
    private String productVersion = "";
    private String hotPatchVersion = "";
    private String deviceName = "";
    private String deviceSerialNumber = "";
    private String ip = "";
    private boolean ipListAreInnerIp = false;
    private String uuid = DevNode.getNoStripUUID();
    private int port = 22;
    private int tlvPort = 8080;
    private String sslVersion = "TLSv1.2";
    private DeviceType deviceType = null;
    private String oemModel = null;
    private String brand = null;
    private String vendor = null;
    private boolean miniSystem = false;
    private boolean isUpgrade = false;
    private List<String> remoteSNs = null;
    private boolean hyperMetroHost = false;
    private Map<String, String> relatedSNIPs = null;
    private List<Object> hostInfo = new ArrayList<Object>();
    private ConcurrentHashMap<String, HashMap<String, Object>> allStrgHyprMtrLns = new ConcurrentHashMap();
    private List<String> hostFCLauncherWwns = new ArrayList<String>();
    private List<String> hostISCSILauncherWwns = new ArrayList<String>();
    private List<String> hostIbLauncherWwns = new ArrayList<String>();
    private List<String> hostNvmeLauncherWwns = new ArrayList<String>();
    private ItDeviceType itDeviceType = ItDeviceType.Storage;
    private DeviceType devTypeLevel2 = null;
    private User loginUser = null;
    private List<MultiRouteNode> sshForwardList = new ArrayList<MultiRouteNode>();
    private String peerIp = "";
    private String developerPwd = "";
    private long createTime = System.currentTimeMillis();
    private String tlvSocketType = null;
    private PriKeyInfo priKey = null;
    public static final String SSL_SOCKET = "SSL";
    private String errorDecs = "";
    private String addConfirmInfo = "";
    private String devKey;
    private String dbName;
    private boolean useJdbc;
    private String scenarioInfo;
    private boolean isVerifyCertificate = false;
    private boolean isSudoGrab;
    private String deviceModel = null;
    private String migrType = null;

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public User getLoginUser() {
        return this.loginUser;
    }

    public void setLoginUser(User loginUser) {
        this.loginUser = loginUser;
    }

    public String getIp() {
        return this.ip;
    }

    public void setActiveIp(String ipAddr) {
        if (this.ipList.contains(ipAddr)) {
            this.ipList.remove(ipAddr);
            this.ipList.add(0, ipAddr);
        }
    }

    public void setIp(String ip1) {
        this.ip = ip1 != null ? ip1.trim() : null;
    }

    public boolean isDstorage() {
        return ItDeviceType.DStorage.equals((Object)this.getItDeviceType());
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public void setDeviceSerialNumber(String deviceSerialNumber) {
        this.deviceSerialNumber = deviceSerialNumber;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getHotPatchVersion() {
        return this.hotPatchVersion;
    }

    public void setHotPatchVersion(String hotPatchVersion) {
        this.hotPatchVersion = hotPatchVersion;
    }

    public List<MultiRouteNode> getSshForwardList() {
        return this.sshForwardList;
    }

    public void setSshForwardList(List<MultiRouteNode> sshForwardList) {
        this.sshForwardList = sshForwardList;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void addIp(String ips) {
        this.ipList.add(ips);
    }

    public List<String> getIpList() {
        ArrayList<String> ips = new ArrayList<String>(this.ipList);
        if (ips.isEmpty()) {
            ips.add(this.ip);
        }
        return ips;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DevNode) {
            DevNode devNode = (DevNode)obj;
            return devNode.getDeviceSerialNumber().equals(this.getDeviceSerialNumber()) && devNode.getDeviceType().equals(this.getDeviceType());
        }
        return false;
    }

    public int hashCode() {
        return 171 + 3 * this.getDeviceSerialNumber().hashCode() + 7 * this.getDeviceType().hashCode();
    }

    public String toString() {
        return "DevNode [deviceName=" + this.deviceName + ", storageDeviceType =" + (Object)((Object)this.getStorageDeviceType()) + ", deviceSerialNumber=" + this.deviceSerialNumber + ", deviceType=" + this.deviceType + ", ip=" + this.ip + ", loginUser=" + this.loginUser + ", port=" + this.port + ", productVersion=" + this.productVersion + ", socks5Proxy=" + this.socks5Proxy + ", sshForwardList=" + this.sshForwardList + ",uuid=" + this.uuid + ",peerIP=" + this.peerIp + "] compute storage dev node:" + this.computeStorageDevNode;
    }

    public boolean isNotSshForward() {
        return null == this.sshForwardList || this.sshForwardList.isEmpty();
    }

    public Socks5Proxy getSocks5Proxy() {
        return this.socks5Proxy;
    }

    public void setSocks5Proxy(Socks5Proxy socks5Proxy) {
        this.socks5Proxy = socks5Proxy;
    }

    private static String getNoStripUUID() {
        UUID uuid = UUID.randomUUID();
        String string = uuid.toString();
        return string.replaceAll("-", "");
    }

    public String getPeerIp() {
        return this.peerIp;
    }

    public void setPeerIp(String peerIp) {
        this.peerIp = peerIp;
    }

    public String getDeveloperPwd() {
        return AESEncrypt.decrypt(this.developerPwd);
    }

    public void setDeveloperPwd(String developerPwd) {
        this.developerPwd = AESEncrypt.encrypt(developerPwd);
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String getTlvSocketType() {
        return this.tlvSocketType;
    }

    public void setTlvSocketType(String tlvSocketType) {
        this.tlvSocketType = tlvSocketType;
    }

    public int getTlvPort() {
        return this.tlvPort;
    }

    public void setTlvPort(int tlvPort) {
        this.tlvPort = tlvPort;
    }

    public String getSslVersion() {
        return this.sslVersion;
    }

    public void setSslVersion(String sslVersion) {
        this.sslVersion = sslVersion;
    }

    public boolean isIpListAreInnerIp() {
        return this.ipListAreInnerIp;
    }

    public void setIpListAreInnerIp(boolean ipListAreInnerIp) {
        this.ipListAreInnerIp = ipListAreInnerIp;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.ipList = new ArrayList<String>();
        this.sshForwardList = new ArrayList<MultiRouteNode>();
    }

    public PriKeyInfo getPriKey() {
        return this.priKey;
    }

    public ItDeviceType getItDeviceType() {
        return this.itDeviceType;
    }

    public void setItDeviceType(ItDeviceType itDeviceType) {
        this.itDeviceType = itDeviceType;
    }

    public void setPriKey(PriKeyInfo priKey) {
        this.priKey = priKey;
    }

    public DeviceType getDevTypeLevel2() {
        return this.devTypeLevel2;
    }

    public void setDevTypeLevel2(DeviceType devTypeLevel2) {
        this.devTypeLevel2 = devTypeLevel2;
    }

    public String getErrorDecs() {
        return this.errorDecs;
    }

    public void setErrorDecs(String errorDecs) {
        this.errorDecs = errorDecs;
    }

    public boolean isMiniSystem() {
        return this.miniSystem;
    }

    public void setMiniSystem(boolean miniSystem) {
        this.miniSystem = miniSystem;
    }

    public boolean isUpgrade() {
        return this.isUpgrade;
    }

    public void setUpgrade(boolean upgrade) {
        this.isUpgrade = upgrade;
    }

    public String getOemModel() {
        return this.oemModel;
    }

    public void setOemModel(String oemModel) {
        this.oemModel = oemModel;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setDevKey(String devKey) {
        this.devKey = devKey;
    }

    public String getDevKey() {
        if (StringUtils.isNULLStr(this.devKey)) {
            this.devKey = this.getAddressKey();
        }
        return this.devKey;
    }

    private String getAddressKey() {
        StringBuilder snSb = new StringBuilder(this.ip);
        if (this.sshForwardList != null) {
            for (MultiRouteNode node : this.sshForwardList) {
                snSb.append(node.getHost());
            }
        }
        if (null != this.socks5Proxy) {
            snSb.append(this.socks5Proxy.getServerIp());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(" use value:" + StringUtils.getCleanMessage(snSb.toString()));
        }
        return snSb.toString();
    }

    public String getRealPeerIp() {
        String pIp = this.peerIp;
        if (null == this.peerIp || "".equals(this.peerIp)) {
            String secondaryIP = "";
            for (String ips : this.getIpList()) {
                if (!(ips = Normalizer.normalize(ips, Normalizer.Form.NFKC)).endsWith("101")) continue;
                secondaryIP = ips;
            }
            pIp = secondaryIP;
        }
        return pIp;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public String getMigrType() {
        return this.migrType;
    }

    public void setMigrType(String migrType) {
        this.migrType = migrType;
    }

    public boolean isSudoGrab() {
        return this.isSudoGrab;
    }

    public void setSudoGrab(boolean sudoGrab) {
        this.isSudoGrab = sudoGrab;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public boolean isUseJdbc() {
        return this.useJdbc;
    }

    public void setUseJdbc(boolean useJdbc) {
        this.useJdbc = useJdbc;
    }

    public List<String> getRemoteSNs() {
        return this.remoteSNs;
    }

    public void setRemoteSNs(List<String> remoteSNs) {
        this.remoteSNs = remoteSNs;
    }

    public Map<String, String> getRelatedSNIPs() {
        return this.relatedSNIPs;
    }

    public void setRelatedSNIPs(Map<String, String> relatedSNIPs) {
        this.relatedSNIPs = relatedSNIPs;
    }

    public boolean isHyperMetro() {
        return null != this.remoteSNs && !this.remoteSNs.isEmpty();
    }

    public List<Object> getHostInfo() {
        return this.hostInfo;
    }

    public void setHostInfo(List<Object> hostInfo) {
        this.hostInfo = hostInfo;
    }

    public ConcurrentHashMap<String, HashMap<String, Object>> getAllStrgHyprMtrLns() {
        return this.allStrgHyprMtrLns;
    }

    public void setAllStrgHyprMtrLns(ConcurrentHashMap<String, HashMap<String, Object>> allStrgHyprMtrLns) {
        this.allStrgHyprMtrLns = allStrgHyprMtrLns;
    }

    public List<String> getHostISCSILauncherWwns() {
        return this.hostISCSILauncherWwns;
    }

    public void setHostISCSILauncherWwns(List<String> hostISCSILauncherWwns) {
        this.hostISCSILauncherWwns = hostISCSILauncherWwns;
    }

    public List<String> getHostIbLauncherWwns() {
        return this.hostIbLauncherWwns;
    }

    public void setHostIbLauncherWwns(List<String> hostIbLauncherWwns) {
        this.hostIbLauncherWwns = hostIbLauncherWwns;
    }

    public List<String> getHostNvmeLauncherWwns() {
        return this.hostNvmeLauncherWwns;
    }

    public void setHostNvmeLauncherWwns(List<String> hostNvmeLauncherWwns) {
        this.hostNvmeLauncherWwns = hostNvmeLauncherWwns;
    }

    public List<String> getHostFCLauncherWwns() {
        return this.hostFCLauncherWwns;
    }

    public void setHostFCLauncherWwns(List<String> hostFCLauncherWwns) {
        this.hostFCLauncherWwns = hostFCLauncherWwns;
    }

    public String getAddConfirmInfo() {
        return this.addConfirmInfo;
    }

    public void setAddConfirmInfo(String partialsupportMsg) {
        this.addConfirmInfo = partialsupportMsg;
    }

    public boolean isHyperMetroHost() {
        return this.hyperMetroHost;
    }

    public void setHyperMetroHost(boolean hyperMetroHost) {
        this.hyperMetroHost = hyperMetroHost;
    }

    public User getRootUser() {
        return this.rootUser;
    }

    public void setRootUser(User rootUser) {
        this.rootUser = rootUser;
    }

    public boolean isFusionCube() {
        return ItDeviceType.FUSIONCUBE.equals((Object)this.itDeviceType);
    }

    public boolean isA3000() {
        return ItDeviceType.A3000.equals((Object)this.itDeviceType);
    }

    public boolean isFusionStorage() {
        return ItDeviceType.FUSION_STORAGE.equals((Object)this.itDeviceType);
    }

    public boolean isFusionCompute() {
        return ItDeviceType.FUSION_COMPUTE.equals((Object)this.itDeviceType);
    }

    public User getFusionCubeLoginUser() {
        return this.fusionCubeLoginUser;
    }

    public void setFusionCubeLoginUser(User fusionCubeLoginUser) {
        this.fusionCubeLoginUser = fusionCubeLoginUser;
    }

    public User getA3000LoginUser() {
        return this.a3000LoginUser;
    }

    public void setA3000LoginUser(User a3000LoginUser) {
        this.a3000LoginUser = a3000LoginUser;
    }

    public User getClientUser() {
        return this.clientUser;
    }

    public void setClientUser(User clientUser) {
        this.clientUser = clientUser;
    }

    public void setSelectedNodeIps(List<String> selectedNodeIps) {
        this.selectedNodeIps = selectedNodeIps;
    }

    public List<String> getSelectedNodeIps() {
        return this.selectedNodeIps;
    }

    public void setComputeStorageDevNode(ComputeStorageDevNode computeStorageDevNode) {
        this.computeStorageDevNode = computeStorageDevNode;
    }

    public ComputeStorageDevNode getComputeStorageDevNode() {
        return this.computeStorageDevNode;
    }

    public String getScenarioInfo() {
        return this.scenarioInfo;
    }

    public void setScenarioInfo(String scenarioInfo) {
        this.scenarioInfo = scenarioInfo;
    }

    public boolean isVerifyCertificate() {
        return this.isVerifyCertificate;
    }

    public void setVerifyCertificate(boolean isVerifyCertificate) {
        this.isVerifyCertificate = isVerifyCertificate;
    }
}

