/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.impl;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.reflection.ReflectionUtils;
import com.huawei.ism.tool.framework.platform.common.annotation.FieldInfo;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolBasicData;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolData;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolDataBase;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.impl.AbstractUserOpDataSev;
import com.huawei.ism.tool.framework.pubservice.service.IUserOpDataServ;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.channels.FileLock;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class UserOpDataServForHostEvalImpl
extends AbstractUserOpDataSev {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UserOpDataServForHostEvalImpl.class);
    private static IUserOpDataServ instance = null;

    private UserOpDataServForHostEvalImpl() {
    }

    public static synchronized IUserOpDataServ getInstance() {
        if (instance == null) {
            instance = new UserOpDataServForHostEvalImpl();
        }
        return instance;
    }

    @Override
    public <T extends UserOpToolBasicData> TaskResult batchSaveUserOpdata(List<T> userOpDatas) {
        LOGGER.info("UserOpDataServForHostEvalImpl.batchSaveUserOpdata");
        return this.batchSaveUserOpdata(userOpDatas, null);
    }

    public <T extends UserOpToolDataBase> TaskResult batchSaveUserOpdataForEval(List<T> userOpDataforHost) {
        LOGGER.info("UserOpDataServForHostEvalImpl.batchSaveUserOpdataForEval");
        return this.batchSaveUserOpdataForHostEval(userOpDataforHost, null);
    }

    private <T extends UserOpToolDataBase> String saveOpDatas(List<T> userOpDatas, TaskResult tr, UserOpToolData commonData) throws IOException {
        String logFileforHost = UserOpDataSaveUtil.lockAndGetLogWriteFile();
        this.execSave(userOpDatas, logFileforHost, commonData);
        LOGGER.info("execSave is success");
        tr.setResult(TaskResult.Result.SUCCESS);
        return logFileforHost;
    }

    private <T extends UserOpToolDataBase> void execSave(List<T> userOpDatas, String logFile, UserOpToolData commonData) throws IOException {
        UserOpToolData opCommonDataforHostEval = commonData != null ? commonData : ApplicationContext.getInstance().getUserOpData();
        List<Field> fileds = this.getAllFields(opCommonDataforHostEval, (UserOpToolDataBase)userOpDatas.get(0));
        this.refreshUser(opCommonDataforHostEval);
        String logsfile = this.appendLogs(userOpDatas, opCommonDataforHostEval, fileds);
        this.writeToFile(logFile, logsfile);
        LOGGER.info("writeTofile is completed");
    }

    private void refreshUser(UserOpToolData opCommonDataforHostEval) {
        if ("unKnown".equals(opCommonDataforHostEval.getUserAccount())) {
            LOGGER.info("UserOpDataServForHostEvalImpl.refreshUser");
            opCommonDataforHostEval.setUserAccount(ApplicationContext.getInstance().getSupportUser());
        }
    }

    private <T extends UserOpToolDataBase> String appendLogs(List<T> userOpDatas, UserOpToolData opCommonData, List<Field> filedsforEval) {
        StringBuilder logsfile = new StringBuilder();
        for (UserOpToolDataBase opData : userOpDatas) {
            try {
                logsfile.append(this.getOpDataInJson(opData, opCommonData, filedsforEval));
            }
            catch (Exception e) {
                LOGGER.error("append data error");
            }
        }
        return logsfile.toString();
    }

    private <T extends UserOpToolDataBase> void saveSingleOpData(T userOpDataforEavl, String logFile, UserOpToolData commonData) {
        UserOpToolData opCommonData = commonData != null ? commonData : ApplicationContext.getInstance().getUserOpData();
        try {
            List<Field> fileds = this.getAllFields(opCommonData, userOpDataforEavl);
            String logStr = this.getOpDataInJson(userOpDataforEavl, opCommonData, fileds);
            this.writeToFile(logFile, logStr);
            LOGGER.info("writeToFile is complete in saveSingleData");
        }
        catch (Exception e) {
            LOGGER.error("save opdata error!", (Throwable)e);
        }
    }

    private <T extends UserOpToolDataBase> List<Field> getAllFields(UserOpToolData opCommonData, T userOpDataforEval) {
        LinkedList<Field> fieldListData = new LinkedList<Field>();
        List<Field> commFields = UserOpDataSaveUtil.getFieldsNeed2Save(opCommonData);
        this.addFieldToList(fieldListData, commFields);
        List<Field> toolFields = UserOpDataSaveUtil.getFieldsNeed2Save(userOpDataforEval);
        this.addFieldToList(fieldListData, toolFields);
        this.sortFields(fieldListData);
        return fieldListData;
    }

    private void sortFields(List<Field> fieldList) {
        Collections.sort(fieldList, new MyFieldCompartor());
    }

    private void addFieldToList(List<Field> fieldList, List<Field> commFields) {
        for (Field field : commFields) {
            FieldInfo fieldInfoEvalData = field.getAnnotation(FieldInfo.class);
            if (fieldInfoEvalData == null || !fieldInfoEvalData.isSaveToFile()) continue;
            fieldList.add(field);
        }
    }

    private <T extends UserOpToolDataBase> String getOpDataInJson(T userOpData, UserOpToolData opCommonDataforHost, List<Field> fieldsEvalData) throws IllegalArgumentException, IllegalAccessException {
        StringBuilder logBuilder = new StringBuilder().append('{');
        for (Field field : fieldsEvalData) {
            this.appendLogData(userOpData, opCommonDataforHost, logBuilder, field);
        }
        this.removeLastChar(logBuilder);
        logBuilder.append("}\r\n");
        LOGGER.info("Builder logs is success");
        return logBuilder.toString();
    }

    private <T extends UserOpToolDataBase> void appendLogData(T userOpData, UserOpToolData opCommonData, StringBuilder logBuilder, Field fieldData) throws IllegalAccessException {
        FieldInfo fieldInfo = fieldData.getAnnotation(FieldInfo.class);
        if (fieldInfo != null && fieldInfo.isSaveToFile()) {
            ReflectionUtils.setAccessable(fieldData, true);
            Object val = this.getFieldVal(userOpData, fieldData, opCommonData);
            this.appendKeyVal(logBuilder, UserOpDataSaveUtil.getFiledName(fieldData), val);
        }
    }

    private void appendKeyVal(StringBuilder logBuilder, String key, Object val) {
        logBuilder.append("\"").append(key).append("\"").append(':').append(this.getValOfObj(val)).append(',');
    }

    private Object getValOfObj(Object val) {
        Class[] clazzs;
        if (val == null) {
            return "\"\"";
        }
        if (val instanceof Date) {
            return DateUtil.toBeiJingTimeMillis((Date)val);
        }
        Class<?> clazz = val.getClass();
        for (Class clazzTemp : clazzs = new Class[]{Integer.class, Long.class}) {
            if (!clazzTemp.getName().equals(clazz.getName())) continue;
            return val;
        }
        if (val instanceof JSONArray || val instanceof JSONObject) {
            return val;
        }
        return "\"" + val.toString() + "\"";
    }

    private void removeLastChar(StringBuilder logBuilderForEval) {
        int idxOfComma = logBuilderForEval.lastIndexOf(String.valueOf(','));
        if (idxOfComma > 0) {
            logBuilderForEval.deleteCharAt(idxOfComma);
        }
    }

    private <T extends UserOpToolDataBase> Object getFieldVal(T userOpData, Field field, UserOpToolData opCommonData) throws IllegalAccessException {
        ReflectionUtils.setAccessable(field, true);
        if (UserOpToolData.isFieldsOfOwn(field)) {
            return field.get(opCommonData);
        }
        return field.get(userOpData);
    }

    private <T extends UserOpToolDataBase> boolean isParamsValid(List<T> userOpDatasForEval) throws IllegalArgumentException, IllegalAccessException {
        if (userOpDatasForEval.isEmpty()) {
            LOGGER.warn("Param list is empty");
            return false;
        }
        if (this.isAnnotationInValid((UserOpToolDataBase)userOpDatasForEval.get(0))) {
            LOGGER.warn("annotation is invalid");
            return false;
        }
        if (!this.checkParamsInfo(userOpDatasForEval)) {
            LOGGER.warn("annotation is null");
            return false;
        }
        return true;
    }

    private <T> boolean checkParamsInfo(List<T> userOpDatasForEval) throws IllegalAccessException {
        for (T opData : userOpDatasForEval) {
            if (this.checkParanInfoIsValid(opData)) continue;
            LOGGER.warn("check param Info is valid");
            return false;
        }
        return true;
    }

    private <T> boolean checkParanInfoIsValid(T opData) throws IllegalAccessException {
        List<Field> fildsData = UserOpDataSaveUtil.getFieldsNeed2Save(opData);
        for (Field field : fildsData) {
            FieldInfo fieldInfoData = field.getAnnotation(FieldInfo.class);
            if (fieldInfoData == null || !fieldInfoData.isMust() || !ReflectionUtils.isFieldNull(field, opData)) continue;
            LOGGER.warn("must input param:" + fieldInfoData.name() + " is null!");
            return false;
        }
        return true;
    }

    private <T extends UserOpToolDataBase> boolean isAnnotationInValid(T opData) {
        HashSet<Integer> indexSet = new HashSet<Integer>();
        HashSet<String> nameSet = new HashSet<String>();
        List<Field> filds = UserOpDataSaveUtil.getFieldsNeed2Save(opData);
        for (Field fieldData : filds) {
            FieldInfo fieldInfo = fieldData.getAnnotation(FieldInfo.class);
            if (fieldInfo == null) continue;
            String fileName = UserOpDataSaveUtil.getFiledName(fieldData);
            if (indexSet.contains(fieldInfo.index()) || nameSet.contains(fileName)) {
                LOGGER.error("there exists duplicated index or name in annotation!");
                return true;
            }
            indexSet.add(fieldInfo.index());
            nameSet.add(fileName);
        }
        return false;
    }

    @Override
    public <T extends UserOpToolDataBase> TaskResult saveUserOpData(T userOpData) {
        return this.saveUserOpDataForHostEval(userOpData, null);
    }

    private <T extends UserOpToolDataBase> boolean isParamValid(T userOpData) throws IllegalAccessException {
        if (this.isAnnotationInValid(userOpData)) {
            LOGGER.warn("annotation is invalid");
            return false;
        }
        if (!this.checkParanInfoIsValid(userOpData)) {
            LOGGER.warn("check param info is valid");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends UserOpToolDataBase> TaskResult batchSaveUserOpdataForHostEval(List<T> userOpDatas, UserOpToolData commonData) {
        TaskResult tr = new TaskResult();
        String logFileData = null;
        FileLock lockfile = null;
        RandomAccessFile raf = null;
        try {
            if (!this.preSaveCheck(userOpDatas) || !this.isParamsValid(userOpDatas)) {
                LOGGER.info("userOpDatas parameter illegality.");
                TaskResult taskResult = tr;
                StreamUtils.closeResource(null, raf);
                UserOpDataSaveUtil.releaseLock(lockfile, logFileData);
                return taskResult;
            }
            this.setToolCloseDate(commonData);
            logFileData = UserOpDataSaveUtil.lockAndGetLogWriteFile();
            raf = new RandomAccessFile(UserOpDataSaveUtil.getLockFileName(logFileData), "rw");
            lockfile = FileUtils.getFileLock(new File(UserOpDataSaveUtil.getLockFileName(logFileData)), raf);
            logFileData = this.saveOpDatas(userOpDatas, tr, commonData);
            StreamUtils.closeResource(null, raf);
        }
        catch (RuntimeException e) {
            LOGGER.error("Write file error!", (Throwable)e);
            return tr;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception e2) {
                LOGGER.error("Write file error!", (Throwable)e2);
                return tr;
            }
        }
        finally {
            StreamUtils.closeResource(null, raf);
            UserOpDataSaveUtil.releaseLock(lockfile, logFileData);
        }
        UserOpDataSaveUtil.releaseLock(lockfile, logFileData);
        return tr;
    }

    private void setToolCloseDate(UserOpToolData commonToolData) {
        if (commonToolData != null) {
            commonToolData.setCloseToolTime(DateUtil.toBeiJingTimeMillis(new Date()));
        } else {
            UserOpDataSaveUtil.setCloseToolTime(new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends UserOpToolDataBase> TaskResult saveUserOpDataForHostEval(T userOpData, UserOpToolData commonData) {
        RandomAccessFile raFilerRandom;
        FileLock lockfile;
        String logFileData;
        TaskResult tr;
        block5: {
            tr = new TaskResult();
            logFileData = null;
            lockfile = null;
            raFilerRandom = null;
            if (this.isParamValid(userOpData) && this.preSaveCheck(userOpData)) break block5;
            TaskResult taskResult = tr;
            StreamUtils.closeResource(null, raFilerRandom);
            UserOpDataSaveUtil.releaseLock(lockfile, logFileData);
            return taskResult;
        }
        try {
            logFileData = UserOpDataSaveUtil.lockAndGetLogWriteFile();
            raFilerRandom = new RandomAccessFile(UserOpDataSaveUtil.getLockFileName(logFileData), "rw");
            lockfile = FileUtils.getFileLock(new File(UserOpDataSaveUtil.getLockFileName(logFileData)), raFilerRandom);
            this.saveSingleOpData(userOpData, logFileData, commonData);
            tr.setResult(TaskResult.Result.SUCCESS);
        }
        catch (Exception e) {
            try {
                LOGGER.error("save opdata error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, raFilerRandom);
                UserOpDataSaveUtil.releaseLock(lockfile, logFileData);
                throw throwable;
            }
            StreamUtils.closeResource(null, raFilerRandom);
            UserOpDataSaveUtil.releaseLock(lockfile, logFileData);
        }
        StreamUtils.closeResource(null, raFilerRandom);
        UserOpDataSaveUtil.releaseLock(lockfile, logFileData);
        return tr;
    }

    @Override
    public <T extends UserOpToolBasicData> TaskResult batchSaveUserOpdata(List<T> userOpDatas, UserOpToolData commonData) {
        return null;
    }

    @Override
    public <T extends UserOpToolBasicData> TaskResult saveUserOpData(T userOpData) {
        return null;
    }

    @Override
    public <T extends UserOpToolBasicData> TaskResult saveUserOpData(T userOpData, UserOpToolData commonData) {
        return null;
    }

    private static final class MyFieldCompartor
    implements Comparator<Field>,
    Serializable {
        private static final long serialVersionUID = -1629578428137101460L;

        private MyFieldCompartor() {
        }

        @Override
        public int compare(Field o1, Field o2) {
            FieldInfo field1Info = o1.getAnnotation(FieldInfo.class);
            FieldInfo field2Info = o2.getAnnotation(FieldInfo.class);
            if (field1Info == null || field2Info == null) {
                return 0;
            }
            return field1Info.index() - field2Info.index();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        }
    }
}

