/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateFormatUtil {
    private static final Map<String, DateTimeFormatter> FORMATTER_MAP = new ConcurrentHashMap<String, DateTimeFormatter>();

    public Date getDate(String dateString) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.parse(dateString);
    }

    public String getDateString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static String formatTime(LocalDateTime localDateTime, String timeFormat) {
        return FORMATTER_MAP.computeIfAbsent(timeFormat, DateTimeFormatter::ofPattern).format(localDateTime);
    }

    public static LocalDateTime parseTime(String timeString, String timeFormat) {
        return LocalDateTime.parse(timeString, FORMATTER_MAP.computeIfAbsent(timeFormat, DateTimeFormatter::ofPattern));
    }
}

