/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.houp.ui;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.framework.pubservice.utils.DateFormatUtil;
import com.huawei.ism.tool.houp.exception.HoupException;
import com.huawei.ism.tool.houp.utils.ClientUtils;
import com.huawei.ism.tool.houp.utils.HoupServer;
import com.huawei.ism.tool.houp.utils.TrustCertificateService;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.json.JSONObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoupBasePanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(HoupBasePanel.class);
    private static final int EMPTY_HEIGHT = 1;
    private static final int COMPONENT_HEIGHT = 20;
    private static final int LABEL_LENGTH = 90;
    private static final int FIELD_LENGTH = 178;
    private static final int SK_LENGTH = 64;
    private static final String OPERATE_TYPE = "operalog.type.system";
    private static final String OPERATE_NAME = "houp.ui.click.import.ak.sk";
    private static final String AKSK_PARAM_ERROR = ResourceUtil.getString((String)"houp.panel.check.result");
    protected JRadioButton houpCertCheckBtn = new JRadioButton(ResourceUtil.getString((String)"houp.panel.check.btn"), false);
    protected JRadioButton houpCertNoCheckBtn = new JRadioButton(ResourceUtil.getString((String)"houp.panel.no.check.btn"), true);
    protected JComponent certPathBox;
    protected JTextField certPathField = new JTextField();
    protected JButton certPathButton = UiMethod.createButton((String)ResourceUtil.getString((String)"houp.panel.certify.path.btn"));
    protected JTextField akField = new JTextField();
    protected IsmPasswordField skField = new IsmPasswordField();
    protected JButton updateButton = UiMethod.createButton((String)ResourceUtil.getString((String)"houp.panel.update.btn"));
    protected JButton downloadButton = UiMethod.createButton((String)ResourceUtil.getString((String)"houp.panel.download.btn"));
    protected JComponent houpBasePanel;
    protected JComponent houpAddrLabel = UiMethod.createLabel((String)ResourceUtil.getString((String)"houp.panel.addr.label"));
    protected JTextField houpAddrField = new JTextField("");
    protected Box houpAddrComp;
    private JDialog parentWindow;
    private JComponent msgLabel = UCD.createTextArea((String)ResourceUtil.getString((String)"houp.panel.msg.label"));
    private ToolHyperLinkLabel houpWebLink = new ToolHyperLinkLabel(ResourceUtil.getString((String)"houp.panel.link.label"));
    private JComponent certifyLabel = UiMethod.createLabel((String)ResourceUtil.getString((String)"houp.panel.certify.label"));
    private JComponent certPathLabel = UiMethod.createLabel((String)ResourceUtil.getString((String)"houp.panel.certify.path.label"));
    private JComponent akLabel = UiMethod.createLabel((String)ResourceUtil.getString((String)"houp.panel.ak.label"));
    private JComponent skLabel = UiMethod.createLabel((String)ResourceUtil.getString((String)"houp.panel.sk.label"));
    private JComponent newSkPathLabel = UiMethod.createLabel((String)ResourceUtil.getString((String)"houp.pabel.newsk.path.label"));
    private JTextField newSKPathField = new JTextField();
    private JComponent newSkPathComp;
    private JButton importCsvButton = UiMethod.createButton((String)ResourceUtil.getString((String)"houp.panel.import.btn"));
    private JTextArea detailArea = UiMethod.createJTextArea((String)"");
    private final String houpWebsite = ResourceUtil.getString((String)"houp.panel.link.website");
    private JLabel akSkTipLabel = new JLabel(ResourceUtil.getImage((String)"info.png"));
    private JLabel certifyTipLabel = new JLabel(ResourceUtil.getImage((String)"info.png"));
    private boolean isVerifyCert;
    private int offset;
    private boolean showDownloadButton;
    private boolean showUpdateButton;

    public HoupBasePanel(JDialog parentWindow, int offset, boolean showDownloadButton) {
        this(parentWindow, offset, showDownloadButton, !showDownloadButton);
    }

    public HoupBasePanel(JDialog parentWindow, int offset, boolean showDownloadButton, boolean showUpdateButton) {
        this.offset = offset;
        this.parentWindow = parentWindow;
        this.showDownloadButton = showDownloadButton;
        this.showUpdateButton = showUpdateButton;
        this.setLayout(new BorderLayout());
        this.initUI();
        this.initListener();
        this.autoImport();
    }

    private void initUI() {
        this.downloadButton.setVisible(this.showDownloadButton);
        this.updateButton.setVisible(this.showUpdateButton);
        String newSkSavePath = HoupServer.getNewSkSavePath();
        this.houpWebLink.setToolTipText(ResourceUtil.getStringWithParams((String)"houp.panel.link.tip", (Object[])new Object[]{newSkSavePath}));
        this.akSkTipLabel.setToolTipText(ResourceUtil.getStringWithParams((String)"houp.panel.aksk.tip", (Object[])new Object[]{newSkSavePath, newSkSavePath}));
        this.certifyTipLabel.setToolTipText(ResourceUtil.getString((String)"houp.panel.certify.tip"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.houpCertCheckBtn);
        buttonGroup.add(this.houpCertNoCheckBtn);
        this.houpCertNoCheckBtn.setSelected(true);
        this.certPathField.setEditable(false);
        this.newSkPathComp = UCD.buildHBoxLeft((Component[])new Component[]{this.newSkPathLabel, this.newSKPathField});
        this.newSkPathComp.setVisible(false);
        this.detailArea.setForeground(Color.red);
        this.setComponetSize();
        this.certPathBox = UCD.buildHBoxLeft((Component[])new Component[]{this.certPathLabel, this.certPathField, this.certPathButton});
        this.certPathBox.setVisible(false);
        this.skField.setMaxValidRestrict(64);
        this.akField.setEnabled(false);
        this.skField.setEnabled(false);
        Box akComp = UCD.buildHBoxLeft((Component[])new Component[]{this.akLabel, this.akField});
        Box skComp = UCD.buildHBoxLeft((Component[])new Component[]{this.skLabel, this.skField});
        this.houpAddrComp = UCD.buildHBoxLeft((Component[])new Component[]{this.houpAddrLabel, this.houpAddrField});
        this.houpAddrComp.setVisible(false);
        Box houpCertifyComp = UCD.buildHBoxLeft((Component[])new Component[]{this.certifyLabel, this.houpCertCheckBtn, this.houpCertNoCheckBtn, this.certifyTipLabel});
        Box bottomComp = UCD.buildHBoxLeft((Component[])new Component[]{this.importCsvButton, this.updateButton, this.downloadButton});
        this.houpBasePanel = UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(1), UCD.buildHBoxLeft((Component[])new Component[]{this.msgLabel}), UCD.buildHBoxLeft((Component[])new Component[]{this.houpWebLink, this.akSkTipLabel}), this.houpAddrComp, houpCertifyComp, this.certPathBox, akComp, skComp, this.newSkPathComp, bottomComp, this.detailArea});
        this.add((Component)UCD.buildVerticalBox((Border)SwingUtil.getEmptyBorder(), (Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(this.offset), this.houpBasePanel})}), "North");
    }

    private void setComponetSize() {
        UCD.setJComponentSize((JComponent)this.houpAddrLabel, (int)90, (int)20);
        UCD.setJComponentSize((JComponent)this.certPathLabel, (int)90, (int)20);
        UCD.setJComponentSize((JComponent)this.certPathField, (int)178, (int)20);
        UCD.setJComponentSize((JComponent)this.akLabel, (int)90, (int)20);
        UCD.setJComponentSize((JComponent)this.skLabel, (int)90, (int)20);
        UCD.setJComponentSize((JComponent)this.akField, (int)178, (int)20);
        UCD.setJComponentSize((JComponent)this.skField, (int)178, (int)20);
        UCD.setJComponentSize((JComponent)this.newSkPathLabel, (int)90, (int)20);
        UCD.setJComponentSize((JComponent)this.newSKPathField, (int)178, (int)20);
        UCD.setJComponentSize((JComponent)this.certPathButton, (int)this.certPathButton.getPreferredSize().width, (int)20);
        UCD.setJComponentSize((JComponent)this.importCsvButton, (int)this.importCsvButton.getPreferredSize().width, (int)20);
        UCD.setJComponentSize((JComponent)this.downloadButton, (int)this.downloadButton.getPreferredSize().width, (int)20);
        UCD.setJComponentSize((JComponent)this.updateButton, (int)this.updateButton.getPreferredSize().width, (int)20);
    }

    private void initListener() {
        this.importCsvButton.addActionListener(this::importCsv);
        this.houpWebLink.addClickListener(this::openHoupWebsite);
        this.updateButton.addActionListener(event -> this.updateSkAndReleaseClient());
        this.akField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HoupBasePanel.this.clearDetailArea();
            }
        });
        this.skField.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HoupBasePanel.this.clearDetailArea();
            }
        });
        this.houpCertCheckBtn.addActionListener(this::houpCertCheckAction);
        this.houpCertNoCheckBtn.addActionListener(this::houpCertNoCheckAction);
        this.certPathButton.addActionListener(this::selectCertAction);
    }

    private void autoImport() {
        String newSkSavePath = HoupServer.getNewSkSavePath();
        File akskFile = new File(newSkSavePath);
        if (!akskFile.exists()) {
            log.info("credentials.csv is not found and do not import.");
            return;
        }
        log.info("find credentials.csv and start auto import");
        this.parseCsvToAkSk(akskFile);
    }

    public void clearDetailArea() {
        this.detailArea.setText("");
    }

    private void houpCertCheckAction(ActionEvent event) {
        log.info("houp cert check btn clicked.");
        this.houpCertNoCheckBtn.setSelected(false);
        this.certPathBox.setVisible(true);
        boolean certPathExist = StringUtils.isNotBlank((CharSequence)this.certPathField.getText());
        this.updateButton.setEnabled(certPathExist);
        this.downloadButton.setEnabled(certPathExist);
    }

    private void houpCertNoCheckAction(ActionEvent event) {
        log.info("houp cert nocheck btn clicked.");
        this.houpCertCheckBtn.setSelected(false);
        this.certPathBox.setVisible(false);
        this.updateButton.setEnabled(true);
        this.downloadButton.setEnabled(true);
        this.isVerifyCert = false;
    }

    private void selectCertAction(ActionEvent event) {
        log.info("houp cert select btn clicked.");
        this.clearDetailArea();
        File file = new File(".");
        String[] fileType = new String[]{"cer"};
        HashMap<String, String> selectFileParams = new HashMap<String, String>();
        selectFileParams.put("title", ResourceUtil.getString((String)"houp.panel.certify.title"));
        selectFileParams.put("PathId", FilePathUtils.getCanonicalPath((File)file));
        selectFileParams.put("description", ResourceUtil.getString((String)"houp.panel.certify.type"));
        File selectedFile = ToolFileChooser.selectFile((Window)this.parentWindow, (String[])fileType, (int)0, (boolean)true, selectFileParams);
        if (selectedFile == null || !selectedFile.exists()) {
            return;
        }
        String certPath = FilePathUtils.getCanonicalPath((File)selectedFile);
        if (!this.updateCert(certPath)) {
            log.error("import houp cert failed.");
            DialogUtils.showInfoDialog((JDialog)this.parentWindow, (String)ResourceUtil.getString((String)"houp.panel.certify.import.fail"));
        } else {
            DialogUtils.showInfoDialog((JDialog)this.parentWindow, (String)ResourceUtil.getString((String)"houp.panel.certify.import.success"));
            this.certPathField.setText(certPath);
            this.updateButton.setEnabled(true);
            this.downloadButton.setEnabled(true);
            this.isVerifyCert = true;
            ClientUtils.setCertPath(certPath);
        }
    }

    private boolean updateCert(String path) {
        return TrustCertificateService.getInstance().updateCert(path);
    }

    private void openHoupWebsite(MouseEvent me) {
        OSCmdUtils.exeExportFile((String)this.houpWebsite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSkAndReleaseClient() {
        if (!this.checkAkSk()) {
            this.setAkskParamError();
            return;
        }
        String originAk = this.akField.getText();
        String originSk = String.valueOf(this.skField.getPassword());
        CloseableHttpClient httpClient = null;
        try {
            httpClient = ClientUtils.getCloseableHttpClient(this.isVerifyCert);
            String newSk = HoupServer.updateSk(originAk, originSk, httpClient);
            if (StringUtils.isNotBlank((CharSequence)newSk)) {
                JSONObject data = HoupServer.activeSk(originAk, newSk, httpClient);
                JSONObject skInfo = data.getJSONObject("skInfo");
                boolean activeSkResult = skInfo != null;
                log.info("activeResult:{}", (Object)activeSkResult);
                if (activeSkResult) {
                    long expiredTime = skInfo.getLong("expiredTimestamp");
                    long canUpdateTime = skInfo.getLong("canUpdateTimestamp");
                    this.saveNewSK(originAk, newSk, expiredTime, canUpdateTime);
                    String expiredString = new DateFormatUtil().getDateString(new Date(expiredTime));
                    String canUpdateString = new DateFormatUtil().getDateString(new Date(canUpdateTime));
                    this.detailArea.setText(ResourceUtil.getStringWithParams((String)"houp.panel.update.sucess", (Object[])new Object[]{expiredString, canUpdateString}));
                }
            }
        }
        catch (HoupException e) {
            this.detailArea.setText(e.getErrorMsg());
        }
        finally {
            ClientUtils.closeClent(httpClient);
        }
    }

    private void saveNewSK(String ak, String newSk, long expiredTime, long canUpdateTime) {
        this.skField.setText(newSk);
        this.newSKPathField.setText(HoupServer.getNewSkSavePath());
        this.newSkPathComp.setVisible(true);
        HoupServer.writeNewSKToLocal(ak, newSk, expiredTime, canUpdateTime);
    }

    private void importCsv(ActionEvent evt) {
        log.info("click select package path button");
        Optional<File> files = this.selectFile();
        if (!files.isPresent()) {
            LogUtils.addOperateLog((String)OPERATE_TYPE, (String)OPERATE_NAME, (boolean)false);
            return;
        }
        files.ifPresent(file -> this.parseCsvToAkSk((File)file));
    }

    private Optional<File> selectFile() {
        String[] fileType = new String[]{"csv"};
        HashMap<String, String> selectFileParams = new HashMap<String, String>();
        selectFileParams.put("title", ResourceUtil.getString((String)"houp.panel.import.csv"));
        selectFileParams.put("PathId", HoupServer.getNewSkSavePath());
        selectFileParams.put("description", "*.csv");
        return Optional.ofNullable(ToolFileChooser.selectFile((Window)this.parentWindow, (String[])fileType, (int)0, (boolean)true, selectFileParams));
    }

    private void parseCsvToAkSk(File file) {
        log.info("start to parse csv file");
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            this.readAkSk(br);
        }
        catch (IOException e) {
            log.error("parse ak/sk failed");
            this.detailArea.setText(AKSK_PARAM_ERROR);
        }
    }

    private void readAkSk(BufferedReader br) throws IOException {
        String line = null;
        boolean findAkSk = false;
        String akValue = "";
        String skValue = "";
        long expiredTime = 0L;
        long canUpdateTime = 0L;
        while ((line = br.readLine()) != null) {
            String encryptValue;
            String decryptVal;
            String[] values;
            if (findAkSk) {
                String[] split = line.split(",");
                if (split.length >= 2 && this.checkAkFormat(split[0]) && this.checkSkFormat(split[1])) {
                    akValue = split[0];
                    skValue = split[1];
                } else {
                    log.error("ak/sk value is error!");
                    this.detailArea.setText(AKSK_PARAM_ERROR);
                    LogUtils.addOperateLog((String)OPERATE_TYPE, (String)OPERATE_NAME, (boolean)false);
                    return;
                }
            }
            if (line.contains("AK") && line.contains("SK")) {
                findAkSk = true;
                continue;
            }
            if (!line.contains("Encrypte,") || (values = (decryptVal = AESEncrypt.decrypt((String)(encryptValue = line.substring(line.indexOf("Encrypte,") + "Encrypte,".length())))).split(",")).length < 4) continue;
            akValue = values[0];
            skValue = values[1];
            expiredTime = Long.valueOf(values[2]);
            canUpdateTime = Long.valueOf(values[3]);
        }
        this.akField.setText(akValue);
        this.skField.setText(skValue);
        if (expiredTime != 0L || canUpdateTime != 0L) {
            String expiredString = new DateFormatUtil().getDateString(new Date(expiredTime));
            String canUpdateString = new DateFormatUtil().getDateString(new Date(canUpdateTime));
            this.detailArea.setText(ResourceUtil.getStringWithParams((String)"houp.panel.import.sucess", (Object[])new Object[]{expiredString, canUpdateString}));
        } else {
            this.detailArea.setText("");
        }
        LogUtils.addOperateLog((String)OPERATE_TYPE, (String)OPERATE_NAME, (boolean)true);
    }

    public boolean checkAkSk() {
        return this.checkAkFormat(this.akField.getText()) && this.checkSkFormat(String.valueOf(this.skField.getPassword()));
    }

    public void setAkskParamError() {
        this.detailArea.setText(AKSK_PARAM_ERROR);
    }

    private boolean checkAkFormat(String ak) {
        return StringUtils.isNotBlank((CharSequence)ak);
    }

    private boolean checkSkFormat(String sk) {
        return StringUtils.isNotBlank((CharSequence)sk);
    }

    public JTextField getAkField() {
        return this.akField;
    }

    public IsmPasswordField getSkField() {
        return this.skField;
    }

    public JButton getUpdateButton() {
        return this.updateButton;
    }

    public JButton getDownloadButton() {
        return this.downloadButton;
    }

    public JTextArea getDetailArea() {
        return this.detailArea;
    }

    public boolean isVerifyCert() {
        return this.isVerifyCert;
    }
}

