/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.houp.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.houp.entity.HoupParamContext;
import com.huawei.ism.tool.houp.exception.HoupException;
import com.huawei.ism.tool.houp.ui.HoupBasePanel;
import com.huawei.ism.tool.houp.utils.ClientUtils;
import com.huawei.ism.tool.houp.utils.HoupServer;
import com.huawei.ism.util.SwingUtil;
import com.huawei.json.JSONObject;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Window;
import java.io.IOException;
import javax.swing.JDialog;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoupLoginDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(HoupLoginDialog.class);
    private static final Dimension HOUP_SIZE = new Dimension(400, 380);
    private static final String OPERATE_TYPE = "operalog.type.system";
    private static final String OPERATE_NAME = "houp.ui.click.Activate.sk";
    private HoupBasePanel panel = new HoupBasePanel(this, 0, true);

    public HoupLoginDialog() {
        this.initUI();
        this.bindListener();
        this.setPreferredSize(HOUP_SIZE);
        this.setModal(true);
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
    }

    private void initUI() {
        this.setTitle(ResourceUtil.getString((String)"houp.dialog.title"));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.panel);
    }

    private void bindListener() {
        this.panel.downloadButton.addActionListener(event -> this.testAkSk());
    }

    private void testAkSk() {
        if (this.panel.checkAkSk()) {
            String ak = this.panel.getAkField().getText();
            char[] sk = this.panel.getSkField().getPassword();
            boolean verifyCert = this.panel.isVerifyCert();
            this.execUpdateSk(ak, String.valueOf(sk), verifyCert);
        } else {
            this.panel.setAkskParamError();
            LogUtils.addOperateLog((String)OPERATE_TYPE, (String)OPERATE_NAME, (boolean)false);
        }
    }

    private void execUpdateSk(String ak, String sk, boolean verifyCert) {
        try (CloseableHttpClient httpClient = ClientUtils.getCloseableHttpClient(verifyCert);){
            String newSk = HoupServer.updateSk(ak, sk, httpClient);
            if (!StringUtils.isNULLStr((String)newSk)) {
                JSONObject data = HoupServer.activeSk(ak, newSk, httpClient);
                JSONObject skInfo = data.getJSONObject("skInfo");
                boolean activeSkResult = skInfo != null;
                log.info("activeResult:{}", (Object)activeSkResult);
                if (activeSkResult) {
                    long expiredTime = skInfo.getLong("expiredTimestamp");
                    long canUpdateTime = skInfo.getLong("canUpdateTimestamp");
                    this.saveAkSk(ak, newSk, verifyCert);
                    HoupServer.writeNewSKToLocal(ak, newSk, expiredTime, canUpdateTime);
                    LogUtils.addOperateLog((String)OPERATE_TYPE, (String)OPERATE_NAME, (boolean)true);
                    this.closeDialog();
                    return;
                }
            }
        }
        catch (HoupException e) {
            if ("6025".equals(e.getErrorCode())) {
                this.saveAkSk(ak, sk, verifyCert);
                LogUtils.addOperateLog((String)OPERATE_TYPE, (String)OPERATE_NAME, (boolean)true);
                this.closeDialog();
                return;
            }
            HoupParamContext.getInstance().clearCache();
            this.panel.getDetailArea().setText(e.getErrorMsg());
        }
        catch (IOException e) {
            log.error("download Path from houp error!");
        }
        LogUtils.addOperateLog((String)OPERATE_TYPE, (String)OPERATE_NAME, (boolean)false);
    }

    private void saveAkSk(String ak, String sk, boolean verifyCert) {
        HoupParamContext instance = HoupParamContext.getInstance();
        instance.setSk(sk);
        instance.setAk(ak);
        instance.setVerifyCert(verifyCert);
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    public void autoLogin() {
        if (!this.panel.checkAkSk()) {
            return;
        }
        this.testAkSk();
    }

    public HoupBasePanel getPanel() {
        return this.panel;
    }
}

