/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.houp.utils;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.houp.utils.HoupConstant;
import com.huawei.json.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AkSkUtils {
    private static final Logger log = LoggerFactory.getLogger(AkSkUtils.class);
    private static final String RESOURCE_START = "huawei.com";
    private static final String RESOURCE_END = "?";

    public static Map<String, String> getAkSkRequestHeader(String url, String ak, String sk, long timestamp) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("H-AK", ak);
        header.put("H-TIMESTAMP", String.valueOf(timestamp));
        header.put("H-VERSION", "1.0");
        header.put("H-SIGN", AkSkUtils.getAkskSignature(url, ak, sk, timestamp));
        return header;
    }

    public static String buildUpdateBody() {
        JSONObject params = new JSONObject();
        params.put("skActiveInterval", (Object)String.valueOf(HoupConstant.SK_ACTIVE_INTERVAL_VALUE));
        params.put("skExpiredInterval", (Object)AkSkUtils.getExpiredIntervalValue());
        return params.toString();
    }

    private static String getExpiredIntervalValue() {
        int day;
        String string = ResourceUtil.getString((String)"houp.sk.expired.interval");
        try {
            day = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            day = 90;
        }
        return String.valueOf((long)(day * 24 * 60 * 60) * 1000L);
    }

    public static String getAkskSignature(String url, String ak, String sk, long timestamp) {
        try {
            String tempUri = AkSkUtils.getResouceUrl(url);
            String decodeUri = URLDecoder.decode(tempUri, "UTF-8");
            String stringToSign = ak + ":" + timestamp + ":" + decodeUri;
            return new HmacUtils(HmacAlgorithms.HMAC_SHA_256, sk).hmacHex(stringToSign);
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnsupportedEncodingException: uri has unsupported character", (Throwable)e);
            return "";
        }
    }

    private static String getResouceUrl(String url) {
        int startIndex = url.indexOf(RESOURCE_START);
        int endIndex = url.indexOf(RESOURCE_END);
        if (endIndex != -1) {
            return url.substring(startIndex + RESOURCE_START.length(), endIndex);
        }
        return url.substring(startIndex + 10);
    }
}

