/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.houp.utils;

import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.certbase.ssl.MyTrustSslSocketFactoryTool;
import com.huawei.ism.tool.channel.config.entity.InternetParams;
import com.huawei.ism.tool.channel.utils.InternetInfoKeeper;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.houp.exception.HoupException;
import com.huawei.ism.tool.https.entity.HttpProxy;
import com.huawei.uMate.common.rest.SimpleTrustManager;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.hc.core5.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtils {
    private static final Logger log = LoggerFactory.getLogger(ClientUtils.class);
    private static final int MAX_TOTOL_CON_NUM = 50;
    private static final int MAX_DEFAULT_CON_NUM = 20;
    private static final int SECONDS_NUM = 60;
    private static final String MULTIPLIER = "*";
    private static final String REG_SPACE = "\\s";
    private static final String DEFAULT = "Default";
    private static String certPath;

    public static CloseableHttpClient getCloseableHttpClient(boolean isVerifyCert) {
        try {
            return ClientUtils.getHttpsClient(true, isVerifyCert);
        }
        catch (KeyManagementException e) {
            log.error("Key Management error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("No Such Algorithm error.");
        }
        catch (KeyStoreException | CertificateException e) {
            log.error("Certificate File is error.");
        }
        throw new HoupException("10001", "Create the Client error, connect the developers.");
    }

    private static CloseableHttpClient getHttpsClient(boolean useProxy, boolean isVerifyCert) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException {
        TrustManager[] trustManagerArray;
        SimpleTrustManager simpleTrustManager = new SimpleTrustManager();
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        if (isVerifyCert) {
            trustManagerArray = MyTrustSslSocketFactoryTool.getMySslX509TrustManager((String)ClientUtils.getCertPath());
        } else {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = simpleTrustManager;
        }
        sslcontext.init(null, trustManagerArray, SecureRandom.getInstanceStrong());
        PoolingHttpClientConnectionManager connManager = ClientUtils.buildPoolingHttpClientConnectionManager(sslcontext);
        RequestConfig defaultRequestConfig = ClientUtils.buildRequestConfig();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        HttpHost proxy = ClientUtils.buildHttpHost(useProxy, credentialsProvider);
        String defaultUserAgent = VersionInfo.getSoftwareInfo((String)"Apache-HttpClient", (String)"org.apache.hc.client5", HttpClientBuilder.class);
        CloseableHttpClient httpent = HttpClients.custom().setUserAgent(ClientUtils.getCustomedUserAgent(defaultUserAgent)).setConnectionManager((HttpClientConnectionManager)connManager).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setRedirectStrategy((RedirectStrategy)new NoRedirectStrategy()).setProxy(proxy).setDefaultRequestConfig(defaultRequestConfig).setRetryStrategy((HttpRequestRetryStrategy)new RetryStrategy(5, TimeValue.ofSeconds((long)1L))).build();
        return httpent;
    }

    private static String getCertPath() {
        return certPath;
    }

    private static PoolingHttpClientConnectionManager buildPoolingHttpClientConnectionManager(SSLContext sslcontext) {
        SSLConnectionSocketFactory sf = new SSLConnectionSocketFactory(sslcontext);
        Registry socketFactoryRegistry = RegistryBuilder.create().register(URIScheme.HTTP.id, (Object)PlainConnectionSocketFactory.getSocketFactory()).register(URIScheme.HTTPS.id, (Object)sf).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, PoolConcurrencyPolicy.STRICT, PoolReusePolicy.LIFO, TimeValue.NEG_ONE_MILLISECOND, null, null, null);
        connManager.setDefaultMaxPerRoute(20);
        connManager.setMaxTotal(50);
        return connManager;
    }

    private static RequestConfig buildRequestConfig() {
        return RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)60L)).setConnectTimeout(Timeout.ofSeconds((long)60L)).build();
    }

    private static HttpHost buildHttpHost(boolean useProxy, BasicCredentialsProvider credentialsProvider) {
        HttpProxy httpProxy;
        HttpHost proxy = null;
        InternetParams internetParams = InternetInfoKeeper.getInstance().getInternetParams();
        if (useProxy && null != internetParams && internetParams.isUseProxy() && HttpProxy.ProxyType.HTTP.equals((Object)(httpProxy = internetParams.getHttpProxy()).getType())) {
            credentialsProvider.setCredentials(new AuthScope(httpProxy.getHost(), httpProxy.getPort()), (Credentials)new UsernamePasswordCredentials(httpProxy.getUserName(), httpProxy.getPassword().toCharArray()));
            proxy = new HttpHost(httpProxy.getHost(), httpProxy.getPort());
        }
        return proxy;
    }

    private static String getCustomedUserAgent(String userAgentOriginal) {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        String fullVersion = applicationContext.getVersion();
        String[] versionSeg = fullVersion.split(REG_SPACE);
        String smartkitVersion = versionSeg.length > 0 ? versionSeg[versionSeg.length - 1] : fullVersion;
        boolean isEnglishVer = PlatformAppContext.getInstance().getFunctionBooleanByKey("toolkit.app.zh_or_en.version");
        String smartkitLocaleVer = "";
        smartkitLocaleVer = isEnglishVer ? "InternationalVersion" : "ChineseVersion";
        String systemLanguage = System.getProperty("user.language");
        String system = System.getProperty("os.name");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        StringBuilder userAgentParam = new StringBuilder();
        userAgentParam.append(userAgentOriginal).append(" ").append("Smartkit").append("/").append(smartkitVersion).append(" ").append("(").append(smartkitLocaleVer).append(";").append(VerifyUtil.isEmpty((String)systemLanguage) ? DEFAULT : systemLanguage).append(";").append(VerifyUtil.isEmpty((String)system) ? DEFAULT : system).append(";").append((int)screenSize.getWidth()).append(MULTIPLIER).append((int)screenSize.getHeight()).append(")");
        return userAgentParam.toString();
    }

    public static void closeClent(CloseableHttpClient client) {
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException e) {
                log.error("HttpClient is closed error.", (Throwable)e);
            }
        }
    }

    public static void setCertPath(String certPath) {
        ClientUtils.certPath = certPath;
    }

    public static class RetryStrategy
    implements HttpRequestRetryStrategy {
        private static final int TOO_MANY_REQUESTS_STATUS = 429;
        private static final int SERVICE_UNAVAILABLE_STATUS = 503;
        private final int maxRetries;
        private final TimeValue defaultRetryInterval;
        private final Set<Integer> retriableCodes;

        protected RetryStrategy(int maxRetries, TimeValue defaultRetryInterval, Collection<Integer> codes) {
            Args.notNegative((int)maxRetries, (String)"maxRetries");
            Args.notNegative((long)defaultRetryInterval.getDuration(), (String)"defaultRetryInterval");
            this.maxRetries = maxRetries;
            this.defaultRetryInterval = defaultRetryInterval;
            this.retriableCodes = new HashSet<Integer>(codes);
        }

        public RetryStrategy(int maxRetries, TimeValue defaultRetryInterval) {
            this(maxRetries, defaultRetryInterval, Arrays.asList(429, 503));
        }

        public boolean retryRequest(HttpRequest httpRequest, IOException exception, int execCount, HttpContext httpContext) {
            if (execCount > this.maxRetries) {
                log.error("Retried {} times and reaches the upper limit.", (Object)execCount);
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                log.error("NoHttpResponseException occurred and retryed {} times", (Object)execCount);
                return true;
            }
            return false;
        }

        public boolean retryRequest(HttpResponse httpResponse, int execCount, HttpContext httpContext) {
            return execCount <= this.maxRetries && this.retriableCodes.contains(httpResponse.getCode());
        }

        public TimeValue getRetryInterval(HttpResponse httpResponse, int i, HttpContext httpContext) {
            TimeValue retryAfter;
            block4: {
                Header header = httpResponse.getFirstHeader("Retry-After");
                if (header == null) {
                    return this.defaultRetryInterval;
                }
                retryAfter = null;
                String value = header.getValue();
                try {
                    retryAfter = TimeValue.ofSeconds((long)Long.parseLong(value));
                }
                catch (NumberFormatException var9) {
                    log.error("The format of the delay response time is incorrect.");
                    Date retryAfterDate = DateUtils.parseDate((String)value);
                    if (retryAfterDate == null) break block4;
                    retryAfter = TimeValue.ofMilliseconds((long)(retryAfterDate.getTime() - System.currentTimeMillis()));
                }
            }
            if (TimeValue.isPositive((TimeValue)retryAfter)) {
                return retryAfter;
            }
            return this.defaultRetryInterval;
        }
    }

    private static class NoRedirectStrategy
    implements RedirectStrategy {
        private NoRedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException {
            return false;
        }

        public URI getLocationURI(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException {
            return null;
        }
    }
}

