/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.houp.utils;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.houp.exception.HoupException;
import com.huawei.ism.tool.houp.utils.AkSkUtils;
import com.huawei.ism.tool.houp.utils.HoupConstant;
import com.huawei.ism.tool.safe.SensitiveInfoFilter;
import com.huawei.json.JSONObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoupServer {
    private static final Logger log = LoggerFactory.getLogger(HoupServer.class);

    public static String updateSk(String ak, String sk, CloseableHttpClient httpClient) throws HoupException {
        String uri = HoupConstant.BASE_HOUP_URL + HoupConstant.UPDATE_SK_URI;
        Map<String, String> header = AkSkUtils.getAkSkRequestHeader(uri, ak, sk, HoupServer.getHoupTimeStamp(httpClient));
        HttpPost httpPost = new HttpPost(uri);
        HoupServer.addHeader((HttpUriRequestBase)httpPost, header);
        String updateBody = AkSkUtils.buildUpdateBody();
        httpPost.setEntity((HttpEntity)new StringEntity(updateBody, ContentType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8)));
        return HoupServer.getNewSkFromResponse(httpPost, httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNewSkFromResponse(HttpPost httpPost, CloseableHttpClient httpClient) throws HoupException {
        JSONObject responseBody;
        InputStream content;
        block6: {
            content = null;
            CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpPost);
            int code = response.getCode();
            content = response.getEntity().getContent();
            responseBody = HoupServer.readContent(content);
            log.info("response Json :{}", (Object)SensitiveInfoFilter.filter((String)responseBody.toString()));
            if (code != 200) break block6;
            String string = responseBody.getJSONObject("data").getStringOrDefault("newSk", "");
            StreamUtils.closeStream(null, (InputStream)content);
            return string;
        }
        try {
            try {
                log.error("update sk failed!");
                throw HoupServer.throwHoupException(responseBody);
            }
            catch (SSLHandshakeException ex) {
                throw HoupServer.buildCertificateError(ex);
            }
            catch (IOException e) {
                log.error("update sk error!");
                StreamUtils.closeStream(null, content);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeStream(null, content);
            throw throwable;
        }
        return "";
    }

    private static HoupException throwHoupException(JSONObject responseBody) {
        return new HoupException(responseBody.getStringOrDefault("errorCode", "500"), responseBody.getStringOrDefault("errorMsg", "System error"));
    }

    public static JSONObject activeSk(String ak, String sk, CloseableHttpClient httpClient) throws HoupException {
        String uri = HoupConstant.BASE_HOUP_URL + HoupConstant.ACTIVE_SK_URI;
        Map<String, String> header = AkSkUtils.getAkSkRequestHeader(uri, ak, sk, HoupServer.getHoupTimeStamp(httpClient));
        HttpPost httpPost = new HttpPost(uri);
        HoupServer.addHeader((HttpUriRequestBase)httpPost, header);
        return HoupServer.getActiveResult(httpPost, httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject getActiveResult(HttpPost httpPost, CloseableHttpClient httpClient) throws HoupException {
        JSONObject responseBody;
        InputStream content;
        block6: {
            content = null;
            CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpPost);
            int code = response.getCode();
            content = response.getEntity().getContent();
            responseBody = HoupServer.readContent(content);
            log.info("response Json :{}", (Object)SensitiveInfoFilter.filter((String)responseBody.toString()));
            if (code != 200) break block6;
            JSONObject jSONObject = responseBody.getJSONObject("data");
            StreamUtils.closeStream(null, (InputStream)content);
            return jSONObject;
        }
        try {
            try {
                log.error("active sk failed!");
                throw HoupServer.throwHoupException(responseBody);
            }
            catch (SSLHandshakeException ex) {
                throw HoupServer.buildCertificateError(ex);
            }
            catch (IOException e) {
                log.error("active sk error!");
                StreamUtils.closeStream(null, content);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeStream(null, content);
            throw throwable;
        }
        return new JSONObject();
    }

    public static boolean houpDownload(String ak, String sk, String uri, File file, CloseableHttpClient httpClient) throws HoupException {
        String newUrl = uri.replace(" ", "%20");
        Map<String, String> header = AkSkUtils.getAkSkRequestHeader(newUrl, ak, sk, HoupServer.getHoupTimeStamp(httpClient));
        HttpGet httpGet = new HttpGet(newUrl);
        HoupServer.addHeader((HttpUriRequestBase)httpGet, header);
        return HoupServer.getDownloadResponse(httpGet, file, httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getDownloadResponse(HttpGet httpGet, File file, CloseableHttpClient httpClient) throws HoupException {
        InputStream content;
        FileOutputStream fos;
        block6: {
            fos = null;
            content = null;
            CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpGet);
            int code = response.getCode();
            content = response.getEntity().getContent();
            if (code != 200 && code != 206) break block6;
            fos = FileUtils.openOutputStream(file);
            HoupServer.downloadFile(content, fos);
            boolean bl = true;
            StreamUtils.closeStream((OutputStream)fos, (InputStream)content);
            return bl;
        }
        try {
            try {
                JSONObject responseBody = HoupServer.readContent(content);
                log.error("download {} from houpWebsite error, response info:{}", (Object)httpGet.getRequestUri(), (Object)responseBody.toString());
                throw HoupServer.throwHoupException(responseBody);
            }
            catch (SSLHandshakeException ex) {
                throw HoupServer.buildCertificateError(ex);
            }
            catch (IOException e) {
                log.error("download from houpWebsite error!");
                StreamUtils.closeStream(fos, content);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeStream(fos, content);
            throw throwable;
        }
        return false;
    }

    public static String houpPost(String ak, String sk, String url, String data, CloseableHttpClient httpClient) throws HoupException {
        Map<String, String> header = AkSkUtils.getAkSkRequestHeader(url, ak, sk, HoupServer.getHoupTimeStamp(httpClient));
        HttpPost httpPost = new HttpPost(url);
        HoupServer.addHeader((HttpUriRequestBase)httpPost, header);
        if (StringUtils.isNotBlank((CharSequence)data)) {
            httpPost.setEntity((HttpEntity)new StringEntity(data, ContentType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8)));
        }
        return HoupServer.getPostResponse(httpPost, httpClient);
    }

    /*
     * Exception decompiling
     */
    private static String getPostResponse(HttpPost httpPost, CloseableHttpClient httpClient) throws HoupException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static JSONObject readContent(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] buffer = new byte[1024];
        int len = -1;
        while ((len = inputStream.read(buffer)) != -1) {
            stringBuffer.append(new String(buffer, 0, len, "UTF-8"));
        }
        return new JSONObject(stringBuffer.toString());
    }

    private static void addHeader(HttpUriRequestBase requestBase, Map<String, String> header) {
        if (header != null) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                requestBase.addHeader(entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    private static void downloadFile(InputStream inputStream, FileOutputStream fos) throws IOException {
        byte[] buffer = new byte[1024];
        int len = -1;
        while ((len = inputStream.read(buffer)) != -1) {
            fos.write(buffer, 0, len);
        }
    }

    public static boolean downloadFileByAksk(String ak, String sk, String url, String localStoragePath, CloseableHttpClient httpClient) throws HoupException {
        String fileUrl = url.substring(url.indexOf("server/Huawei/") + "server/Huawei/".length());
        int length = fileUrl.split("/").length;
        String fileName = fileUrl.split("/")[length - 1];
        log.info(String.format(Locale.ENGLISH, "start to download %s.", fileName));
        String filePath = localStoragePath + File.separator + fileUrl;
        File file = FileUtils.getFile(filePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return HoupServer.houpDownload(ak, sk, url, file, httpClient);
    }

    public static String updateForNewSk(String ak, String sk, CloseableHttpClient httpClient) throws HoupException {
        String finalSk;
        block4: {
            finalSk = sk;
            try {
                String newSk = HoupServer.updateSk(ak, sk, httpClient);
                if (StringUtils.isNotBlank((CharSequence)newSk)) {
                    JSONObject data = HoupServer.activeSk(ak, newSk, httpClient);
                    JSONObject skInfo = data.getJSONObject("skInfo");
                    boolean activeSkResult = skInfo != null;
                    log.info("activeResult:{}", (Object)activeSkResult);
                    if (activeSkResult) {
                        finalSk = newSk;
                        long expiredTime = skInfo.getLong("expiredTimestamp");
                        long canUpdateTime = skInfo.getLong("canUpdateTimestamp");
                        HoupServer.writeNewSKToLocal(ak, newSk, expiredTime, canUpdateTime);
                    }
                }
            }
            catch (HoupException e) {
                log.info("active sk error before download, cause:{}", (Object)e.getErrorMsg());
                if ("6025".equals(e.getErrorCode())) break block4;
                throw e;
            }
        }
        return finalSk;
    }

    private static HoupException buildCertificateError(SSLHandshakeException ex) {
        return new HoupException("10000", ex.getMessage());
    }

    public static void writeNewSKToLocal(String ak, String newSk, long expiredTime, long canUpdateTime) {
        String newSkSavePath = HoupServer.getNewSkSavePath();
        HoupServer.writeAkSk(ak, newSk, newSkSavePath, expiredTime, canUpdateTime);
    }

    public static String getNewSkSavePath() {
        StringBuffer sb = new StringBuffer();
        String userDataPath = ApplicationContext.getInstance().getUserDataPath();
        String filePath = ApplicationContext.getInstance().getCurrWorkPath();
        sb.append(filePath);
        sb.append(userDataPath);
        sb.append(File.separatorChar);
        sb.append("credentials.csv");
        return sb.toString();
    }

    private static void writeAkSk(String ak, String newSk, String savePath, long expiredTime, long canUpdateTime) {
        File saveFile = new File(savePath);
        com.huawei.ism.tool.base.utils.FileUtils.createDir((String)saveFile.getParent());
        log.info("start save newSk to path:{}", (Object)savePath);
        String akSkValue = new StringBuffer(ak).append(",").append(newSk).append(",").append(expiredTime).append(",").append(canUpdateTime).append(",").toString();
        String encryptedValue = new StringBuffer("Encrypte,").append(AESEncrypt.encrypt((String)akSkValue)).toString();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(saveFile));){
            bw.write(encryptedValue);
            bw.flush();
        }
        catch (IOException e) {
            log.error("save new sk failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Long getHoupTimeStamp(CloseableHttpClient httpClient) {
        block8: {
            String uri = HoupConstant.BASE_HOUP_URL + HoupConstant.HOUP_TIME_URI;
            HttpGet httpGet = new HttpGet(uri);
            InputStream content = null;
            try {
                CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpGet);
                int code = response.getCode();
                content = response.getEntity().getContent();
                JSONObject responseBody = HoupServer.readContent(content);
                log.info("query houp server timestamp result:{}", (Object)SensitiveInfoFilter.filter((String)responseBody.toString()));
                if (code == 200) {
                    Long l = responseBody.getJSONObject("data").getLong("timestamp");
                    StreamUtils.closeStream(null, (InputStream)content);
                    return l;
                }
                StreamUtils.closeStream(null, (InputStream)content);
            }
            catch (SSLHandshakeException ex) {
                log.error("query houp server timestamp error!", (Object)ex.getMessage());
                StreamUtils.closeStream(null, (InputStream)content);
            }
            catch (IOException e) {
                log.error("query houp server timestamp  error!");
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                StreamUtils.closeStream(null, content);
            }
        }
        return System.currentTimeMillis();
    }
}

