/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.houp.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustCertificateService {
    private static final Logger log = LoggerFactory.getLogger(TrustCertificateService.class);
    private static volatile TrustCertificateService instance;
    private Set<X509Certificate> trustedCerts = new HashSet<X509Certificate>();
    private KeyStore trustKeyStore = null;

    private TrustCertificateService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TrustCertificateService getInstance() {
        if (null != instance) return instance;
        Class<TrustCertificateService> clazz = TrustCertificateService.class;
        synchronized (TrustCertificateService.class) {
            if (null != instance) return instance;
            instance = new TrustCertificateService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean updateCert(String certPath) {
        File certFile;
        if (!this.trustedCerts.isEmpty()) {
            this.trustedCerts.clear();
        }
        return this.loadCert(certFile = new File(certPath)) && this.updateKeyStore();
    }

    private boolean loadCert(File certItem) {
        try (FileInputStream certFile = FileUtils.openInputStream(certItem);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> x509Certs = certificateFactory.generateCertificates(certFile);
            for (X509Certificate x509Certificate : x509Certs) {
                x509Certificate.checkValidity();
                log.info(String.format(Locale.ROOT, "load crt correct. file name:%s", certItem.getName()));
                this.trustedCerts.add(x509Certificate);
            }
        }
        catch (FileNotFoundException e) {
            log.error("load cert FileNotFoundException error.");
            return false;
        }
        catch (Exception e) {
            log.error("load cert Exception error.", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean updateKeyStore() {
        this.trustKeyStore = null;
        try {
            if (this.trustedCerts.isEmpty()) {
                return false;
            }
            this.trustKeyStore = KeyStore.getInstance("JKS");
            this.trustKeyStore.load(null, null);
            int count = 1;
            for (Certificate certificate : this.trustedCerts) {
                this.trustKeyStore.setCertificateEntry("TurstCer" + count++, certificate);
            }
        }
        catch (KeyStoreException e) {
            log.error("initKeyStore by trustedCerts error.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.error("initKeyStore by trustedCerts error, unknown exception", (Throwable)e);
            return false;
        }
        return true;
    }
}

