/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.umate.common.config.upgradecheck.utils;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.rest.https.HttpsCertManager;
import com.huawei.uMate.common.utils.RedfishUtils;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.SecurityUtils;
import com.huawei.umate.common.config.upgradecheck.model.HttpResponseModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class HttpDownloadFileUtil {
    private static final Logger LOGGER = new Logger(HttpDownloadFileUtil.class);
    private static final ResUtil RES = ResUtil.getInstance("BundleUpgrade");
    private static final String URL_SEPARATOR = "/";

    private HttpDownloadFileUtil() {
        throw new IllegalStateException("HttpClientUtil class");
    }

    private static int getErrorCode(CloseableHttpResponse httpResponse) throws IOException, ParseException {
        HttpEntity httpEntity = httpResponse.getEntity();
        String resultStr = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
        resultStr = resultStr == null ? null : resultStr.replace("\\/", URL_SEPARATOR);
        int errorCode = StringUtils.isNULLStr((String)RedfishUtils.getObjectAttr(resultStr, String.class, "errorCode")) ? -1 : Integer.valueOf(RedfishUtils.getObjectAttr(resultStr, String.class, "errorCode"));
        return errorCode;
    }

    public static void downloadFile(String userName, String password, String url, String localStoragePath, boolean isVerifyCert) throws UMateException {
        if (!SecurityUtils.isValidURL(url)) {
            LOGGER.error(String.format(Locale.ROOT, "%s is Invalid.", url));
            throw new UMateException(HttpDownloadFileUtil.getFailReason(401, -1).getReason());
        }
        String fileUrl = url.substring(url.indexOf("server/Huawei/") + "server/Huawei/".length());
        HttpGet httpGet = new HttpGet(url.replace(" ", "%20"));
        String token = Base64.encodeBase64String((byte[])(userName + ":" + password).getBytes(Charset.defaultCharset()));
        httpGet.addHeader("Authorization", (Object)("Basic " + token));
        int length = fileUrl.split(URL_SEPARATOR).length;
        String fileName = fileUrl.split(URL_SEPARATOR)[length - 1];
        LOGGER.info(String.format(Locale.ENGLISH, "start to download %s.", fileName));
        String filePath = localStoragePath + File.separator + fileUrl;
        File file = FileUtils.getFile(filePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        HttpDownloadFileUtil.processDownload(httpGet, fileName, file, isVerifyCert);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processDownload(HttpGet httpGet, String fileName, File file, boolean isVerifyCert) throws UMateException {
        InputStream inputStream = null;
        FileOutputStream fos = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpDownloadFileUtil.getHttpClient(isVerifyCert);
            CloseableHttpResponse httpResponse = httpClient.execute((ClassicHttpRequest)httpGet);
            int code = httpResponse.getCode();
            LOGGER.info(String.format(Locale.ENGLISH, "the connection status: %s.", code));
            if (code != 200) {
                int errorCode = HttpDownloadFileUtil.getErrorCode(httpResponse);
                HttpResponseModel httpResponseModel = HttpDownloadFileUtil.getFailReason(code, errorCode);
                LOGGER.error(httpResponseModel.getReason());
                throw new UMateException(httpResponseModel.getReason());
            }
            fos = FileUtils.openOutputStream(file);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                LOGGER.error(String.format(Locale.ENGLISH, "download %s failed, the file is not exist.", fileName));
                throw new UMateException(String.format(Locale.ENGLISH, RES.getStringWithParams("bundle.upgrade.connection.error5", fileName), new Object[0]));
            }
            inputStream = httpEntity.getContent();
            HttpDownloadFileUtil.readContent(inputStream, fos);
            LOGGER.info(String.format(Locale.ENGLISH, "download %s successfully.", fileName));
        }
        catch (IOException | ParseException e) {
            try {
                LOGGER.error(String.format(Locale.ENGLISH, "download %s failed.", fileName), e);
                throw new UMateException(String.format(Locale.ENGLISH, RES.getStringWithParams("bundle.upgrade.connection.error5", new Object[0]), fileName));
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(fos, inputStream);
                try {
                    if (httpClient == null) throw throwable;
                    httpClient.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    LOGGER.error("close httpclient object failed.", e2);
                }
                throw throwable;
            }
        }
        StreamUtils.closeStream((OutputStream)fos, (InputStream)inputStream);
        try {
            if (httpClient == null) return;
            httpClient.close();
            return;
        }
        catch (IOException e) {
            LOGGER.error("close httpclient object failed.", e);
            return;
        }
    }

    private static void readContent(InputStream inputStream, FileOutputStream fos) throws IOException {
        byte[] buffer = new byte[1024];
        int len = -1;
        while ((len = inputStream.read(buffer)) != -1) {
            fos.write(buffer, 0, len);
        }
    }

    public static CloseableHttpClient getHttpClient(boolean isVerifyCert) {
        PoolingHttpClientConnectionManager connectionManager = null;
        SSLContext sslContext = HttpsCertManager.getInstance().getSSLContext("TLSv1.2", isVerifyCert);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
        connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    private static HttpResponseModel getFailReason(int code, int errorCode) {
        HttpResponseModel httpResponseModel = new HttpResponseModel();
        httpResponseModel.setStatusCode(code);
        switch (code) {
            case 200: {
                httpResponseModel.setReason(RES.getString("bundle.upgrade.connection.info1"));
                break;
            }
            case 401: {
                HttpDownloadFileUtil.set401Reason(errorCode, httpResponseModel);
                break;
            }
            case 403: {
                httpResponseModel.setReason(errorCode != 122 ? RES.getString("bundle.upgrade.connection.error6") : HttpDownloadFileUtil.getReasonFormat("bundle.upgrade.firmware.download.premission.check.message122", "bundle.upgrade.firmware.download.premission.check.solution122"));
                break;
            }
            case 404: {
                httpResponseModel.setReason(RES.getString("bundle.upgrade.connection.error4"));
                break;
            }
            default: {
                httpResponseModel.setReason(RES.getString("bundle.upgrade.connection.error1"));
            }
        }
        return httpResponseModel;
    }

    private static void set401Reason(int errorCode, HttpResponseModel httpResponseModel) {
        switch (errorCode) {
            case 107: {
                httpResponseModel.setReason(HttpDownloadFileUtil.getReasonFormat("bundle.upgrade.firmware.download.premission.check.message107", "bundle.upgrade.firmware.download.premission.check.solution107"));
                break;
            }
            case 108: {
                httpResponseModel.setReason(HttpDownloadFileUtil.getReasonFormat("bundle.upgrade.firmware.download.premission.check.message108", "bundle.upgrade.firmware.download.premission.check.solution108"));
                break;
            }
            case 109: {
                httpResponseModel.setReason(HttpDownloadFileUtil.getReasonFormat("bundle.upgrade.firmware.download.premission.check.message109", "bundle.upgrade.firmware.download.premission.check.solution109"));
                break;
            }
            case 121: {
                httpResponseModel.setReason(HttpDownloadFileUtil.getReasonFormat("bundle.upgrade.firmware.download.premission.check.message121", "bundle.upgrade.firmware.download.premission.check.solution121"));
                break;
            }
            default: {
                httpResponseModel.setReason(RES.getString("bundle.upgrade.connection.error3"));
            }
        }
    }

    private static String getReasonFormat(String errorMessage, String solution) {
        return String.format(Locale.ENGLISH, "%s, %s", RES.getString(errorMessage), RES.getString(solution));
    }
}

