/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.connection;

import com.huawei.ism.common.bean.User;
import com.huawei.ism.connection.ConnectionManager;
import com.huawei.ism.connection.IConnection;
import com.huawei.ism.connection.SocketPool;
import com.huawei.ism.connection.TLVConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.TLVMOMsg;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.DataPackage;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tlv.lang.SignedInt32;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.util.ByteUtil;
import com.huawei.ism.util.NetUtil;
import com.huawei.ism.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLVConnectionImpl
extends TLVConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(TLVConnectionImpl.class);
    public static final int MSG_HEAD_LENGTH = 28;
    public static final int INVALID_RETRY_TIME = -1;
    private AtomicInteger serial = new AtomicInteger();
    private String ip = null;
    private String userName = null;
    private String passW = null;
    private int userScope = 0;
    private String sessionKey = null;
    private String userID = null;
    private String deviceID = null;
    private boolean isUserOff = false;
    private int port;
    private int protocolType;
    private User loginUser = null;

    @Override
    public String getDeviceID() {
        return this.deviceID;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getProtocalType() {
        return this.protocolType;
    }

    @Override
    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
        if (deviceID != null && this.ip != null) {
            ConnectionManager.getInstance().addDeviceIP(deviceID, this.ip);
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.passW;
    }

    @Override
    public boolean init(Properties properties) {
        boolean checkParam;
        this.userName = properties.getProperty("USER_NAME");
        this.passW = properties.getProperty("USER_WORD");
        try {
            this.userScope = Integer.parseInt(properties.getProperty("USERSCOPE"));
            this.ip = properties.getProperty("IP_OR_NAME");
            this.port = Integer.valueOf(properties.getProperty("PORT"));
            this.protocolType = 1;
            if (properties.getProperty("CONN_PROTOCOL") != null) {
                this.protocolType = Integer.valueOf(properties.getProperty("CONN_PROTOCOL"));
            }
        }
        catch (Exception e) {
            LOGGER.error("init fail", (Throwable)e);
        }
        boolean bl = checkParam = Utils.isNullStr(this.ip) || this.port < 0 || this.protocolType < 0;
        if (checkParam) {
            throw new IllegalArgumentException();
        }
        return true;
    }

    public void setUserInfo(String user, String ps, int scope) {
        this.userName = user;
        this.passW = ps;
        this.userScope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User authenticate(String localIP) throws IsmException {
        String validLocalIp = null == localIP ? NetUtil.queryLocalIP(this.ip, this.port) : localIP;
        Socket socket = this.getSocket();
        try {
            User user = this.authenticateByLocalIP(socket, validLocalIp);
            return user;
        }
        finally {
            try {
                this.releaseSocket(socket);
            }
            catch (Exception e) {
                LOGGER.error("releaseSocket fail", (Throwable)e);
            }
        }
    }

    @Override
    public User authenticate() throws IsmException {
        String localIP = NetUtil.queryLocalIP(this.ip, this.port);
        return this.authenticate(localIP);
    }

    protected User authenticateByLocalIP(Socket socket, String localIP) {
        String loginPassword = this.passW;
        List<Param> list = this.createTLVList(localIP, loginPassword);
        Record record = this.sendAndGetRecord(socket, list);
        User returnUser = this.fixReturnUserData(record);
        this.isUserOff = false;
        this.loginUser = returnUser;
        return returnUser;
    }

    private User fixReturnUserData(Record record) {
        User returnUser = this.createRawUserData(record);
        this.setSessionKey(returnUser.getSessionKey());
        this.userID = returnUser.getID();
        int userState = record.getParamIntValue(TLV.USER.ACCOUNTSTATE.getParamIndex(), new SignedInt32(User.Status.Online.getValue())).intValue();
        returnUser.setStatus(User.Status.valueOf(userState));
        returnUser.setPwdChangeTime(record.getParamIntValue(TLV.USER.PWDCHANGETIME.getParamIndex(), new UnsignedInt32(0)).longValue());
        return returnUser;
    }

    private User createRawUserData(Record record) {
        User returnUser = new User(this.userName);
        returnUser.setPassword(this.passW);
        returnUser.setUserScope(User.USER_SCOPE.valueOf(this.userScope));
        returnUser.setSessionKey("" + ((IsmInteger)record.getParamValue(TLV.USER.SESSIONKEY.getParamIndex())).intValue());
        returnUser.setLevel(User.Level.valueOf(record.getParamIntValue(TLV.USER.LEVEL.getParamIndex()).intValue()));
        returnUser.setID(record.getParamStrValue(TLV.USER.ID.getParamIndex()));
        return returnUser;
    }

    private Record sendAndGetRecord(Socket socket, List<Param> list) {
        DataPackage sendData = TLVUtils.param2DP(55847813121L, "0", list);
        DataPackage returnData = this.sendAndReceive(socket, sendData, 30);
        List<Record> datas = returnData.getRecordset();
        if (datas.isEmpty()) {
            throw new IsmException(16797698L);
        }
        return datas.get(0);
    }

    private List<Param> createTLVList(String localIP, String loginPassword) {
        return TLVUtils.paramList(new Param(TLV.USER.NAME.getParamIndex(), TLV.USER.NAME.getParamType(), this.userName), new Param(TLV.USER.PASSWORD.getParamIndex(), TLV.USER.PASSWORD.getParamType(), loginPassword), new Param(TLV.USER.ADDRESSINFO.getParamIndex(), TLV.USER.ADDRESSINFO.getParamType(), localIP), new Param(TLV.USER.SCOPE.getParamIndex(), TLV.USER.SCOPE.getParamType(), (IsmInteger)new UnsignedInt32(this.userScope)));
    }

    @Override
    public String getSessionKey() {
        return this.sessionKey;
    }

    @Override
    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    @Override
    public void close() {
        this.logout();
    }

    public void logout() {
        if (this.sessionKey == null) {
            return;
        }
        try {
            IConnection.ConnectionState connectionState;
            if (null != this.deviceID && IConnection.ConnectionState.Disconnected == (connectionState = this.getConnectionState())) {
                return;
            }
            Param userIDParam = new Param(TLV.USER.ID.getParamIndex(), TLV.USER.ID.getParamType(), this.userID);
            DataPackage sendData = TLVUtils.param2DP(55847813122L, this.sessionKey, Arrays.asList(userIDParam));
            this.sendAndReceive(sendData, 30);
        }
        catch (Exception e1) {
            LOGGER.error(this.userName + " logout fail on " + this.getURL(), (Throwable)e1);
        }
    }

    public void sendCMD(long cmdWord, List<Param> tlvParams) throws IsmException {
        this.sendCMD(cmdWord, tlvParams, 30);
    }

    public void sendCMD(long cmdWord, List<Param> tlvParams, int timeout) throws IsmException {
        this.invoke(cmdWord, tlvParams, timeout);
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams) throws IsmException {
        return this.invoke(cmdWord, tlvParams, 30);
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams, int timeout) throws IsmException {
        List<Record> datas = this.getBatch(cmdWord, tlvParams, timeout);
        return datas.isEmpty() ? null : datas.get(0);
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams, int timeout, int retryTimes) throws IsmException {
        List<Record> datas = null;
        datas = retryTimes <= 0 ? this.getBatch(cmdWord, tlvParams, timeout) : this.getBatch(cmdWord, tlvParams, timeout, retryTimes);
        return datas.isEmpty() ? null : datas.get(0);
    }

    @Override
    public Record invoke(Socket socket, long cmdWord, List<Param> tlvParams, int timeout) throws IsmException {
        DataPackage sendData = TLVUtils.param2DP(cmdWord, this.sessionKey, tlvParams);
        DataPackage returnData = this.sendAndReceive(socket, sendData, timeout);
        List<Record> datas = returnData.getRecordset();
        return datas.isEmpty() ? null : datas.get(0);
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams, TLVConnection.CMD_WORK_CONTRL workContrl) throws IsmException {
        DataPackage sendData = TLVUtils.param2DP(cmdWord, this.sessionKey, tlvParams, workContrl);
        DataPackage returnData = this.sendAndReceive(sendData, 30);
        List<Record> records = returnData.getRecordset();
        return records.isEmpty() ? null : records.get(0);
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams, TLVConnection.CMD_WORK_CONTRL workContrl, int timeout) throws IsmException {
        DataPackage sendData = TLVUtils.param2DP(cmdWord, this.sessionKey, tlvParams, workContrl);
        DataPackage returnData = this.sendAndReceive(sendData, timeout);
        List<Record> records = returnData.getRecordset();
        return records.isEmpty() ? null : records.get(0);
    }

    @Override
    public List<Record> getBatch(long cmdWord, List<Param> tlvParams) throws IsmException {
        return this.getBatch(cmdWord, tlvParams, 30);
    }

    @Override
    public List<Record> getBatch(long cmdWord, List<Param> tlvParams, int timeout) throws IsmException {
        DataPackage sendData = TLVUtils.param2DP(cmdWord, this.sessionKey, tlvParams);
        DataPackage returnData = this.sendAndReceive(sendData, timeout);
        return returnData.getRecordset();
    }

    @Override
    public List<Record> getBatch(long cmdWord, List<Param> tlvParams, int timeout, int retryTimes) throws IsmException {
        DataPackage sendData = TLVUtils.param2DP(cmdWord, this.sessionKey, tlvParams);
        DataPackage returnData = null;
        returnData = retryTimes <= 0 ? this.sendAndReceive(sendData, timeout) : this.sendAndReceive(sendData, timeout, retryTimes);
        return returnData.getRecordset();
    }

    @Override
    public List<Record> getNext(long cmdWord, Param param) throws IsmException {
        return this.getNext(cmdWord, param, 30);
    }

    @Override
    public List<Record> getNext(long cmdWord, Param param, int timeOut) throws IsmException {
        ArrayList<Record> dataList = new ArrayList<Record>();
        List<Record> tmpDatas = this.getBatch(cmdWord, TLVUtils.singleItemList(param), timeOut);
        Record lastRecord = null;
        long errorcode = 0L;
        while (!tmpDatas.isEmpty()) {
            for (int i = 0; i < tmpDatas.size() - 1; ++i) {
                dataList.add(tmpDatas.get(i));
            }
            lastRecord = tmpDatas.get(tmpDatas.size() - 1);
            if (TLVUtils.containTag(lastRecord, 4095)) {
                errorcode = ((IsmInteger)lastRecord.getParamValue(4095)).longValue();
                if (errorcode == 1L) break;
                throw new IsmException(errorcode);
            }
            dataList.add(lastRecord);
            tmpDatas = this.getBatch(cmdWord, TLVUtils.singleItemList(param.getIndex(), param.getType(), lastRecord.getParamValue(param.getIndex())), timeOut);
        }
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataPackage sendAndReceive(DataPackage sendData, int timeout) throws IsmException {
        Socket socket = this.getSocket();
        try {
            DataPackage dataPackage = this.sendAndReceive(socket, sendData, timeout);
            return dataPackage;
        }
        finally {
            try {
                this.releaseSocket(socket);
            }
            catch (Exception e) {
                LOGGER.error("releaseSocket fail", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataPackage sendAndReceive(DataPackage sendData, int timeout, int retryTimes) throws IsmException {
        Socket socket = this.getSocketWithRetryTime(retryTimes);
        try {
            DataPackage dataPackage = this.sendAndReceive(socket, sendData, timeout);
            return dataPackage;
        }
        finally {
            try {
                this.releaseSocket(socket);
            }
            catch (Exception e) {
                LOGGER.error("releaseSocket fail", (Throwable)e);
            }
        }
    }

    protected DataPackage processAuthenticateException(Socket socket, IsmException exception, DataPackage sendData, int timeout) {
        if (exception.getErrorId() == 1077949070L) {
            this.clean(socket);
            throw exception;
        }
        if (this.isAuthenticateFail(exception) && !this.isUserOff) {
            String localIP = NetUtil.queryLocalIP(this.ip, this.port);
            this.authenticateByLocalIP(socket, localIP);
            sendData.getHead().setSessionKey(Long.valueOf(this.sessionKey));
            this.sendDataPackage(socket, sendData, timeout);
            byte[] result = this.receiveByteStream(socket);
            return this.decodeByteStream(result);
        }
        throw exception;
    }

    private boolean isAuthenticateFail(IsmException exception) {
        long errorId = exception.getErrorId();
        if (errorId == 1077949070L) {
            this.isUserOff = true;
        }
        return errorId == 16797700L || errorId == 16806404L || errorId == 0x5000504L || errorId == 83887382L || errorId == 1077949069L || errorId == 1700000018L;
    }

    protected void sendDataPackage(Socket socket, DataPackage sendData, int timeout) {
        OutputStream outputStream = null;
        try {
            socket.setSoTimeout(timeout * 1000);
            outputStream = socket.getOutputStream();
            short msgSn = (short)(this.serial.incrementAndGet() & 0xFFFF7FFF);
            sendData.getHead().setSerial(msgSn);
            outputStream.write(sendData.toByteArray());
            outputStream.flush();
            if (StringUtils.getCheckItemValue("is.print.tlv.log")) {
                LOGGER.info("SEND TO {}:\n {}", (Object)socket.getRemoteSocketAddress(), (Object)sendData.toString());
            } else {
                LOGGER.info("SEND TO {} :\n {}", (Object)socket.getRemoteSocketAddress(), (Object)sendData.getHead().toString());
            }
        }
        catch (RuntimeException e) {
            this.clean(socket);
            throw new IsmException(1073949185L, (Throwable)e);
        }
        catch (Exception e) {
            this.clean(socket);
            throw new IsmException(1073949185L, (Throwable)e);
        }
    }

    protected byte[] receiveByteStream(Socket socket) {
        byte[] result = null;
        InputStream inputStream = null;
        try {
            inputStream = socket.getInputStream();
            byte[] receiveDataHeadByte = new byte[28];
            this.fillBuffer(inputStream, receiveDataHeadByte);
            byte[] tmp4Byte = new byte[4];
            System.arraycopy(receiveDataHeadByte, 8, tmp4Byte, 0, 4);
            System.arraycopy(receiveDataHeadByte, 24, tmp4Byte, 0, 4);
            int bufferLength = ByteUtil.bytes2int(tmp4Byte, false);
            result = new byte[28 + bufferLength];
            byte[] receiveDataBuf = new byte[bufferLength];
            if (bufferLength > 0) {
                this.fillBuffer(inputStream, receiveDataBuf);
            }
            System.arraycopy(receiveDataHeadByte, 0, result, 0, 28);
            System.arraycopy(receiveDataBuf, 0, result, 28, receiveDataBuf.length);
        }
        catch (Exception e) {
            this.clean(socket);
            throw new IsmException(16797698L, (Throwable)e);
        }
        return result;
    }

    protected DataPackage decodeByteStream(byte[] byteStream) {
        return TLVUtils.decode(byteStream);
    }

    protected void clean(Socket socket) {
        try {
            socket.close();
        }
        catch (Exception e1) {
            LOGGER.error("", (Throwable)e1);
        }
    }

    protected void fillBuffer(InputStream is, byte[] receiveDataBuf) throws IOException, InterruptedException {
        int totalReadBytes = 0;
        int onceReadBytes = 0;
        while (totalReadBytes < receiveDataBuf.length) {
            onceReadBytes = is.read(receiveDataBuf, totalReadBytes, receiveDataBuf.length - totalReadBytes);
            if (onceReadBytes > -1) {
                totalReadBytes += onceReadBytes;
            }
            if (onceReadBytes != -1) continue;
            throw new IOException("socket closed");
        }
    }

    @Override
    public IConnection.ConnectionState getConnectionState() {
        SocketPool pool = ConnectionManager.getInstance().getSocketPoolByDeviceID(this.deviceID);
        if (pool != null) {
            return pool.getConnectionState();
        }
        return IConnection.ConnectionState.Disconnected;
    }

    @Override
    public String getURL() {
        return this.ip;
    }

    @Override
    public Record pmCreate(int moType, List<Param> tlvParams, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(moType));
        return this.invoke(0xD00004000L, TLVUtils.addParam(tlvParams, moTypeParam), timeout);
    }

    @Override
    public void pmDelete(int moType, String moid, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(moType));
        Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), moid);
        this.sendCMD(0xD00006000L, TLVUtils.addParam(Collections.EMPTY_LIST, moTypeParam, moidParam), timeout);
    }

    @Override
    public void pmModify(int moType, String moid, List<Param> tlvParams, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(moType));
        List<Param> actualTlvParams = TLVUtils.addParam(tlvParams, moTypeParam);
        if (null != moid && !moid.isEmpty()) {
            Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), moid);
            actualTlvParams = TLVUtils.addParam(actualTlvParams, moidParam);
        }
        this.sendCMD(0xD00002000L, actualTlvParams, timeout);
    }

    @Override
    public Record pmGet(int moType, String moid, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(moType));
        Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), moid);
        return this.invoke(0xD00000000L, TLVUtils.addParam(Collections.EMPTY_LIST, moTypeParam, moidParam), timeout);
    }

    @Override
    public List<Record> pmGetBacthNext(int moType, List<Param> tlvParams, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(moType));
        return this.bacthNext(0xD0000C000L, TLVUtils.addParam(tlvParams, moTypeParam), timeout);
    }

    @Override
    public List<Record> bacthNext(long cmd, List<Param> tlvParams, int timeout) throws IsmException {
        return this.bacthNextWithRetryTimes(cmd, tlvParams, timeout, -1);
    }

    @Override
    public List<Record> bacthNext(long cmd, List<Param> tlvParams, int timeout, int retryTimes) throws IsmException {
        if (retryTimes <= 0) {
            return this.bacthNext(cmd, tlvParams, timeout);
        }
        return this.bacthNextWithRetryTimes(cmd, tlvParams, timeout, retryTimes);
    }

    private List<Record> bacthNextWithRetryTimes(long cmd, List<Param> tlvParams, int timeout, int retryTimes) throws IsmException {
        ArrayList<Record> dataList = new ArrayList<Record>();
        List<Record> datas = null;
        datas = retryTimes > 0 ? this.getBatch(cmd, tlvParams, timeout, retryTimes) : this.getBatch(cmd, tlvParams, timeout);
        long errorcode = 0L;
        Record lastRecord = null;
        while (!datas.isEmpty()) {
            for (int i = 0; i < datas.size() - 1; ++i) {
                dataList.add(datas.get(i));
            }
            lastRecord = datas.get(datas.size() - 1);
            if (TLVUtils.containTag(lastRecord, 4095)) {
                errorcode = ((IsmInteger)lastRecord.getParamValue(4095)).longValue();
                if (errorcode == 1L) break;
                throw new IsmException(errorcode);
            }
            dataList.add(lastRecord);
            Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), lastRecord.getParamStrValue(TLVMOMsg.ID.getParamIndex()));
            if (retryTimes > 0) {
                datas = this.getBatch(cmd, TLVUtils.addParam(tlvParams, moidParam), timeout, retryTimes);
                continue;
            }
            datas = this.getBatch(cmd, TLVUtils.addParam(tlvParams, moidParam), timeout);
        }
        return dataList;
    }

    @Override
    public int pmCount(int moType, List<Param> tlvParams, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(moType));
        Record record = this.invoke(0xD0000E000L, TLVUtils.addParam(tlvParams, moTypeParam), timeout);
        if (record == null) {
            throw new IsmException(" connt failed. record is null.");
        }
        Object obj = record.getParamValue(TLVMOMsg.COUNT.getParamIndex());
        if (obj == null || !(obj instanceof IsmInteger)) {
            throw new IsmException(33L);
        }
        return ((IsmInteger)obj).intValue();
    }

    @Override
    public List<Record> pmAssociate(int srcMOType, int associateMOType, String associateMOID, int timeout) throws IsmException {
        Param srcmoTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(srcMOType));
        Param associateMOTypeParam = new Param(TLVMOMsg.ASSOCIATEOBJTYPE.getParamIndex(), TLVMOMsg.ASSOCIATEOBJTYPE.getParamType(), (IsmInteger)new UnsignedInt32(associateMOType));
        Param associateMOIDParam = new Param(TLVMOMsg.ASSOCIATEOBJID.getParamIndex(), TLVMOMsg.ASSOCIATEOBJID.getParamType(), associateMOID);
        return this.bacthNext(0xD0000A000L, TLVUtils.addParam(Collections.EMPTY_LIST, srcmoTypeParam, associateMOTypeParam, associateMOIDParam), timeout);
    }

    @Override
    public Record pmCreateAssociate(int srcMOType, String srcMOID, int associateMOType, String associateMOID, List<Param> tlvParams, int timeout) throws IsmException {
        Param srcmoTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(srcMOType));
        Param srcmoidTypeParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), srcMOID);
        Param associateMOTypeParam = new Param(TLVMOMsg.ASSOCIATEOBJTYPE.getParamIndex(), TLVMOMsg.ASSOCIATEOBJTYPE.getParamType(), (IsmInteger)new UnsignedInt32(associateMOType));
        Param associateMOIDParam = new Param(TLVMOMsg.ASSOCIATEOBJID.getParamIndex(), TLVMOMsg.ASSOCIATEOBJID.getParamType(), associateMOID);
        return this.invoke(0xD00005000L, TLVUtils.addParam(tlvParams, srcmoTypeParam, srcmoidTypeParam, associateMOTypeParam, associateMOIDParam), timeout);
    }

    @Override
    public void pmRemoveAssociate(int srcMOType, String srcMOID, int associateMOType, String associateMOID, List<Param> tlvParams, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(srcMOType));
        Param moidTypeParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), srcMOID);
        Param associateMOTypeParam = new Param(TLVMOMsg.ASSOCIATEOBJTYPE.getParamIndex(), TLVMOMsg.ASSOCIATEOBJTYPE.getParamType(), (IsmInteger)new UnsignedInt32(associateMOType));
        Param associateMOIDParam = new Param(TLVMOMsg.ASSOCIATEOBJID.getParamIndex(), TLVMOMsg.ASSOCIATEOBJID.getParamType(), associateMOID);
        this.sendCMD(0xD00007000L, TLVUtils.addParam(tlvParams, moTypeParam, moidTypeParam, associateMOTypeParam, associateMOIDParam), timeout);
    }

    @Override
    public DataPackage sendAndReceive(Socket socket, DataPackage sendData, int timeout) throws IsmException {
        DataPackage receivedDataPackage = null;
        try {
            this.sendDataPackage(socket, sendData, timeout);
            byte[] result = this.receiveByteStream(socket);
            receivedDataPackage = this.decodeByteStream(result);
            if (StringUtils.getCheckItemValue("is.print.tlv.log")) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("RECEIVE FROM " + socket.getRemoteSocketAddress() + ":\n" + receivedDataPackage.getHead().toString() + ",result data:" + receivedDataPackage.getRecordset());
                }
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("RECEIVE FROM " + socket.getRemoteSocketAddress() + ":\n" + receivedDataPackage.getHead().toString());
            }
        }
        catch (IsmException exception) {
            StringBuffer loginfo = new StringBuffer();
            loginfo.append("Error: sendAndReceive Exception.\nconnection: ").append(socket.getRemoteSocketAddress()).append("\nrequest msg: ").append(sendData.toString());
            LOGGER.warn(loginfo.toString(), (Throwable)exception);
            receivedDataPackage = this.processAuthenticateException(socket, exception, sendData, timeout);
        }
        return receivedDataPackage;
    }

    public Socket getSocketByIP(String addr) throws IsmException {
        Socket socket = null;
        SocketPool socketPool = this.getSocketPool();
        if (socketPool == null) {
            try {
                socket = NetUtil.connect(addr, this.port, this.protocolType, null);
                this.notifyStateChanged(IConnection.ConnectionState.Connected);
            }
            catch (Exception e) {
                this.notifyStateChanged(IConnection.ConnectionState.Disconnected);
                throw new IsmException(1073949185L, (Throwable)e);
            }
        }
        try {
            socket = socketPool.getSocketByIP(addr);
        }
        catch (InterruptedException e) {
            throw new IsmException(0x100000005L, (Throwable)e);
        }
        catch (IsmException e) {
            this.notifyStateChanged(IConnection.ConnectionState.Disconnected);
            throw e;
        }
        return socket;
    }

    @Override
    public Socket getSocket() throws IsmException {
        Socket socket = null;
        SocketPool socketPool = this.getSocketPool();
        if (socketPool == null) {
            try {
                socket = NetUtil.connect(this.ip, this.port, this.protocolType, null);
            }
            catch (Exception e) {
                throw new IsmException(1073949185L, (Throwable)e);
            }
        }
        try {
            socket = socketPool.getSocket();
        }
        catch (InterruptedException e) {
            throw new IsmException(0x100000005L, (Throwable)e);
        }
        return socket;
    }

    private Socket getSocketWithRetryTime(int retryTimes) throws IsmException {
        Socket socket = null;
        SocketPool socketPool = this.getSocketPool();
        if (socketPool == null) {
            LOGGER.info("socketPool is null.");
            try {
                socket = NetUtil.connect(this.ip, this.port, this.protocolType, retryTimes, null);
            }
            catch (Exception e) {
                throw new IsmException(1073949185L, (Throwable)e);
            }
        }
        LOGGER.info("socketPool isn't null.");
        try {
            socket = socketPool.getSocket();
        }
        catch (InterruptedException e) {
            throw new IsmException(0x100000005L, (Throwable)e);
        }
        return socket;
    }

    @Override
    public void releaseSocket(Socket socket) throws IsmException {
        if (socket == null) {
            return;
        }
        SocketPool socketPool = this.getSocketPool();
        boolean releaseOK = false;
        if (socketPool != null) {
            releaseOK = socketPool.releaseSocket(socket);
        }
        if (!releaseOK) {
            this.clean(socket);
        }
    }

    @Override
    public User getLoginUser() {
        return this.loginUser;
    }

    @Override
    public User authenticate(Socket socket) {
        String localIP = NetUtil.queryLocalIP(this.ip, this.port);
        return this.authenticateByLocalIP(socket, localIP);
    }
}

