/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolManager.class);
    private static ThreadPoolManager instance = new ThreadPoolManager();
    private ExecutorService refreshExcutor = new ThreadPoolExecutor(8, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private ScheduledThreadPoolExecutor heartBeatExcutor = new ScheduledThreadPoolExecutor(3);
    private ExecutorService newCachedExcutor = Executors.newCachedThreadPool();
    private ReavedTask reavedTask = new ReavedTask();
    private ExecutorService asyncExcutor = new ThreadPoolExecutor(2, 256, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    private ThreadPoolManager() {
        this.newCachedExcutor.execute(this.reavedTask);
    }

    public static ThreadPoolManager getInstance() {
        return instance;
    }

    public void shutdown() {
        this.reaveExecute(new InterruptTask());
        this.shutdownExcuter(this.refreshExcutor);
        this.shutdownExcuter(this.heartBeatExcutor);
        this.shutdownExcuter(this.newCachedExcutor);
        this.shutdownExcuter(this.asyncExcutor);
    }

    private void shutdownExcuter(ExecutorService tempExcutor) {
        try {
            tempExcutor.shutdown();
        }
        catch (Throwable e) {
            LOGGER.error("", e);
        }
    }

    public void execute(Runnable command) {
        this.newCachedExcutor.execute(command);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.newCachedExcutor.submit(task);
    }

    public void executeAndLogException(Runnable command) {
        this.executeAndLogException(command, null);
    }

    public void reaveExecute(Runnable command) {
        this.reavedTask.setCommand(command);
    }

    public void executeAndLogException(Runnable command, String taskName) {
        MyCommand task = new MyCommand(command, taskName);
        this.newCachedExcutor.execute(task);
    }

    public ExecutorService getAsyncExcutor() {
        return this.asyncExcutor;
    }

    public ScheduledThreadPoolExecutor getHeartBeatExcutor() {
        return this.heartBeatExcutor;
    }

    public ExecutorService getRefreshExcutor() {
        return this.refreshExcutor;
    }

    static final class ReavedTask
    implements Runnable {
        private Runnable command;
        private long num = 0L;

        ReavedTask() {
        }

        public synchronized void setCommand(Runnable command) {
            this.notifyAll();
            this.command = command;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("ReavedTask");
            while (this.toRun()) {
            }
        }

        private synchronized boolean toRun() {
            try {
                while (null == this.command) {
                    this.wait();
                }
                Runnable tmpCmd = this.command;
                this.command = null;
                tmpCmd.run();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("ReavedTask execute times: " + this.num++);
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
            return true;
        }
    }

    private static final class InterruptTask
    implements Runnable {
        private InterruptTask() {
        }

        @Override
        public void run() {
            Thread.currentThread().interrupt();
        }
    }

    private static final class MyCommand
    implements Runnable {
        private final Runnable command;
        private final String taskName;

        private MyCommand(Runnable command, String taskName) {
            this.taskName = taskName;
            this.command = command;
        }

        @Override
        public void run() {
            String oldName = Thread.currentThread().getName();
            try {
                if (null != this.taskName) {
                    Thread.currentThread().setName(this.taskName);
                }
                this.command.run();
            }
            catch (Exception e) {
                LOGGER.error("Task :" + this.taskName, (Throwable)e);
            }
            finally {
                Thread.currentThread().setName(oldName);
            }
        }
    }
}

