/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv.server;

import com.huawei.ism.common.TimerTaskManager;
import com.huawei.ism.connection.ConnectionManager;
import com.huawei.ism.connection.TLVConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.DataPackage;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.server.ITLVMsgHandler;
import com.huawei.ism.tlv.server.TLVSession;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransferMsgHandler
implements ITLVMsgHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTransferMsgHandler.class);
    private static final int TIME_IN_MS = 600000;
    private TLVConnection conn;
    private Map<Socket, Socket> socketPair = new Hashtable<Socket, Socket>();
    private Map<Socket, Long> socketActiveTimeMap = new Hashtable<Socket, Long>();

    public FileTransferMsgHandler(String deviceID) {
        this.conn = (TLVConnection)ConnectionManager.getInstance().getConnection(deviceID);
        TimerTaskManager.getInstance().scheduleCommonTask(new Runnable(){

            @Override
            public void run() {
                try {
                    Iterator iterator = FileTransferMsgHandler.this.socketActiveTimeMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Long lastActiveTime = (Long)entry.getValue();
                        if (System.currentTimeMillis() - lastActiveTime <= 600000L) continue;
                        iterator.remove();
                        Socket deviceSocket = (Socket)FileTransferMsgHandler.this.socketPair.remove(entry.getKey());
                        FileTransferMsgHandler.this.conn.releaseSocket(deviceSocket);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }, 0, 600000, TimeUnit.MILLISECONDS);
    }

    @Override
    public DataPackage handle(TLVSession session, DataPackage data) {
        Record record = null;
        if (data.getRecordCount() <= 0) {
            LOGGER.info("DataPackage don't have record.");
            return TLVUtils.errorCodePackage(-1L);
        }
        record = data.getRecordset().get(0);
        Socket socket = session.getSocket();
        if (socket == null || record.getMsgCode() != 55847747713L) {
            return TLVUtils.errorCodePackage(-1L);
        }
        int dataStartIndex = record.getParamIntValue(TLV.FileTransfer.START.getParamIndex()).intValue();
        Object dataEnd = record.getParamValue(TLV.FileTransfer.END.getParamIndex());
        if (dataStartIndex == 0 && this.socketPair.get(socket) == null) {
            return this.dealFirstConnection(data, socket);
        }
        if (dataStartIndex > 0 && this.socketPair.get(socket) != null) {
            return this.dealTransaction(data, socket);
        }
        if (dataEnd != null && ((String)dataEnd).equalsIgnoreCase("END_OF_FILE") && this.socketPair.get(socket) != null) {
            return this.dealTransactionFinish(data, socket);
        }
        return TLVUtils.errorCodePackage(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataPackage dealTransactionFinish(DataPackage data, Socket socket) {
        DataPackage dp;
        Socket deviceSocket = this.socketPair.remove(socket);
        this.socketActiveTimeMap.remove(socket);
        try {
            dp = this.conn.sendAndReceive(deviceSocket, data, 30);
        }
        finally {
            try {
                this.conn.releaseSocket(deviceSocket);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(FileTransferMsgHandler.class).error("release socket failed!" + e);
            }
        }
        return dp;
    }

    private DataPackage dealTransaction(DataPackage data, Socket socket) {
        DataPackage dp;
        Socket deviceSocket = this.socketPair.get(socket);
        try {
            dp = this.conn.sendAndReceive(deviceSocket, data, 30);
            this.socketActiveTimeMap.put(socket, System.currentTimeMillis());
        }
        catch (IsmException e) {
            this.socketPair.remove(socket);
            this.socketActiveTimeMap.remove(socket);
            this.conn.releaseSocket(deviceSocket);
            throw e;
        }
        return dp;
    }

    private DataPackage dealFirstConnection(DataPackage data, Socket socket) {
        DataPackage dp;
        Socket deviceSocket = this.conn.getSocket();
        this.socketPair.put(socket, deviceSocket);
        this.socketActiveTimeMap.put(socket, System.currentTimeMillis());
        try {
            dp = this.conn.sendAndReceive(deviceSocket, data, 30);
        }
        catch (IsmException e) {
            this.socketPair.remove(socket);
            this.socketActiveTimeMap.remove(socket);
            this.conn.releaseSocket(deviceSocket);
            throw e;
        }
        return dp;
    }
}

