/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms.help;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.forms.help.HelpKeyGetter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

@Deprecated
public class HelpManager {
    public static final String PLATFORM_HELPSET_NAME = "helpset.hs";
    private static HelpManager instance = null;

    private String getHelpSetName(String identifier, String type) {
        String helpSetName = ResourceManager.getLocale().getLanguage() + '_' + PLATFORM_HELPSET_NAME;
        String vendor = Framework.getInstance().getStrProperty("VENDER");
        if (null != vendor) {
            helpSetName = vendor + "_" + helpSetName;
        }
        if (null != type) {
            helpSetName = type.toUpperCase(ResourceManager.getLocale()) + '_' + helpSetName;
        }
        if (null != identifier) {
            helpSetName = identifier + '_' + helpSetName;
        }
        return helpSetName;
    }

    private String getDeviceType(String deviceID, String identifier) {
        String deviceTypeStr = null;
        Launcher selectLaucher = LauncherManager.getInstance().getLauncher(deviceID);
        if (null == selectLaucher) {
            return deviceTypeStr;
        }
        DeviceType deviceType = selectLaucher.getDeviceContext().getDeviceType();
        deviceTypeStr = deviceType.name();
        if (DeviceType.S5500 == deviceType || DeviceType.S5300 == deviceType || DeviceType.S5600 == deviceType) {
            deviceTypeStr = DeviceType.S5000.name();
        } else if (DeviceType.NEX == deviceType || DeviceType.C3 == deviceType) {
            deviceTypeStr = selectLaucher.getDeviceContext().getDeviceModelType().toString();
            if (DeviceType.NEX == deviceType) {
                deviceTypeStr = deviceTypeStr + "_" + deviceType.toString();
            }
        }
        String productVersion = selectLaucher.getProductVersion();
        if (!"".equals(productVersion) && null == identifier) {
            deviceTypeStr = deviceTypeStr + productVersion;
        }
        return deviceTypeStr;
    }

    public void helpMenuItem(ActionEvent actionEvent, String mapID) {
        if (null == mapID) {
            return;
        }
        new HelpHandler(mapID).actionPerformed(actionEvent);
    }

    public static HelpManager getInstance() {
        if (null == instance) {
            instance = new HelpManager();
        }
        return instance;
    }

    public void displayHelp(String mapID) {
        new HelpHandler(mapID).actionPerformed(null);
    }

    public void linkHelp(AbstractButton component, String mapID) {
        ActionListener[] listeners;
        for (ActionListener actionListener : listeners = component.getActionListeners()) {
            if (!(actionListener instanceof HelpHandler)) continue;
            component.removeActionListener(actionListener);
        }
        HelpHandler listener = new HelpHandler(mapID);
        component.addActionListener(listener);
    }

    public void linkEventHelp(AbstractButton component, String mapID, String deviceID) {
        ActionListener[] listeners;
        String helpIdentifier = "Event";
        for (ActionListener actionListener : listeners = component.getActionListeners()) {
            if (actionListener instanceof HelpHandler) {
                component.removeActionListener(actionListener);
                continue;
            }
            if (!(actionListener instanceof EventHelpActionListener)) continue;
            component.removeActionListener(actionListener);
        }
        EventHelpActionListener listener = null;
        listener = new EventHelpActionListener(mapID, helpIdentifier, deviceID);
        component.addActionListener(listener);
    }

    public void linkHelp(AbstractButton component, HelpKeyGetter keyGetter) {
        ActionListener[] listeners;
        for (ActionListener actionListener : listeners = component.getActionListeners()) {
            if (!(actionListener instanceof HelpHandler)) continue;
            component.removeActionListener(actionListener);
        }
        HelpHandler listener = new HelpHandler(keyGetter);
        component.addActionListener(listener);
    }

    public void linkHelp(JComponent component, HelpKeyGetter keyGetter) {
        MouseListener[] listeners;
        for (MouseListener handler : listeners = component.getMouseListeners()) {
            if (!(handler instanceof HelpHandler)) continue;
            component.removeMouseListener(handler);
        }
        HelpHandler listener = new HelpHandler(keyGetter);
        component.addMouseListener(listener);
    }

    private class EventHelpActionListener
    implements ActionListener {
        private String key = null;
        private String identifier = null;
        private String deviceID = null;

        public EventHelpActionListener(String key, String identifier, String deviceID) {
            this.key = key;
            this.identifier = identifier;
            this.deviceID = deviceID;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class HelpHandler
    extends MouseAdapter
    implements ActionListener {
        private String key = null;
        private HelpKeyGetter keyGetter = null;

        public HelpHandler(String key) {
            this.key = key;
        }

        public HelpHandler(HelpKeyGetter keyGetter) {
            this.keyGetter = keyGetter;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.popHelpFrame();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Component source = mouseEvent.getComponent();
            if (source instanceof JComponent && !(source instanceof AbstractButton)) {
                JComponent srcComp = (JComponent)source;
                srcComp.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Component source = mouseEvent.getComponent();
            if (source instanceof JComponent && !(source instanceof AbstractButton)) {
                JComponent srcComp = (JComponent)source;
                srcComp.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.popHelpFrame();
        }

        private void popHelpFrame() {
        }

        private String getHelpSetName() {
            String helpSetName = ResourceManager.getLocale().getLanguage() + '_' + HelpManager.PLATFORM_HELPSET_NAME;
            String productIdentifier = "array_";
            Launcher launcher = LauncherManager.getInstance().getActivedLauncher();
            if (null != launcher) {
                DeviceType deviceType = launcher.getDeviceContext().getDeviceType();
                if (deviceType == DeviceType.N8000) {
                    productIdentifier = "n8000_";
                } else if (deviceType == DeviceType.VIS) {
                    productIdentifier = "vis_";
                } else if (deviceType == DeviceType.S8000) {
                    productIdentifier = "s8000_";
                } else if (deviceType == DeviceType.NEX) {
                    String productVersion = launcher.getProductVersion();
                    if ("R002".equals(productVersion)) {
                        productIdentifier = "nex_r2_";
                    }
                } else if (deviceType == DeviceType.C3) {
                    String productVersion = launcher.getProductVersion();
                    if ("XVEC00".equals(productVersion)) {
                        productIdentifier = "xve_c00_";
                    } else if ("XVEC01".equals(productVersion)) {
                        productIdentifier = "xve_c01_";
                    } else if ("HVS".equals(productVersion)) {
                        productIdentifier = "hvs_";
                    }
                }
            }
            helpSetName = productIdentifier + helpSetName;
            return helpSetName;
        }

        private String getDefaultHelpSetName() {
            String helpSetName = ResourceManager.getLocale().getLanguage() + '_' + HelpManager.PLATFORM_HELPSET_NAME;
            String productIdentifier = "array_";
            helpSetName = productIdentifier + helpSetName;
            return helpSetName;
        }
    }
}

