/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.event;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.BatchExecutionException;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.excel.CsvUtils;
import com.huawei.ism.ui.module.event.EventDetailDialog;
import com.huawei.ism.ui.module.event.EventManager;
import com.huawei.ism.ui.module.event.EventManagerLayout;
import com.huawei.ism.ui.module.event.EventManagerListener;
import com.huawei.ism.ui.module.event.EventTabLayout;
import com.huawei.ism.ui.module.event.FaultTabLayout;
import com.huawei.ism.ui.swing.IsmFileChooser;
import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.swing.dialog.ConfirmDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.MultiErrorDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.KeywordFilterField;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManagerPanel
extends PropertyPane
implements EventManagerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventManagerPanel.class);
    static final Pair<?, ?> COMBOBOX_ITEM_ALL_LEVEL = new Pair<String, String>("COMBOBOX_ITEM_ALL_LEVEL", ResourceManager.getString("EVENT_ALL_LEVEL"));
    static final Pair<?, ?> COMBOBOX_ITEM_ALL_SOURCE = new Pair<String, String>("COMBOBOX_ITEM_ALL_SOURCE", ResourceManager.getString("EVENT_ALL_SOURCE"));
    static final Pair<?, ?> COMBOBOX_ITEM_ALL_DEVICE = new Pair<String, String>("COMBOBOX_ITEM_ALL_DEVICE", ResourceManager.getString("EVENT_ALL_DEVICE"));
    static final Pair<?, ?> COMBOBOX_ITEM_SELECT_SOURCE = new Pair<String, String>("COMBOBOX_ITEM_SELECT_SOURCE", ResourceManager.getString("EVENT_SELECT_SOURCE"));
    static final Pair<?, ?> COMBOBOX_ITEM_SELECT_DEVICE = new Pair<String, String>("COMBOBOX_ITEM_SELECT_DEVICE", ResourceManager.getString("EVENT_SELECT_DEVICE"));
    private static final long serialVersionUID = 1L;
    private Window parent = null;
    private EventManagerLayout layout;
    private Map<String, Set<String>> deviceIDMap = new HashMap<String, Set<String>>(0);

    public EventManagerPanel(Window parent) {
        this.parent = parent;
        this.layout = new EventManagerLayout();
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
        this.initFilterComponents();
        this.initListeners();
        this.updateButtonState();
    }

    public void setFilter(Event.Level level, String deviceID) {
        int size;
        JComboBox deviceComboBox = this.layout.getFaultLayout().getDeviceComboBox();
        if (null == deviceID) {
            deviceComboBox.setSelectedIndex(0);
        } else {
            Pair item = null;
            size = deviceComboBox.getItemCount();
            for (int i = 0; i < size; ++i) {
                item = (Pair)deviceComboBox.getItemAt(i);
                if (!deviceID.equals(item.getKey())) continue;
                deviceComboBox.setSelectedIndex(i);
                break;
            }
        }
        JComboBox levelBox = this.layout.getFaultLayout().getLevelComboBox();
        if (null == level || !level.isFault()) {
            levelBox.setSelectedIndex(0);
        } else {
            size = levelBox.getItemCount();
            Pair item = null;
            for (int i = 0; i < size; ++i) {
                item = (Pair)levelBox.getItemAt(i);
                if (!level.equals(item.getKey())) continue;
                levelBox.setSelectedIndex(i);
                break;
            }
        }
        this.refreshSourceComboBox(this.layout.getFaultLayout().getDeviceComboBox());
        this.updateButtonState();
    }

    public void remvoeAllTableEvent() {
        if (null != this.layout.getFaultTableModel()) {
            this.layout.getFaultTableModel().removeAll();
        }
        if (null != this.layout.getEventTableModel()) {
            this.layout.getEventTableModel().removeAll();
        }
    }

    public void synWithEventCache() {
        this.layout.getFaultTableModel().removeAll();
        this.fireFaultEventsAdded(EventManager.getInstance().getAllEvents());
        List<String> sourceIDs = EventManager.getInstance().getSourceIDs();
        this.deviceIDMap.clear();
        this.fireSourceAdded(sourceIDs.toArray(new String[sourceIDs.size()]));
    }

    private void initListeners() {
        this.layout.getFaultTable().addMouseListener(new DoubleClickAdapter(this.layout.getFaultTable()));
        this.layout.getEventTable().addMouseListener(new DoubleClickAdapter(this.layout.getEventTable()));
        this.layout.getEventTabbedPane().addChangeListener(this.getEventTabbedListener());
        ListenerProxy proxy = new ListenerProxy();
        this.layout.getEventTable().addListSelectionListener(proxy);
        this.layout.getFaultTable().addListSelectionListener(proxy);
        this.layout.getEventLayout().getSourceComboBox().addItemListener(proxy);
        this.layout.getFaultLayout().getSourceComboBox().addItemListener(proxy);
        this.layout.getEventLayout().getDeviceComboBox().addItemListener(proxy);
        this.layout.getFaultLayout().getDeviceComboBox().addItemListener(proxy);
        this.layout.getEventLayout().getQueryButton().addActionListener(this.getQueryEventsActionListener());
        this.layout.getFaultLayout().getRefreshButton().addActionListener(this.getRefreshActionListener());
        this.layout.getFaultLayout().getClearButton().addActionListener(this.getFaultClearListener());
        this.layout.getFaultLayout().getSaveButton().addActionListener(this.getSaveMarkedAlarmActionListener());
        this.layout.getEventLayout().getSaveButton().addActionListener(this.getSaveMarkedAlarmActionListener());
        this.initFilterActions();
    }

    private ChangeListener getEventTabbedListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EventManagerPanel.this.updateButtonState();
            }
        };
    }

    private ActionListener getFaultClearListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String description = ResourceManager.getString("ALARM_CLEAR_DESC");
                String result = ResourceManager.getString("ALARM_CLEAR_SUGGESTION");
                if (ConfirmDialog.showDialog(EventManagerPanel.this.parent, ConfirmDialog.Level.INFO, description, result, "", "")) {
                    List toBeClearedEvents = EventManagerPanel.this.getMarkedEvent();
                    EventTaskRequester.doClearFaultTask(EventManagerPanel.this.parent, toBeClearedEvents);
                }
            }
        };
    }

    private void initFilterComponents() {
        this.layout.getFaultLayout().getSourceComboBox().addItem(COMBOBOX_ITEM_ALL_SOURCE);
        this.layout.getFaultLayout().getDeviceComboBox().addItem(COMBOBOX_ITEM_ALL_DEVICE);
        this.layout.getEventLayout().getSourceComboBox().addItem(COMBOBOX_ITEM_SELECT_SOURCE);
        this.layout.getEventLayout().getDeviceComboBox().addItem(COMBOBOX_ITEM_SELECT_DEVICE);
        this.layout.getFaultLayout().getLevelComboBox().addItem(COMBOBOX_ITEM_ALL_LEVEL);
        this.layout.getEventLayout().getLevelComboBox().addItem(COMBOBOX_ITEM_ALL_LEVEL);
        Pair<Event.Level, Event.Level> levelItem = null;
        for (Event.Level level : Event.Level.values()) {
            levelItem = new Pair<Event.Level, Event.Level>(level, level);
            if (level.isFault()) {
                this.layout.getFaultLayout().getLevelComboBox().addItem(levelItem);
            }
            this.layout.getEventLayout().getLevelComboBox().addItem(levelItem);
        }
    }

    private ActionListener getClearFilterListener(FaultTabLayout faultTab) {
        return new MyClearActionListner(faultTab);
    }

    private ActionListener getClearEventFilterListener(EventTabLayout eventTab) {
        return new ClearActionListner(eventTab);
    }

    private ChangeListener getKeywordFilterChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EventManagerPanel.this.updateClearFilterButtonState();
            }
        };
    }

    private ItemListener getFaultTabItemListener(final FaultTabLayout faultTab) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EventManagerPanel.this.updateClearFilterButtonState();
                    faultTab.getKeywordFilter().updateFilter();
                }
            }
        };
    }

    private ItemListener getDeviceItemListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EventManagerPanel.this.updateClearFilterButtonState();
                    EventManagerPanel.this.refreshSourceComboBox((JComboBox)e.getSource());
                }
            }
        };
    }

    private ItemListener getEventLevelListener(final EventTabLayout eventTab) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EventManagerPanel.this.updateClearFilterButtonState();
                    eventTab.getKeywordFilter().updateFilter();
                }
            }
        };
    }

    private ItemListener getFauleLevelListener(final FaultTabLayout faultTab) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EventManagerPanel.this.updateClearFilterButtonState();
                    faultTab.getKeywordFilter().updateFilter();
                }
            }
        };
    }

    private void initFilterActions() {
        FaultTabLayout faultTab = this.layout.getFaultLayout();
        EventTabLayout eventTab = this.layout.getEventLayout();
        faultTab.getClearFilterButton().addActionListener(this.getClearFilterListener(faultTab));
        eventTab.getClearFilterButton().addActionListener(this.getClearEventFilterListener(eventTab));
        faultTab.getKeywordFilter().addChangeListener(this.getKeywordFilterChangeListener());
        eventTab.getKeywordFilter().addChangeListener(this.getKeywordFilterChangeListener());
        faultTab.getSourceComboBox().addItemListener(this.getFaultTabItemListener(faultTab));
        faultTab.getDeviceComboBox().addItemListener(this.getDeviceItemListener());
        eventTab.getDeviceComboBox().addItemListener(this.getDeviceItemListener());
        eventTab.getLevelComboBox().addItemListener(this.getEventLevelListener(eventTab));
        faultTab.getLevelComboBox().addItemListener(this.getFauleLevelListener(faultTab));
        ComboBoxModel faultSourceModel = faultTab.getSourceComboBox().getModel();
        ComboBoxModel faultLevelModel = faultTab.getLevelComboBox().getModel();
        faultTab.getKeywordFilter().setExtFilter(new DeviceAndLevelFilter(faultSourceModel, faultLevelModel));
        ComboBoxModel eventLevelModel = eventTab.getLevelComboBox().getModel();
        eventTab.getKeywordFilter().setExtFilter(new DeviceAndLevelFilter(eventLevelModel));
    }

    private void updateClearFilterButtonState() {
        FaultTabLayout faultTab = this.layout.getFaultLayout();
        EventTabLayout eventTab = this.layout.getEventLayout();
        boolean isEnabled = false;
        isEnabled |= faultTab.getKeywordFilter().getKeyword().length() > 0;
        isEnabled |= faultTab.getSourceComboBox().getSelectedIndex() > 0;
        isEnabled |= faultTab.getLevelComboBox().getSelectedIndex() > 0;
        faultTab.getClearFilterButton().setEnabled(isEnabled |= faultTab.getDeviceComboBox().getSelectedIndex() > 0);
        isEnabled = false;
        isEnabled |= eventTab.getKeywordFilter().getKeyword().length() > 0;
        eventTab.getClearFilterButton().setEnabled(isEnabled |= eventTab.getLevelComboBox().getSelectedIndex() > 0);
    }

    private ActionListener getRefreshActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTaskRequester.doRefreshFaultEventsTask(EventManagerPanel.this.parent, EventManagerPanel.this.getSelectedSourceID());
            }
        };
    }

    private ActionListener getQueryEventsActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = EventManagerPanel.this.getSelectedSourceID();
                if (!list.isEmpty()) {
                    EventTaskRequester.doRefreshAllEventsTask(EventManagerPanel.this.parent, (String)list.get(0));
                    EventManagerPanel.this.sortTime();
                }
            }
        };
    }

    private ActionListener getSaveMarkedAlarmActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List markedEvents = EventManagerPanel.this.getMarkedEvent();
                EventTaskRequester.doSaveMarkedEventTask(EventManagerPanel.this.parent, markedEvents, EventManagerPanel.this.isFaultTabSelected());
            }
        };
    }

    @Override
    public void fireFaultCleared(Collection<Event> events, Map<Event.Identifier, Long> failedMap) {
        ArrayList<TableRow<Event, Event.Identifier>> tableRows = new ArrayList<TableRow<Event, Event.Identifier>>(0);
        TimeZone zone = null;
        TableRow<Event, Event.Identifier> tableRow = null;
        for (Event ev : events) {
            if (failedMap.containsKey(ev.getIdentifier())) continue;
            zone = Framework.getDeviceTimeZone(ev.getIdentifier().getDeviceID());
            tableRow = this.convertFaultRow(ev, zone);
            tableRows.add(tableRow);
        }
    }

    @Override
    public void fireSourceAdded(String ... sourceIDs) {
        Set<String> sourceIDSet = null;
        Pair<String, String> deviceItem = null;
        Launcher laun = null;
        String deviceID = null;
        boolean hasDev = false;
        String deviceName = null;
        for (String sourceID : sourceIDs) {
            laun = LauncherManager.getInstance().findDeviceOwner(sourceID);
            if (null == laun) continue;
            deviceID = laun.getDeviceID();
            hasDev = true;
            if (!this.deviceIDMap.containsKey(deviceID)) {
                this.deviceIDMap.put(deviceID, new HashSet(0));
                hasDev = false;
            }
            if (!(sourceIDSet = this.deviceIDMap.get(deviceID)).contains(sourceID)) {
                sourceIDSet.add(sourceID);
            }
            if (hasDev) continue;
            deviceName = EventManagerPanel.getDeviceName(deviceID);
            deviceItem = new Pair<String, String>(deviceID, deviceName);
            this.layout.getEventLayout().getDeviceComboBox().addItem(deviceItem);
            this.layout.getFaultLayout().getDeviceComboBox().addItem(deviceItem);
        }
    }

    private void refreshSourceComboBox(JComboBox dc) {
        JComboBox sc = this.layout.getFaultLayout().getSourceComboBox();
        KeywordFilterField kf = this.layout.getFaultLayout().getKeywordFilter();
        Object selObj = sc.getSelectedItem();
        boolean isEventTab = false;
        if (dc == this.layout.getEventLayout().getDeviceComboBox()) {
            isEventTab = true;
            sc = this.layout.getEventLayout().getSourceComboBox();
            kf = this.layout.getEventLayout().getKeywordFilter();
        }
        if (sc.getItemCount() > 1) {
            int len = sc.getItemCount();
            for (int i = 1; i < len; ++i) {
                sc.removeItemAt(1);
            }
        }
        Pair selItem = (Pair)dc.getSelectedItem();
        ArrayList<String> deviceIDs = new ArrayList<String>(0);
        if (selItem.equals(COMBOBOX_ITEM_SELECT_DEVICE)) {
            LOGGER.info("COMBOBOX_ITEM_SELECT_DEVICE selected");
        } else if (selItem.equals(COMBOBOX_ITEM_ALL_DEVICE)) {
            deviceIDs.addAll(this.deviceIDMap.keySet());
        } else {
            deviceIDs.add((String)selItem.getKey());
        }
        Pair<String, String> item = null;
        String sourceName = null;
        for (String deviceID : deviceIDs) {
            for (String sourceID : this.deviceIDMap.get(deviceID)) {
                sourceName = EventManagerPanel.getDeviceName(sourceID);
                item = new Pair<String, String>(sourceID, sourceName);
                sc.addItem(item);
            }
        }
        if (isEventTab && sc.getItemCount() == 2) {
            sc.setSelectedIndex(1);
        } else if (null != selObj) {
            sc.setSelectedItem(selObj);
        }
        kf.updateFilter();
    }

    public void fireClearAllEvents() {
        this.layout.getEventTableModel().removeAll();
    }

    @Override
    public void fireSourceRemoved(String ... deviceIDs) {
        Pair<String, String> item = null;
        String deviceName = null;
        List<TableRow> tableRows = null;
        Event curEvent = null;
        ArrayList<TableRow> rowsToBeDeleted = null;
        for (String devID : deviceIDs) {
            deviceName = EventManagerPanel.getDeviceName(devID);
            item = new Pair<String, String>(devID, deviceName);
            this.layout.getEventLayout().getSourceComboBox().removeItem(item);
            this.layout.getFaultLayout().getSourceComboBox().removeItem(item);
            tableRows = this.layout.getEventTableModel().getAllRows();
            rowsToBeDeleted = new ArrayList<TableRow>(0);
            for (TableRow row : tableRows) {
                curEvent = (Event)row.getUserObject();
                if (!curEvent.getIdentifier().getDeviceID().equals(devID)) continue;
                rowsToBeDeleted.add(row);
            }
            this.layout.getEventTableModel().removeRow(rowsToBeDeleted.toArray(new TableRow[rowsToBeDeleted.size()]));
            this.layout.getFaultTableModel().removeRow(rowsToBeDeleted.toArray(new TableRow[rowsToBeDeleted.size()]));
        }
    }

    @Override
    public void fireFaultEventsAdded(Collection<Event> events) {
        ArrayList<TableRow<Event, Event.Identifier>> faultToBeAdded = new ArrayList<TableRow<Event, Event.Identifier>>(0);
        TimeZone zone = null;
        for (Event ev : events) {
            if (!ev.getLevel().isFault() || ev.isRecovered()) continue;
            zone = Framework.getDeviceTimeZone(ev.getIdentifier().getDeviceID());
            faultToBeAdded.add(this.convertFaultRow(ev, zone));
        }
        this.layout.getFaultTableModel().addRow(faultToBeAdded.toArray(new TableRow[faultToBeAdded.size()]));
        this.setFilter(this.layout.getFaultLayout().getLevelComboBox());
    }

    @Override
    public void fireEventsAdded(List<Event> events) {
        this.fireClearAllEvents();
        ArrayList<TableRow<Event, Event.Identifier>> rowList = new ArrayList<TableRow<Event, Event.Identifier>>(0);
        TimeZone zone = null;
        for (Event event : events) {
            zone = Framework.getDeviceTimeZone(event.getIdentifier().getDeviceID());
            rowList.add(this.convertEventRow(event, zone));
        }
        this.layout.getEventTableModel().addRow(rowList.toArray(new TableRow[rowList.size()]));
        this.setFilter(this.layout.getFaultLayout().getLevelComboBox());
    }

    private void setFilter(JComboBox levelbox) {
        Pair levelFilter;
        int size;
        String deviceId = null;
        JComboBox deviceComboBox = this.layout.getFaultLayout().getDeviceComboBox();
        if (null != deviceComboBox && (size = deviceComboBox.getSelectedIndex()) > 0) {
            Pair item = (Pair)deviceComboBox.getSelectedItem();
            deviceId = (String)item.getKey();
        }
        if (null != (levelFilter = (Pair)levelbox.getModel().getSelectedItem()) && levelFilter != COMBOBOX_ITEM_ALL_LEVEL) {
            Event.Level eventLevel = (Event.Level)((Object)levelFilter.getKey());
            this.setFilter(eventLevel, deviceId);
        }
    }

    @Override
    public void fireFaultEventUpdated(Collection<Event> events) {
        TimeZone timeZone = null;
        for (Event event : events) {
            if (!event.getLevel().isFault()) continue;
            timeZone = Framework.getDeviceTimeZone(event.getIdentifier().getDeviceID());
            if (!event.isRecovered()) {
                this.layout.getFaultTableModel().updateRow(this.convertFaultRow(event, timeZone));
                continue;
            }
            this.layout.getFaultTableModel().removeRow(this.convertFaultRow(event, timeZone));
        }
        this.setFilter(this.layout.getFaultLayout().getLevelComboBox());
    }

    @Override
    public void fireFaultEventRemoved(Collection<Event> events) {
        ArrayList<DefaultTableRow<Event, Event.Identifier>> faultToBeRemoved = new ArrayList<DefaultTableRow<Event, Event.Identifier>>(0);
        DefaultTableRow<Event, Event.Identifier> tableRow = null;
        for (Event event : events) {
            tableRow = new DefaultTableRow<Event, Event.Identifier>(1, event, event.getIdentifier());
            if (!event.getLevel().isFault() || event.isRecovered()) continue;
            faultToBeRemoved.add(tableRow);
        }
        this.layout.getFaultTableModel().removeRow(faultToBeRemoved.toArray(new TableRow[faultToBeRemoved.size()]));
        this.setFilter(this.layout.getFaultLayout().getLevelComboBox());
    }

    private void updateButtonState() {
        if (this.isFaultTabSelected()) {
            int sourceCount = this.layout.getFaultLayout().getSourceComboBox().getItemCount();
            int markedFaultCount = this.layout.getFaultTable().getSelectedRowCount();
            this.layout.getFaultLayout().getClearButton().setEnabled(markedFaultCount > 0);
            this.layout.getFaultLayout().getSaveButton().setEnabled(markedFaultCount > 0);
            this.layout.getFaultLayout().getRefreshButton().setEnabled(sourceCount > 1);
        } else {
            int sourceindex = this.layout.getEventLayout().getSourceComboBox().getSelectedIndex();
            int markedEventCount = this.layout.getEventTable().getSelectedRowCount();
            this.layout.getEventLayout().getSaveButton().setEnabled(markedEventCount > 0);
            this.layout.getEventLayout().getQueryButton().setEnabled(sourceindex > 0);
        }
    }

    private TableRow<Event, Event.Identifier> convertFaultRow(Event event, TimeZone zone) {
        if (null == event) {
            return null;
        }
        int columnCount = EventManagerLayout.getFaultColumnName().length;
        DefaultTableRow<Event, Event.Identifier> row = new DefaultTableRow<Event, Event.Identifier>(columnCount, event, event.getIdentifier());
        String startTime = TimeUtil.gmtToString(event.getStartTime(), zone != null ? zone : TimeZone.getDefault());
        row.setValueAt(0, SwingUtil.getLevelCell(event.getLevel()));
        row.setValueAt(1, EventManagerPanel.getDeviceName(event.getIdentifier().getDeviceID()));
        row.setValueAt(2, new IsmTableCell.HexCell(event.getEventID()));
        row.setValueAt(3, event.getDescription());
        row.setValueAt(4, startTime);
        long sn = event.getIdentifier().getEventSN();
        row.setValueAt(5, new IsmTableCell.NumberCell<Long>(sn));
        String view = ResourceManager.getString("COMMON.TXT.VIEW");
        row.setValueAt(6, new IsmTableCell.HyperlinkCell(view, new ViewActionListener(true)));
        return row;
    }

    private TableRow<Event, Event.Identifier> convertEventRow(Event event, TimeZone zone) {
        if (null == event) {
            return null;
        }
        if (null == EventManagerLayout.getEventColumnName()) {
            throw new NullPointerException();
        }
        int columnCount = EventManagerLayout.getEventColumnName().length;
        DefaultTableRow<Event, Event.Identifier> row = new DefaultTableRow<Event, Event.Identifier>(columnCount, event, event.getIdentifier());
        String startTime = TimeUtil.gmtToString(event.getStartTime(), zone);
        String recoverTime = event.isRecovered() ? TimeUtil.gmtToString(event.getRecoverTime(), zone) : "";
        row.setValueAt(0, SwingUtil.getLevelCell(event.getLevel()));
        row.setValueAt(1, EventManagerPanel.getDeviceName(event.getIdentifier().getDeviceID()));
        row.setValueAt(2, new IsmTableCell.HexCell(event.getEventID()));
        row.setValueAt(3, event.getDescription());
        row.setValueAt(4, startTime);
        row.setValueAt(5, recoverTime);
        long sn = event.getIdentifier().getEventSN();
        row.setValueAt(6, new IsmTableCell.NumberCell<Long>(sn));
        String view = ResourceManager.getString("COMMON.TXT.VIEW");
        row.setValueAt(7, new IsmTableCell.HyperlinkCell(view, new ViewActionListener(false)));
        return row;
    }

    private static String getDeviceName(String deviceID) {
        return CommonUtil.getDeviceName(deviceID);
    }

    private List<Event> getMarkedEvent() {
        ArrayList<Event> evs = new ArrayList<Event>(0);
        IsmTable table = null;
        table = this.isFaultTabSelected() ? this.layout.getFaultTable() : this.layout.getEventTable();
        List<TableRow> rows = table.getMarkedRows();
        for (TableRow row : rows) {
            evs.add((Event)row.getUserObject());
        }
        return evs;
    }

    private List<String> getSelectedSourceID() {
        JComboBox sourceComboBox = null;
        ArrayList<String> selectedDeviceID = new ArrayList<String>(0);
        sourceComboBox = this.isFaultTabSelected() ? this.layout.getFaultLayout().getSourceComboBox() : this.layout.getEventLayout().getSourceComboBox();
        if (0 != sourceComboBox.getSelectedIndex()) {
            Pair pair = (Pair)sourceComboBox.getSelectedItem();
            selectedDeviceID.add(pair.getKey().toString());
        } else if (this.isFaultTabSelected()) {
            Pair pair = null;
            for (int i = 1; i < sourceComboBox.getItemCount(); ++i) {
                pair = (Pair)sourceComboBox.getItemAt(i);
                selectedDeviceID.add(pair.getKey().toString());
            }
        }
        return selectedDeviceID;
    }

    private boolean isFaultTabSelected() {
        return this.layout.getEventTabbedPane().getSelectedIndex() == 0;
    }

    public void sortTime() {
        this.layout.getFaultTable().getRowSorter().toggleSortOrder(4);
        this.layout.getEventTable().getRowSorter().toggleSortOrder(4);
        this.layout.getFaultTable().getRowSorter().toggleSortOrder(4);
        this.layout.getEventTable().getRowSorter().toggleSortOrder(4);
    }

    @Override
    public void updateProperty(int updateMode) {
        EventTaskRequester.doRefreshFaultEventsTask(this.parent, this.getSelectedSourceID());
    }

    @Override
    public String getDeviceID() {
        return null;
    }

    @Override
    public String getHelpKey() {
        return "event_manage";
    }

    private static class DeviceAndLevelFilter
    extends RowFilter<TableModel, Integer> {
        private ComboBoxModel levelComboBoxModel;
        private ComboBoxModel sourceComboBoxModel;

        public DeviceAndLevelFilter(ComboBoxModel levelModel) {
            this.levelComboBoxModel = levelModel;
        }

        public DeviceAndLevelFilter(ComboBoxModel sourceModel, ComboBoxModel levelModel) {
            this.sourceComboBoxModel = sourceModel;
            this.levelComboBoxModel = levelModel;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> value) {
            Pair sourceFilter;
            DefaultTableModel model = (DefaultTableModel)value.getModel();
            int rowIndex = value.getIdentifier();
            TableRow row = model.getRow(rowIndex);
            Event event = (Event)row.getUserObject();
            if (null != this.sourceComboBoxModel && null != (sourceFilter = (Pair)this.sourceComboBoxModel.getSelectedItem()) && !this.filter(event, sourceFilter)) {
                return false;
            }
            Pair levelFilter = (Pair)this.levelComboBoxModel.getSelectedItem();
            if (null != levelFilter && levelFilter != COMBOBOX_ITEM_ALL_LEVEL) {
                Event.Level eventLevel = (Event.Level)((Object)levelFilter.getKey());
                if (event.getLevel() != eventLevel) {
                    return false;
                }
            }
            return true;
        }

        private boolean filter(Event event, Pair<?, ?> sourceFilter) {
            if (sourceFilter != COMBOBOX_ITEM_ALL_SOURCE) {
                String sourceID = sourceFilter.getKey().toString();
                if (!event.getIdentifier().getDeviceID().equals(sourceID)) {
                    return false;
                }
            } else {
                int length = this.sourceComboBoxModel.getSize();
                boolean isInclude = this.isInclude(event, length);
                if (!isInclude) {
                    return false;
                }
            }
            return true;
        }

        private boolean isInclude(Event event, int length) {
            boolean isInclude = false;
            Pair sf = null;
            String sourceID = null;
            for (int i = 1; i < length; ++i) {
                sf = (Pair)this.sourceComboBoxModel.getElementAt(i);
                sourceID = sf.getKey().toString();
                if (!event.getIdentifier().getDeviceID().equals(sourceID)) continue;
                isInclude = true;
                break;
            }
            return isInclude;
        }
    }

    private static class EventTaskRequester {
        private EventTaskRequester() {
        }

        public static void doClearFaultTask(Window eventManageDialog, List<Event> toBeClearedEvents) {
            List<?> failedMapList = AsyncExcutor.execute(eventManageDialog, EventTaskRequester.createClearFaultTask(toBeClearedEvents));
            EventTaskRequester.handleClearFaultResult(eventManageDialog, toBeClearedEvents, failedMapList);
        }

        public static void doRefreshFaultEventsTask(Window eventManageDialog, List<String> deviceIDs) {
            List<?> results = AsyncExcutor.execute(eventManageDialog, EventTaskRequester.createRefreshFaultEventsTask(deviceIDs));
            EventTaskRequester.handleExcuteResult(eventManageDialog, results);
        }

        public static void doRefreshAllEventsTask(Window eventManageDialog, String deviceID) {
            List<?> results = AsyncExcutor.execute(eventManageDialog, EventTaskRequester.createRefreshAllEventsTask(deviceID));
            EventTaskRequester.handleExcuteResult(eventManageDialog, results);
        }

        private static Callable createRefreshAllEventsTask(final String deviceID) {
            return new Callable(){

                public Object call() throws Exception {
                    Thread.currentThread().setName("Refresh all faults");
                    try {
                        EventManager.getInstance().refreshAllEvents(deviceID);
                    }
                    catch (Exception e) {
                        return e;
                    }
                    return "";
                }
            };
        }

        public static void doSaveAllEventTask(JDialog eventManageDialog, List<Event> events) {
            EventTaskRequester.doSaveMarkedEventTask(eventManageDialog, events, false);
        }

        public static void doSaveMarkedEventTask(Window eventManageDialog, List<Event> markedEvents, boolean saveFualt) {
            if (null == markedEvents || markedEvents.isEmpty()) {
                return;
            }
            IsmFileChooser chooser = new IsmFileChooser(ResourceManager.getString("ALARM_SAVE_TITLE"));
            if (!saveFualt) {
                chooser.setDialogTitle(ResourceManager.getString("EVENT_SAVE_TITLE"));
            }
            chooser.setName("ISMV1R2_platform_AlarmInterfaceImpl_chooser");
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.addFileFilter(new String[]{ResourceManager.getString("ALARM_EXPORT_TYPE_CSV")}, ResourceManager.getString("ALARM_EXPORT_CSV"));
            int option = chooser.showSaveDialog(eventManageDialog);
            if (option == 0) {
                File aFile = chooser.getSelectedFile();
                String name = aFile.getName();
                String tmp = EventTaskRequester.getFilePath(aFile);
                String dir = tmp.substring(0, tmp.lastIndexOf(name));
                String filetype = "." + ResourceManager.getString("ALARM_EXPORT_TYPE_CSV");
                if (-1 == name.toLowerCase(Locale.ENGLISH).indexOf(filetype)) {
                    name = name + filetype;
                }
                String filename = dir + File.separator + name;
                EventTaskRequester.saveEventToFile(eventManageDialog, markedEvents, filename, saveFualt);
            }
        }

        private static String getFilePath(File aFile) {
            try {
                return aFile.getCanonicalPath();
            }
            catch (IOException e) {
                return aFile.toPath().toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void saveEventToFile(Window eventManageDialog, List<Event> markedEvents, String fileName, boolean saveFualt) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), Charset.defaultCharset()));
                EventTaskRequester.saveEvents(markedEvents, bufferedWriter, saveFualt);
            }
            catch (Throwable e) {
                LOGGER.error("save marked alarm error :" + e);
                DialogUtils.showErrorDialog(eventManageDialog, e.getMessage());
            }
            finally {
                if (null != bufferedWriter) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                }
            }
            DialogUtils.showInfoDialog(eventManageDialog);
        }

        private static void saveEvents(List<Event> markedEvents, BufferedWriter bufferdWriter, boolean saveFualt) throws IOException {
            Boolean flag = true;
            String tableHead = null;
            String alarmStr = null;
            for (Event event : markedEvents) {
                tableHead = "";
                if (flag.booleanValue()) {
                    if (!saveFualt) {
                        tableHead = ResourceManager.getString("ALARM_EXPORT_TABLE_HISTROY_HEAD");
                        bufferdWriter.write(tableHead);
                        bufferdWriter.newLine();
                    } else {
                        tableHead = ResourceManager.getString("ALARM_EXPORT_TABLE_CURRENT_HEAD");
                        bufferdWriter.write(tableHead);
                        bufferdWriter.newLine();
                    }
                }
                alarmStr = EventTaskRequester.convertEventToStr(event, saveFualt);
                bufferdWriter.write(alarmStr);
                bufferdWriter.newLine();
                flag = false;
            }
        }

        private static String convertEventToStr(Event event, boolean isFault) {
            if (null == event) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            EventTaskRequester.createCSVCell(builder, event.getLevel().toString());
            String deviceID = event.getIdentifier().getDeviceID();
            Launcher launcher = LauncherManager.getInstance().getLauncher(deviceID);
            EventTaskRequester.createCSVCell(builder, null == launcher ? "" : launcher.getDeviceName());
            EventTaskRequester.createCSVCell(builder, "0x" + Long.toHexString(event.getEventID()));
            TimeZone timeZone = TimeZone.getDefault();
            if (null != launcher) {
                timeZone = launcher.getDeviceTimeZone();
            }
            EventTaskRequester.createCSVCell(builder, TimeUtil.gmtToString(event.getStartTime(), timeZone));
            if (!isFault) {
                String ret = "";
                if (event.getRecoverTime() > 0L) {
                    ret = TimeUtil.gmtToString(event.getRecoverTime(), timeZone);
                }
                EventTaskRequester.createCSVCell(builder, ret);
            }
            EventTaskRequester.createCSVCell(builder, event.getDescription());
            EventTaskRequester.createCSVCell(builder, event.getDetail());
            EventTaskRequester.createCSVCell(builder, event.getSuggestion());
            return builder.toString();
        }

        private static void createCSVCell(StringBuilder out, String content) {
            out.append('\"');
            if (CsvUtils.isStartswithInvalidChar(content)) {
                out.append('\t');
            }
            out.append(content);
            out.append('\"');
            out.append(',');
        }

        private static Callable createClearFaultTask(final List<Event> toBeClearedEvents) {
            return new Callable(){

                public Map<Event.Identifier, Long> call() throws Exception {
                    Thread.currentThread().setName("Clear fault");
                    HashMap<Event.Identifier, Long> failedMap = new HashMap<Event.Identifier, Long>(0);
                    EventManager.getInstance().manualRecover(toBeClearedEvents, failedMap);
                    return failedMap;
                }
            };
        }

        private static Callable createRefreshFaultEventsTask(final List<String> deviceIDs) {
            return new Callable(){

                public Object call() throws Exception {
                    Thread.currentThread().setName("Refresh all faults");
                    try {
                        EventManager.getInstance().refreshFaultEvents(deviceIDs.toArray(new String[deviceIDs.size()]));
                    }
                    catch (Exception e) {
                        return e;
                    }
                    return "";
                }
            };
        }

        static Callable createSaveAllEventsTask(final String deviceID, final String filePath) {
            return new Callable(){

                public Object call() throws Exception {
                    Thread.currentThread().setName("Save all events");
                    EventManager.getInstance().saveAllEvents(deviceID, filePath);
                    return "";
                }
            };
        }

        private static void handleClearFaultResult(Window eventManageDialog, List<Event> toBeClearedEvents, List<?> failedMapList) {
            if (null == failedMapList || failedMapList.isEmpty()) {
                return;
            }
            Object object = failedMapList.get(0);
            if (null == object) {
                return;
            }
            if (object instanceof Map) {
                Map errorMap = (Map)object;
                int size = errorMap.size();
                if (size > 0) {
                    EventTaskRequester.showErrorDialog(eventManageDialog, toBeClearedEvents, errorMap);
                    return;
                }
            } else if (object instanceof Throwable) {
                DialogUtils.showErrorDialog(eventManageDialog, (Throwable)object);
            }
        }

        private static void showErrorDialog(Window eventManageDialog, List<Event> toBeClearedEvents, Map<Event.Identifier, Long> errorMsg) {
            String source = ResourceManager.getString("ALARM_TABLE_MODEL_SOURCE");
            String sequenceId = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_NO");
            String description = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_DESC");
            String[] colNames = new String[]{source, sequenceId, description};
            String errinfo = ResourceManager.getString("ALARM_BLOCK_SELECT_CLEAR_SUCCESS") + " " + (toBeClearedEvents.size() - errorMsg.size()) + " " + ResourceManager.getString("ALARM_COUNT_SURFIX_TITLE") + " " + ResourceManager.getString("ALARM_BLOCK_SELECT_CLEAR_FAIL") + " " + errorMsg.size() + " " + ResourceManager.getString("ALARM_BLOCK_SELECT_BI");
            MultiErrorDialog meDialog = new MultiErrorDialog(eventManageDialog, errinfo, colNames);
            ArrayList<DefaultTableRow<Event.Identifier, Event.Identifier>> tableRows = new ArrayList<DefaultTableRow<Event.Identifier, Event.Identifier>>(0);
            DefaultTableRow<Event.Identifier, Event.Identifier> row = null;
            String deviceID = null;
            IsmException exception = null;
            for (Map.Entry<Event.Identifier, Long> entry : errorMsg.entrySet()) {
                row = new DefaultTableRow<Event.Identifier, Event.Identifier>(colNames.length, entry.getKey(), entry.getKey());
                deviceID = entry.getKey().getDeviceID();
                row.setValueAt(0, EventManagerPanel.getDeviceName(deviceID));
                row.setValueAt(1, entry.getKey().getEventSN());
                exception = new IsmException(entry.getValue());
                row.setValueAt(2, exception.getErrorMessage());
                tableRows.add(row);
            }
            meDialog.getTableModel().setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
            meDialog.setVisible(true);
        }

        private static void handleExcuteResult(Window eventManageDialog, List<?> results) {
            if (null == results || results.isEmpty()) {
                return;
            }
            Object obj = results.get(0);
            if (obj instanceof BatchExecutionException) {
                DialogUtils.showDeviceErrorDialog(eventManageDialog, (BatchExecutionException)obj);
            } else if (obj instanceof Throwable) {
                DialogUtils.showErrorDialog(eventManageDialog, (Throwable)obj);
            } else {
                LOGGER.info("do nothing.");
            }
        }
    }

    private class ListenerProxy
    implements ListSelectionListener,
    ItemListener {
        private ListenerProxy() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            EventManagerPanel.this.updateButtonState();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                EventManagerPanel.this.updateButtonState();
            }
        }
    }

    private class ViewActionListener
    implements ActionListener {
        private boolean isFaultTabPane;

        public ViewActionListener(boolean isFaultTabPanel) {
            this.isFaultTabPane = isFaultTabPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row;
            IsmTable source = (IsmTable)e.getSource();
            TableRow tRow = null;
            if (this.isFaultTabPane) {
                row = EventManagerPanel.this.layout.getFaultTable().convertRowIndexToModel(source.getCurRolloverRow());
                tRow = EventManagerPanel.this.layout.getFaultTableModel().getRow(row);
            } else {
                row = EventManagerPanel.this.layout.getEventTable().convertRowIndexToModel(source.getCurRolloverRow());
                tRow = EventManagerPanel.this.layout.getEventTableModel().getRow(row);
            }
            Event event = (Event)tRow.getUserObject();
            new EventDetailDialog(EventManagerPanel.this.parent, event).setVisible(true);
        }
    }

    private final class DoubleClickAdapter
    extends MouseAdapter {
        private IsmTable table = null;

        public DoubleClickAdapter(IsmTable table) {
            this.table = table;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int curRolloverRow;
            if (!EventManagerPanel.this.isEnabled()) {
                return;
            }
            IsmTable source = (IsmTable)e.getSource();
            List<TableRow> markedRows = source.getMarkedRows();
            Event event = null;
            Iterator<TableRow> iterator = markedRows.iterator();
            if (iterator.hasNext()) {
                TableRow markedRow = iterator.next();
                event = (Event)markedRow.getUserObject();
            }
            if ((curRolloverRow = source.getCurRolloverRow()) < 0) {
                return;
            }
            int row = this.table.convertRowIndexToModel(curRolloverRow);
            if (row >= 0 && e.getClickCount() == 2) {
                new EventDetailDialog(EventManagerPanel.this.parent, event).setVisible(true);
            }
        }
    }

    private static final class MyClearActionListner
    implements ActionListener {
        private final FaultTabLayout faultTab;

        private MyClearActionListner(FaultTabLayout faultTab) {
            this.faultTab = faultTab;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.faultTab.getKeywordFilter().setKeyword("");
            this.faultTab.getSourceComboBox().setSelectedIndex(0);
            this.faultTab.getDeviceComboBox().setSelectedIndex(0);
            this.faultTab.getLevelComboBox().setSelectedIndex(0);
        }
    }

    private static final class ClearActionListner
    implements ActionListener {
        private final EventTabLayout eventTab;

        private ClearActionListner(EventTabLayout eventTab) {
            this.eventTab = eventTab;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.eventTab.getKeywordFilter().setKeyword("");
            this.eventTab.getLevelComboBox().setSelectedIndex(0);
        }
    }
}

