/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.perfhis;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.module.perfhis.XYTimeSeriesData;
import com.huawei.ism.ui.swing.IsmFileChooser;
import com.huawei.ism.ui.swing.chart.IsmChartFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.RangeType;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class TimeSeriesChart
extends JPanel {
    private static final long serialVersionUID = 5861209865216428886L;
    private String tooltipFormat = "<html>{0}: {2}<br> {1} </html>";
    private TimeZone chartTimeZone = null;
    private boolean lineVisible = true;
    private TimeSeriseChartPanel chartPanel;
    private TimeSeriesCollection timeSeriesDataSet;
    private XYLineAndShapeRenderer renderer = null;
    private JFreeChart chart;

    public TimeSeriesChart(boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips, boolean legend, boolean domainZoomable, boolean rangeZoomable) {
        this.initChartPanel(properties, save, print, zoom, tooltips, legend, domainZoomable, rangeZoomable);
        this.setDefaultValue();
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.chartPanel), "Center");
    }

    public TimeSeriesChart() {
        this(false, false, false, false, true, true, false, false);
    }

    private void initChartPanel(boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips, boolean legend, boolean domainZoomable, boolean rangeZoomable) {
        this.timeSeriesDataSet = new TimeSeriesCollection();
        this.chart = this.createTimeSeriesChart("", "", "", (XYDataset)this.timeSeriesDataSet, legend, tooltips, false);
        this.chart.setBackgroundPaint((Paint)Color.WHITE);
        this.chart.setPadding(new RectangleInsets(8.0, 0.0, 0.0, 14.0));
        this.chartPanel = new TimeSeriseChartPanel(this.chart, properties, save, print, zoom, tooltips);
        this.chartPanel.setName("ISMV1R2_platform_PerformanceFigurePanel_chartPanel");
        this.chartPanel.setMouseZoomable(false);
        this.chartPanel.setDomainZoomable(domainZoomable);
        this.chartPanel.setRangeZoomable(rangeZoomable);
        this.chartPanel.setBackground(Color.WHITE);
        XYPlot plot = this.chart.getXYPlot();
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        this.renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        this.renderer.setSeriesPaint(0, (Paint)new Color(5204130));
        this.renderer.setSeriesPaint(1, (Paint)new Color(3971267));
        this.renderer.setSeriesPaint(2, (Paint)new Color(7781730));
        this.renderer.setSeriesPaint(3, (Paint)new Color(13601815));
        this.renderer.setDefaultShapesVisible(true);
        this.renderer.setDefaultShapesFilled(true);
        MySimpleDateFormat format = new MySimpleDateFormat("yyyy-MM-dd HH:mm:ss 'UTC'Z", this);
        format.setTimeZone(this.getTimeZone());
        StandardXYToolTipGenerator toolTipGenerator = new StandardXYToolTipGenerator(this.tooltipFormat, (DateFormat)format, NumberFormat.getInstance());
        this.renderer.setDefaultToolTipGenerator((XYToolTipGenerator)toolTipGenerator);
    }

    private JFreeChart createTimeSeriesChart(String title, String timeAxisLabel, String valueAxisLabel, XYDataset dataset, boolean legend, boolean tooltips, boolean urls) {
        DateAxis timeAxis = new DateAxis(timeAxisLabel);
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        MyNumberAxis numberAxis = new MyNumberAxis(valueAxisLabel);
        numberAxis.setAutoRangeIncludesZero(false);
        XYPlot xyPlot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)numberAxis, null);
        StandardXYToolTipGenerator xyToolTipGenerator = null;
        if (tooltips) {
            xyToolTipGenerator = StandardXYToolTipGenerator.getTimeSeriesInstance();
        }
        StandardXYURLGenerator xyurlGenerator = null;
        if (urls) {
            xyurlGenerator = new StandardXYURLGenerator();
        }
        XYLineAndShapeRenderer lineRenderer = new XYLineAndShapeRenderer(true, false);
        lineRenderer.setDefaultToolTipGenerator((XYToolTipGenerator)xyToolTipGenerator);
        lineRenderer.setURLGenerator((XYURLGenerator)xyurlGenerator);
        this.setLineRendererShape(lineRenderer, 16);
        xyPlot.setRenderer((XYItemRenderer)lineRenderer);
        JFreeChart jFreeChart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)xyPlot, legend);
        return jFreeChart;
    }

    private void setLineRendererShape(XYLineAndShapeRenderer lineRenderer, int series) {
        for (int i = 0; i < series; ++i) {
            lineRenderer.setSeriesShape(i, (Shape)new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0));
        }
    }

    public void setToolTipGenerator(XYToolTipGenerator generator) {
        this.renderer.setDefaultToolTipGenerator(generator);
    }

    public XYToolTipGenerator getToolTipGenerator() {
        return this.renderer.getDefaultToolTipGenerator();
    }

    public synchronized void setLineVisible(boolean visible) {
        this.lineVisible = visible;
        int series = this.timeSeriesDataSet.getSeriesCount();
        for (int i = 0; i < series; ++i) {
            this.renderer.setSeriesLinesVisible(i, visible);
        }
    }

    public void setChartTitle(String title) {
        TextTitle titleText = new TextTitle(title, IsmChartFactory.DEFAULT_TITLE_FONT);
        this.chart.setTitle(titleText);
    }

    public void setChartTitle(String title, Font titleFont) {
        TextTitle titleText = new TextTitle(title, titleFont);
        this.chart.setTitle(titleText);
    }

    public void setAxisXTitle(String timeTitle) {
        DateAxis valueAxis = this.getAxisX();
        valueAxis.setLabel(timeTitle);
        valueAxis.setLabelFont(IsmChartFactory.DEFAULT_LABEL_FONT);
    }

    public void setAxisYTitle(String timeTitle) {
        int index;
        String actualTimeTitle = timeTitle;
        if (actualTimeTitle.endsWith("()") && (index = actualTimeTitle.lastIndexOf("()")) != -1) {
            actualTimeTitle = actualTimeTitle.substring(0, index);
        }
        ValueAxis valueAxis = this.getAxisY();
        valueAxis.setLabel(actualTimeTitle);
        valueAxis.setLabelFont(IsmChartFactory.DEFAULT_LABEL_FONT);
    }

    public void setDataFormat(DateFormat format) {
        DateAxis valueAxis = this.getAxisX();
        valueAxis.setDateFormatOverride(format);
        StandardXYToolTipGenerator toolTipGenerator = new StandardXYToolTipGenerator(this.tooltipFormat, format, NumberFormat.getInstance());
        this.renderer.setDefaultToolTipGenerator((XYToolTipGenerator)toolTipGenerator);
    }

    public void setDateAxisFormat(DateFormat format) {
        DateAxis dateAxis = this.getAxisX();
        dateAxis.setDateFormatOverride(format);
    }

    public synchronized void removeAllSeries() {
        if (null != this.timeSeriesDataSet) {
            this.timeSeriesDataSet.removeAllSeries();
            this.chartPanel.validate();
        }
    }

    public synchronized void removeSeriesByKey(String key) {
        if (null != this.timeSeriesDataSet) {
            TimeSeries removeSeries = this.getSeries((Comparable<?>)((Object)key));
            if (removeSeries != null) {
                this.timeSeriesDataSet.removeSeries(removeSeries);
            }
            this.chartPanel.validate();
        }
    }

    private void setDefaultValue() {
        this.setDateAxisFormat(new SimpleDateFormat("HH:mm:ss"));
        DateAxis xAxis = this.getAxisX();
        xAxis.setAutoRange(true);
        ValueAxis yAxis = this.getAxisY();
        yAxis.setAutoRangeMinimumSize(10.0);
        if (yAxis instanceof NumberAxis) {
            NumberAxis na = (NumberAxis)yAxis;
            na.setRangeType(RangeType.POSITIVE);
        }
    }

    public DateAxis getAxisX() {
        ValueAxis xAxis = this.chart.getXYPlot().getDomainAxis();
        DateAxis valueAxis = (DateAxis)xAxis;
        return valueAxis;
    }

    public ValueAxis getAxisY() {
        ValueAxis yAxis = this.chart.getXYPlot().getRangeAxis();
        return yAxis;
    }

    public synchronized void addOrUpdateData(String timeSeriesName, XYTimeSeriesData data) {
        TimeSeries timeSeries = this.getOrCreate((Comparable<?>)((Object)timeSeriesName));
        RegularTimePeriod period = RegularTimePeriod.createInstance(Millisecond.class, (Date)new Date(data.getValueX()), (TimeZone)this.getTimeZone(), (Locale)Locale.getDefault());
        double yValue = data.getValueY();
        timeSeries.addOrUpdate(period, yValue);
    }

    public synchronized void addOrUpdateData(String timeSeriesName, Collection<XYTimeSeriesData> datas) {
        this.addData(timeSeriesName, datas, false);
    }

    public synchronized void resetData(String timeSeriesName, Collection<XYTimeSeriesData> datas) {
        this.addData(timeSeriesName, datas, true);
    }

    private void addData(String timeSeriesName, Collection<XYTimeSeriesData> datas, boolean clearBefor) {
        TimeSeries tmpSeries = new TimeSeries((Comparable)((Object)"timeSeriesNametmp"));
        RegularTimePeriod period = null;
        for (XYTimeSeriesData data : datas) {
            Double valueY = data.getValueY();
            period = RegularTimePeriod.createInstance(Millisecond.class, (Date)new Date(data.getValueX()), (TimeZone)this.getTimeZone(), (Locale)Locale.getDefault());
            tmpSeries.addOrUpdate(period, (Number)valueY);
        }
        TimeSeries timeSeries = this.getOrCreate((Comparable<?>)((Object)timeSeriesName));
        if (clearBefor) {
            timeSeries.clear();
        }
        timeSeries.addAndOrUpdate(tmpSeries);
    }

    public void setAutoRange(double autoRangeValue) {
        DateAxis valueAxis = this.getAxisX();
        if (!valueAxis.isAutoRange()) {
            valueAxis.setAutoRange(true);
            valueAxis.setAutoRangeMinimumSize(1.0, true);
        }
        valueAxis.setFixedAutoRange(autoRangeValue);
    }

    public synchronized TimeSeries getOrCreate(Comparable<?> timeSeriesName) {
        TimeSeries timeSeries = this.getSeries(timeSeriesName);
        if (null == timeSeries) {
            timeSeries = new TimeSeries(timeSeriesName);
            this.timeSeriesDataSet.addSeries(timeSeries);
            int index = this.timeSeriesDataSet.indexOf(timeSeries);
            this.renderer.setSeriesLinesVisible(index, this.lineVisible);
        }
        return timeSeries;
    }

    public TimeSeries getSeries(Comparable<?> key) {
        TimeSeries result = null;
        List serieses = this.timeSeriesDataSet.getSeries();
        TimeSeries series = null;
        Comparable k = null;
        for (Object obj : serieses) {
            series = (TimeSeries)obj;
            k = series.getKey();
            if (k == null || !k.equals(key)) continue;
            result = series;
        }
        return result;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public List<TimeSeries> getAllSeries() {
        return this.timeSeriesDataSet.getSeries();
    }

    public void addTimeSeries(TimeSeries timeSeries) {
        if (timeSeries == null) {
            return;
        }
        this.timeSeriesDataSet.addSeries(timeSeries);
    }

    public void addAllTimeSeries(List<TimeSeries> timeSeriesList) {
        if (timeSeriesList == null) {
            return;
        }
        for (TimeSeries timeSeries : timeSeriesList) {
            this.timeSeriesDataSet.addSeries(timeSeries);
        }
    }

    public void setSeriesColor(int series, Color color) {
        this.renderer.setSeriesPaint(series, (Paint)color);
    }

    public void setAutoPopulateSeriesShape(boolean isAuto) {
        this.renderer.setAutoPopulateSeriesShape(isAuto);
    }

    public void setSeriesColor(Comparable<?> key, Color color) {
        int index;
        TimeSeries timeSeries = this.getSeries(key);
        if (timeSeries != null && (index = this.timeSeriesDataSet.indexOf(timeSeries)) != -1) {
            this.setSeriesColor(index, color);
        }
    }

    public synchronized boolean getLineVisible() {
        return this.lineVisible;
    }

    public TimeZone getTimeZone() {
        if (this.chartTimeZone == null) {
            return TimeZone.getDefault();
        }
        return this.chartTimeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone != null && this.chartTimeZone != null && !timeZone.getID().equals(this.chartTimeZone.getID())) {
            this.clearAllSeriesData();
        }
        this.chartTimeZone = timeZone;
    }

    private void clearAllSeriesData() {
        List timeSeriesList = this.timeSeriesDataSet.getSeries();
        for (TimeSeries timeSeries : timeSeriesList) {
            timeSeries.clear();
        }
    }

    public void addData(String name, Collection<XYTimeSeriesData> datas) {
        TimeSeries tmpSeries = new TimeSeries((Comparable)((Object)name));
        Double valueY = null;
        for (XYTimeSeriesData data : datas) {
            valueY = data.getValueY();
            tmpSeries.add((RegularTimePeriod)new Millisecond(new Date(data.getValueX())), (Number)valueY);
        }
        this.timeSeriesDataSet.addSeries(tmpSeries);
    }

    public void setCharPanelAutoBounds() {
        this.chartPanel.restoreAutoBounds();
    }

    public JPanel getChartPanel() {
        return this.chartPanel;
    }

    private static class TimeSeriseChartPanel
    extends ChartPanel {
        public TimeSeriseChartPanel(JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
            super(chart, properties, save, print, zoom, tooltips);
        }

        public void doSaveAs() throws IOException {
            String filename = this.getTimeSeriesChartPath();
            if (!StringUtils.isNULLStr(filename)) {
                ChartUtils.saveChartAsPNG((File)new File(filename), (JFreeChart)this.getChart(), (int)this.getWidth(), (int)this.getHeight());
            }
        }

        private String getTimeSeriesChartPath() {
            String filter = "png";
            IsmFileChooser fileChooser = new IsmFileChooser(ResourceManager.getString("PERF_HS_SAVEFILE_SELECTFILE"));
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.addFileFilter(new String[]{filter}, ResourceManager.getString("COMMON.TXT.TIME_SERISE_CHART") + "(." + filter + ")");
            fileChooser.setFileFilter(fileChooser.getChoosableFileFilters()[0]);
            fileChooser.setDefaultFileName(ResourceManager.getString("COMMON.TXT.TIME_SERISE_CHART") + "_" + System.currentTimeMillis() + "." + filter);
            if (fileChooser.showSaveDialog((Component)((Object)this)) != 0) {
                return null;
            }
            File aFile = fileChooser.getSelectedFile();
            if (null == aFile) {
                return null;
            }
            String filePath = aFile.getAbsolutePath().trim();
            if (!fileChooser.withFileType(aFile.getName()).booleanValue()) {
                filePath = filePath + "." + fileChooser.getSelectedFileType()[0];
            }
            return filePath;
        }
    }

    private static final class MyNumberAxis
    extends NumberAxis {
        private static final long serialVersionUID = 8893698660752060582L;

        public MyNumberAxis(String label) {
            super(label);
        }

        public void resizeRange(double percent, double anchorValue) {
            if (percent > 0.0) {
                double halfLength = this.getRange().getLength() * percent / 2.0;
                double temp = anchorValue - halfLength;
                if (temp < 0.0) {
                    temp = 0.0;
                }
                Range adjusted = new Range(temp, anchorValue + halfLength);
                this.setRange(adjusted);
            } else {
                this.setAutoRange(true);
            }
        }
    }

    private static final class MySimpleDateFormat
    extends SimpleDateFormat {
        private static final long serialVersionUID = 4733674717218357496L;
        private TimeSeriesChart chart;

        public MySimpleDateFormat(String str, TimeSeriesChart chart) {
            super(str);
            this.chart = chart;
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
            String str = super.format(date, toAppendTo, pos).toString();
            StringBuilder sb = new StringBuilder(str);
            sb.insert(str.length() - 2, ":");
            if (this.chart.getTimeZone().useDaylightTime()) {
                sb.append(" DST");
            }
            return new StringBuffer(sb.toString());
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

