/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;

public class IsmListModel<T>
extends AbstractListModel {
    private static final long serialVersionUID = 1L;
    private List<T> delegate = new ArrayList<T>(0);

    IsmListModel(ListModel model) {
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            this.delegate.add(model.getElementAt(i));
        }
    }

    public IsmListModel() {
    }

    public IsmListModel(T ... elements) {
        this((Collection<T>)Arrays.asList(elements));
    }

    public IsmListModel(Collection<T> elements) {
        this.delegate.addAll(elements);
    }

    @Override
    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.delegate.get(index);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public List<T> elements() {
        return new ArrayList<T>(this.delegate);
    }

    public boolean contains(T elem) {
        return this.delegate.contains(elem);
    }

    public int indexOf(T elem) {
        return this.delegate.indexOf(elem);
    }

    public int lastIndexOf(T elem) {
        return this.delegate.lastIndexOf(elem);
    }

    public void setElementAt(int index, T obj) {
        this.delegate.add(index, obj);
        this.fireContentsChanged(this, index, index);
    }

    public void setElements(Collection<T> ts) {
        int endIndex = this.getSize() - 1;
        this.delegate.clear();
        this.delegate.addAll(ts);
        this.fireContentsChanged(this, 0, endIndex);
    }

    public void removeElementAt(int index) {
        this.delegate.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public boolean removeElement(T obj) {
        int index = this.indexOf(obj);
        boolean rv = this.delegate.remove(obj);
        if (index >= 0) {
            this.fireIntervalRemoved(this, index, index);
        }
        return rv;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void addElementAt(T element) {
        this.addElementAt(this.delegate.size(), element);
    }

    public void addElementAt(int index, T element) {
        this.delegate.add(index, element);
        this.fireIntervalAdded(this, index, index);
    }

    public void clear() {
        int index1 = this.delegate.size() - 1;
        this.delegate.clear();
        if (index1 >= 0) {
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    public void addElements(Collection<T> ts) {
        if (null == ts || ts.isEmpty()) {
            return;
        }
        int startIndex = this.getSize();
        int endIndex = startIndex + ts.size() - 1;
        this.delegate.addAll(ts);
        this.fireIntervalAdded(this, startIndex, endIndex);
    }

    public T lastElement() {
        return this.delegate.get(this.delegate.size() - 1);
    }
}

