/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.IsmMenuItem;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.widgets.action.ActionManager;
import com.huawei.ism.ui.widgets.action.CfgElement;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.parser.XmlParser;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class IsmMenuBar
extends JMenuBar {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsmMenuBar.class);
    private static final long serialVersionUID = -3711296110235063861L;
    private static final String MENU_BAR_XML = "config/framework/configuration/menu.xml";
    private transient ResourceBundle resource = null;
    private Collection<JComponent> currentMenus = null;
    private boolean enableBool = true;

    public IsmMenuBar(Collection<JComponent> currentMenus) {
        this.currentMenus = currentMenus;
    }

    public IsmMenuBar() {
        this.setName("ISM_KaimseMenuBar");
        XmlParser parser = XmlParser.getXmlDomParser(MENU_BAR_XML);
        if (null == parser) {
            return;
        }
        Element rootNode = parser.treeWalkOfOneElementNode("root");
        if (null == rootNode) {
            return;
        }
        String propertyFile = rootNode.getAttribute("property-file");
        this.loadPropertyFile(propertyFile);
        Collection<JComponent> list = this.buildMenu(parser, rootNode);
        for (JComponent menu : list) {
            if (null == menu) continue;
            menu.setEnabled(this.enableBool);
            super.add(menu);
        }
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            this.setPreferredSize(new Dimension(0, 28));
        }
        this.validate();
    }

    protected String getMenuName(String name) {
        String nameStr = null;
        try {
            nameStr = name.toUpperCase(Locale.ENGLISH) + "_TEXT";
            return this.resource.getString(nameStr);
        }
        catch (MissingResourceException e) {
            LOGGER.error(" The key \"" + nameStr + "\" doesn't exist in menu.property");
            return name;
        }
    }

    public static boolean isNull(String string) {
        return null == string || "".equals(string);
    }

    public Collection<JComponent> buildMenu(XmlParser parser, Element rootElemnt) {
        ArrayList<JComponent> menus = new ArrayList<JComponent>(0);
        Collection<Element> children = parser.getChildren(rootElemnt);
        ActionManager actionManager = ActionManager.getInstance();
        JComponent menu = null;
        String mnemonicChar = null;
        Collection<JComponent> subMenus = null;
        String name = null;
        for (Element element : children) {
            Element actionIdElement;
            menu = null;
            if (!this.isModuleEnable(element)) continue;
            if (this.isMenu(element)) {
                subMenus = this.buildMenu(parser, element);
                menu = new JMenu();
                name = element.getAttribute("name");
                if (null != name && !"".equalsIgnoreCase(name)) {
                    String text = this.getMenuName(name);
                    ((JMenu)menu).setText(text);
                    this.setName("ISM_KaimseMenuBar_" + name);
                }
                if (!IsmMenuBar.isNull(mnemonicChar = element.getAttribute("mnemonic"))) {
                    int iMnemonic = CfgElement.dealWithMnemonic(mnemonicChar);
                    ((JMenu)menu).setMnemonic(iMnemonic);
                }
                for (JComponent component : subMenus) {
                    menu.add(component);
                }
            } else if (this.isSeparator(element)) {
                menu = new JPopupMenu.Separator();
            } else if (this.isMenuItem(element) && (actionIdElement = parser.treeWalkOfOneElementNode(element, "action-id")) != null) {
                String actionId = actionIdElement.getTextContent();
                Action deligateAction = actionManager.getAction(actionId);
                menu = new IsmMenuItem(deligateAction);
            }
            menus.add(menu);
        }
        return menus;
    }

    private boolean isModuleEnable(Element element) {
        String moduleEnable = element.getAttribute("module");
        if (IsmMenuBar.isNull(moduleEnable)) {
            return true;
        }
        return CommonUtil.isModuleEnable(moduleEnable);
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.enableBool = enable;
        if (null != this.currentMenus) {
            for (JComponent menu : this.currentMenus) {
                menu.setEnabled(enable);
            }
        }
    }

    protected void loadPropertyFile(String propertyFile) {
        if (null == propertyFile) {
            return;
        }
        this.resource = ResourceBundle.getBundle(propertyFile, ResourceManager.getLocale());
    }

    public boolean isMenuItem(Element element) {
        String tagName = element.getTagName();
        return "menu-item".equals(tagName);
    }

    public boolean isMenu(Element element) {
        String tagName = element.getTagName();
        return "menu".equals(tagName);
    }

    public boolean isSeparator(Element element) {
        String tagName = element.getTagName();
        return "separator".equals(tagName);
    }
}

