/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.plaf.IsmBorders;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.armor.ArmorBorders;
import com.huawei.ism.ui.swing.plaf.unify.UnifyBorders;
import com.huawei.ism.ui.templets.PropertyPaneAction;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class RolloverButton
extends JButton {
    private static final String UI_CLASSID = "RolloverButtonUI";
    private static final long serialVersionUID = 1L;
    private boolean repaint = false;
    private Color renderColor;
    private boolean isOpen = true;
    private boolean paintIcon;

    public RolloverButton(String groupName, Action ... actions) {
        super(groupName);
        this.doInit(groupName);
        this.addHander(groupName, actions);
    }

    public RolloverButton(String groupName, List<PropertyPaneAction> threeLeveMenuActions, Action ... actions) {
        super(groupName);
        this.doInit(groupName);
        this.addHander(groupName, threeLeveMenuActions, actions);
    }

    public RolloverButton(Action action) {
        super(action);
        this.setBorder(false);
        this.setFocusable(false);
        if (null != action.getValue("Name")) {
            this.setToolTipText(action.getValue("Name").toString());
            this.setName(action.getValue("Name").toString());
        }
        if (action.getValue("ShortDescription") != null) {
            this.setToolTipText(action.getValue("ShortDescription").toString());
        }
        this.updatePreferSize();
    }

    public RolloverButton(String text) {
        super(text);
        this.setBorder(false);
        this.setFocusable(false);
        this.updatePreferSize();
    }

    private void doInit(String groupName) {
        this.setToolTipText(groupName);
        this.setBorder(true);
        this.updatePreferSize();
        this.setFocusable(false);
        this.setName(groupName);
        this.paintIcon = true;
    }

    private void addHander(final String groupName, final List<PropertyPaneAction> threeLeveMenuActions, final Action ... actions) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                if (!SwingUtilities.isLeftMouseButton(me) || !RolloverButton.this.isOpen) {
                    return;
                }
                JPopupMenu popmenu = new JPopupMenu();
                popmenu.setName(groupName);
                int i = 0;
                for (Action action : actions) {
                    if (action instanceof PropertyPaneAction && RolloverButton.this.getSubmenu(action, popmenu, threeLeveMenuActions)) continue;
                    popmenu.add(action).setName(groupName + '_' + i++);
                }
                popmenu.show(me.getComponent(), 0, RolloverButton.this.getY() + RolloverButton.this.getHeight() - 3);
            }
        });
    }

    private void addHander(final String groupName, final Action ... actions) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                if (!SwingUtilities.isLeftMouseButton(me) || !RolloverButton.this.isOpen) {
                    return;
                }
                JPopupMenu popmenu = new JPopupMenu();
                popmenu.setName(groupName);
                int i = 0;
                for (Action action : actions) {
                    popmenu.add(action).setName(groupName + '_' + i++);
                }
                popmenu.show(me.getComponent(), 0, RolloverButton.this.getY() + RolloverButton.this.getHeight() - 3);
            }
        });
    }

    private boolean getSubmenu(Action action, JPopupMenu popmenu, List<PropertyPaneAction> threeLeveMenuActions) {
        PropertyPaneAction propertyPaneAction = (PropertyPaneAction)action;
        String subMenuName = propertyPaneAction.menuInfoWithDefault().getSubMenuName();
        if (subMenuName == null || !subMenuName.equals(ResourceManager.getString("CREATE_LUN_COPY"))) {
            return false;
        }
        JMenu subMenu = new JMenu(subMenuName + "     ");
        PropertyPaneAction clonedSubMenuAction = null;
        String menuItemName = null;
        for (PropertyPaneAction submenuAction : threeLeveMenuActions) {
            clonedSubMenuAction = (PropertyPaneAction)submenuAction.clone();
            menuItemName = clonedSubMenuAction.menuInfoWithDefault().getMenuName();
            if (null != menuItemName) {
                clonedSubMenuAction.setName(menuItemName);
            }
            clonedSubMenuAction.setUserObject(propertyPaneAction.getUserObject());
            clonedSubMenuAction.update();
            subMenu.add(clonedSubMenuAction);
        }
        popmenu.add(subMenu);
        return true;
    }

    protected void setBorder(boolean drawArrow) {
        if (IsmPlafUtils.isBlueStyle()) {
            this.setBorder(IsmBorders.getRolloverButtonButton(drawArrow));
        } else if (IsmPlafUtils.isArmorStyle()) {
            this.setBorder(ArmorBorders.getArmorRolloverButtonBorder(drawArrow));
        } else if (IsmPlafUtils.isUnifyStyle()) {
            this.setBorder(UnifyBorders.getRolloverButtonBorder(drawArrow));
        }
    }

    private void updatePreferSize() {
        Dimension dim = UCD.computeButtonPreferredSize(this, true);
        dim.height = 25;
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
    }

    public void setPaintIcon(boolean selection) {
        this.paintIcon = selection;
    }

    @Override
    public String getUIClassID() {
        return UI_CLASSID;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.paintIcon && this.isEnabled()) {
            Icon arrow = null;
            arrow = this.getModel().isRollover() || this.getModel().isSelected() ? UIManager.getIcon("OEMIcon.orientSouth") : UIManager.getIcon("ScrollBar.southButtonIconImage");
            int xx = this.getWidth() - arrow.getIconWidth() - 4;
            int yy = (this.getHeight() - arrow.getIconHeight()) / 2;
            arrow.paintIcon(this, graphics, xx, yy);
        }
    }

    public void setOpenStatus(boolean bool) {
        this.isOpen = bool;
    }

    public void setRenderColor(Color renderColor) {
        this.renderColor = renderColor;
    }

    public Color getRenderColor() {
        return this.renderColor;
    }

    public boolean isRepaint() {
        return this.repaint;
    }

    public void setRepaint(boolean repaint) {
        this.repaint = repaint;
    }
}

