/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.calendar;

import com.huawei.ism.util.CommonUtil;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;

public class DateSpinnerEditor
extends JSpinner {
    private static final long serialVersionUID = 1L;
    private static final String DATA_REGEX = "(([0-1]\\d)|2[0-3]|\\d{0,1}):([0-5]\\d|\\d{0,1}):([0-5]\\d|\\d{0,1})";
    private static final String HHMM_DATA_REGEX = "(([0-1]\\d)|2[0-3]|\\d{0,1}):([0-5]\\d|\\d{0,1})";
    private Pattern pattern;
    private String oldTime;
    private JSpinner.DateEditor jdateeditor;
    private SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
    private String dateFormat;

    public DateSpinnerEditor() {
        this.pattern = Pattern.compile(DATA_REGEX);
        this.dateFormat = "HH:mm:ss";
        this.init();
    }

    public DateSpinnerEditor(SpinnerModel model) {
        this.spinnerDateModel = CommonUtil.convertObject(model, SpinnerDateModel.class);
        this.pattern = Pattern.compile(HHMM_DATA_REGEX);
        this.dateFormat = "HH:mm";
        this.init();
    }

    private void init() {
        this.setModel(this.spinnerDateModel);
        this.jdateeditor = new JSpinner.DateEditor((JSpinner)this, this.dateFormat);
        final JFormattedTextField textField = this.jdateeditor.getTextField();
        this.oldTime = textField.getText();
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                String time = textField.getText();
                Matcher matcher = DateSpinnerEditor.this.pattern.matcher(time);
                if (!matcher.matches()) {
                    textField.setText(DateSpinnerEditor.this.oldTime);
                    return;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String time = textField.getText();
                Matcher matcher = DateSpinnerEditor.this.pattern.matcher(time);
                if (!matcher.matches()) {
                    textField.setText(DateSpinnerEditor.this.oldTime);
                    return;
                }
            }
        });
        this.setEditor(this.jdateeditor);
    }

    public JSpinner.DateEditor getDateEditor() {
        return this.jdateeditor;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

