/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.ui.swing.IsmToolTip;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.dialog.WarningInfo;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WarningDialogWithLink
extends WarningDialog {
    public WarningDialogWithLink(Window parent, List<WarningInfo> warningInfo, String ensureInfo) {
        super(parent, warningInfo.stream().map(WarningInfo::getMessage).collect(Collectors.joining("\n")), ensureInfo);
        this.updateWarningInfo(warningInfo);
        this.pack();
    }

    private void updateWarningInfo(List<WarningInfo> warningInfo) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int curIndex = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        for (WarningInfo info : warningInfo) {
            gridBagConstraints.gridy = curIndex++;
            gridBagConstraints.anchor = 17;
            if (info.isHiddenIfTooLong()) {
                JLabel jtext = new JLabel();
                jtext.setText(info.getMessage());
                jtext.addMouseListener(this.buildMouseListener(jtext, info.getMessage()));
                WarningDialogWithLink.setSize(jtext, jPanel);
                gridBagConstraints.insets = new Insets(2, 0, 2, 0);
                jPanel.add((Component)jtext, gridBagConstraints);
            } else {
                IsmTextArea ismTextArea = new IsmTextArea();
                ismTextArea.setEditable(false);
                ismTextArea.setLineWrap(true);
                ismTextArea.setColumns(this.textColumn == 0 ? 31 : this.textColumn);
                gridBagConstraints.insets = new Insets(0, 0, 2, 0);
                ismTextArea.setText(info.getMessage());
                jPanel.add((Component)ismTextArea, gridBagConstraints);
            }
            if (info.getHyperLink() == null) continue;
            gridBagConstraints.gridy = curIndex++;
            gridBagConstraints.insets = new Insets(0, 0, 12, 0);
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)info.getHyperLink(), gridBagConstraints);
        }
        GridBagConstraints panelGrid = new GridBagConstraints();
        panelGrid.gridx = 1;
        panelGrid.gridy = 0;
        panelGrid.anchor = 10;
        panelGrid.insets = new Insets(0, 0, 12, 0);
        this.displayPrompt.setWrapStyleWord(true);
        this.displayPanel.remove(this.displayPrompt);
        panelGrid.weighty = 1.0;
        this.displayPanel.add(jPanel, panelGrid, 0);
        this.pack();
    }

    private static void setSize(JLabel jtext, JPanel jPanel) {
        jtext.setMaximumSize(new Dimension(jPanel.getPreferredSize().width, 15));
        jtext.setMinimumSize(new Dimension(jPanel.getPreferredSize().width, 15));
        jtext.setPreferredSize(new Dimension(jPanel.getPreferredSize().width, 15));
        jtext.setSize(new Dimension(jPanel.getPreferredSize().width, 15));
    }

    private MouseListener buildMouseListener(JLabel jLabel, String tipMsg) {
        final IsmToolTip ismToolTip = new IsmToolTip();
        ismToolTip.setComponent(jLabel);
        ismToolTip.setTipText(tipMsg);
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ismToolTip.setVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ismToolTip.setVisible(false);
            }
        };
    }

    @Override
    protected Box buildBox() {
        Box hBox = Box.createHorizontalBox();
        this.check = new JCheckBox();
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            Box verticalBox = Box.createVerticalBox();
            verticalBox.add(this.check);
            verticalBox.add(Box.createVerticalStrut(16));
            hBox.add(verticalBox);
        } else {
            hBox.add(this.check);
        }
        return hBox;
    }
}

