/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class IsmTableHeaderUI
extends BasicTableHeaderUI {
    private static int rolloverColumn = -1;
    private TableCellRenderer originalHeaderRenderer;

    public static ComponentUI createUI(JComponent h) {
        return new IsmTableHeaderUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.originalHeaderRenderer = this.header.getDefaultRenderer();
        if (this.originalHeaderRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new IsmDefaultRenderer(this.header));
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MyMouseInputHandler();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        if (this.header.getDefaultRenderer() instanceof IsmDefaultRenderer) {
            this.header.setDefaultRenderer(this.originalHeaderRenderer);
        }
        super.uninstallUI(jComponent);
    }

    private void updateRolloverColumn(MouseEvent mouseEvent) {
        int col;
        if (this.header.getDraggedColumn() == null && this.header.contains(mouseEvent.getPoint()) && (col = this.header.columnAtPoint(mouseEvent.getPoint())) != rolloverColumn) {
            rolloverColumn = col;
            this.header.repaint();
        }
    }

    private class MyMouseInputHandler
    extends BasicTableHeaderUI.MouseInputHandler {
        private MyMouseInputHandler() {
            super(IsmTableHeaderUI.this);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            IsmTableHeaderUI.this.updateRolloverColumn(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            IsmTableHeaderUI.this.updateRolloverColumn(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            rolloverColumn = -1;
            IsmTableHeaderUI.this.header.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (IsmTableHeaderUI.this.header.getReorderingAllowed()) {
                rolloverColumn = -1;
                IsmTableHeaderUI.this.header.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
            IsmTableHeaderUI.this.updateRolloverColumn(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            IsmTableHeaderUI.this.updateRolloverColumn(mouseEvent);
        }
    }

    public static class IsmDefaultRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private static final long serialVersionUID = -466364326409311619L;
        private boolean isSelected;
        private boolean hasFocus;
        private boolean hasRollover;
        private int column;
        private JTableHeader header;

        public IsmDefaultRenderer(JTableHeader header) {
            this.header = header;
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(2);
            this.setIconTextGap(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelectedTemp, boolean hasFocusTemp, int row, int columnTemp) {
            JTableHeader tableHeader = table.getTableHeader();
            if (tableHeader != null) {
                this.setFont(tableHeader.getFont());
            }
            this.isSelected = isSelectedTemp;
            this.hasFocus = hasFocusTemp;
            this.column = columnTemp;
            this.hasRollover = columnTemp == rolloverColumn;
            this.setArrowIcon(table);
            this.setText(value == null ? "" : value.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            int availableWidth = table.getColumnModel().getColumn(columnTemp).getWidth();
            availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
            if (this.getBorder() != null) {
                Insets borderInsets = this.getBorder().getBorderInsets(this);
                availableWidth -= borderInsets.left + borderInsets.right;
            }
            String cellText = value == null ? "" : value.toString();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (fm.stringWidth(cellText) > availableWidth) {
                this.setToolTipText(cellText);
            } else {
                this.setToolTipText(null);
            }
            return this;
        }

        private void setArrowIcon(JTable table) {
            RowSorter<? extends TableModel> rowSorter = table.getRowSorter();
            if (null == rowSorter || rowSorter.getSortKeys().isEmpty()) {
                this.setIcon(null);
                return;
            }
            List<RowSorter.SortKey> list = rowSorter.getSortKeys();
            if (list.isEmpty()) {
                return;
            }
            RowSorter.SortKey sortKey = list.get(0);
            int curColumn = sortKey.getColumn();
            SortOrder sortOrder = sortKey.getSortOrder();
            if (sortOrder != SortOrder.UNSORTED && table.convertColumnIndexToModel(this.column) == curColumn) {
                if (sortOrder == SortOrder.ASCENDING) {
                    Icon upwardsSortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                    this.setIcon(upwardsSortIcon);
                } else {
                    Icon downwardsSortIcon = UIManager.getIcon("Table.descendingSortIcon");
                    this.setIcon(downwardsSortIcon);
                }
            } else {
                this.setIcon(null);
            }
        }

        private int viewIndexForColumn(TableColumn tableColumn) {
            TableColumnModel cmTemp = this.header.getColumnModel();
            for (int col = 0; col < cmTemp.getColumnCount(); ++col) {
                if (cmTemp.getColumn(col) != tableColumn) continue;
                return col;
            }
            return -1;
        }

        @Override
        public void paint(Graphics drawDualGradient) {
            Dimension size = this.header.getSize();
            IsmButtonStyle style = (IsmButtonStyle)UIManager.get("TableHeader.style");
            IsmButtonStyle.ButtonState state = IsmButtonStyle.ButtonState.NORMAL;
            if (!this.header.getTable().isEnabled()) {
                state = IsmButtonStyle.ButtonState.DISABLED;
            } else if (this.column == this.viewIndexForColumn(this.header.getDraggedColumn())) {
                state = IsmButtonStyle.ButtonState.PRESSED;
            } else if (this.isSelected || this.hasFocus || this.hasRollover) {
                state = IsmButtonStyle.ButtonState.ROLLOVER;
            }
            IsmPlafUtils.drawDualGradient((Component)this.header, drawDualGradient, style.getGradientUL(state), style.getGradientDR(state), new Rectangle(0, 0, size.width, size.height), true);
            IsmButtonStyle buttonStyle = (IsmButtonStyle)UIManager.get("TableHeader.style");
            IsmButtonStyle.ButtonState buttonState = state == IsmButtonStyle.ButtonState.PRESSED ? IsmButtonStyle.ButtonState.PRESSED : IsmButtonStyle.ButtonState.NORMAL;
            Color innerBorderColorLU = buttonStyle.getInnerBorderColorLU(buttonState);
            Color innerBorderColorRD = buttonStyle.getInnerBorderColorRD(buttonState);
            int width = size.width;
            int height = size.height;
            drawDualGradient.setColor(innerBorderColorLU);
            drawDualGradient.fillRect(0, 1, width, 1);
            drawDualGradient.fillRect(0, 1, 1, height - 2);
            drawDualGradient.setColor(innerBorderColorRD);
            drawDualGradient.fillRect(1, height - 3 + 1, width - 2, 1);
            drawDualGradient.fillRect(width - 3 + 1, 1, 1, height - 2);
            super.paint(drawDualGradient);
        }
    }
}

