/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.plaf.IsmIconFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalScrollButton;

public class ArmorScrollButton
extends MetalScrollButton {
    private static final long serialVersionUID = -6336068584563893337L;
    private static Color shadowColor;
    private static Color highlightColor;

    public ArmorScrollButton(int direction, int width, boolean freeStanding) {
        super(direction, width, freeStanding);
        ArmorScrollButton.initColor();
    }

    private static void initColor() {
        shadowColor = UIManager.getColor("IsmScrollBarArrowButton.shadow");
        highlightColor = UIManager.getColor("IsmScrollBarArrowButton.highlight");
    }

    @Override
    public void paint(Graphics graphics) {
        boolean isHorizontal = this.direction == 3 || this.direction == 7;
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.setColor(highlightColor);
        graphics.drawLine(0, 0, width - 1, 0);
        graphics.drawLine(0, 1, 0, height - 1);
        graphics.setColor(shadowColor);
        if (isHorizontal) {
            graphics.drawLine(width - 1, 1, width - 1, height - 1);
        } else {
            graphics.drawLine(0, height - 1, width - 1, height - 1);
        }
        if (!this.model.isPressed() && this.model.isRollover()) {
            IsmPlafUtils.drawGradient((Component)this, graphics, "IsmScrollBar.rolloverGradient", new Rectangle(1, 1, width - 2, width - 2), !isHorizontal);
        } else if (this.model.isPressed()) {
            IsmPlafUtils.drawGradient((Component)this, graphics, "IsmScrollBar.selectedGradient", new Rectangle(1, 1, width - 2, height - 2), !isHorizontal);
        }
        Icon ic = null;
        switch (this.getDirection()) {
            case 3: {
                ic = IsmIconFactory.getScrollBarRightArrowIcon();
                break;
            }
            case 7: {
                ic = IsmIconFactory.getScrollBarLeftArrowIcon();
                break;
            }
            case 1: {
                ic = IsmIconFactory.getScrollBarUpArrowIcon();
                break;
            }
            default: {
                ic = IsmIconFactory.getScrollBarDownArrowIcon();
            }
        }
        ic.paintIcon(this, graphics, width - ic.getIconWidth() - 1 >> 1, height - ic.getIconHeight() - 1 >> 1);
    }
}

