/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.splitpane;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JSplitPane;
import javax.swing.UIManager;

public class IsmSplitPane
extends JSplitPane {
    private static final int DIVIDE_SIZE = 16;
    private static final long serialVersionUID = 5828293951063069553L;
    private boolean oneSideExpand = true;
    private boolean expandDown = true;
    private boolean expanded = true;

    public IsmSplitPane() {
        this(1);
    }

    public IsmSplitPane(int newOrientation) {
        this(newOrientation, true, true);
    }

    public IsmSplitPane(int newOrientation, boolean newContinuousLayout) {
        this(newOrientation, newContinuousLayout, true, true);
    }

    public IsmSplitPane(boolean isOneSideExpand, boolean isExpandDown) {
        this(1, UIManager.getBoolean("SplitPane.continuousLayout"), isOneSideExpand, isExpandDown);
    }

    public IsmSplitPane(int newOrientation, boolean isOneSideExpand, boolean isExpandDown) {
        this(newOrientation, UIManager.getBoolean("SplitPane.continuousLayout"), isOneSideExpand, isExpandDown);
    }

    public IsmSplitPane(int newOrientation, boolean newContinuousLayout, boolean isOneSideExpand, boolean isExpandDown) {
        super(newOrientation, newContinuousLayout);
        this.setDividerSize(16);
        this.setOneSideExpand(isOneSideExpand);
        this.setExpandDown(isExpandDown);
    }

    @Override
    public String getUIClassID() {
        return "NewSplitPaneUI";
    }

    public boolean isOneSideExpand() {
        return this.oneSideExpand;
    }

    public void setOneSideExpand(boolean oneSideExpand) {
        this.oneSideExpand = oneSideExpand;
    }

    public boolean isExpandDown() {
        return this.expandDown;
    }

    public void setExpandDown(boolean expandDown) {
        this.expandDown = expandDown;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    public void setLeftComponent(Component comp) {
        if (this.isOneSideExpand() && this.isExpandDown()) {
            Dimension dimension = comp.getMinimumSize();
            if (null == dimension) {
                throw new NullPointerException();
            }
            int width = (int)dimension.getWidth();
            int height = (int)dimension.getHeight();
            if (this.getOrientation() == 1) {
                width = dimension.getWidth() <= 0.0 ? 1 : (int)dimension.getWidth();
            } else {
                height = dimension.getHeight() <= 0.0 ? 1 : (int)dimension.getHeight();
            }
            comp.setMinimumSize(new Dimension(width, height));
        }
        super.setLeftComponent(comp);
    }

    @Override
    public void setRightComponent(Component comp) {
        if (this.isOneSideExpand() && !this.isExpandDown()) {
            Dimension dimension = comp.getMinimumSize();
            if (null == dimension) {
                throw new NullPointerException();
            }
            int width = (int)dimension.getWidth();
            int height = (int)dimension.getHeight();
            if (this.getOrientation() == 1) {
                width = dimension.getWidth() <= 0.0 ? 1 : (int)dimension.getWidth();
            } else {
                height = dimension.getHeight() <= 0.0 ? 1 : (int)dimension.getHeight();
            }
            comp.setMinimumSize(new Dimension(width, height));
        }
        super.setRightComponent(comp);
    }

    @Override
    public void setDividerLocation(int location) {
        super.setDividerLocation(location);
        boolean oldExpanded = this.isExpanded();
        double distance = this.orientation == 1 ? (this.isExpandDown() ? this.getSize().getWidth() - (double)this.getDividerSize() - (double)location : (double)location) : (this.isExpandDown() ? this.getSize().getHeight() - (double)this.getDividerSize() - (double)location : (double)location);
        if (distance > 0.0) {
            this.setExpanded(true);
        } else {
            this.setExpanded(false);
        }
        if (this.isOneSideExpand() && oldExpanded != this.isExpanded()) {
            this.repaint();
        }
    }
}

