/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.UCD;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableCountPane
extends JPanel {
    private static final long serialVersionUID = -7517962469256940841L;
    private IsmTable ismTable = null;
    private JLabel totalCount = new JLabel("0");
    private JLabel countLable = new JLabel(ResourceManager.getString("ITEMS"));
    private JLabel selectCount = new JLabel("0");

    public TableCountPane() {
    }

    public TableCountPane(IsmTable table) {
        this.ismTable = table;
        this.updateRowCount();
        this.doLayoutUI();
        this.addHandler();
    }

    private void doLayoutUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.add(Box.createHorizontalStrut(8));
        this.add(new JLabel(ResourceManager.getString("ITEMS")));
        this.add(Box.createHorizontalStrut(5));
        this.add(this.totalCount);
        this.add(new JLabel(ResourceManager.getString("SELECTED")));
        this.add(Box.createHorizontalStrut(5));
        this.add(this.selectCount);
        this.add(Box.createHorizontalStrut(8));
        if (CommonUtil.isFwUpgradeScene()) {
            UCD.setJComponentSize(this.totalCount, 30, 25);
            UCD.setJComponentSize(this.selectCount, 30, 25);
        } else {
            UCD.setJComponentSize(this.totalCount, 50, 25);
            UCD.setJComponentSize(this.selectCount, 50, 25);
        }
    }

    private void updateRowCount() {
        int rowCount = this.ismTable.getRowCount();
        int selRowCount = this.ismTable.getSelectedRowCount();
        this.totalCount.setText("" + rowCount);
        this.selectCount.setText("" + selRowCount);
    }

    private void addHandler() {
        ListSelectionModel selectionModel = this.ismTable.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TableCountPane.this.updateRowCount();
            }
        });
        TableModel tableModel = this.ismTable.getModel();
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TableCountPane.this.updateRowCount();
            }
        });
        RowSorter<? extends TableModel> sorter = this.ismTable.getRowSorter();
        if (null != sorter) {
            sorter.addRowSorterListener(new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent e) {
                    TableCountPane.this.updateRowCount();
                }
            });
        }
    }

    public JLabel getCountLable() {
        return this.countLable;
    }

    public JLabel getSelectLable() {
        return this.selectCount;
    }

    public IsmTable getIsmTable() {
        return this.ismTable;
    }

    public void setIsmTable(IsmTable table) {
        this.ismTable = table;
    }
}

