/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.ui.swing.table.IsmVirtualTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.util.List;

public final class VirtualTableRow<U, K>
implements TableRow<U, K> {
    private U userObjectU;
    private K identifierK;
    private Object[] rowValues;
    private IsmVirtualTableCell[] rowComps;

    public VirtualTableRow(int columnCount, U userObject, K identifier) {
        this.rowValues = columnCount < 0 ? new Object[0] : new Object[columnCount];
        this.userObjectU = userObject;
        this.identifierK = identifier;
    }

    public VirtualTableRow(int columnCount, K identifier) {
        this(columnCount, null, identifier);
    }

    @Override
    public U getUserObject() {
        return this.userObjectU;
    }

    @Override
    public Object getValueAt(int columnIndex) {
        if (columnIndex < this.rowValues.length) {
            if (this.rowComps == null || this.rowComps[columnIndex] == null) {
                return this.rowValues[columnIndex];
            }
            IsmVirtualTableCell cell = this.rowComps[columnIndex];
            return cell;
        }
        return null;
    }

    public Object getRealValueAt(int columnIndex) {
        if (columnIndex < this.rowValues.length) {
            if (this.rowComps != null && this.rowComps[columnIndex] != null) {
                return this.rowComps[columnIndex].getValue();
            }
            return this.rowValues[columnIndex];
        }
        return null;
    }

    @Override
    public void setValueAt(int columnIndex, Object aValue) {
        if (columnIndex < this.rowValues.length) {
            this.rowValues[columnIndex] = aValue;
            if (this.rowComps != null && this.rowComps[columnIndex] != null) {
                this.rowComps[columnIndex].setValue(aValue);
            }
        }
    }

    public void setCompoments(IsmVirtualTableCell[] cells) {
        IsmVirtualTableCell[] ismVirtualTableCellArray = this.rowComps = this.rowComps == null ? null : (IsmVirtualTableCell[])cells.clone();
        if (this.rowComps != null) {
            int length = this.rowComps.length;
            for (int i = 0; i < length; ++i) {
                IsmVirtualTableCell cell = this.rowComps[i];
                Object value = this.rowValues[i];
                if (cell == null || value == null) continue;
                cell.setValue(value);
            }
        }
    }

    public void removeComps() {
        if (this.rowComps != null) {
            for (IsmVirtualTableCell cell : this.rowComps) {
                if (cell == null) continue;
                this.rowValues[i] = cell.getValue();
            }
        }
        this.rowComps = null;
    }

    public void setValues(List<?> datas) {
        if (null == datas) {
            return;
        }
        for (int i = 0; i < datas.size(); ++i) {
            this.setValueAt(i, datas.get(i));
        }
    }

    @Override
    public K getIdentifier() {
        return this.identifierK;
    }

    @Override
    public int getColumnCount() {
        return this.rowValues.length;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TableRow)) {
            return false;
        }
        TableRow that = (TableRow)obj;
        K thisID = this.getIdentifier();
        Object thatID = that.getIdentifier();
        if (null == thisID || null == thatID) {
            return super.equals(obj);
        }
        return thisID.equals(thatID);
    }

    public int hashCode() {
        if (null == this.identifierK) {
            return super.hashCode();
        }
        return this.identifierK.hashCode();
    }
}

