/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text;

import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.text.NameRegexDocument2;
import com.huawei.ism.ui.widgets.PopupInform;
import com.huawei.ism.util.SwingUtil;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.im.InputMethodRequests;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.Document;

public class IsmTextArea
extends JTextArea {
    private static final long serialVersionUID = 8215785380686714425L;
    private boolean isError;
    private String errorToolTip = "";
    private transient PopupInform popupInform;

    public IsmTextArea() {
        this(true, true);
    }

    public IsmTextArea(boolean isLineWrap, boolean useAsLabel) {
        this(isLineWrap);
        if (useAsLabel) {
            this.setFocusable(true);
            this.setEditable(false);
            this.setOpaque(false);
        }
        this.addHandler();
    }

    public IsmTextArea(boolean isLineWrap, boolean useAsLabel, boolean Focusable) {
        this(isLineWrap);
        this.setFocusable(Focusable);
        if (useAsLabel) {
            this.setEditable(false);
            this.setOpaque(false);
        }
        this.addHandler();
    }

    public IsmTextArea(boolean isLineWrap) {
        super.setLineWrap(isLineWrap);
        this.addHandler();
        super.setWrapStyleWord(true);
        SwingUtil.applyKeyBoardLockPatch(this);
    }

    public IsmTextArea(Document doc) {
        super(doc);
        this.addHandler();
    }

    private void addHandler() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyCode) {
                if (keyCode.getKeyCode() == 9) {
                    IsmTextArea.this.transferFocus();
                }
            }
        });
    }

    public static IsmTextArea getIsmTextArea(String regex, String text, boolean isLineWrap, int maxFieldLength) {
        NameRegexDocument2 regexDoc = new NameRegexDocument2(regex, maxFieldLength, true);
        IsmTextArea ismTextArea = new IsmTextArea(regexDoc);
        ismTextArea.setText(text);
        ismTextArea.setLineWrap(isLineWrap);
        ismTextArea.setWrapStyleWord(true);
        SwingUtil.applyKeyBoardLockPatch(ismTextArea);
        return ismTextArea;
    }

    public static IsmTextArea getIsmTextAreaLabel(String text) {
        IsmTextArea textAreaLabel = IsmTextArea.getIsmTextAreaLabelNoColor(text);
        textAreaLabel.setForeground(UIManager.getColor("TextAreaLabel.Foreground.Color"));
        return textAreaLabel;
    }

    public static IsmTextArea getIsmTextAreaLabelNoColor(String text) {
        IsmTextArea textAreaLabel = new IsmTextArea(true, true);
        textAreaLabel.setText(text);
        textAreaLabel.setFont(IsmFontFactory.getDialogPlain());
        return textAreaLabel;
    }

    @Override
    public int getRowHeight() {
        return super.getRowHeight();
    }

    @Override
    public int getColumnWidth() {
        return super.getColumnWidth();
    }

    public void setErrorToolTip(String errorToolTip) {
        this.errorToolTip = errorToolTip;
        this.setError(true);
        this.requestFocus();
    }

    public boolean isShowErrorToolTip() {
        return this.isError;
    }

    public String getErrorToolTip() {
        return this.errorToolTip;
    }

    public void setError(boolean isErrorInput) {
        this.isError = isErrorInput;
        if (isErrorInput && this.popupInform != null) {
            this.popupInform.setErrorTooltip(this.errorToolTip, isErrorInput);
        }
        this.repaint();
    }

    public void setPopupInform(PopupInform popupInform) {
        this.popupInform = popupInform;
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return null;
    }
}

