/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text.validator;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Utils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueRangeInputValidator
implements InputValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueRangeInputValidator.class);
    private static final long serialVersionUID = 8562692880649047208L;
    public static final double MAX_VALUE = Double.MAX_VALUE;
    public static final double MIN_VALUE = -1.0;
    private boolean showTooltip = true;
    private String tooltipPattern = null;
    private String validatetipPattern = null;
    private double min = 0.0;
    private double max = 0.0;
    private boolean minContainEqual = false;
    private boolean maxContainEqual = false;

    public ValueRangeInputValidator(double min, double max) {
        this(min, max, true, true);
    }

    public ValueRangeInputValidator(double min, double max, boolean minContainEqual, boolean maxContainEqual) {
        this.min = min;
        this.max = max;
        this.minContainEqual = minContainEqual;
        this.maxContainEqual = maxContainEqual;
        if (Double.compare(min, max) == 0) {
            this.tooltipPattern = ResourceManager.getString("textfield.value.range.tooltip");
            this.validatetipPattern = ResourceManager.getString("textfield.value.range.validatetip");
        } else if (max >= Double.MAX_VALUE) {
            if (minContainEqual) {
                this.tooltipPattern = ResourceManager.getString("textfield.value.morethan.andequal.tootip");
                this.validatetipPattern = ResourceManager.getString("textfield.value.morethan.andequal.validatetip");
            } else {
                this.tooltipPattern = ResourceManager.getString("textfield.value.morethan.tooltip");
                this.validatetipPattern = ResourceManager.getString("textfield.value.morethan.validatetip");
            }
        } else if (min <= -1.0) {
            if (maxContainEqual) {
                this.tooltipPattern = ResourceManager.getString("textfield.value.lessthan.andequal.tootip");
                this.validatetipPattern = ResourceManager.getString("textfield.value.lessthan.andequal.validatetip");
            } else {
                this.tooltipPattern = ResourceManager.getString("textfield.value.lessthan.tootip");
                this.validatetipPattern = ResourceManager.getString("textfield.value.lessthan.validatetip");
            }
        } else {
            this.setRangePattern();
        }
    }

    private void setRangePattern() {
        if (this.minContainEqual && this.maxContainEqual) {
            this.tooltipPattern = ResourceManager.getString("textfield.value.range.tooltip");
            this.validatetipPattern = ResourceManager.getString("textfield.value.range.validatetip");
        } else if (!this.minContainEqual && this.maxContainEqual) {
            this.tooltipPattern = ResourceManager.getString("textfield.value.lessthan.range2.tootip");
            this.validatetipPattern = ResourceManager.getString("textfield.value.lessthan.range2.validatetip");
        } else if (this.minContainEqual && !this.maxContainEqual) {
            this.tooltipPattern = ResourceManager.getString("textfield.value.lessthan.range3.tootip");
            this.validatetipPattern = ResourceManager.getString("textfield.value.lessthan.range3.validatetip");
        } else {
            this.tooltipPattern = ResourceManager.getString("textfield.value.lessthan.range1.tootip");
            this.validatetipPattern = ResourceManager.getString("textfield.value.lessthan.range1.validatetip");
        }
    }

    @Override
    public String validateInput(String input, String inputValueName) {
        try {
            double value = Utils.safeParseDouble(input);
            if (value < this.max && value > this.min) {
                return null;
            }
            if (this.maxContainEqual && Math.abs(value - this.max) < 1.0E-7) {
                return null;
            }
            if (this.minContainEqual && Math.abs(value - this.min) < 1.0E-7) {
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        return this.getValidateFailMsg(inputValueName);
    }

    private String getValidateFailMsg(String inputValueName) {
        DecimalFormat decimalFormat = new DecimalFormat("#");
        String validInputValueName = CommonUtil.handleInputName(this.validatetipPattern, inputValueName);
        if (this.isMaxEquMin()) {
            return MessageFormat.format(this.validatetipPattern, validInputValueName, decimalFormat.format(this.max));
        }
        if (this.max >= Double.MAX_VALUE) {
            return MessageFormat.format(this.validatetipPattern, validInputValueName, decimalFormat.format(this.min));
        }
        if (this.min <= -1.0) {
            return MessageFormat.format(this.validatetipPattern, validInputValueName, decimalFormat.format(this.max));
        }
        return MessageFormat.format(this.validatetipPattern, validInputValueName, decimalFormat.format(this.min), decimalFormat.format(this.max));
    }

    private boolean isMaxEquMin() {
        return new BigDecimal(this.min).equals(new BigDecimal(this.max));
    }

    @Override
    public String getToolTip() {
        if (!this.showTooltip) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("#");
        if (this.isMaxEquMin()) {
            return MessageFormat.format(this.tooltipPattern, decimalFormat.format(this.max));
        }
        if (this.max >= Double.MAX_VALUE) {
            return MessageFormat.format(this.tooltipPattern, decimalFormat.format(this.min));
        }
        if (this.min <= -1.0) {
            return MessageFormat.format(this.tooltipPattern, decimalFormat.format(this.max));
        }
        return MessageFormat.format(this.tooltipPattern, this.min, decimalFormat.format(this.max));
    }

    public void setShowTooltip(boolean showTooltip) {
        this.showTooltip = showTooltip;
    }

    public void setMinMaxRang(double minRang, double maxRang) {
        this.min = minRang;
        this.max = maxRang;
    }
}

